/*
 * getopt.c
 *
 * Replacement for a Unix style getopt function
 *
 */

#include "frotz.h"
#include "s5api.h"

short getopt (struct sg *g, short argc, char *argv[], const char *options)
{
    const char *p;

    if (g->optind >= argc || argv[g->optind][0] != '-' || argv[g->optind][1] == 0)
	return 0;

    g->optopt = argv[g->optind][g->pos++];
    g->optarg = NULL;

    if (argv[g->optind][g->pos] == 0)
	{ g->pos = 1; g->optind++; }

    p = Srvstrchr (options, (char)g->optopt);

    if (g->optopt == ':' || p == NULL) {

	goto error;

    } else if (p[1] == ':')

	if (g->optind >= argc) {

	    goto error;

	} else {

	    g->optarg = argv[g->optind];

	    if (g->pos != 1)
		g->optarg += g->pos;

	    g->pos = 1; g->optind++;

	}

    return g->optopt;

error:

    return '?';

}/* getopt */
