/*
 * frotz.h
 *
 * Global declarations and definitions
 *
 */

#ifndef _FROTZ_H
#define _FROTZ_H

#define TRUE 1
#define FALSE 0

typedef unsigned char zbyte;
typedef unsigned short zword;

enum story {
    BEYOND_ZORK,
    SHERLOCK,
    ZORK_ZERO,
    SHOGUN,
    ARTHUR,
    JOURNEY,
    LURKING_HORROR,
    UNKNOWN
};

typedef unsigned char zchar;

/*** Constants that may be set at compile time ***/

#ifndef MAX_UNDO_SLOTS
#define MAX_UNDO_SLOTS 2
#endif
#ifndef MAX_FILE_NAME
#define MAX_FILE_NAME 128
#endif
#ifndef TEXT_BUFFER_SIZE
#define TEXT_BUFFER_SIZE 200
#endif
#ifndef INPUT_BUFFER_SIZE
#define INPUT_BUFFER_SIZE 200
#endif
#ifndef STACK_SIZE
#define STACK_SIZE 1024
#endif

#ifndef DEFAULT_SAVE_NAME
#define DEFAULT_SAVE_NAME "story.sav"
#endif
#ifndef DEFAULT_SCRIPT_NAME
#define DEFAULT_SCRIPT_NAME "story.scr"
#endif
#ifndef DEFAULT_COMMAND_NAME
#define DEFAULT_COMMAND_NAME "story.rec"
#endif
#ifndef DEFAULT_AUXILARY_NAME
#define DEFAULT_AUXILARY_NAME "story.aux"
#endif

/*** Story file header format ***/

#define H_VERSION 0
#define H_CONFIG 1
#define H_RELEASE 2
#define H_RESIDENT_SIZE 4
#define H_START_PC 6
#define H_DICTIONARY 8
#define H_OBJECTS 10
#define H_GLOBALS 12
#define H_DYNAMIC_SIZE 14
#define H_FLAGS 16
#define H_SERIAL 18
#define H_ABBREVIATIONS 24
#define H_FILE_SIZE 26
#define H_CHECKSUM 28
#define H_INTERPRETER_NUMBER 30
#define H_INTERPRETER_VERSION 31
#define H_SCREEN_ROWS 32
#define H_SCREEN_COLS 33
#define H_SCREEN_WIDTH 34
#define H_SCREEN_HEIGHT 36
#define H_FONT_HEIGHT 38 /* this is the font width in V5 */
#define H_FONT_WIDTH 39 /* this is the font height in V5 */
#define H_FUNCTIONS_OFFSET 40
#define H_STRINGS_OFFSET 42
#define H_DEFAULT_BACKGROUND 44
#define H_DEFAULT_FOREGROUND 45
#define H_TERMINATING_KEYS 46
#define H_LINE_WIDTH 48
#define H_STANDARD_HIGH 50
#define H_STANDARD_LOW 51
#define H_ALPHABET 52
#define H_EXTENSION_TABLE 54
#define H_USER_NAME 56

#define HX_TABLE_SIZE 0
#define HX_MOUSE_X 1
#define HX_MOUSE_Y 2
#define HX_UNICODE_TABLE 3

/*** Various Z-machine constants ***/

#define V1 1
#define V2 2
#define V3 3
#define V4 4
#define V5 5
#define V6 6
#define V7 7
#define V8 8

#define CONFIG_BYTE_SWAPPED 0x01 /* Story file is byte swapped         - V3  */
#define CONFIG_TIME         0x02 /* Status line displays time          - V3  */
#define CONFIG_TWODISKS     0x04 /* Story file occupied two disks      - V3  */
#define CONFIG_TANDY        0x08 /* Tandy licensed game                - V3  */
#define CONFIG_NOSTATUSLINE 0x10 /* Interpr can't support status lines - V3  */
#define CONFIG_SPLITSCREEN  0x20 /* Interpr supports split screen mode - V3  */
#define CONFIG_PROPORTIONAL 0x40 /* Interpr uses proportional font     - V3  */

#define CONFIG_COLOUR       0x01 /* Interpr supports colour            - V5+ */
#define CONFIG_PICTURES     0x02 /* Interpr supports pictures          - V6  */
#define CONFIG_BOLDFACE     0x04 /* Interpr supports boldface style    - V4+ */
#define CONFIG_EMPHASIS     0x08 /* Interpr supports emphasis style    - V4+ */
#define CONFIG_FIXED        0x10 /* Interpr supports fixed width style - V4+ */
#define CONFIG_TIMEDINPUT   0x80 /* Interpr supports timed input       - V4+ */

#define SCRIPTING_FLAG    0x0001 /* Outputting to transscription file  - V1+ */
#define FIXED_FONT_FLAG   0x0002 /* Use fixed width font               - V3+ */
#define REFRESH_FLAG      0x0004 /* Refresh the screen                 - V6  */
#define GRAPHICS_FLAG     0x0008 /* Game wants to use graphics         - V5+ */
#define OLD_SOUND_FLAG    0x0010 /* Game wants to use sound effects    - V3  */
#define UNDO_FLAG         0x0010 /* Game wants to use UNDO feature     - V5+ */
#define MOUSE_FLAG        0x0020 /* Game wants to use a mouse          - V5+ */
#define COLOUR_FLAG       0x0040 /* Game wants to use colours          - V5+ */
#define SOUND_FLAG        0x0080 /* Game wants to use sound effects    - V5+ */
#define MENU_FLAG         0x0100 /* Game wants to use menus            - V6  */

#define INTERP_DEC_20 1
#define INTERP_APPLE_IIE 2
#define INTERP_MACINTOSH 3
#define INTERP_AMIGA 4
#define INTERP_ATARI_ST 5
#define INTERP_MSDOS 6
#define INTERP_CBM_128 7
#define INTERP_CBM_64 8
#define INTERP_APPLE_IIC 9
#define INTERP_APPLE_IIGS 10
#define INTERP_TANDY 11
#define INTERP_PSIONS5 6

#define REVERSE_STYLE 1
#define BOLDFACE_STYLE 2
#define EMPHASIS_STYLE 4
#define FIXED_WIDTH_STYLE 8

#define TEXT_FONT 1
#define PICTURE_FONT 2
#define GRAPHICS_FONT 3
#define FIXED_WIDTH_FONT 4

/*** Constants for os_restart_game */

#define RESTART_BEGIN 0
#define RESTART_WPROP_SET 1
#define RESTART_END 2

/*** Character codes ***/

#define ZC_TIME_OUT 0x00
#define ZC_NEW_STYLE 0x01
#define ZC_NEW_FONT 0x02
#define ZC_BACKSPACE 0x08
#define ZC_INDENT 0x09
#define ZC_GAP 0x0b
#define ZC_RETURN 0x0d
#define ZC_HKEY_RECORD 18
#define ZC_HKEY_PLAYBACK 16
#define ZC_HKEY_UNDO 21
#define ZC_HKEY_RESTART 14
#define ZC_HKEY_QUIT 24
#define ZC_HKEY_DEBUG 4
#define ZC_HKEY_HELP 19
#define ZC_ESCAPE 0x1b
#define ZC_ASCII_MIN 0x20
#define ZC_ASCII_MAX 0x7e
#define ZC_BAD 0x7f
#define ZC_ARROW_MIN 129
#define ZC_ARROW_UP 129
#define ZC_ARROW_DOWN 130
#define ZC_ARROW_LEFT 131
#define ZC_ARROW_RIGHT 132
#define ZC_ARROW_MAX 132
#define ZC_FKEY_MIN 0x85
#define ZC_FKEY_MAX 0x90
#define ZC_NUMPAD_MIN 0x91
#define ZC_NUMPAD_MAX 0x9a
#define ZC_SINGLE_CLICK 0x9b
#define ZC_DOUBLE_CLICK 0x9c
#define ZC_MENU_CLICK 0x9d
#define ZC_LATIN1_MIN 0xa0
#define ZC_LATIN1_MAX 0xff
/*** Key Codes for EPOC Arrow Keys ***/
#define ZC_EPOC_RIGHT 0x1008
#define ZC_EPOC_LEFT 0x1007
#define ZC_EPOC_UP 0x1009
#define ZC_EPOC_DOWN 0x100A

/*** File types ***/

#define FILE_RESTORE 0
#define FILE_SAVE 1
#define FILE_SCRIPT 2
#define FILE_PLAYBACK 3
#define FILE_RECORD 4
#define FILE_LOAD_AUX 5
#define FILE_SAVE_AUX 6

/*** Data access macros ***/

#define SET_BYTE(addr,v)  { (g->zmp)[addr] = v; }
#define LOW_BYTE(addr,v)  { v = (g->zmp)[addr]; }
#define CODE_BYTE(v)      { v = *((g->pcp)++); }

#define lo(v)   ((zbyte *)&v)[0]
#define hi(v)   ((zbyte *)&v)[1]

#define SET_WORD(addr,v)  { (g->zmp)[addr] = hi(v); (g->zmp)[addr+1] = lo(v); }
#define LOW_WORD(addr,v)  { v = ((zword) (g->zmp)[addr] << 8) | (zword)((g->zmp)[addr+1]); }
#define HIGH_WORD(addr,v) { v = ((zword) (g->zmp)[addr] << 8) | (zword)((g->zmp)[addr+1]); }
#define CODE_WORD(v)      { v = ((zword) (g->pcp)[0] << 8) | (zword)((g->pcp)[1]); (g->pcp) += 2; }
#define GET_PC(v)         { v = g->pcp - g->zmp; }
#define SET_PC(v)         { g->pcp = g->zmp + v; }

/*** Story file header data ***/

/*extern zbyte h_version;
extern zbyte h_config;
extern zword h_release;
extern zword h_resident_size;
extern zword h_start_pc;
extern zword h_dictionary;
extern zword h_objects;
extern zword h_globals;
extern zword h_dynamic_size;
extern zword h_flags;
extern zbyte h_serial[6];
extern zword h_abbreviations;
extern zword h_file_size;
extern zword h_checksum;
extern zbyte h_interpreter_number;
extern zbyte h_interpreter_version;
extern zbyte h_screen_rows;
extern zbyte h_screen_cols;
extern zword h_screen_width;
extern zword h_screen_height;
extern zbyte h_font_height;
extern zbyte h_font_width;
extern zword h_functions_offset;
extern zword h_strings_offset;
extern zbyte h_default_background;
extern zbyte h_default_foreground;
extern zword h_terminating_keys;
extern zword h_line_width;
extern zbyte h_standard_high;
extern zbyte h_standard_low;
extern zword h_alphabet;
extern zword h_extension_table;
extern zbyte h_user_name[8];

extern zword hx_table_size;
extern zword hx_mouse_x;
extern zword hx_mouse_y;
extern zword hx_unicode_table;
*/
/*** Various data ***/

/*extern const char *story_name;

extern enum story story_id;
extern long story_size;

extern zword stack[STACK_SIZE];
extern zword *sp;
extern zword *fp;

extern zword zargs[8];
extern short zargc;

extern short ostream_screen;
extern short ostream_script;
extern short ostream_memory;
extern short ostream_record;
extern short istream_replay;
extern short message;

extern short cwin;
extern short mwin;

extern short mouse_x;
extern short mouse_y;

extern short enable_wrapping;
extern short enable_scripting;
extern short enable_scrolling;
extern short enable_buffering;

extern short option_attribute_assignment;
extern short option_attribute_testing;
extern short option_object_locating;
extern short option_object_movement;
extern short option_context_lines;
extern short option_left_margin;
extern short option_right_margin;
extern short option_ignore_errors;
extern short option_piracy;
extern short option_undo_slots;
extern short option_expand_abbreviations;
extern short option_script_cols;

extern long reserve_mem;
*/
/*** Z-machine opcodes ***/

void    z_add (struct sg *g);
void    z_and (struct sg *g);
void    z_art_shift (struct sg *g);
void    z_buffer_mode (struct sg *g);
void    z_call_n (struct sg *g);
void    z_call_s (struct sg *g);
void    z_catch (struct sg *g);
void    z_check_arg_count (struct sg *g);
void    z_check_unicode (struct sg *g);
void    z_clear_attr (struct sg *g);
void    z_copy_table (struct sg *g);
void    z_dec (struct sg *g);
void    z_dec_chk (struct sg *g);
void    z_div (struct sg *g);
void    z_draw_picture (struct sg *g);
void    z_encode_text (struct sg *g);
void    z_erase_line (struct sg *g);
void    z_erase_picture (struct sg *g);
void    z_erase_window (struct sg *g);
void    z_get_child (struct sg *g);
void    z_get_cursor (struct sg *g);
void    z_get_next_prop (struct sg *g);
void    z_get_parent (struct sg *g);
void    z_get_prop (struct sg *g);
void    z_get_prop_addr (struct sg *g);
void    z_get_prop_len (struct sg *g);
void    z_get_sibling (struct sg *g);
void    z_get_wind_prop (struct sg *g);
void    z_inc (struct sg *g);
void    z_inc_chk (struct sg *g);
void    z_input_stream (struct sg *g);
void    z_insert_obj (struct sg *g);
void    z_je (struct sg *g);
void    z_jg (struct sg *g);
void    z_jin (struct sg *g);
void    z_jl (struct sg *g);
void    z_jump (struct sg *g);
void    z_jz (struct sg *g);
void    z_load (struct sg *g);
void    z_loadb (struct sg *g);
void    z_loadw (struct sg *g);
void    z_log_shift (struct sg *g);
void    z_make_menu (struct sg *g);
void    z_mod (struct sg *g);
void    z_mouse_window (struct sg *g);
void    z_move_window (struct sg *g);
void    z_mul (struct sg *g);
void    z_new_line (struct sg *g);
void    z_nop (struct sg *g);
void    z_not (struct sg *g);
void    z_or (struct sg *g);
void    z_output_stream (struct sg *g);
void    z_picture_data (struct sg *g);
void    z_picture_table (struct sg *g);
void    z_piracy (struct sg *g);
void    z_pop (struct sg *g);
void    z_pop_stack (struct sg *g);
void    z_print (struct sg *g);
void    z_print_addr (struct sg *g);
void    z_print_char (struct sg *g);
void    z_print_form (struct sg *g);
void    z_print_num (struct sg *g);
void    z_print_obj (struct sg *g);
void    z_print_paddr (struct sg *g);
void    z_print_ret (struct sg *g);
void    z_print_table (struct sg *g);
void    z_print_unicode (struct sg *g);
void    z_pull (struct sg *g);
void    z_push (struct sg *g);
void    z_push_stack (struct sg *g);
void    z_put_prop (struct sg *g);
void    z_put_wind_prop (struct sg *g);
void    z_quit (struct sg *g);
void    z_random (struct sg *g);
void    z_read (struct sg *g);
void    z_read_char (struct sg *g);
void    z_read_mouse (struct sg *g);
void    z_remove_obj (struct sg *g);
void    z_restart (struct sg *g);
void    z_restore (struct sg *g);
void    z_restore_undo (struct sg *g);
void    z_ret (struct sg *g);
void    z_ret_popped (struct sg *g);
void    z_rfalse (struct sg *g);
void    z_rtrue (struct sg *g);
void    z_save (struct sg *g);
void    z_save_undo (struct sg *g);
void    z_scan_table (struct sg *g);
void    z_scroll_window (struct sg *g);
void    z_set_attr (struct sg *g);
void    z_set_font (struct sg *g);
void    z_set_colour (struct sg *g);
void    z_set_cursor (struct sg *g);
void    z_set_margins (struct sg *g);
void    z_set_window (struct sg *g);
void    z_set_text_style (struct sg *g);
void    z_show_status (struct sg *g);
void    z_sound_effect (struct sg *g);
void    z_split_window (struct sg *g);
void    z_store (struct sg *g);
void    z_storeb (struct sg *g);
void    z_storew (struct sg *g);
void    z_sub (struct sg *g);
void    z_test (struct sg *g);
void    z_test_attr (struct sg *g);
void    z_throw (struct sg *g);
void    z_tokenise (struct sg *g);
void    z_verify (struct sg *g);
void    z_window_size (struct sg *g);
void    z_window_style (struct sg *g);

/*** Various global functions ***/

short   translate_from_zscii (struct sg *g, short);
short   translate_to_zscii (struct sg *g, short);

void    flush_buffer (struct sg *g);
void    new_line (struct sg *g);
void    print_char (struct sg *g, zchar);
void    print_num (struct sg *g, zword);
void    print_object (struct sg *g, zword);
void    print_string (struct sg *g, const char *);

void    stream_mssg_on (struct sg *g);
void    stream_mssg_off (struct sg *g);

void    runtime_error (struct sg *g, const char *);

void    ret (struct sg *g, zword);
void    store (struct sg *g, zword);
void    branch (struct sg *g, short);

void    storeb (struct sg *g, zword, zbyte);
void    storew (struct sg *g, zword, zword);

/*** Interface functions ***/

void    os_beep (struct sg *g, short);
void    os_display_char (struct sg *g, zchar);
void    os_display_string (struct sg *g, const zchar *);
void    os_draw_picture (struct sg *g, short, short, short);
void    os_erase_area (struct sg *g, short, short, short, short);
void    os_fatal (struct sg *g, const char *);
void    os_finish_with_sample (struct sg *g);
short   os_font_data (struct sg *g, short, short *, short *);
void    os_init_screen (struct sg *g);
void    os_more_prompt (struct sg *g);
short   os_peek_colour (struct sg *g);
short   os_picture_data (struct sg *g, short, short *, short *);
void    os_prepare_sample (struct sg *g, short);
void    os_process_arguments (struct sg *g, short, char *[]);
short   os_random_seed (struct sg *g);
short   os_read_file_name (struct sg *g, char *, const char *, short);
zchar   os_read_key (struct sg *g, short, short);
zchar   os_read_line (struct sg *g, short, zchar *, short, short, short);
void    os_reset_screen (struct sg *g);
void    os_restart_game (struct sg *g, short);
void    os_scroll_area (struct sg *g, short, short, short, short, short);
void    os_set_colour (struct sg *g, short, short);
void    os_set_cursor (struct sg *g, short, short);
void    os_set_font (struct sg *g, short);
void    os_set_text_style (struct sg *g, short);
void    os_start_sample (struct sg *g, short, short, short);
void    os_stop_sample (struct sg *g);
short   os_string_width (struct sg *g, const zchar *);

#endif
