// ----------------------------------------------------------------------------
// fuji force logo : atari rainbow
// 	
// description	:	DS game using PAlib www.palib.com
//
// ----------------------------------------------------------------------------
// (c) papafuji - 2006 - using PAlib
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// PAlib includes
// ----------------------------------------------------------------------------

#include <PA9.h>
#include <stdio.h> 

// ----------------------------------------------------------------------------
// project includes
// ----------------------------------------------------------------------------

#include "draw.h"
#include "gfx/all_gfx.h"

// ----------------------------------------------------------------------------
// local variables
// ----------------------------------------------------------------------------

u32 rainbow_palette[] =
{
	0x000000,
	0x111111,
	0x222222,
	0x333333,
	0x444444,
	0x555555,
	0x666666,
	0x777777,
	0x888888,
	0x999999,
	0xaaaaaa,
	0xbbbbbb,
	0xcccccc,
	0xdddddd,
	0xeeeeee,
	0xffffff,
	0x4c2d00,
	0x643c00,
	0x7c4a00,
	0x935800,
	0xab6700,
	0xc37500,
	0xdb8300,
	0xf39100,
	0xff9d0b,
	0xffa723,
	0xffb03b,
	0xffba53,
	0xffc36b,
	0xffcd82,
	0xfed69a,
	0xffe0b2,
	0x4c0f00,
	0x641400,
	0x7c1800,
	0x931d00,
	0xab2200,
	0xc32700,
	0xdb2b00,
	0xf33000,
	0xff3c0b,
	0xff4f23,
	0xff623b,
	0xff7553,
	0xff886b,
	0xff9b82,
	0xfeae9a,
	0xffc1b2,
	0x4c000f,
	0x640014,
	0x7c0018,
	0x93001d,
	0xab0022,
	0xc30027,
	0xdb002b,
	0xf30030,
	0xff0b3c,
	0xff234f,
	0xff3b62,
	0xff5375,
	0xff6b88,
	0xff829b,
	0xfe9aae,
	0xffb2c1,
	0x4c002d,
	0x64003c,
	0x7c004a,
	0x930058,
	0xab0067,
	0xc30075,
	0xdb0083,
	0xf30091,
	0xff0b9d,
	0xff23a7,
	0xff3bb0,
	0xff53ba,
	0xff6bc3,
	0xff82cd,
	0xfe9ad6,
	0xffb2e0,
	0x4c004c,
	0x640064,
	0x7c007c,
	0x930093,
	0xab00ab,
	0xc300c3,
	0xdb00db,
	0xf300f3,
	0xff0bff,
	0xff23ff,
	0xff3bff,
	0xff53ff,
	0xff6bff,
	0xff82ff,
	0xfe9afe,
	0xffb2ff,
	0x2d004c,
	0x3c0064,
	0x4a007c,
	0x580093,
	0x6700ab,
	0x7500c3,
	0x8300db,
	0x9100f3,
	0x9d0bff,
	0xa723ff,
	0xb03bff,
	0xba53ff,
	0xc36bff,
	0xcd82ff,
	0xd69afe,
	0xe0b2ff,
	0x0f004c,
	0x140064,
	0x18007c,
	0x1d0093,
	0x2200ab,
	0x2700c3,
	0x2b00db,
	0x3000f3,
	0x3c0bff,
	0x4f23ff,
	0x623bff,
	0x7553ff,
	0x886bff,
	0x9b82ff,
	0xae9afe,
	0xc1b2ff,
	0x000f4c,
	0x001464,
	0x00187c,
	0x001d93,
	0x0022ab,
	0x0027c3,
	0x002bdb,
	0x0030f3,
	0x0b3cff,
	0x234fff,
	0x3b62ff,
	0x5375ff,
	0x6b88ff,
	0x829bff,
	0x9aaefe,
	0xb2c1ff,
	0x002d4c,
	0x003c64,
	0x004a7c,
	0x005893,
	0x0067ab,
	0x0075c3,
	0x0083db,
	0x0091f3,
	0x0b9dff,
	0x23a7ff,
	0x3bb0ff,
	0x53baff,
	0x6bc3ff,
	0x82cdff,
	0x9ad6fe,
	0xb2e0ff,
	0x004c4c,
	0x006464,
	0x007c7c,
	0x009393,
	0x00abab,
	0x00c3c3,
	0x00dbdb,
	0x00f3f3,
	0x0bffff,
	0x23ffff,
	0x3bffff,
	0x53ffff,
	0x6bffff,
	0x82ffff,
	0x9afefe,
	0xb2ffff,
	0x004c2d,
	0x00643c,
	0x007c4a,
	0x009358,
	0x00ab67,
	0x00c375,
	0x00db83,
	0x00f391,
	0x0bff9d,
	0x23ffa7,
	0x3bffb0,
	0x53ffba,
	0x6bffc3,
	0x82ffcd,
	0x9afed6,
	0xb2ffe0,
	0x004c0f,
	0x006414,
	0x007c18,
	0x00931d,
	0x00ab22,
	0x00c327,
	0x00db2b,
	0x00f330,
	0x0bff3c,
	0x23ff4f,
	0x3bff62,
	0x53ff75,
	0x6bff88,
	0x82ff9b,
	0x9afeae,
	0xb2ffc1,
	0x0f4c00,
	0x146400,
	0x187c00,
	0x1d9300,
	0x22ab00,
	0x27c300,
	0x2bdb00,
	0x30f300,
	0x3cff0b,
	0x4fff23,
	0x62ff3b,
	0x75ff53,
	0x88ff6b,
	0x9bff82,
	0xaefe9a,
	0xc1ffb2,
	0x2d4c00,
	0x3c6400,
	0x4a7c00,
	0x589300,
	0x67ab00,
	0x75c300,
	0x83db00,
	0x91f300,
	0x9dff0b,
	0xa7ff23,
	0xb0ff3b,
	0xbaff53,
	0xc3ff6b,
	0xcdff82,
	0xd6fe9a,
	0xe0ffb2,
	0x4c4c00,
	0x646400,
	0x7c7c00,
	0x939300,
	0xabab00,
	0xc3c300,
	0xdbdb00,
	0xf3f300,
	0xffff0b,
	0xffff23,
	0xffff3b,
	0xffff53,
	0xffff6b,
	0xffff82,
	0xfefe9a,
	0xffffb2,
};

// ----------------------------------------------------------------------------
//
// ----------------------------------------------------------------------------

bool 	rainbowIsOn 	= false;
int		paletteOffset	= 0;

// -----------------------------------------------------------------------------
//
// -----------------------------------------------------------------------------

void LoopPalette( int _screen, int _bg_number, int _offset )
{

	u16*		palette;
	int			i;
	int			pal_number = 0;
	
	if ( _screen == BOTTOM_SCREEN )
	{
		vramSetBankE(VRAM_E_LCD);  // On passe en mode LCD pour pouvoir ecrire dessus, on reviendre en palette apres
		palette = (u16*)(VRAM_E + (_bg_number << 12) + (pal_number << 8));
	}
	else {
		vramSetBankH(VRAM_H_LCD);  // On passe en mode LCD pour pouvoir ecrire dessus, on reviendre en palette apres
		palette = (u16*)(VRAM_H + (_bg_number << 12) + (pal_number << 8));
	}

	for( i=0; i<256; i++, palette ++ )
	{
		u32		col = rainbow_palette[16+(i+_offset)%240];
		u32 	R 	= col & 255;
		u32 	G 	= (col>>8)  & 255;
		u32 	B 	= (col>>16) & 255;
		u16 	r 	= R / 8;
		u16 	g 	= G / 8;
		u16 	b 	= B / 8;
		*palette 	= PA_RGB(r,g,b);
	}

	if ( _screen == BOTTOM_SCREEN )
	{
		vramSetBankE(VRAM_E_BG_EXT_PALETTE);
	}
	else
	{
		vramSetBankH(VRAM_H_SUB_BG_EXT_PALETTE);
	}
}

// ----------------------------------------------------------------------------
//
// ----------------------------------------------------------------------------

void StartRainbow( void )
{
	if ( !rainbowIsOn )
	{
		PA_LoadTiledBg	( TOP_SCREEN, 0, fujiforce 	); 
		PA_LoadTiledBg	( TOP_SCREEN, 1, rainbow 	);
		rainbowIsOn 	= true;
		paletteOffset	= 0;
	} 
}

// ----------------------------------------------------------------------------
//
// ----------------------------------------------------------------------------

void PlayRainbow( void )
{
	if ( rainbowIsOn )
	{
		LoopPalette( TOP_SCREEN, 1, paletteOffset ); 
		paletteOffset = (paletteOffset+1)%256;
	}
}

// ----------------------------------------------------------------------------
//
// ----------------------------------------------------------------------------

void EndRainbow( void )
{
	if ( rainbowIsOn )
	{
		//PA_DeleteBg	( TOP_SCREEN, 0	); 
		PA_DeleteBg	( TOP_SCREEN, 1	);
		rainbowIsOn = false;
	} 
}

// ----------------------------------------------------------------------------
// (c) papafuji - 2006 - using PAlib
// ----------------------------------------------------------------------------

