
#ifndef tracelog_h_INCLUDED
#define tracelog_h_INCLUDED

#include <inttypes.h>
#include <stdio.h>
#include <stdarg.h>

#include "config.h"
#include "types.h"

#ifndef tracelog_c_INCLUDED
// Since splint doesn't support variadic macros and thus cannot interpret
// TRACE_LOG, we have to inhibit warnings for the usage of the trace-stream.
/*@-exportlocal@*/
/*@null@*/ extern FILE *stream_t;
/*@+exportlocal@*/
#endif // tracelog_c_INCLUDED
 
#ifndef S_SPLINT_S
#ifdef ENABLE_TRACING

#define TRACE_LOG(...) \
if (stream_t != NULL) { fprintf(stream_t, __VA_ARGS__); fflush(stream_t); }
#define TRACE_LOG_Z_UCS _trace_log_z_ucs
void turn_on_trace(void);
void turn_off_trace(void);
void _trace_log_z_ucs(z_ucs *output);
#else /* ENABLE_TRACING */

#define TRACE_LOG(...) ;
#define TRACE_LOG_Z_UCS(...) ;

#endif /* ENABLE_TRACING */
#endif /* S_SPLINT_S */

#endif // tracelog_h_INCLUDED

