
#ifndef blockbuf_h_INCLUDED 
#define blockbuf_h_INCLUDED

#include "types.h"


struct blockbuf_char
{
  z_ucs character;
  z_font font;
  z_style style;
  z_colour foreground_colour;
  z_colour background_colour;
};


typedef struct 
{
  int width;
  int height;
  int xpos;
  int ypos;

  struct blockbuf_char *content;
  z_style current_style;
  z_font current_font;
  z_colour current_foreground_colour;
  z_colour current_background_colour;

  z_style default_style;
  z_font default_font;
  z_colour default_foreground_colour;
  z_colour default_background_colour;
} BLOCKBUF;


/*@null@*/ BLOCKBUF *create_blockbuffer(int width, int height,
    z_style default_style, z_font default_font,
    z_colour default_foreground_colour, z_colour default_background_colour);

void destroy_blockbuffer(/*@only@*/ BLOCKBUF *blockbuffer);

void store_z_ucs_output_in_blockbuffer(BLOCKBUF *buffer, z_ucs *z_ucs_output);

void set_blockbuf_cursor(BLOCKBUF *buffer, int x, int y);

void set_blockbuf_style(BLOCKBUF *buffer, z_style style);

void set_blockbuf_font(BLOCKBUF *buffer, z_font font);

void blockbuf_resize(BLOCKBUF *buffer, int new_width, int new_height);

#endif // blockbuf_h_INCLUDED

