//---------------------------------------------------------------------------

#ifndef storyH
#define storyH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>

#include "Main.h"
//---------------------------------------------------------------------------
struct story_id{
  String ifid;
  String format;
  int bafn;};

struct story_bib{
  String title;
  String author;
  String language;
  String headline;
  String firstpublished;
  String genre;
  String group;
  String description;
  String series;
  int seriesnumber;
  String forgiveness;};

struct story_metadata{
  story_id id;
  story_bib bib;};

class TStoryForm : public TForm
{
__published:	// IDE-managed Components
  TLabel *TitleLabel;
  TLabel *DetailLabel;
  TBevel *TitleBevel;
  TLabel *HeadlineLabel;
  TBevel *HeadlineBevel;
  TBevel *DesBevel;
  TLabel *DesLabel;
  TImage *CoverImage;
private:	// User declarations
  story_metadata metadata;
public:		// User declarations
  __fastcall TStoryForm(TComponent* Owner);
  void clear_metadata();
  void load_metadata(_di_IXMLDocument xml);
  void show_form(TFileStream *story_file);
};
//---------------------------------------------------------------------------
extern PACKAGE TStoryForm *StoryForm;
//---------------------------------------------------------------------------
#endif
