# DecInf: DecBasic to Inform 6 compiler.
# Written January 2007 by Johan Berntsson (johan@microheaven.com)
#
# This code is in public domain, but it would be polite to credit my name
# in any derivate work.

class BasicParser
option
  ignorecase

macro
  BLANK         \s+
  REMARK        \'              # '

rule
# How to recognize and parse remarks
		{REMARK}	{ state = :REM;	[:rem_in, text] } # '
		REM		{ state = :REM;	[:rem_in, text] }
  :REM        \n		{ state = nil;	[:rem_out, text] }
  :REM        .*(?=$)	{                	[:remark, text] }

# Skip blank lines
                {BLANK}	# no action

# Keywords		
		CRT		{ [:crt_function, text ] }
		CHR\$ 	{ [:chr_function, text ] }
		MID\$ 	{ [:mid_function, text ] }
		LEFT\$ 	{ [:left_function, text ] }
		RIGHT\$ 	{ [:right_function, text ] }
		SPACE\$	{ [:space_function, text ] }
		INT		{ [:int_function, text ] }
		VAL		{ [:val_function, text ] }
		RND		{ [:rnd_function, text ]}
		LEN		{ [:len_function, text ]}
		ASCII		{ [:ascii_function, text ]}
		INSTR	{ [:instr_function, text ] }
		TAB		{ [:tab_function, text ]}
		ABS           { [:abs_function, text ]}
		DATE\$	{ [:date_function, text ] }
		TIME\$	{ [:time_function, text ] }
		STR\$	{ [:str_function, text ] }
		ECHO		{ [:echo_function, text ] }
		SLEEP	{ [:sleep_function, text ] }
		ERL		{ [:erl_function, text ] }
		
		# -- C64 Basic
		PEEK		{ [:peek_function, text ] }
		POKE		{ [:poke, text ] }	
		WAIT		{ [:wait, text ] }	
		SYS		{ [:sys, text ] }
		GET		{ [:get, text ] }
		TI		{ [:ti_function, text ] }
		RUN		{ [:run, text ] }
		ASC		{ [:ascii_function, text ]}
		# -- C64 Basic
		
		# --- Inform keyword extensions (not Basic!)
		INFORMSAVEGAME	{ [:inform_save_game, text] }
		INFORMRESTOREGAME	{ [:inform_restore_game, text] }
		INFORMSAVEUNDO	{ [:inform_save_undo, text] }
		INFORMRESTOREUNDO	{ [:inform_restore_undo, text] }
		# --- 

		SET		{ [:set, text] }
		LOF		{ [:lof, text ] }
		DEF		{ [:def, text] }
		FNEND	{ [:fnend, text] }
		NOT		{ [:not, text] }
		DIM		{ [:dim, text] }
                FOR		{ [:for, text] }
                TO		{ [:to, text] }
                STEP		{ [:step, text] }
                NEXT		{ [:next, text] }
                IF		{ [:if, text] }
                THEN		{ [:then, text] }
		ELSE          { [:else, text] }
                INPUT	{ [:input, text] }
                PRINT	{ [:print, text] }
		ON            { [:on, text ]}
                GOTO	{ [:goto, text] }
		GOSUB	{ [:gosub, text] }
		RETURN	{ [:return, text] }
		END		{ [:end_token, text] }
		AND		{ [:and, text] }
		OR		{ [:or, text] }
		CLOSE	{ [:close, text] }
		LINE		{ [:line, text] }
		OPEN		{ [:open, text] }
		INPUT	{ [:input, text] }
		OUTPUT	{ [:output, text] }
		AS		{ [:as, text] }
		FILE		{ [:file, text ]}
		RESUME	{ [:resume, text] }
		ERROR        { [:error, text] }
		MARGIN	{ [:margin, text] }
		QUOTE	{ [:quote, text] }
		STOP		{ [:stop, text] }
		READ		{ [:read, text] }
		WRITE	{ [:write, text] }
		DATA		{ [:data, text] }
		CHANGE	{ [:change, text] }
		
		ERR		{ [:err_function, text ] }

# operators
		<>					{ [:NEQ, text ] }
		>=					{ [:GE, text ] }
		<=					{ [:LE, text ] }
		
# statement separator (<line_no> <statement> [\ <statment> ]*) 
		[\\]					{ [:separator, text ] }
		:					{ [:separator, text ] } # C64 Basic

# value and variable formats
                \"[^"]*\"				{ [:string, text] }
		\d*\.\d*				{ [:float, text.to_f] }
		\d+%?				{ [:int, text.to_i] }
		FN[A-Z,0-9]\$			{ [:sfnc_id, text] } # user defined function
		[A-Z]\w*\d*\$			{ [:svar_id, text] }
		[A-Z]\w*\d*%?			{ [:ivar_id, text] }
                .					{ [text, text] }
end
