package zpplet.ops;

import zpplet.machine.ZMachine;

public class ZStackFrame
	{
	/* Creates a stack frame, updating the zm and zm.zi to reflect 
	 * a call made to zi.o[0].  Pretty much does entire routine call and return.
	 */
	
	public int[] l;
	public int args; // number of arguments passed on this invocation (used by Quetzal)
	public int pc; // location to which to return
	public int store; // variable to store into 
	public boolean interrupt; // true if called in an interrupt routine
	
	public ZStackFrame()
		{}
	
	public ZStackFrame(ZMachine zm, boolean stores)
		{
		if (stores)
			store = zm.getCodeByte();
		else
			store = -1;
		interrupt = zm.zi.interrupting;

		pc = zm.pc;
		l = zm.l;
		zm.pc = zm.unpackRAddr(zm.zi.o[0]);

		int nlocals = zm.getCodeByte(); // from first byte of target
		if (nlocals < (zm.zi.noperands - 1))
			args = nlocals;
		else
			args = zm.zi.noperands - 1;
		zm.l = new int[nlocals];
		zm.zi.nargs = args;

		zm.zi.loadParameters(nlocals);
		}
	
	public void restore(ZMachine zm, int retval)
		{
		zm.l = l;
		zm.pc = pc;
		zm.zi.nargs = args;
		if (store > -1)
			zm.setVariable(store, retval);
		
		else if (zm.zi.interrupting && !interrupt)
			{
			// exiting an interrupt routine
			zm.zi.interrupting = false;
			zm.setVariable(0, retval); // push interrupt result onto stack
			}
		}
	}
