package zpplet.iff;

import java.io.*;
import java.util.*;

public class IFF
		extends RandomAccessFile
	{
	protected Stack openchunks; // Chunk info
	
	public class ChunkInfo
		{
		public String type; // 4 or 8 characters
		public long start; // of chunk including header
		public int length; // of body
		public boolean composite; // contains chunks
		}

	public IFF(String name, String mode)
			throws IOException
		{
		super(name, mode);
		openchunks = new Stack();
		}

	public IFF(File file, String mode)
			throws IOException
		{
		super(file, mode);
		openchunks = new Stack();
		}

	// moves to a position within the current chunk
	public void chunkSeek(int offset)
			throws IOException
		{
		seek(((ChunkInfo)openchunks.peek()).start + 8 + offset);
		}

	// returns position within current chunk
	public int getChunkPosition()
			throws IOException
		{
		return (int)(getFilePointer() - ((ChunkInfo)openchunks.peek()).start - 8);
		}
	
	public String read4Chars()
			throws IOException
		{
		byte[] b = new byte[4];
		read(b, 0, 4);
		return new String(b);
		}
	}
