package zpplet.data;

import zpplet.machine.ZMachine;

/*
 * Same as ZDictionary4, except address is provided, and entries may be unsorted
 */

public class ZUserDictionary
		extends ZDictionary4
	{
	private boolean unsorted;
	
	public ZUserDictionary(ZMachine zm, int addr)
		{
		this.zm = zm;
		this.addr = addr;
		
		int n = zm.getByte(addr);
		char[] separray = new char[n];
		for (int i = 0; i < n; i++)
			separray[i] = (char)zm.getByte(addr + i + 1);
		separators = new String(separray);
		
		entry_length = zm.getByte(addr + n + 1);
		nentries = zm.getWord(addr + n + 2);
		unsorted = (nentries < 0);
		if (unsorted)
			nentries = -nentries;
		wtable_addr = addr + n + 4;
		}

	protected boolean addToken(int textaddr, int wordaddr, int wordlength, int parseaddr, boolean keepUnknown)
		{
		if (!unsorted)
			return super.addToken(textaddr, wordaddr, wordlength, parseaddr, keepUnknown);
		
		if (zm.getByte(parseaddr) == zm.getByte(parseaddr + 1))
			return true;

		int[] encword = zm.zc.encode(wordaddr, wordlength, 3);
		long enclong = ((long)encword[0] << 32) | ((long)encword[1] << 16) | encword[2];

		int dictloc = 0;
		long dictlong = 0;
		
		for (int entry = 0; entry < nentries; entry++)
			{
			dictloc = wtable_addr + entry * entry_length;
			dictlong = ((long)zm.getWord(dictloc) << 32) | ((long)zm.getWord(dictloc + 2) << 16) |
				zm.getWord(dictloc + 4);
			if (enclong == dictlong)
				break;
			}

		if (enclong != dictlong)
			dictloc = 0;

		if ((dictloc != 0) || keepUnknown)
			{
			int parseentry = parseaddr + zm.getByte(parseaddr + 1) * 4 + 2;
			zm.setWord(parseentry, dictloc);
			zm.setByte(parseentry + 2, wordlength);
			zm.setByte(parseentry + 3, wordaddr - textaddr);
			zm.setByte(parseaddr + 1, zm.getByte(parseaddr + 1) + 1);
			}
		return (zm.getByte(parseaddr) == zm.getByte(parseaddr + 1));
		}
	}
