/*
 * Decompiled with CFR 0.152.
 */
package zpplet.ops;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import zpplet.machine.ZMachine;
import zpplet.misc.ZError;
import zpplet.ops.ZInstruction;
import zpplet.ops.ZInstruction5;
import zpplet.system.ZWindow;

public class ZInstruction6
extends ZInstruction5 {
    private static final int CURRENT_WINDOW = -3;

    public ZInstruction6(ZMachine zm) {
        super(zm);
    }

    public void callMain() {
        this.noperands = 1;
        this.o[0] = (short)this.zm.hd.getInitialPC();
        this.doCall(false);
    }

    protected void initOps() {
        super.initOps();
        this.ops[233] = new OP_PULL();
        this.ops[239] = new OP_SET_CURSOR();
        this.ops[242] = new ZInstruction.OP_NOP(this);
        this.ops[261] = new OP_DRAW_PICTURE();
        this.ops[262] = new OP_PICTURE_DATA();
        this.ops[263] = new OP_ERASE_PICTURE();
        this.ops[264] = new OP_SET_MARGINS();
        this.ops[272] = new OP_MOVE_WINDOW();
        this.ops[273] = new OP_WINDOW_SIZE();
        this.ops[274] = new OP_WINDOW_STYLE();
        this.ops[275] = new OP_GET_WIND_PROP();
        this.ops[276] = new OP_SCROLL_WINDOW();
        this.ops[277] = new OP_POP_STACK();
        this.ops[278] = new OP_READ_MOUSE();
        this.ops[279] = new OP_MOUSE_WINDOW();
        this.ops[280] = new OP_PUSH_STACK();
        this.ops[281] = new OP_PUT_WIND_PROP();
        this.ops[282] = new OP_PRINT_FORM();
        this.ops[283] = new OP_MAKE_MENU();
        this.ops[284] = new OP_PICTURE_TABLE();
    }

    protected void doEraseWindow() {
        short n = (short)this.o[0];
        if (n == -1) {
            this.doSplitWindow(0);
            this.zm.s.clear();
            this.zm.w[0].moveCursor(1, 1);
        } else if (n == -2) {
            this.zm.s.clear();
        } else {
            this.zm.w[this.o[0]].clear();
            this.zm.w[this.o[0]].moveCursor(1, 1);
        }
    }

    protected void doSplitWindow(int lines) {
        this.zm.w[1].moveTo(1, 1);
        this.zm.w[1].resize(this.zm.s.getBoundsWidth(), lines);
        this.zm.w[0].moveTo(1, 1 + lines);
        this.zm.w[0].resize(this.zm.s.getBoundsWidth(), this.zm.s.getBoundsHeight() - lines);
    }

    protected void doSetColour() {
        ZWindow w = this.noperands < 3 || (short)this.o[2] == -3 ? this.zm.curw : this.zm.w[this.o[2]];
        w.setColor((short)this.o[0], (short)this.o[1]);
    }

    protected void doEraseLine() {
        if (this.o[0] == 1) {
            this.zm.curw.eraseLine();
        } else {
            this.zm.curw.eraseLineTo(this.o[0] - 1);
        }
    }

    class OP_PULL
    implements ZInstruction.IOP {
        OP_PULL() {
        }

        public void x() {
            if (ZInstruction6.this.noperands == 0 || ZInstruction6.this.o[0] == 0) {
                ZInstruction6.this.doStore(ZInstruction6.this.zm.getVariable(0));
            } else {
                int stackbase = ZInstruction6.this.o[0];
                int stackcount = ZInstruction6.this.zm.getWord(stackbase) + 1;
                int pulled = ZInstruction6.this.zm.getWord(stackbase + stackcount * 2);
                ZInstruction6.this.zm.setWord(stackbase, stackcount);
                ZInstruction6.this.doStore(pulled);
            }
        }
    }

    class OP_SET_CURSOR
    implements ZInstruction.IOP {
        OP_SET_CURSOR() {
        }

        public void x() {
            ZWindow window;
            ZWindow zWindow = window = ZInstruction6.this.noperands < 3 || (short)ZInstruction6.this.o[2] == -3 ? ZInstruction6.this.zm.curw : ZInstruction6.this.zm.w[ZInstruction6.this.o[2]];
            if ((short)ZInstruction6.this.o[0] >= 0) {
                window.moveCursor((short)ZInstruction6.this.o[1], (short)ZInstruction6.this.o[0]);
            }
        }
    }

    class OP_DRAW_PICTURE
    implements ZInstruction.IOP {
        OP_DRAW_PICTURE() {
        }

        public void x() {
            int y = ZInstruction6.this.o[1] == 0 ? ZInstruction6.this.zm.curw.getPosY() : ZInstruction6.this.zm.curw.top + ZInstruction6.this.o[1] - 1;
            int x = ZInstruction6.this.o[2] == 0 ? ZInstruction6.this.zm.curw.getPosX() : ZInstruction6.this.zm.curw.left + ZInstruction6.this.o[2] - 1;
            Image img = ZInstruction6.this.zm.media.getImage(ZInstruction6.this.o[0]);
            if (img != null) {
                ZInstruction6.this.zm.s.drawImage(img, x, y, ZInstruction6.this.zm.curw);
            }
        }
    }

    class OP_PICTURE_DATA
    implements ZInstruction.IOP {
        OP_PICTURE_DATA() {
        }

        public void x() {
            if (ZInstruction6.this.o[0] == 0) {
                if (ZInstruction6.this.zm.media != null) {
                    ZInstruction6.this.zm.setWord(ZInstruction6.this.o[1], ZInstruction6.this.zm.media.getPictureCount());
                    ZInstruction6.this.zm.setWord(ZInstruction6.this.o[1] + 2, 0);
                    ZInstruction6.this.doBranch(true);
                } else {
                    ZInstruction6.this.doBranch(false);
                }
            } else {
                Dimension p = ZInstruction6.this.zm.media.getImageData(ZInstruction6.this.o[0]);
                if (p != null) {
                    ZInstruction6.this.zm.setWord(ZInstruction6.this.o[1], p.height);
                    ZInstruction6.this.zm.setWord(ZInstruction6.this.o[1] + 2, p.width);
                    ZInstruction6.this.doBranch(true);
                } else {
                    ZInstruction6.this.zm.setWord(ZInstruction6.this.o[1], 0);
                    ZInstruction6.this.zm.setWord(ZInstruction6.this.o[1] + 2, 0);
                    ZInstruction6.this.doBranch(false);
                }
            }
        }
    }

    class OP_ERASE_PICTURE
    implements ZInstruction.IOP {
        OP_ERASE_PICTURE() {
        }

        public void x() {
            int y = ZInstruction6.this.o[1] == 0 ? ZInstruction6.this.zm.curw.getPosY() : ZInstruction6.this.zm.curw.top + ZInstruction6.this.o[1] - 1;
            int x = ZInstruction6.this.o[2] == 0 ? ZInstruction6.this.zm.curw.getPosX() : ZInstruction6.this.zm.curw.left + ZInstruction6.this.o[2] - 1;
            Dimension p = ZInstruction6.this.zm.media.getImageData(ZInstruction6.this.o[0]);
            if (p != null) {
                ZInstruction6.this.zm.s.eraseRegion(x, y, p.width, p.height, ZInstruction6.this.zm.curw.font.getBack());
            }
        }
    }

    class OP_SET_MARGINS
    implements ZInstruction.IOP {
        OP_SET_MARGINS() {
        }

        public void x() {
            ZWindow window = ZInstruction6.this.noperands < 3 || (short)ZInstruction6.this.o[2] == -3 ? ZInstruction6.this.zm.curw : ZInstruction6.this.zm.w[ZInstruction6.this.o[2]];
            window.setMargins(ZInstruction6.this.o[0], ZInstruction6.this.o[1]);
        }
    }

    class OP_MOVE_WINDOW
    implements ZInstruction.IOP {
        OP_MOVE_WINDOW() {
        }

        public void x() {
            ZWindow window = (short)ZInstruction6.this.o[0] == -3 ? ZInstruction6.this.zm.curw : ZInstruction6.this.zm.w[ZInstruction6.this.o[0]];
            window.moveTo(ZInstruction6.this.o[2], ZInstruction6.this.o[1]);
        }
    }

    class OP_WINDOW_SIZE
    implements ZInstruction.IOP {
        OP_WINDOW_SIZE() {
        }

        public void x() {
            ZWindow window = (short)ZInstruction6.this.o[0] == -3 ? ZInstruction6.this.zm.curw : ZInstruction6.this.zm.w[ZInstruction6.this.o[0]];
            window.resize(ZInstruction6.this.o[2], ZInstruction6.this.o[1]);
        }
    }

    class OP_WINDOW_STYLE
    implements ZInstruction.IOP {
        OP_WINDOW_STYLE() {
        }

        public void x() throws ZError {
            ZWindow window = (short)ZInstruction6.this.o[0] == -3 ? ZInstruction6.this.zm.curw : ZInstruction6.this.zm.w[ZInstruction6.this.o[0]];
            window.setWindowStyle(ZInstruction6.this.o[1], ZInstruction6.this.o[2]);
        }
    }

    class OP_GET_WIND_PROP
    implements ZInstruction.IOP {
        OP_GET_WIND_PROP() {
        }

        public void x() throws ZError {
            ZWindow window = (short)ZInstruction6.this.o[0] == -3 ? ZInstruction6.this.zm.curw : ZInstruction6.this.zm.w[ZInstruction6.this.o[0]];
            ZInstruction6.this.doStore(window.getProp(ZInstruction6.this.o[1]));
        }
    }

    class OP_SCROLL_WINDOW
    implements ZInstruction.IOP {
        OP_SCROLL_WINDOW() {
        }

        public void x() {
            ZWindow window = (short)ZInstruction6.this.o[0] == -3 ? ZInstruction6.this.zm.curw : ZInstruction6.this.zm.w[ZInstruction6.this.o[0]];
            short n = (short)ZInstruction6.this.o[1];
            if (n > 0) {
                ZInstruction6.this.zm.s.scrollUp(window, n);
            } else if (n < 0) {
                ZInstruction6.this.zm.s.scrollDown(window, -n);
            }
        }
    }

    class OP_POP_STACK
    implements ZInstruction.IOP {
        OP_POP_STACK() {
        }

        public void x() {
            if (ZInstruction6.this.noperands < 2 || ZInstruction6.this.o[1] == 0) {
                int i = 0;
                while (i < ZInstruction6.this.o[0]) {
                    ZInstruction6.this.zm.getVariable(0);
                    ++i;
                }
            } else {
                int stackbase = ZInstruction6.this.o[1];
                int stackcount = ZInstruction6.this.zm.getWord(stackbase);
                ZInstruction6.this.zm.setWord(stackbase, stackcount + ZInstruction6.this.o[0]);
            }
        }
    }

    class OP_READ_MOUSE
    implements ZInstruction.IOP {
        OP_READ_MOUSE() {
        }

        public void x() {
            PointerInfo pi = MouseInfo.getPointerInfo();
            ZInstruction6.this.zm.setWord(ZInstruction6.this.o[0], pi.getLocation().y);
            ZInstruction6.this.zm.setWord(ZInstruction6.this.o[0] + 2, pi.getLocation().x);
            ZInstruction6.this.zm.setWord(ZInstruction6.this.o[0] + 4, ZInstruction6.this.zm.s.getMouseButtons());
            ZInstruction6.this.zm.setWord(ZInstruction6.this.o[0] + 6, 0);
        }
    }

    class OP_MOUSE_WINDOW
    implements ZInstruction.IOP {
        OP_MOUSE_WINDOW() {
        }

        public void x() {
            ZInstruction6.this.zm.s.setMouseWindow((short)ZInstruction6.this.o[0]);
        }
    }

    class OP_PUSH_STACK
    implements ZInstruction.IOP {
        OP_PUSH_STACK() {
        }

        public void x() {
            if (ZInstruction6.this.noperands < 2 || ZInstruction6.this.o[1] == 0) {
                ZInstruction6.this.zm.setVariable(0, ZInstruction6.this.o[0]);
                ZInstruction6.this.doBranch(true);
                return;
            }
            int stackbase = ZInstruction6.this.o[1];
            int stackcount = ZInstruction6.this.zm.getWord(stackbase);
            if (stackcount > 0) {
                ZInstruction6.this.zm.setWord(stackbase + stackcount * 2, ZInstruction6.this.o[0]);
                ZInstruction6.this.zm.setWord(stackbase, stackcount - 1);
                ZInstruction6.this.doBranch(true);
            } else {
                ZInstruction6.this.doBranch(false);
            }
        }
    }

    class OP_PUT_WIND_PROP
    implements ZInstruction.IOP {
        OP_PUT_WIND_PROP() {
        }

        public void x() throws ZError {
            ZWindow window = (short)ZInstruction6.this.o[0] == -3 ? ZInstruction6.this.zm.curw : ZInstruction6.this.zm.w[ZInstruction6.this.o[0]];
            window.setProp(ZInstruction6.this.o[1], ZInstruction6.this.o[2]);
        }
    }

    class OP_PRINT_FORM
    implements ZInstruction.IOP {
        OP_PRINT_FORM() {
        }

        public void x() {
            int len;
            int addr = ZInstruction6.this.zm.getWord(ZInstruction6.this.o[0]);
            while ((len = ZInstruction6.this.zm.getWord(addr)) != 0) {
                addr += 2;
                int i = 0;
                while (i < len) {
                    ZInstruction6.this.zm.printAsciiChar(ZInstruction6.this.zm.getByte(addr + i));
                    ++i;
                }
                ZInstruction6.this.zm.printAsciiChar(13);
                addr += len;
            }
        }
    }

    class OP_MAKE_MENU
    implements ZInstruction.IOP {
        OP_MAKE_MENU() {
        }

        public void x() {
            System.err.println("MAKE MENU operation attempted.");
            ZInstruction6.this.doBranch(false);
        }
    }

    class OP_PICTURE_TABLE
    implements ZInstruction.IOP {
        OP_PICTURE_TABLE() {
        }

        public void x() {
        }
    }
}

