/*
 * Decompiled with CFR 0.152.
 */
package zpplet.machine;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import java.util.Stack;
import javax.swing.JOptionPane;
import zpplet.data.ZDictionary;
import zpplet.data.ZObjectTree;
import zpplet.header.ZHeader;
import zpplet.machine.ZMachine2;
import zpplet.machine.ZMachine3;
import zpplet.machine.ZMachine4;
import zpplet.machine.ZMachine5;
import zpplet.machine.ZMachine6;
import zpplet.machine.ZMachine7;
import zpplet.machine.ZMachine8;
import zpplet.misc.ZChars;
import zpplet.misc.ZError;
import zpplet.misc.ZState;
import zpplet.ops.ZInstruction;
import zpplet.system.ZMedia;
import zpplet.system.ZScreen;
import zpplet.system.ZWindow;

public abstract class ZMachine
extends Thread {
    protected static final int STANDARDS_VERSION_MAJOR = 0;
    protected static final int STANDARDS_VERSION_MINOR = 0;
    protected static final int INTERPRETER_VERSION = 74;
    public static final int OSTREAM_SCREEN = 1;
    public static final int OSTREAM_TRANSCRIPT = 2;
    public static final int OSTREAM_MEMORY = 3;
    public static final int OSTREAM_LOG = 4;
    public static final int ISTREAM_KEYBOARD = 0;
    public static final int ISTREAM_LOG = 1;
    public boolean running;
    public int pc;
    public ZWindow[] w;
    public ZWindow curw;
    public ZHeader hd;
    public ZScreen s;
    public ZObjectTree objs;
    public ZDictionary zd;
    public Random random;
    protected byte[] m;
    public Stack st;
    public int[] l;
    protected int g;
    public ZState restart;
    public int checksum;
    public boolean[] outputs;
    public BufferedWriter transcript;
    public Stack stream3;
    public BufferedWriter log;
    public BufferedReader input;
    public ZInstruction zi;
    public ZChars zc;
    public ZMedia media;

    public ZMachine(byte[] m, ZScreen s) {
        this.m = m;
        this.s = s;
        s.attach(this);
        this.setDaemon(true);
        this.running = false;
        this.zc = new ZChars(this);
        this.l = new int[0];
        this.st = new Stack();
        this.random = new Random();
        this.outputs = new boolean[5];
        this.outputs[1] = true;
        this.input = null;
        this.stream3 = new Stack();
    }

    public boolean wantsMedia() {
        ZHeader header = new ZHeader(this.m);
        return this.media == null && header.wantsMedia();
    }

    public static ZMachine NewZMachine(String fname, ZScreen screen) {
        byte[] data;
        try {
            File f = new File(fname);
            data = new byte[(int)f.length()];
            FileInputStream fs = new FileInputStream(fname);
            fs.read(data);
            fs.close();
        }
        catch (IOException iOException) {
            return null;
        }
        switch (ZHeader.getImageVersion(data)) {
            case 2: {
                return new ZMachine2(data, screen);
            }
            case 3: {
                return new ZMachine3(data, screen);
            }
            case 4: {
                return new ZMachine4(data, screen);
            }
            case 5: {
                return new ZMachine5(data, screen);
            }
            case 6: {
                return new ZMachine6(data, screen);
            }
            case 7: {
                return new ZMachine7(data, screen);
            }
            case 8: {
                return new ZMachine8(data, screen);
            }
            case 70: {
                data = null;
                ZMedia m = new ZMedia();
                if (!m.readBlorbFile(fname)) break;
                return m.getZM(screen);
            }
        }
        return null;
    }

    public static ZMachine NewZMachine(byte[] data, ZScreen screen) {
        switch (ZHeader.getImageVersion(data)) {
            case 2: {
                return new ZMachine2(data, screen);
            }
            case 3: {
                return new ZMachine3(data, screen);
            }
            case 4: {
                return new ZMachine4(data, screen);
            }
            case 5: {
                return new ZMachine5(data, screen);
            }
            case 6: {
                return new ZMachine6(data, screen);
            }
            case 7: {
                return new ZMachine7(data, screen);
            }
            case 8: {
                return new ZMachine8(data, screen);
            }
        }
        return null;
    }

    public void loadMedia(String fname) {
        try {
            this.media = new ZMedia();
            if (!this.media.readBlorbFile(fname)) {
                this.media = null;
            }
        }
        catch (Exception exception) {
            this.media = null;
        }
    }

    public final synchronized void kill() {
        this.running = false;
        this.s.detach();
        int i = 0;
        while (i < this.w.length) {
            this.w[i] = null;
            ++i;
        }
        this.interrupt();
        boolean joined = false;
        while (!joined) {
            try {
                this.join();
                joined = true;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected abstract void initStructures();

    protected abstract void initWindows();

    public abstract void setHeaderFlags();

    public final void start() {
        this.initStructures();
        this.s.redoMetrics();
        this.setHeaderFlags();
        this.initWindows();
        this.g = this.hd.getGlobalTableAddr();
        this.checksum = this.calculateChecksum();
        this.zi.callMain();
        this.hd.setTranscripting(false);
        this.restart = new ZState(this);
        this.running = true;
        this.s.clear();
        this.s.requestFocus();
        super.start();
    }

    public final void run() {
        while (this.running) {
            try {
                this.zi.decode();
                this.zi.execute();
            }
            catch (Exception e) {
                if (e.getMessage() != null) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this.s, e.getMessage(), null, 2);
                }
                this.running = false;
            }
        }
    }

    public void restart() {
        this.restart.restoreSnapshot();
    }

    public void updateStatusLine() {
        ZWindow current = this.curw;
        try {
            String right;
            String left = this.getStringAt(this.objs.getShortNameAddr(this.getVariable(16)));
            this.w[1].clear();
            this.w[1].moveCursor(2, 1);
            this.curw = this.w[1];
            this.printAsciiString(left);
            if (this.hd.isTimeGame()) {
                int hours = this.getVariable(17);
                int minutes = this.getVariable(18);
                String meridiem = hours < 12 ? "AM" : "PM";
                if ((hours %= 12) == 0) {
                    hours = 12;
                }
                right = String.valueOf(Integer.toString(hours)) + (minutes < 10 ? ":0" : ":") + Integer.toString(minutes) + meridiem;
            } else {
                int score = this.getVariable(17);
                int turns = this.getVariable(18);
                right = String.valueOf(Integer.toString(score)) + "/" + Integer.toString(turns);
            }
            this.w[1].moveCursor(this.s.getChars() - right.length() - 1, 1);
            this.printAsciiString(right);
        }
        catch (ZError zError) {}
        this.curw = current;
    }

    public abstract int unpackSAddr(int var1);

    public abstract int unpackRAddr(int var1);

    public final void printAsciiChar(int ch) {
        if (this.outputs[3]) {
            this.printToStream3(ch);
            return;
        }
        if (this.outputs[1]) {
            if (this.zc.isTerminator(ch)) {
                this.curw.newLine();
            } else {
                this.curw.printZAscii(ch);
            }
        }
        if (this.outputs[2]) {
            try {
                this.transcript.write(ch);
            }
            catch (IOException iOException) {
                System.err.println("Transcript write FAILED");
            }
        }
    }

    public abstract String getStringAt(int var1) throws ZError;

    protected final int calculateChecksum() {
        int filesize = this.hd.getFileLength();
        int result = 0;
        if (filesize <= this.m.length) {
            int i = 64;
            while (i < filesize) {
                result += this.getByte(i);
                ++i;
            }
        }
        return result & 0xFFFF;
    }

    public final int getVariable(int varnum) {
        if (varnum == 0) {
            return (Integer)this.st.pop();
        }
        if (varnum >= 16) {
            return this.getWord(this.g + (varnum - 16) * 2);
        }
        return this.l[varnum - 1];
    }

    public final void setVariable(int varnum, int val) {
        val &= 0xFFFF;
        if (varnum == 0) {
            this.st.push(new Integer(val));
        } else if (varnum < 16) {
            this.l[varnum - 1] = val;
        } else {
            this.setWord(this.g + (varnum - 16) * 2, val);
        }
    }

    public final int getCodeByte() {
        return this.m[this.pc++] & 0xFF;
    }

    public final int getCodeWord() {
        return this.m[this.pc++] << 8 & 0xFF00 | this.m[this.pc++] & 0xFF;
    }

    public final int getByte(int addr) {
        return this.m[addr] & 0xFF;
    }

    public final void setByte(int addr, int val) {
        this.m[addr] = (byte)(val & 0xFF);
    }

    public final int getWord(int addr) {
        return this.m[addr] << 8 & 0xFF00 | this.m[addr + 1] & 0xFF;
    }

    public final void setWord(int addr, int val) {
        this.m[addr] = (byte)(val >> 8 & 0xFF);
        this.m[addr + 1] = (byte)(val & 0xFF);
    }

    public final int getInput(boolean buffered, int timeout, int timeoutroutine) {
        int result = 0;
        result = buffered ? this.s.readBufferedCode(timeout, timeoutroutine) : this.s.readKeyCode(timeout, timeoutroutine);
        if (this.outputs[4] && result >= 0) {
            try {
                this.log.write(result);
            }
            catch (IOException iOException) {
                System.err.println("Log write FAILED");
            }
        }
        return result;
    }

    public void resize0(int height) {
        this.w[0].clear();
    }

    public void resize() {
        this.w[0].resize(this.s.getChars(), this.s.getLines() - this.w[1].getLines());
        this.w[1].resize(this.s.getChars(), this.w[1].getLines());
        this.updateStatusLine();
    }

    public final byte[] getMem() {
        return this.m;
    }

    public final boolean verifyChecksum() {
        return this.hd.getFileLength() <= this.m.length && this.hd.getChecksum() == this.checksum;
    }

    public void openStream3(int addr, int width) {
        this.stream3.push(new Stream3Data(addr, width));
        this.outputs[3] = true;
        this.setWord(addr, 0);
    }

    public void closeStream3() {
        this.stream3.pop();
        this.outputs[3] = !this.stream3.isEmpty();
    }

    public void printToStream3(int ch) {
        int printmemory = ((Stream3Data)this.stream3.peek()).addr;
        int nchars = this.getWord(printmemory);
        this.setByte(printmemory + nchars + 2, ch);
        this.setWord(printmemory, ++nchars);
    }

    public void printAsciiString(String s) {
        int i = 0;
        while (i < s.length()) {
            this.printAsciiChar(s.charAt(i));
            ++i;
        }
    }

    public int printStringAt(int addr) throws ZError {
        String s = this.getStringAt(addr);
        this.printAsciiString(s);
        return s.length();
    }

    public void debugDumpHeader() {
        int i = 0;
        while (i < 56) {
            System.out.println("0x" + Integer.toHexString(i) + ": " + this.getByte(i));
            ++i;
        }
    }

    public void setOutputStream(int stream, boolean value, int addr, int width) {
        switch (stream) {
            case 1: {
                this.outputs[stream] = value;
                break;
            }
            case 3: {
                if (value) {
                    this.openStream3(addr, width);
                    break;
                }
                this.closeStream3();
                break;
            }
            case 2: {
                if (value) {
                    String fn = this.s.getFileName("Create Transcript", true);
                    value = false;
                    if (fn != null) {
                        try {
                            this.transcript = new BufferedWriter(new FileWriter(fn));
                            value = true;
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    try {
                        this.transcript.close();
                    }
                    catch (IOException iOException) {}
                    this.transcript = null;
                }
                this.hd.setTranscripting(value);
                this.outputs[stream] = value;
                break;
            }
            case 4: {
                if (value) {
                    String fn = this.s.getFileName("Create Log", true);
                    value = false;
                    if (fn != null) {
                        try {
                            this.log = new BufferedWriter(new FileWriter(fn));
                            value = true;
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    try {
                        this.log.close();
                    }
                    catch (IOException iOException) {}
                    this.log = null;
                }
                this.outputs[stream] = value;
                break;
            }
            default: {
                System.err.println("Attempted to set stream " + stream + " to " + value);
            }
        }
    }

    public synchronized void setInputStream(int n) {
        if (n == 0) {
            if (this.input == null) {
                return;
            }
            try {
                this.input.close();
            }
            catch (IOException iOException) {}
            this.input = null;
            return;
        }
        if (n == 1) {
            try {
                if (this.input != null) {
                    this.input.close();
                }
            }
            catch (IOException iOException) {}
            this.input = null;
            String fn = this.s.getFileName("Open Log File", false);
            if (fn != null) {
                try {
                    this.input = new BufferedReader(new FileReader(fn));
                    this.s.primeInput();
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
            return;
        }
        System.err.println("Tried to set input stream to " + n);
    }

    public void notifyConfigChange() {
        this.w[0].font.touch();
        this.s.setSize(this.s.getWidth(), this.s.getHeight());
        this.s.repaint();
    }

    protected class Stream3Data {
        public int addr;
        public int width;
        public int pixelwidth;

        public Stream3Data(int addr, int width) {
            this.addr = addr;
            this.width = width;
            this.pixelwidth = 0;
        }
    }
}

