/*
 * Decompiled with CFR 0.152.
 */
package zpplet.header;

import zpplet.ZUserConfig;

public class ZHeader {
    protected byte[] m;
    protected static final int VERSION = 0;
    protected static final int FLAGS1 = 1;
    protected static final int RELEASE = 2;
    protected static final int HIGH_BASE = 4;
    protected static final int INITIAL_PC = 6;
    protected static final int DICTIONARY = 8;
    protected static final int OBJECT_TABLE = 10;
    protected static final int GLOBAL_TABLE = 12;
    protected static final int STATIC_BASE = 14;
    protected static final int FLAGS2 = 16;
    protected static final int SERIAL_NUMBER = 18;
    protected static final int ABBREV_TABLE = 24;
    protected static final int FILE_LENGTH = 26;
    protected static final int FILE_CHECKSUM = 28;
    protected static final int STD_REVISION = 50;
    public static final int UNKNOWN = 0;
    public static final int BEYOND_ZORK = 1;
    public static final int SHERLOCK = 2;
    public static final int ZORK_ZERO = 3;
    public static final int SHOGUN = 4;
    public static final int ARTHUR = 5;
    public static final int JOURNEY = 6;
    public static final int LURKING_HORROR = 7;
    private static Record[] records = new Record[]{new Record(2, 21, "871214"), new Record(2, 26, "880127"), new Record(1, 47, "870915"), new Record(1, 49, "870917"), new Record(1, 51, "870923"), new Record(1, 57, "871221"), new Record(3, 296, "881019"), new Record(3, 366, "890323"), new Record(3, 383, "890602"), new Record(3, 393, "890714"), new Record(4, 292, "890314"), new Record(4, 295, "890321"), new Record(4, 311, "890510"), new Record(4, 322, "890706"), new Record(5, 54, "890606"), new Record(5, 63, "890622"), new Record(5, 74, "890714"), new Record(6, 26, "890316"), new Record(6, 30, "890322"), new Record(6, 77, "890616"), new Record(6, 83, "890706"), new Record(7, 203, "870506"), new Record(7, 219, "870912"), new Record(7, 221, "870918")};
    public int story;
    public boolean newlineatstart;

    public ZHeader(byte[] m) {
        this.m = m;
        this.story = 0;
        int i = 0;
        while (i < records.length) {
            String serial;
            if (this.getRelease() == ZHeader.records[i].release && (serial = new String(this.getSerialNumber())).equals(ZHeader.records[i].serial)) {
                this.story = ZHeader.records[i].story;
                break;
            }
            ++i;
        }
        this.newlineatstart = ZUserConfig.interpreter != 6 || this.story != 3 || this.getRelease() != 393;
    }

    public boolean wantsMedia() {
        return (this.m[17] & 0x88) != 0 || this.story == 7;
    }

    public boolean useAmigaScreenModel() {
        if (ZUserConfig.interpreter == 4) {
            switch (this.story) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return true;
                }
            }
        }
        return false;
    }

    public int getVersion() {
        return this.m[0] & 0xFF;
    }

    public static int getImageVersion(byte[] m) {
        return m[0] & 0xFF;
    }

    public int getHighBase() {
        return this.getWord(4);
    }

    public int getInitialPC() {
        return this.getWord(6);
    }

    public int getDictionaryAddr() {
        return this.getWord(8);
    }

    public int getObjectTableAddr() {
        return this.getWord(10);
    }

    public int getGlobalTableAddr() {
        return this.getWord(12);
    }

    public int getStaticBase() {
        return this.getWord(14);
    }

    public boolean getTranscripting() {
        return (this.m[17] & 1) == 1;
    }

    public void setTranscripting(boolean value) {
        this.m[17] = value ? (byte)(this.m[17] | 1) : (byte)(this.m[17] & 0xFFFFFFFE);
    }

    public byte[] getSerialNumber() {
        byte[] result = new byte[6];
        System.arraycopy(this.m, 18, result, 0, 6);
        return result;
    }

    public int getAbbrevTableAddr() {
        return this.getWord(24);
    }

    public void setRevision(int major, int minor) {
        this.m[50] = (byte)major;
        this.m[51] = (byte)minor;
    }

    public int getRelease() {
        return this.getWord(2);
    }

    public int getChecksum() {
        return this.getWord(28);
    }

    public int getFileLength() {
        return this.getWord(26) * 2;
    }

    protected int getWord(int addr) {
        return this.m[addr] << 8 & 0xFF00 | this.m[addr + 1] & 0xFF;
    }

    public void setStatusUnavailable(boolean value) {
        this.m[1] = value ? (byte)(this.m[1] | 0x10) : (byte)(this.m[1] & 0xFFFFFFEF);
    }

    public void setSplittingAvailable(boolean value) {
        this.m[1] = value ? (byte)(this.m[1] | 0x20) : (byte)(this.m[1] & 0xFFFFFFDF);
    }

    public void setVariableDefault(boolean value) {
        this.m[1] = value ? (byte)(this.m[1] | 0x40) : (byte)(this.m[1] & 0xFFFFFFBF);
    }

    public boolean isTimeGame() {
        return false;
    }

    private static class Record {
        int story;
        int release;
        String serial;

        Record(int story, int release, String serial) {
            this.story = story;
            this.release = release;
            this.serial = serial;
        }
    }
}

