/*
 * Decompiled with CFR 0.152.
 */
package zpplet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import zpplet.About;
import zpplet.FontSelect;
import zpplet.ZUserConfig;
import zpplet.machine.ZMachine;
import zpplet.system.ZColor;
import zpplet.system.ZScreen;

public final class Zpplication
extends JFrame {
    ZMachine zm;
    private JPanel jContentPane = null;
    private JMenuBar jJMenuBar = null;
    private JMenu gameMenu = null;
    private JMenu helpMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem aboutMenuItem = null;
    private ZScreen zScreen = null;
    private JMenuItem loadFileMenuItem = null;
    private JMenu displayMenu = null;
    private JCheckBoxMenuItem fixedFontCheckBoxMenuItem = null;
    private JMenu fontMenu = null;
    private JRadioButtonMenuItem smallFontRadioButtonMenuItem = null;
    private JRadioButtonMenuItem regularFontRadioButtonMenuItem = null;
    private JRadioButtonMenuItem largeFontRadioButtonMenuItem = null;
    private JRadioButtonMenuItem xlargeFontRadioButtonMenuItem = null;
    private JMenuItem jMenuItem = null;
    private JCheckBoxMenuItem logMenuItem = null;
    private JCheckBoxMenuItem transMenuItem = null;
    private JMenuItem useLogMenuItem = null;

    public Zpplication() {
        this.initialize();
    }

    private void initialize() {
        this.setLocation(0, 0);
        this.setPreferredSize(new Dimension(640, 480));
        this.setContentPane(this.getJContentPane());
        this.setJMenuBar(this.getJJMenuBar());
        this.setDefaultCloseOperation(3);
        this.setSize(650, 480);
        this.setTitle("Zpplication");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setPreferredSize(new Dimension(640, 400));
            this.jContentPane.add((Component)this.getZScreen(), "Center");
            this.jContentPane.setVisible(true);
        }
        return this.jContentPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getGameMenu());
            this.jJMenuBar.add(this.getDisplayMenu());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getGameMenu() {
        if (this.gameMenu == null) {
            this.gameMenu = new JMenu();
            this.gameMenu.setText("Game");
            this.gameMenu.add(this.getLoadFileMenuItem());
            this.gameMenu.add(this.getLogMenuItem());
            this.gameMenu.add(this.getTransMenuItem());
            this.gameMenu.add(this.getUseLogMenuItem());
            this.gameMenu.addSeparator();
            this.gameMenu.add(this.getExitMenuItem());
        }
        return this.gameMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getJMenuItem());
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new About(Zpplication.this).setVisible(true);
                }
            });
        }
        return this.aboutMenuItem;
    }

    private ZScreen getZScreen() {
        if (this.zScreen == null) {
            this.zScreen = new ZScreen();
            this.zScreen.setVisible(true);
            this.zScreen.setPreferredSize(new Dimension(640, 480));
        }
        return this.zScreen;
    }

    byte[] getStream(InputStream s) throws IOException {
        byte[] oldbuffer;
        int currentbytes = 0;
        int buffersize = 2048;
        byte[] buffer = new byte[buffersize];
        int bytesleft = buffersize;
        int got = 0;
        while (got != -1) {
            currentbytes += got;
            if ((bytesleft -= got) == 0) {
                oldbuffer = buffer;
                buffer = new byte[buffersize + currentbytes];
                System.arraycopy(oldbuffer, 0, buffer, 0, currentbytes);
                oldbuffer = null;
                bytesleft = buffersize;
            }
            got = s.read(buffer, currentbytes, bytesleft);
        }
        if (buffer.length != currentbytes) {
            oldbuffer = buffer;
            buffer = new byte[currentbytes];
            System.arraycopy(oldbuffer, 0, buffer, 0, currentbytes);
        }
        return buffer;
    }

    void lookForBlorb(String codefile) {
        int dot = codefile.lastIndexOf(".");
        if (dot < 0) {
            return;
        }
        String blorbfile = String.valueOf(codefile.substring(0, dot)) + ".blb";
        File f = new File(blorbfile);
        if (f.exists()) {
            this.zm.loadMedia(blorbfile);
        }
    }

    void startz(String codefile) {
        block12: {
            try {
                if (this.zm != null) {
                    this.zm.kill();
                    this.zm.join();
                }
                this.zm = ZMachine.NewZMachine(codefile, this.zScreen);
                if (this.zm == null) {
                    throw new Exception("Could not load file");
                }
                if (this.zm.wantsMedia()) {
                    this.lookForBlorb(codefile);
                }
                this.setTitle("Zpplet - " + codefile);
                if (this.smallFontRadioButtonMenuItem.isSelected()) {
                    ZUserConfig.fontsize = 12;
                } else if (this.regularFontRadioButtonMenuItem.isSelected()) {
                    ZUserConfig.fontsize = 16;
                } else if (this.largeFontRadioButtonMenuItem.isSelected()) {
                    ZUserConfig.fontsize = 20;
                } else if (this.xlargeFontRadioButtonMenuItem.isSelected()) {
                    ZUserConfig.fontsize = 24;
                }
                ZUserConfig.normalfont = this.fixedFontCheckBoxMenuItem.isSelected() ? ZUserConfig.fixedfont : ZUserConfig.variablefont;
                this.zm.start();
            }
            catch (Exception e) {
                if (e.getMessage() == null) break block12;
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getMessage(), null, 0);
            }
        }
    }

    private JMenuItem getLoadFileMenuItem() {
        if (this.loadFileMenuItem == null) {
            this.loadFileMenuItem = new JMenuItem();
            this.loadFileMenuItem.setText("Load game...");
            this.loadFileMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String codefile = Zpplication.this.promptForCodeFile();
                    if (codefile != null) {
                        Zpplication.this.startz(codefile);
                    }
                }
            });
        }
        return this.loadFileMenuItem;
    }

    String promptForCodeFile() {
        FileDialog fd = new FileDialog((Frame)this, "Select game file", 0);
        fd.setVisible(true);
        if (fd.getFile() != null) {
            return new File(fd.getDirectory(), fd.getFile()).getAbsolutePath();
        }
        return null;
    }

    private JMenu getDisplayMenu() {
        if (this.displayMenu == null) {
            this.displayMenu = new JMenu();
            this.displayMenu.setText("Display");
            this.displayMenu.add(this.getFontMenu());
        }
        return this.displayMenu;
    }

    private JCheckBoxMenuItem getFixedFontCheckBoxMenuItem() {
        if (this.fixedFontCheckBoxMenuItem == null) {
            this.fixedFontCheckBoxMenuItem = new JCheckBoxMenuItem();
            this.fixedFontCheckBoxMenuItem.setText("Use fixed font only");
            this.fixedFontCheckBoxMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    String string = ZUserConfig.normalfont = Zpplication.this.fixedFontCheckBoxMenuItem.isSelected() ? ZUserConfig.fixedfont : ZUserConfig.variablefont;
                    if (Zpplication.this.zm != null) {
                        Zpplication.this.zm.notifyConfigChange();
                    }
                }
            });
        }
        return this.fixedFontCheckBoxMenuItem;
    }

    private JMenu getFontMenu() {
        if (this.fontMenu == null) {
            this.fontMenu = new JMenu();
            this.fontMenu.setText("Font");
            this.fontMenu.add(this.getFixedFontCheckBoxMenuItem());
            this.fontMenu.addSeparator();
            this.fontMenu.add(this.getSmallFontRadioButtonMenuItem());
            this.fontMenu.add(this.getRegularFontRadioButtonMenuItem());
            this.fontMenu.add(this.getLargeFontRadioButtonMenuItem());
            this.fontMenu.add(this.getXlargeFontRadioButtonMenuItem());
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.smallFontRadioButtonMenuItem);
            bg.add(this.regularFontRadioButtonMenuItem);
            bg.add(this.largeFontRadioButtonMenuItem);
            bg.add(this.xlargeFontRadioButtonMenuItem);
        }
        return this.fontMenu;
    }

    private JRadioButtonMenuItem getSmallFontRadioButtonMenuItem() {
        if (this.smallFontRadioButtonMenuItem == null) {
            this.smallFontRadioButtonMenuItem = new JRadioButtonMenuItem();
            this.smallFontRadioButtonMenuItem.setText("Small");
            this.smallFontRadioButtonMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ZUserConfig.fontsize = 12;
                    if (Zpplication.this.zm != null) {
                        Zpplication.this.zm.notifyConfigChange();
                    }
                }
            });
        }
        return this.smallFontRadioButtonMenuItem;
    }

    private JRadioButtonMenuItem getRegularFontRadioButtonMenuItem() {
        if (this.regularFontRadioButtonMenuItem == null) {
            this.regularFontRadioButtonMenuItem = new JRadioButtonMenuItem();
            this.regularFontRadioButtonMenuItem.setText("Regular");
            this.regularFontRadioButtonMenuItem.setSelected(true);
            this.regularFontRadioButtonMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ZUserConfig.fontsize = 16;
                    if (Zpplication.this.zm != null) {
                        Zpplication.this.zm.notifyConfigChange();
                    }
                }
            });
        }
        return this.regularFontRadioButtonMenuItem;
    }

    private JRadioButtonMenuItem getLargeFontRadioButtonMenuItem() {
        if (this.largeFontRadioButtonMenuItem == null) {
            this.largeFontRadioButtonMenuItem = new JRadioButtonMenuItem();
            this.largeFontRadioButtonMenuItem.setText("Large");
            this.largeFontRadioButtonMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ZUserConfig.fontsize = 20;
                    if (Zpplication.this.zm != null) {
                        Zpplication.this.zm.notifyConfigChange();
                    }
                }
            });
        }
        return this.largeFontRadioButtonMenuItem;
    }

    private JRadioButtonMenuItem getXlargeFontRadioButtonMenuItem() {
        if (this.xlargeFontRadioButtonMenuItem == null) {
            this.xlargeFontRadioButtonMenuItem = new JRadioButtonMenuItem();
            this.xlargeFontRadioButtonMenuItem.setText("Extra large");
            this.xlargeFontRadioButtonMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ZUserConfig.fontsize = 24;
                    if (Zpplication.this.zm != null) {
                        Zpplication.this.zm.notifyConfigChange();
                    }
                }
            });
        }
        return this.xlargeFontRadioButtonMenuItem;
    }

    private JMenuItem getJMenuItem() {
        if (this.jMenuItem == null) {
            this.jMenuItem = new JMenuItem();
            this.jMenuItem.setText("Fiddle with fonts");
            this.jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FontSelect jd = new FontSelect();
                    jd.setVisible(true);
                }
            });
        }
        return this.jMenuItem;
    }

    private JCheckBoxMenuItem getLogMenuItem() {
        if (this.logMenuItem == null) {
            this.logMenuItem = new JCheckBoxMenuItem();
            this.logMenuItem.setText("Log");
            this.logMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (Zpplication.this.zm != null) {
                        Zpplication.this.zm.setOutputStream(4, e.getStateChange() == 1, 0, 0);
                        ((JCheckBoxMenuItem)e.getItem()).setSelected(Zpplication.this.zm.outputs[4]);
                    }
                }
            });
        }
        return this.logMenuItem;
    }

    private JCheckBoxMenuItem getTransMenuItem() {
        if (this.transMenuItem == null) {
            this.transMenuItem = new JCheckBoxMenuItem();
            this.transMenuItem.setText("Transcript");
            this.transMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (Zpplication.this.zm != null) {
                        Zpplication.this.zm.setOutputStream(2, e.getStateChange() == 1, 0, 0);
                        ((JCheckBoxMenuItem)e.getItem()).setSelected(Zpplication.this.zm.outputs[2]);
                    }
                }
            });
        }
        return this.transMenuItem;
    }

    private JMenuItem getUseLogMenuItem() {
        if (this.useLogMenuItem == null) {
            this.useLogMenuItem = new JMenuItem();
            this.useLogMenuItem.setText("Use log");
            this.useLogMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Zpplication.this.zm != null) {
                        Zpplication.this.zm.setInputStream(1);
                    }
                }
            });
        }
        return this.useLogMenuItem;
    }

    public static void main(String[] args) {
        Zpplication app = new Zpplication();
        app.pack();
        app.setVisible(true);
        String codefile = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].charAt(0) == '-') {
                switch (args[i].charAt(1)) {
                    case 'f': {
                        ZColor.setDefaultForeground(args[++i]);
                        break;
                    }
                    case 'b': {
                        ZColor.setDefaultBackground(args[++i]);
                        break;
                    }
                }
            } else {
                codefile = args[i];
            }
            ++i;
        }
        if (codefile != null) {
            app.startz(codefile);
        }
    }
}

