/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.blorb;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.zmpp.base.MemoryAccess;
import org.zmpp.blorb.BlorbImage;
import org.zmpp.blorb.BlorbMediaCollection;
import org.zmpp.blorb.MemoryAccessInputStream;
import org.zmpp.iff.Chunk;
import org.zmpp.iff.FormChunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlorbImages
extends BlorbMediaCollection<BlorbImage> {
    private Map<Integer, BlorbImage> images;

    public BlorbImages(FormChunk formChunk) {
        super(formChunk);
        this.handleResoChunk();
    }

    @Override
    public void clear() {
        super.clear();
        this.images.clear();
    }

    @Override
    protected void initDatabase() {
        this.images = new HashMap<Integer, BlorbImage>();
    }

    @Override
    protected boolean isHandledResource(byte[] byArray) {
        return byArray[0] == 80 && byArray[1] == 105 && byArray[2] == 99 && byArray[3] == 116;
    }

    @Override
    public BlorbImage getResource(int n) {
        return this.images.get(n);
    }

    @Override
    protected boolean putToDatabase(Chunk chunk, int n) {
        if (!this.handlePlaceholder(chunk, n)) {
            return this.handlePicture(chunk, n);
        }
        return true;
    }

    private boolean handlePlaceholder(Chunk chunk, int n) {
        if ("Rect".equals(new String(chunk.getId()))) {
            MemoryAccess memoryAccess = chunk.getMemoryAccess();
            int n2 = (int)memoryAccess.readUnsigned32(8);
            int n3 = (int)memoryAccess.readUnsigned32(12);
            this.images.put(n, new BlorbImage(n2, n3));
            return true;
        }
        return false;
    }

    private boolean handlePicture(Chunk chunk, int n) {
        MemoryAccessInputStream memoryAccessInputStream = new MemoryAccessInputStream(chunk.getMemoryAccess(), 8, chunk.getSize() + 8);
        try {
            BufferedImage bufferedImage = ImageIO.read(memoryAccessInputStream);
            this.images.put(n, new BlorbImage(bufferedImage));
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private void handleResoChunk() {
        Chunk chunk = this.getFormChunk().getSubChunk("Reso".getBytes());
        if (chunk != null) {
            this.adjustResolution(chunk);
        }
    }

    private void adjustResolution(Chunk chunk) {
        MemoryAccess memoryAccess = chunk.getMemoryAccess();
        int n = 4;
        int n2 = (int)memoryAccess.readUnsigned32(n);
        int n3 = (int)memoryAccess.readUnsigned32(n += 4);
        int n4 = (int)memoryAccess.readUnsigned32(n += 4);
        int n5 = (int)memoryAccess.readUnsigned32(n += 4);
        int n6 = (int)memoryAccess.readUnsigned32(n += 4);
        int n7 = (int)memoryAccess.readUnsigned32(n += 4);
        int n8 = (int)memoryAccess.readUnsigned32(n += 4);
        n += 4;
        BlorbImage.ResolutionInfo resolutionInfo = new BlorbImage.ResolutionInfo(new BlorbImage.Resolution(n3, n4), new BlorbImage.Resolution(n5, n6), new BlorbImage.Resolution(n7, n8));
        for (int i = 0; i < this.getNumResources() && n < n2; ++i) {
            int n9 = (int)memoryAccess.readUnsigned32(n);
            int n10 = (int)memoryAccess.readUnsigned32(n += 4);
            int n11 = (int)memoryAccess.readUnsigned32(n += 4);
            int n12 = (int)memoryAccess.readUnsigned32(n += 4);
            int n13 = (int)memoryAccess.readUnsigned32(n += 4);
            int n14 = (int)memoryAccess.readUnsigned32(n += 4);
            int n15 = (int)memoryAccess.readUnsigned32(n += 4);
            n += 4;
            BlorbImage.ScaleInfo scaleInfo = new BlorbImage.ScaleInfo(resolutionInfo, new BlorbImage.Ratio(n10, n11), new BlorbImage.Ratio(n12, n13), new BlorbImage.Ratio(n14, n15));
            BlorbImage blorbImage = this.images.get(n9);
            if (blorbImage == null) continue;
            blorbImage.setScaleInfo(scaleInfo);
        }
    }
}

