/* -- GEMIO v 0.03 -- Steve Nickolas steve@dosius.zzn.com */

/* $Id: unixio.c,v 1.3 2000/10/04 23:06:24 jholder Exp $
 * --------------------------------------------------------------------
 * see doc/License.txt for License Information   
 * --------------------------------------------------------------------
 * 
 * File name: $Id: unixio.c,v 1.3 2000/10/04 23:06:24 jholder Exp $  
 *   
 * Description:    
 *    
 * Modification history:      
 * $Log: unixio.c,v $
 * Revision 1.3  2000/10/04 23:06:24  jholder
 * made zscii2latin1 table global
 *
 * Revision 1.2  2000/06/29 20:42:04  jholder
 * fixed termcap scroll bug
 *
 * Revision 1.1.1.1  2000/05/10 14:20:51  jholder
 *
 * imported
 *
 *
 * --------------------------------------------------------------------
 */

/* unixio.c */

/* *JWK* Altered by John W. Kennedy */

/* *JWK* Source code made safe (naughty bytes hexed) */

/* *JWK* Right margin forced to 1 only where needed */

/* *JWK* 2000-02-29 */

#include "ztypes.h"

#include "tw.h"

#include <signal.h>
#include <sys/types.h>
#include <time.h>

#define WHITE            0 /* colors */
#define BLACK            1
#define RED              2
#define GREEN            3
#define BLUE             4
#define CYAN             5
#define YELLOW           6
#define MAGENTA          7
#define DWHITE           8
#define DBLACK           9
#define DRED            10
#define DGREEN          11
#define DBLUE           12
#define DCYAN           13
#define DYELLOW         14
#define DMAGENTA        15

#define EXTENDED 1
#define PLAIN    2

#ifdef HARD_COLORS
static ZINT16 current_fg;
static ZINT16 current_bg;
#endif
extern ZINT16 default_fg;
extern ZINT16 default_bg;

extern int hist_buf_size;
extern int use_bg_color;

/* new stuff for command editing */
int BUFFER_SIZE;
char *commands;
int space_avail;
static int ptr1, ptr2 = 0;
static int end_ptr = 0;
static int row, head_col;
static int keypad_avail = 1;

/* done with editing global info */

static int current_row = 1;
static int current_col = 1;

static int saved_row;
static int saved_col;

static int cursor_saved = OFF;

static int freeze_screen = OFF;

static char tcbuf[1024];
static char cmbuf[1024];
static char *cmbufp;

#define BELL 7

static void display_string( char *s );
static int wait_for_char(  );
static int read_key( void );
static void set_cbreak_mode( int );
static void rundown(  );
static void sig_rundown(  );
void get_prev_command(  );
void get_next_command(  );
void get_first_command(  );
void delete_command(  );
void add_command( char *, int );
int display_command( char * );
int input_line( int, char *, int, int * );
int input_character( int );
static int wait_for_char( int );

void outc( int );
void move_cursor( int, int );
void get_cursor_position( int *, int * );
void set_attribute( int );
void display_char( int );

/* done with editing prototypes */

static int cx=1,cy=1,cc=BLACK;
static char screen_map[100][50][2];

#ifdef DEBUG
#define gemprintf printf
#endif

void outc( int c )
{
   if (c==13) {cx=1; gotoxy (cx, cy); return;}
   if (c==10) {if (freeze_screen == OFF) gemprintf ("\n"); cy++; cx=1; return;}
   screen_map[cx][cy][0]=c;
   screen_map[cx][cy][1]=cc;
   gotoxy(cx,cy);
   if (freeze_screen == OFF) gemprintf ( "%c", c );
   cx++;
   if (cx>screen_cols) {cx=1; cy++; gotoxy(cx,cy);}
}                               /* outc */

void del_line (int l)
{
 /* Scroll lines up */
 int travel,x,wy;
 wy=cy-1;
 for (travel=l+1; travel<=(wy+1); travel++)
  for (x=0; x<screen_cols; x++)
  {
   screen_map[x][travel-1][0]=screen_map[x][travel][0];
   screen_map[x][travel-1][1]=screen_map[x][travel][1];
   gotoxy(x,travel-1);
   textcolor(screen_map[x][travel-1][1]);
   if (freeze_screen == OFF) gemprintf ("%c",screen_map[x][travel-1][0]);
   textcolor(cc);
  }
  gotoxy (1,wy);
}

void unfreeze_screen (void)
{
 int x,y;
 for (y=0;y<=screen_rows;y++)
  for (x=0;x<=screen_cols;x++)
  {
   gotoxy(x,y);
   textcolor(screen_map[x][y][1]);
   if (freeze_screen == ON) gemprintf ("%c",screen_map[x][y][0]);
   textcolor(cc);
  }
 freeze_screen = OFF;
}

void gabort (int val)
{
 unfreeze_screen();
 gotoxy (1,screen_rows);
 gemprintf ("[Hit any key to exit.]");
 cgetc();
 close_textmode();
 appl_exit();
 exit(val);
}

void initialize_screen(  )
{
   int row, col;

   appl_init();
   if (screen_rows==0 || screen_rows > 22) screen_rows=22;
   if (screen_cols==0 || screen_cols > 80) screen_cols=80;

   init_textmode (screen_cols,screen_rows+2,0,20);
   clrscr();

   cmbufp = cmbuf;

   set_attribute( NORMAL );

   clear_screen(  );

   monochrome=1;

   row = screen_rows / 2 - 1;
   col = ( screen_cols - ( sizeof ( DZIPVER ) - 1 ) ) / 2;
   move_cursor( row, col );
   display_string( DZIPVER );
   row = screen_rows / 2;
   col = ( screen_cols - ( sizeof ( "The story is loading..." ) - 1 ) ) / 2;
   move_cursor( row, col );
   display_string( "The story is loading..." );

   JTERP = INTERP_GEM;

   commands = ( char * ) malloc( hist_buf_size * sizeof ( char ) );

   if ( commands == NULL )
      fatal( "initialize_screen(): Could not allocate history buffer." );
   BUFFER_SIZE = hist_buf_size;
   space_avail = hist_buf_size - 1;

   set_cbreak_mode( 1 );
   interp_initialized = 1;

}                               /* initialize_screen */

void restart_screen(  )
{
   zbyte_t high = 1, low = 0;

   cursor_saved = OFF;

   set_byte( H_STANDARD_HIGH, high );
   set_byte( H_STANDARD_LOW, low );
   if ( h_type < V4 )
      set_byte( H_CONFIG, ( get_byte( H_CONFIG ) | CONFIG_WINDOWS ) );
   else
   {
      /* turn stuff on */
      set_byte( H_CONFIG,
                ( get_byte( H_CONFIG ) | CONFIG_BOLDFACE | CONFIG_EMPHASIS | CONFIG_FIXED |
                  CONFIG_TIMEDINPUT ) );

      /* turn stuff off */
	 set_byte( H_CONFIG, ( get_byte( H_CONFIG ) & ~CONFIG_COLOUR & ~CONFIG_PICTURES & ~CONFIG_SFX ) );
   }

   /* Force graphics off as we can't do them */
   set_word( H_FLAGS, ( get_word( H_FLAGS ) & ( ~GRAPHICS_FLAG ) ) );

}                               /* restart_screen */

void reset_screen(  )
{
   /* only do this stuff on exit when called AFTER initialize_screen */
   if ( interp_initialized )
   {
      display_string( "\n" );
      clear_line(  );
	 move_cursor( screen_rows, 1 );

      delete_status_window(  );
      select_text_window(  );

      set_attribute( NORMAL );

      set_cbreak_mode( 0 );

   }
   display_string( "\n" );

}                               /* reset_screen */

void sig_reset_screen(  )
{
   /* only do this stuff on exit when called AFTER initialize_screen */
   if ( interp_initialized )
   {
      delete_status_window(  );
      select_text_window(  );

      set_attribute( NORMAL );

      set_cbreak_mode( 0 );

   }
   display_string( "\n" );

}                               /* sig_reset_screen */

void clear_screen(  )
{

/*
    tputs (CL, 1, outc);
*/
   int row;

   for ( row = 1; row <= screen_rows; row++ )
   {
      move_cursor( row, 1 );
      clear_line(  );
   }
   current_row = 1;
   current_col = 1;
   unfreeze_screen();

}                               /* clear_screen */

void select_status_window(  )
{

   save_cursor_position(  );

}                               /* select_status_window */

void select_text_window(  )
{

   restore_cursor_position(  );

}                               /* select_text_window */

void create_status_window(  )
{

}                               /* create_status_window */

void delete_status_window(  )
{
   int row, col;

}                               /* delete_status_window */

void clear_line(  )
{

/*    tputs (CE, 1, outc);*/
   int i;

   for ( i = 1; i <= screen_cols; i++ )
      outc( ' ' );

}                               /* clear_line */

void clear_text_window(  )
{
   int i, row, col;

   get_cursor_position( &row, &col );

   for ( i = status_size + 1; i <= screen_rows; i++ )
   {
      move_cursor( i, 1 );
      clear_line(  );
   }
   unfreeze_screen();

   move_cursor( row, col );

}                               /* clear_text_window */

void clear_status_window(  )
{
   int i, row, col;

   get_cursor_position( &row, &col );

   for ( i = status_size; i; i-- )
   {
      move_cursor( i, 1 );
      clear_line(  );
   }

   move_cursor( row, col );

}                               /* clear_status_window */

void move_cursor( int row, int col )
{

   gotoxy( col, row );
   current_row = cy = row;
   current_col = cx = col;

}                               /* move_cursor */

void get_cursor_position( int *row, int *col )
{

   *row = current_row;
   *col = current_col;

}                               /* get_cursor_position */

void save_cursor_position(  )
{

   if ( cursor_saved == OFF )
   {
      get_cursor_position( &saved_row, &saved_col );
      cursor_saved = ON;
   }

}                               /* save_cursor_position */

void restore_cursor_position(  )
{

   if ( cursor_saved == ON )
   {
      move_cursor( saved_row, saved_col );
      cursor_saved = OFF;
   }

}                               /* restore_cursor_position */

void set_attribute( int attribute )
{
   if ( attribute == NORMAL )
   {
    cc=BLACK;
    textcolor (BLACK);
   }

   if ( attribute & REVERSE )
   {
    cc=MAGENTA;
    textcolor (MAGENTA);
   }

   if ( attribute & BOLD )
   {
    cc=BLUE;
    textcolor (BLUE);
   }

   if ( attribute & EMPHASIS )
   {
    cc=RED;
    textcolor (RED);
   }

   if ( attribute & FIXED_FONT ) {}

}                               /* set_attribute */

static void display_string( char *s )
{
   while ( *s )
      display_char( *s++ );
}                               /* display_string */

void display_char( int c )
{
   outc( c );

   if ( ++current_col > screen_cols )
      current_col = screen_cols;
}                               /* display_char */

void scroll_line(  )
{
   int row, col;
   int i;
   freeze_screen=ON;

   get_cursor_position( &row, &col );

   if ( row < screen_rows )
   {
      for ( i = col; i < screen_cols; i++ )
         outc( ' ' );           /* BUGFIX */
      display_char( '\n' );
   }
   else
   {
	 del_line (status_size+1);
	 move_cursor( row, 1 );
   }

   current_col = 1;
   if ( ++current_row > screen_rows )
   {
      current_row = screen_rows;
      move_cursor( current_row, 1 );
      for ( i = 1; i < screen_cols; i++ )
         outc( ' ' );           /* BUGFIX */
      move_cursor( current_row, 1 );
   }

}                               /* scroll_line */

/*
 * Previous command system
 *
 * Here's how this works:
 *
 * The previous command buffer is BUFFER_SIZE bytes long. After the player
 * presses Enter, the command is added to this buffer, with a trailing '\n'
 * added. The '\n' is used to show where one command ends and another begins.
 *
 * The up arrow key retrieves a previous command. This is done by working
 * backwards through the buffer until a '\n' is found. The down arrow
 * retieves the next command by counting forward. The ptr1 and ptr2
 * values hold the start and end of the currently displayed command.
 *
 * PgUp displays the first ("oldest") command, while PgDn displays a blank
 * prompt.
 */
int display_command( char *buffer )
{
   int counter, loop;

   move_cursor( row, head_col );
   clreol();  /* fix scoll bug w/ command history */

   /* ptr1 = end_ptr when the player has selected beyond any previously
    * saved command.
    */

   if ( ptr1 == end_ptr )
   {
      return ( 0 );
   }
   else
   {
      /* Put the characters from the save buffer into the variable "buffer".
       * The return value (counter) is the value of *read_size.
       */

      counter = 0;
      for ( loop = ptr1; loop <= ptr2; loop++ )
      {
         buffer[counter] = commands[loop];
         display_char( buffer[counter++] );
      }
      return ( counter );
   }
}                               /* display_command */

void get_prev_command(  )
{
   /* Checking to see if ptr1 > 0 prevents moving ptr1 and ptr2 into
    * never-never land.
    */

   if ( ptr1 > 0 )
   {
      /* Subtract 2 to jump over any intervening '\n' */

      ptr2 = ptr1 -= 2;

      /* If we've jumped too far, fix it */

      if ( ptr1 < 0 )
         ptr1 = 0;
      if ( ptr2 < 0 )
         ptr2 = 0;

      if ( ptr1 > 0 )
      {
         do

            /* Decrement ptr1 until a '\n' is found */

            ptr1--;
         while ( ( commands[ptr1] != '\n' ) && ( ptr1 >= 0 ) );

         /* Then advance back to the position after the '\n' */

         ptr1++;
      }
   }
}                               /* get_prev_command */

void get_next_command(  )
{
   if ( ptr2 < end_ptr )
   {
      /* Add 2 to advance over any intervening '\n' */

      ptr1 = ptr2 += 2;
      if ( ptr2 >= end_ptr )
      {
         ptr1 = ptr2 = end_ptr;
      }
      else
      {
         do
            ptr2++;
         while ( ( commands[ptr2] != '\n' ) && ( ptr2 <= end_ptr ) );
         ptr2--;
      }
   }
}                               /* get_next_command */

void get_first_command(  )
{

   if ( end_ptr > 1 )
   {
      ptr1 = ptr2 = 0;
      do
         ptr2++;
      while ( commands[ptr2] != '\n' );
      ptr2--;
   }
}                               /* get_first_command */

void delete_command(  )
{

   /* Deletes entire commands from the beginning of the command buffer */

   int loop;

   /* Keep moving the characters in the command buffer one space to the left
    * until a '\n' is found...
    */

   do
   {
      for ( loop = 0; loop < end_ptr; loop++ )
      {
         commands[loop] = commands[loop + 1];
      }
      end_ptr--;
      space_avail++;

   }
   while ( commands[0] != '\n' );

   /* ...then delete the '\n' */

   for ( loop = 0; loop < end_ptr; loop++ )
   {
      commands[loop] = commands[loop + 1];
   }
   end_ptr--;
   space_avail++;
   ptr1 = ptr2 = end_ptr;

}                               /* delete_command */

void add_command( char *buffer, int size )
{
   int loop, counter;

   /* Add the player's last command to the command buffer */

   counter = 0;
   for ( loop = end_ptr; loop < ( end_ptr + size ); loop++ )
   {
      commands[loop] = buffer[counter++];
   }

   /* Add one space for '\n' */

   end_ptr += size + 1;
   ptr1 = ptr2 = end_ptr;
   commands[end_ptr - 1] = '\n';
   space_avail -= size + 1;

}                               /* add_command */


int input_line( int buflen, char *buffer, int timeout, int *read_size )
{
   int c, col;
   int init_char_pos, curr_char_pos;
   int loop, tail_col;

   /*
    * init_char_pos : the initial cursor location
    * curr_char_pos : the current character position within the input line
    * head_col: the head of the input line (used for cursor position)
    *  (global variable)
    * tail_col: the end of the input line (used for cursor position)
    */

/*
    if (timeout != 0) {
	ftime (&timenow);
/*	tmptr = gmtime (&timenow.time);
	target_second = (tmptr->tm_sec + (timeout/10));*/

/*	target_second = timenow.time + (timeout/10);
	target_millisecond = timenow.millitm + (timeout*10);
	while (target_millisecond >= 1000)
	{
	   target_millisecond -= 1000;
	   target_second++;
	}

    }
*/
   get_cursor_position( &row, &col );
   head_col = tail_col = col;

   init_char_pos = curr_char_pos = *read_size;

   ptr1 = ptr2 = end_ptr;

   for ( ;; )
   {
      /* Read a single keystroke */
      do
      {
         if ( timeout == 0 )
         {
            c = read_key(  );
         }
         else
         {
            c = timed_read_key( timeout );
            if ( c == -1 )
               return ( c );
         }
      }
      while ( c == 0 );

      /****** Previous Command Selection Keys ******/

      if ( c == ( unsigned char ) '\x081' )
      {                         /* Up arrow */
         get_prev_command(  );
         curr_char_pos = *read_size = display_command( buffer );
         tail_col = head_col + *read_size;
      }
      else if ( c == ( unsigned char ) '\x082' )
      {                         /* Down arrow */
         get_next_command(  );
         curr_char_pos = *read_size = display_command( buffer );
         tail_col = head_col + *read_size;
      }
      else if ( c == ( unsigned char ) '\x09a' )
      {                         /* PgUp */
         get_first_command(  );
         curr_char_pos = *read_size = display_command( buffer );
         tail_col = head_col + *read_size;
      }
      else if ( ( c == ( unsigned char ) '\x094' ) || ( c == ( unsigned char ) '\x0bc' ) )
      {                         /* PgDn or Esc */
         ptr1 = ptr2 = end_ptr;
         curr_char_pos = *read_size = display_command( buffer );
         tail_col = head_col + *read_size;
      }

      /****** Cursor Editing Keys ******/

      else if ( c == ( unsigned char ) '\x083' )
      {                         /* Left arrow */
         get_cursor_position( &row, &col );

         /* Prevents moving the cursor into the prompt */
         if ( col > head_col )
         {
            move_cursor( row, --col );
            curr_char_pos--;
         }
      }
      else if ( c == ( unsigned char ) '\x0aa' )
      {                         /* Ctrl + Left arrow */
         get_cursor_position( &row, &col );
         if ( col > head_col )
         {
            col--;
            curr_char_pos--;
            do
            {
               /* Decrement until a ' ' is found */
               col--;
               curr_char_pos--;
            }
            while ( ( buffer[curr_char_pos] != ' ' ) && ( col >= head_col ) );
            curr_char_pos++;
            move_cursor( row, ++col );
         }
      }
      else if ( c == ( unsigned char ) '\x084' )
      {                         /* Right arrow */
         get_cursor_position( &row, &col );

         /* Prevents moving the cursor beyond the end of the input line */
         if ( col < tail_col )
         {
            move_cursor( row, ++col );
            curr_char_pos++;
         }
      }
      else if ( c == ( unsigned char ) '\x0ba' )
      {                         /* Ctrl + Right arrow */
         get_cursor_position( &row, &col );
         if ( col < tail_col )
         {
            do
            {
               /* Increment until a ' ' is found */
               col++;
               curr_char_pos++;
            }
            while ( ( buffer[curr_char_pos] != ' ' ) && ( col < tail_col ) );

            if ( col == tail_col )
            {
               move_cursor( row, tail_col );
            }
            else
            {
               curr_char_pos++;
               move_cursor( row, ++col );
            }
         }
      }
      else if ( c == ( unsigned char ) '\x092' )
      {                         /* End */
         move_cursor( row, tail_col );
         curr_char_pos = init_char_pos + *read_size;
      }
      else if ( c == ( unsigned char ) '\x098' )
      {                         /* Home */
         move_cursor( row, head_col );
         curr_char_pos = init_char_pos;
      }
      else if ( c == ( unsigned char ) '\x096' )
      {                         /* Delete */
         if ( curr_char_pos < *read_size )
         {
            get_cursor_position( &row, &col );

            /* Moves the input line one to the left */
            for ( loop = curr_char_pos; loop < *read_size; loop++ )
            {
               buffer[loop] = buffer[loop + 1];
            }

            /* Decrements the end of the input line and the *read_size value */
            tail_col--;
            ( *read_size )--;

            /* Displays the input line */
            clear_line(  );

            for ( loop = curr_char_pos; loop < *read_size; loop++ )
            {
               display_char( buffer[loop] );
            }

            /* Restores the cursor position */
            move_cursor( row, col );
         }

      }
      else if ( c == '\b' )
      {                         /* Backspace */
         get_cursor_position( &row, &col );
         if ( col > head_col )
         {
            move_cursor( row, --col );
            clear_line(  );
            for ( loop = curr_char_pos; loop < *read_size; loop++ )
            {
               buffer[loop - 1] = buffer[loop];
               display_char( buffer[loop - 1] );
            }
            curr_char_pos--;
            tail_col--;
            ( *read_size )--;
            move_cursor( row, col );
         }

      }
      else
      {                         /* Normal key action */

         if ( *read_size == ( buflen - 1 ) )
         {                      /* Ring bell if buffer is full */
            putchar( '\a' );
         }
         else
         {                      /* Scroll line if return key pressed */
            if ( c == '\r' || c == '\n' )
            {
               c = '\n';
               scroll_line(  );
            }

            if ( ( c == '\n' ) || ( c > ( unsigned char ) '\x080' ) )
            {                   /* Add the current command to the command buffer */

               if ( *read_size > space_avail )
               {
                  do
                  {
                     delete_command(  );
                  }
                  while ( *read_size > space_avail );
               }
               if ( *read_size > 0 )
               {
                  add_command( buffer, *read_size );
               }

               /* Return key if it is a line terminator */

               return ( ( unsigned char ) c );

            }
            else
            {
               get_cursor_position( &row, &col );

               /* Used if the cursor is not at the end of the line */
               if ( col < tail_col )
               {

                  /* Moves the input line one character to the right */

                  for ( loop = *read_size; loop >= curr_char_pos; loop-- )
                  {
                     buffer[loop + 1] = buffer[loop];
                  }

                  /* Puts the character into the space created by the
                   * "for" loop above */

                  buffer[curr_char_pos] = ( char ) c;

                  /* Increment the end of the line values */

                  ( *read_size )++;
                  tail_col++;

                  /* Move the cursor back to its original position */

                  move_cursor( row, col );

                  /* Redisplays the input line from the point of
                   * * insertion */

                  for ( loop = curr_char_pos; loop < *read_size; loop++ )
                  {
                     display_char( buffer[loop] );
                  }

                  /* Moves the cursor to the next position */

                  move_cursor( row, ++col );
                  curr_char_pos++;
               }
               else
               {                /* Used if the cursor is at the end of the line */
                  buffer[curr_char_pos++] = ( char ) c;
                  display_char( c );
                  ( *read_size )++;
                  tail_col++;
               }
            }
         }
      }
   }
}                               /* input_line */

/*
 * Patched 28-June-1995: Changed this routine's expectation of a \n to
 *                       a \r so the form in Bureaucracy works.  Patch
 *                       applied by John Holder.
 */
int input_character( int timeout )
{
   int c;

   if ( timeout == 0 )
   {
      c = read_key(  );
   }
   else
   {
      c = timed_read_key( timeout );
   }
   return ( c );

}                               /* input_character */

int timed_read_key( int timeout )
{
   int c;
   register clock_t curr_tick, target_tick;

   /* do math BEFORE calling clock for stability */
   target_tick = ( int ) ( timeout * CLK_TCK ) / 10;
   target_tick += clock(  );

   for ( ;; )
   {
      do
      {
         curr_tick = clock(  );
      }
      while ( ( curr_tick < target_tick ) && !kbhit(  ) );

      if ( !kbhit(  ) )
      {
         return ( -1 );
      }
      else
      {
         c = read_key(  );
         if ( c > 31 || c == 8 || c == 13 )
         {
            return ( c );
         }
      }
   }                            /* for */
}                               /* timed_read_key */


int read_key( void )
{
   int c;

 read_key_top:
   unfreeze_screen();
   gotoxy(cx,cy); gemprintf ("*"); gotoxy(cx,cy); /* Draw a cursor */
   c = cgetc(  );
   textcolor(screen_map[cx][cy][1]);
   gemprintf("%c",screen_map[cx][cy][0]);            /* then erase it */
   textcolor(cc);
   if (c==17) gabort(1); /* Abort ^Q if needed */
   if ( c < 32 && !( c == 0 || c == 8 || c == 13 ) )
      goto read_key_top;

   if ( c != '\0' && c != ( unsigned char ) '\x0e0' )
   {
      if ( c == '\x07f' )
      {
         c = '\b';
      }
      return ( c );
   }

   unfreeze_screen();
   c = cgetc(  );

   if ( c == 'H' )
      return ( ( unsigned char ) '\x081' ); /* Up arrow                */
   else if ( c == 'P' )
      return ( ( unsigned char ) '\x082' ); /* Down arrow              */
   else if ( c == 'K' )
      return ( ( unsigned char ) '\x083' ); /* Left arrow              */
   else if ( c == 'M' )
      return ( ( unsigned char ) '\x084' ); /* Right arrow             */
   else if ( c == 'O' )
      return ( ( unsigned char ) '\x092' ); /* End (SW)                */
   else if ( c == 'Q' )
      return ( ( unsigned char ) '\x094' ); /* PgDn (SE)               */
   else if ( c == 'S' )
      return ( ( unsigned char ) '\x096' ); /* Delete                  */
   else if ( c == 'G' )
      return ( ( unsigned char ) '\x098' ); /* Home (NW)               */
   else if ( c == 'I' )
      return ( ( unsigned char ) '\x09a' ); /* PgUp (NE)               */
   else if ( c == 's' )
      return ( ( unsigned char ) '\x0aa' ); /* Ctrl + Left Arrow       */
   else if ( c == 't' )
      return ( ( unsigned char ) '\x0ba' ); /* Ctrl + Right Arrow      */
   else if ( c >= ';' && c <= 'D' ) /* Function keys F1 to F10 */
      return ( ( c - ';' ) + ( unsigned char ) '\x085' );

   return ( 0 );

}                               /* read_key */

static void set_cbreak_mode( int mode )
{
 mode=mode;
}                               /* set_cbreak_mode */

static void rundown(  )
{
   unload_cache(  );
   close_story(  );
   close_script(  );
   reset_screen(  );
}                               /* rundown */

static void sig_rundown(  )
{
   unload_cache(  );
   close_story(  );
   close_script(  );
   sig_reset_screen(  );
}                               /* rundown */

void set_colours( zword_t foreground, zword_t background )
{
   foreground=foreground;
   background=background;
   return;
}

/*
 * codes_to_text
 *
 * Translate Z-code characters to machine specific characters. These characters
 * include line drawing characters and international characters.
 *
 * The routine takes one of the Z-code characters from the following table and
 * writes the machine specific text replacement. The target replacement buffer
 * is defined by MAX_TEXT_SIZE in ztypes.h. The replacement text should be in a
 * normal C, zero terminated, string.
 *
 * Return 0 if a translation was available, otherwise 1.
 *
 *  Arrow characters (0x18 - 0x1b):
 *
 *  0x18 Up arrow
 *  0x19 Down arrow
 *  0x1a Right arrow
 *  0x1b Left arrow
 *
 *  International characters (0x9b - 0xa3):
 *
 *  0x9b a umlaut (ae)
 *  0x9c o umlaut (oe)
 *  0x9d u umlaut (ue)
 *  0x9e A umlaut (Ae)
 *  0x9f O umlaut (Oe)
 *  0xa0 U umlaut (Ue)
 *  0xa1 sz (ss)
 *  0xa2 open quote (>>)
 *  0xa3 close quota (<<)
 *
 *  Line drawing characters (0xb3 - 0xda):
 *
 *  0xb3 vertical line (|)
 *  0xba double vertical line (#)
 *  0xc4 horizontal line (-)
 *  0xcd double horizontal line (=)
 *  all other are corner pieces (+)
 *
 */

int codes_to_text( int c, char *s )
{
   /* Characters 24 to 27 and 179 to 218 need no translation */

   if ( ( c > 23 && c < 28 ) || ( c > 178 && c < 219 ) )
   {
      s[0] = ( char ) c;
      s[1] = '\0';
      return ( 0 );
   }

   /* German characters need translation */

   if ( c > 154 && c < 164 )
   {
      char xlat[9] = { 0x84, 0x94, 0x81, 0x8e, 0x99, 0x9a, 0xe1, 0xaf, 0xae };

      s[0] = xlat[c - 155];
      s[1] = '\0';

      return ( 0 );
   }

   return ( 1 );

}                               /* codes_to_text */
