/*
**  This file is part of Zterp, and is
**  Copyright 1992, 1993 Charles Hannum
*/

#ifdef UNALIGNED_MEMORY_ACCESS
#include <netinet/in.h>
#endif

#ifdef VIRTUAL_MEMORY
NOT_IMPLEMENTED
#endif

typedef zbyte *zpointer;

static INLINE uword
unaligned_get_word (zpointer p)
{
  return ((p[0] << 8) | p[1]);
}

static INLINE uword
unaligned_set_word (zpointer p, uword x)
{
  p[0] = x >> 8;
  p[1] = x & 0xff;
}

#ifdef UNALIGNED_MEMORY_ACCESS
#define get_word(x) (ntohs(*(uword *)(x)))
#define set_word(x,n) (*(uword *)(x)=htons(n))
#else /* UNALIGNED_MEMORY_ACCESS */
#define get_word(P) unaligned_get_word((zpointer)P)
#define set_word(P,X) unaligned_set_word((zpointer)P,X)
#endif /* UNALIGNED_MEMORY_ACCESS */

#define get_word_pc() (pc+=2,get_word(pc-2))
#define get_byte(x) (*(zbyte *)(x))
#define set_byte(x,n) (*(zbyte *)(x)=(n))
#define get_byte_pc() (pc+=1,get_byte(pc-1))
#define set_pc(x) (pc=(x))

#define ZADDR(x) (((unsigned int)(x))<<zaddr_shift)
#define far_address(x) (game+ZADDR(x))
#define near_address(x) (game+(x))
