/* Header for module ZIP_Ext, generated by p2c */
#ifndef ZIPEXT_H
#define ZIPEXT_H


#ifdef ZIPEXT_G
# define vextern
#else
# define vextern extern
#endif



typedef uchar Byte;

typedef short ShortInteger;

typedef Char aMaxString[256];


typedef Byte aPage[256];
typedef FILE *aPageFile;

typedef Byte *PtrPage;


vextern int ScreenWidth;
vextern int ScreenHeight;


extern void ClearScreen(void);
extern void ClearToEOL(void);
extern void GotoXY(int x, int y);
extern void WriteRawChOnScreen(Char Ch);
extern void WriteChOnScreen(Char Ch);
extern int Random(void);
extern void Randomize(void);
extern boolean KeyPressed(void);
extern void EnableTimer(void);
extern void DisableTimer(void);
extern Char ReadKeyWithNoEcho(int TimeOut);
extern Char Backspace(void);
extern Char EOL(void);
extern Char ESC(void);
extern Char Ctrl_S(void);
extern Char DeleteChar(void);
extern Char KeyToDeleteLine(void);
extern void ScrollLinesUp(int FirstLine);
extern boolean FileExists(aMaxString FileName);
extern boolean IsDirectory(aMaxString Name);
extern Char *StateDirectory(Char StateDirectory_ReturnValue[256]);
extern void CloseText(FILE **TextToClose);
extern void ClosePageFile(aPageFile *theFile);
extern void RingBell(void);
extern void CursorOn(void);
extern void CursorOff(void);
extern void SaveTextAttributes(void);
extern void RestoreTextAttributes(void);
extern void NormalOn(void);
extern void InverseOn(void);
extern void BoldOn(void);
extern void ItalicOn(void);
extern void ExtraOn(void);
extern void SplitWord(int theWord, int *LowByte, int *HighByte);
extern int JoinBytes(int LowByte, int HighByte);
extern void WrapAddress(int *PageNo, int *PageIndex);
extern void ShiftLeft(int *HighWord, int *LowWord);
extern void ShiftRight(int *HighWord, int *LowWord);
extern int Nibble(int theByte, int NibbleNo);
extern int Bittle(int theByte, int BittleNo);
extern boolean TstBit(int theWord, int BitNo);
extern void SetBit(int *theWord, int BitNo);
extern void ClrBit(int *theWord, int BitNo);
extern int cOp4(int Code);
extern int cMode(int Code);
extern int cCmd2(int Code);
extern int cOp5(int Code);
extern int cMode3(int Code);
extern int cDistance(int Code);
extern boolean cShort(int Code);
extern boolean cTrueJump(int Code);
extern int land(int i1, int i2);
extern int lor(int i1, int i2);
extern int lnot(int i);
extern int lsr(int i, int c);
extern int lsl(int i, int c);
extern void InitSystem(void);
extern void SetupTerminal(int *Width, int *Height);
extern void ResetTerminal(void);
extern Char UpArrow(void);
extern Char DownArrow(void);
extern Char LeftArrow(void);
extern Char RightArrow(void);
extern boolean IsFuncKey(Char Key);
extern int FuncKeyNo(Char Key);
extern Char NumericSW(void);
extern Char NumericS(void);
extern Char NumericSE(void);
extern Char NumericW(void);
extern Char NumericCentre(void);
extern Char NumericE(void);
extern Char NumericNW(void);
extern Char NumericN(void);
extern Char NumericNE(void);
extern boolean SwitchToFont(int FontNo);
extern void SysSetColours(int Foreground, int Background);


#undef vextern

#endif /*ZIPEXT_H*/

/* End. */
