/*
  Console
  Routines for handling the mixed proportional/fixed font display
  JBS 15 June 1994
*/

#ifndef _CONSOLE_

#define _CONSOLE_

#include "config.h"
#include "types.h"


#ifndef MAX_HEIGHT
#define MAX_HEIGHT 80
#endif

#ifndef MAX_FIXED
#define MAX_FIXED  160
#endif

#ifndef MAX_SLACK
#define MAX_SLACK ((MAX_FIXED * 3) / 2)
#endif

#define MAX_MAX_FIXED 160 /* Status bar buffer size */

/* Font attributes */
/* Modified from bitset to ordinal to pack better and avoid 9/10 */

#define FONT_NORMAL     1
#define FONT_REVS       2
#define FONT_BOLD       3
#define FONT_EMPH       4
#define FONT_FIXED      5
#define FONT_FIXED_REVS 6

#define is_reverse(f)   ((f)==FONT_REVS || (f)==FONT_FIXED_REVS)
#define is_fixed(f)     ((f)==FONT_FIXED || (f)==FONT_FIXED_REVS)

#define mark(n,b)                (((n)<<8)|((byte)(b)))
#define kind(c)                  (((c)>>8)&0xFF)

#define make_attr(f,b)           (((f)<<4)+(b))

#define attr_get_fore(a)         (((a)>>4)&0x0F)
#define attr_get_back(a)         ((a)&0x0F)

#define make_font_request(f)     mark(1,f)
#define make_attr_request(a)     mark(2,a)

#define request_get_data(r)      ((r)&0xFF)

#define is_font_request(c)       (kind(c)==1)
#define is_attr_request(c)       (kind(c)==2)

typedef struct
{
#ifdef OLD
  unsigned font : 4, fore : 4, back : 4;
#else
  byte font, fore, back, dummy;
#endif

} console_attr;

typedef struct
{
  byte text;
  console_attr attr;
} console_cell;

typedef struct
{
  unsigned flag : 1, just : 1, fix : 1;
  int held;
  console_cell *fixed;
  console_cell *slack;
} console_row;

typedef struct
{
  int x;
  int y;
  bool align;
  console_attr attr;
} console_context;

typedef struct
{
  int fixed;
  int height;
} console_shape;

typedef struct
{
  console_context cursor;
  console_shape shape;
  int top, bottom;
  console_row row[MAX_HEIGHT];
} console;

extern console con;

int find_eol(int);
void init_console(int, int);
void touch(int);
void start_update(void);
void finish_update(void);
void force_update(void);
void set_xy(int, int);
void goto_xy(int, int);
void force_font(int);
void put_char(word);
void use_window(int);
void erase_to_eoln(void);
void erase_window(word, word);
void swap_font_status(int *);
void save_attributes(int);
void restore_attributes(int);
void get_xy(int *, int *);
void clip_attributes(void);
#ifdef OLD
int is_a_space(const console_cell *);
#else
#define is_a_space(c)  ((c).text==' ' && (c).attr.font!=FONT_FIXED_REVS)
#endif
void allocate_console(void);

#endif

