/*
  Compare
*/

#include "compare.h"

#include "jump.h"
#include "mem.h"
#include "var.h"

void compare(void)
{
  extern word param_stack[];

  word num_params = param_stack[0];
  word param1     = param_stack[1];
  word *param_ptr = &param_stack[2];

  while(--num_params != 0)
    if(param1 == *param_ptr++)
    {
      ret_value(1);
      return;
    }
  ret_value(0);
}

void plus_compare2(void)
{
  extern word param_stack[];
  word data         = param_stack[1];
  long_word address = param_stack[2];
  word num_words    = param_stack[3];
  while(num_words-- != 0)
  {
    word val = rd_word_addr(address);
    address += 2;
    if(data == val)
    {
      store((word) address);
      ret_value(1);
      return;
    }
  }
  store(0);
  ret_value(0);
}

void adv_compare2(void)
{
  extern word param_stack[];

  int params     = param_stack[0];
  word data      = param_stack[1];
  word address   = param_stack[2];
  word num_words = param_stack[3];
  word inc       = params > 3 ? param_stack[4] & 0x7F : 0x02;
  word data_size = params > 3 ? param_stack[4] & 0x80 : 0x80;

  while(num_words--)
  {
    if(data_size != 0
    ?  (data == rd_word_addr(address))
    :  ((byte) data == rd_byte_addr(address)))
    {
      store(address);
      ret_value(1);
      return;
    }
    address += inc;
  }
  store(0);
  ret_value(0);
}
