/*
	FrosOS_Pict.cpp: OS dependant functions called by the Z-Machine.
	Copyright (C) 2005 Fabio Concas

	You can redistribute this file and/or modify it under the terms
	of version 2 of the GNU General Public License as published by
	the Free Software Foundation.  You should have received a copy
	of the license along with this file; see the file GPL.txt.

	This file is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	license for more details.
*/



#include "StdAfx.h"

#include "Zroft.h"


extern "C" {
#include "Frotz/Frotz.h"
}


BYTE *Img = NULL;

static BITMAPINFO16 bmi;
BYTE *imgData;


extern "C" {
#include "ZTools/pix2gif.h"

// Don't use graphics if in blind mode.
extern char cBlindMode;


//****************************************************************************
// write_bmp
//	Takes an uncompressed V6 image and makes a BMP of it
//	This is called by process_image in pix2gif
//****************************************************************************
void write_bmp (image_t *Img, int n)
{
    long Cnt;
    long X, Y;
    DWORD numBytes; // Total bmp byte count
    long rowLen = Img->width; // Bytes per row in bmp

    // Adjust image physical size
    while (rowLen % 8)
        rowLen++;
    numBytes = rowLen * Img->height / 2;

    // Set bitmap info properly
    bmi.bmiHeader.biSize = sizeof (BITMAPINFOHEADER);
    bmi.bmiHeader.biWidth = Img->width;
    bmi.bmiHeader.biHeight = Img->height;
    bmi.bmiHeader.biPlanes = 1;
    bmi.bmiHeader.biBitCount = 4;
    bmi.bmiHeader.biCompression = BI_RGB;
    bmi.bmiHeader.biSizeImage = numBytes;
    bmi.bmiHeader.biXPelsPerMeter = 2834;
    bmi.bmiHeader.biYPelsPerMeter = 2834;
    bmi.bmiHeader.biClrUsed = 16;
    bmi.bmiHeader.biClrImportant = 0;

    /*** Display some info ***
	{
		TCHAR wInfo[512];

	    wsprintf (wInfo, L"Image %d is %dx%d, %dbpp",
        n,
        bmi.bmiHeader.biWidth,
        bmi.bmiHeader.biHeight,
        bmi.bmiHeader.biBitCount);

		MessageBox (Application.GetMainWnd (), wInfo, L"DEBUG", MB_OK);
	}
	/*************************/

    // Store palette info
    for (Cnt = 0; Cnt < 16; ++Cnt)
    {
        bmi.bmiColors[Cnt].rgbBlue = Img->colourmap[Cnt][BLUE];
        bmi.bmiColors[Cnt].rgbRed = Img->colourmap[Cnt][RED];
        bmi.bmiColors[Cnt].rgbGreen = Img->colourmap[Cnt][GREEN];
        bmi.bmiColors[Cnt].rgbReserved = 0;
    }

    // (Re)allocate image data memory
    if (imgData)
        LocalFree (imgData);
    imgData = (BYTE*)LocalAlloc (LPTR, numBytes);
	if (!imgData)
		os_fatal ("Could not allocate image data memory.");

    Cnt = 0;
    // Store pix image data into bitmap image data in the correct order
    for (Y = Img->height - 1; Y >= 0; --Y)
    {
        for (X = 0; X < rowLen; ++X)
        {
            unsigned char Pix = 0;
            if (X < Img->width)
                Pix = (Img->image[(Y * Img->width) + X] << 4);
            ++X;
            if (X < Img->width)
                Pix |= (Img->image[(Y * Img->width) + X] & 0x0F);

            imgData[Cnt++] = Pix;
        }
    }
}



//****************************************************************************
// os_peek_colour
//****************************************************************************
int os_peek_colour (void)
{
	return Application.PeekColor ();
}



//****************************************************************************
// os_picture_data
//	Return true if the given picture is available. If so, store the
//	picture width and height in the appropriate variables. Picture
//	number 0 is a special case: Write the number of pictures available
//	and the picture file release number into the height and width
//	variables respectively when this picture number is asked for.
//****************************************************************************
int os_picture_data (int n, int *height, int *width)
{
	// Correct position and aspect ratio
	float X_Ratio = (float)h_screen_width * (float)Application.GetFontWidth() / 320;
	float Y_Ratio = (float)h_screen_height * (float)Application.GetFontHeight () / 200;

	if (n == 0)
	{
		*width = Application.imgCount;
		*height = Application.imgVersion;
		return TRUE;
	}

	// Browse dir entries to find image n
	for (int Cnt = 0; Cnt < Application.imgCount; ++Cnt)
		if (Application.imgDir[Cnt].image_number == n)
		{
			// Frotz wants dimensions in rows/columns, not pixels!
			int W = Application.imgDir[Cnt].image_width;
			int H = Application.imgDir[Cnt].image_height;

			//*** Buggy stories fixes ***
			if (story_id == ZORK_ZERO)
			{
				if (n == 126)
					H += 4;
			}

			if (W == 320)
				W = h_screen_width;
			else
				W = (int)(((float)W * X_Ratio) / Application.GetFontWidth ());

			if (H == 200)
				H = h_screen_height;
			else
				H = (int)(((float)H * Y_Ratio) / Application.GetFontHeight ());

			if (W == 0)
				W = 1;

			if (H == 0)
				H = 1;

			*width = W;//(int)(Application.imgDir[Cnt].image_width * X_Ratio) / Application.GetFontWidth ();
			*height = H;//(int)(Application.imgDir[Cnt].image_height * Y_Ratio) / Application.GetFontHeight ();
			return TRUE;
		}

	/*** DEBUG ***
	{
		TCHAR wMsg[32];
		wsprintf (wMsg, L"Image %d not found!", n);
		MessageBox (Application.GetMainWnd (), wMsg, L"DEBUG", MB_OK);
		Application.GoFullScreen ();
	}
	/*************/

    return FALSE;
}



//****************************************************************************
// os_draw_picture
//****************************************************************************
void process_image (FILE *, pdirectory_t *);
void os_draw_picture (int n, int Y, int X)
{
	int Index = -1, Cnt;

	// Don't use graphics if in blind mode
	if (cBlindMode)
		return;

	// Browse dir entries to find image n
	for (Cnt = 0; Cnt < Application.imgCount; ++Cnt)
		if (Application.imgDir[Cnt].image_number == n)
		{
			Index = Cnt;
			break;
		}

	if (Index >= 0)
		process_image (Application.imgFile, &Application.imgDir[Index]);
	else
	{
		TCHAR wMsg[64];
		wsprintf (wMsg, L"Image entry %d not found!", n);
		MessageBox (Application.GetMainWnd (), wMsg, L"DEBUG", MB_OK);
	}

	//*** Buggy games fixes ***
	if (story_id == ARTHUR)
	{
		if (n == 3)
			++X;
	}
	else if (story_id == ZORK_ZERO)
	{
		if (n >= 2 && n <=4)
		{
			--X;
			--Y;
		}
		else if (n >= 9 && n <= 24)
		{
			++X;
			--Y;
		}
		else if (n >= 203 && n <= 247)
		{
			--X;
			--Y;
		}
	}

	// Now the imgData should be filled and valid...
	//	let's draw it on the bitmap buffer

	if (Index >= 0)
	{
		// Correct position and aspect ratio
		float X_Ratio = (float)h_screen_width * (float)Application.GetFontWidth () / 320;
		float Y_Ratio = (float)h_screen_height * (float)Application.GetFontHeight () / 200;
		// Given coordinates are in rows/colons
		//	We must convert them to pixels
		int dstX = (X - 1) * Application.GetFontWidth ();
		int dstY = (Y - 1) * Application.GetFontHeight ();
		int dstW = (int)(Application.imgDir[Index].image_width * X_Ratio);
			//(bmi.bmiHeader.biWidth * X_Ratio);
		int dstH = (int)(Application.imgDir[Index].image_height * Y_Ratio);
			//(bmi.bmiHeader.biHeight * Y_Ratio);

		//*** More fixes ***
		if (story_id == ARTHUR)
		{
			if (n == 54)
			{
				--dstX;
				++dstY;
				--dstH;
			}
			else if (n == 170)
				++dstW;
			else if (n == 171)
			{
				dstX += 3;
				++dstW;
			}
		}
		else if (story_id == ZORK_ZERO)
		{
			if (n >= 2 && n <= 4)
				dstH -= 7;
			else if (n >= 203 && n <= 247)
			{
				dstY -= 3;
				dstH -= 4;
			}
		}

		/*** DEBUG ***
		if (dstX > (h_screen_width * Application.GetFontWidth ())
			|| dstY > (h_screen_height * Application.GetFontHeight ())
			|| dstY < 0)
		{
			TCHAR wMsg[128];

			wsprintf (wMsg, L"Bmp %d = %dx%d\nAt %d, %d",
				Application.imgDir[Index].image_number,
				bmi.bmiHeader.biWidth, bmi.bmiHeader.biHeight,
				X, Y);
			MessageBox (Application.GetMainWnd (), wMsg, L"DEBUG", MB_OK);

			wsprintf (wMsg, L"Dst = %d, %d to %d, %d",
				dstX, dstY, dstW, dstH);
			MessageBox (Application.GetMainWnd (), wMsg, L"DEBUG", MB_OK);
		}
		/*************/

		HDC hdcMem = CreateCompatibleDC (NULL);
		HBITMAP hOldBmp = (HBITMAP)SelectObject (hdcMem, Application.hbmpScreen);

		StretchDIBits (hdcMem,
			dstX, dstY,
			dstW,
			dstH,
			0, 0,
			bmi.bmiHeader.biWidth, bmi.bmiHeader.biHeight,
			imgData, (BITMAPINFO*)&bmi, DIB_RGB_COLORS,
			(Application.imgDir[Index].image_flags & 1)? // Transparent?
			SRCAND : SRCCOPY);

		SelectObject (hdcMem, hOldBmp);
		DeleteObject (hOldBmp);
		DeleteDC (hdcMem);

		RECT rc = { dstX, dstY, dstX + dstW, dstY + dstH };
		InvalidateRect (Application.GetMainWnd (), &rc, TRUE);
	}


	//if (imgData)
	//	LocalFree (imgData);
}



}	// extern "C"
