/*
FrosOS_Input.cpp: OS dependant functions called by the Z-Machine.
Copyright (C) 2005 Fabio Concas

You can redistribute this file and/or modify it under the terms
of version 2 of the GNU General Public License as published by
the Free Software Foundation.  You should have received a copy
of the license along with this file; see the file GPL.txt.

This file is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
license for more details.
*/



#include "StdAfx.h"

#include "Zroft.h"
#include "Commdlg.h"



#pragma warning( disable : 4018 )



extern "C" {
#include "FROTZ/Frotz.h"


    DWORD WINAPI FullScreen (LPVOID lpParameter)
    {
        Sleep (250);
        Application.GoFullScreen ();
        return 0;
    }


    //****************************************************************************
    // os_read_file_name
    //****************************************************************************
    //bool GetAppDir (LPWSTR pathName, HINSTANCE appInstance);
    int os_read_file_name (char *name, const char *default_name, int type)
    {
        static wchar_t strFileName[256];
        static wchar_t strDefDir[256];
        wchar_t strFilter[256];
        UINT  i, cbString;
        wchar_t  chReplace;
        int nReturn = 1;
        OPENFILENAME ofn;

        BOOL bOPEN;

        //mbstowcs (strFileName, default_name, strlen (default_name));

        // Hide cursor
        os_cursor_off ();

        if ((type == FILE_RESTORE ) || (type == FILE_PLAYBACK ) || (type == FILE_LOAD_AUX )) 
        {
            // Set default dir
            GetAppDir (strDefDir, Application.GetAppInstance ());
            memset (strFileName, 0, sizeof(wchar_t)*256);
            bOPEN = TRUE;
        }
        else
        {
            bOPEN = FALSE;
        }


        /*** DEBUG ***
        {
        TCHAR wMsg[64];
        wsprintf (wMsg, L"DefDir = \"%s\"", strDefDir);
        MessageBox (Application.GetMainWnd (), wMsg, L"DEBUG", MB_OK);
        }
        /*************/

        wcscpy (strFilter, L"Saved games (*.SAV)|*.SAV|All files (*.*)|*.*|\0");

        cbString = wcslen(strFilter);

        chReplace = strFilter[cbString - 1];

        for (i = 0; strFilter[i] != 0x0000; ++i)
        {
            if (strFilter[i] == chReplace)
                strFilter[i] = 0x0000;
        }

        memset (&ofn, 0, sizeof(OPENFILENAME));
        ofn.lStructSize = sizeof(OPENFILENAME);
        ofn.hwndOwner = Application.GetMainWnd ();
        ofn.lpstrFilter = strFilter;
        ofn.nFilterIndex = 1;
        ofn.lpstrFile= strFileName;
        ofn.nMaxFile = 256;
        //ofn.lpstrFileTitle = szFileTitle;
        //ofn.nMaxFileTitle = sizeof(szFileTitle);
        ofn.lpstrInitialDir = strDefDir;
        ofn.Flags = (type == FILE_SAVE)?	OFN_PATHMUSTEXIST | OFN_HIDEREADONLY
            : OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;

        bool oldDWS = Application.disregardWmSize;
        Application.disregardWmSize = true;
        int IsOK = (type == FILE_SAVE)? GetSaveFileName (&ofn) : GetOpenFileName (&ofn);
        Application.disregardWmSize = oldDWS;
        Application.GoFullScreen();

        // Process file dialog
        if (IsOK)
        {
            int i;

            // Get file name from dialog
            wcscpy (strFileName, ofn.lpstrFile);

            // Convert wide char file name to single byte chars
            for (i = 0; i < wcslen (strFileName); i++)
            {
                name[i] = (char) strFileName[i];
            }
            name[wcslen (strFileName)] = '\0';

            // Save default dir
            for (i = wcslen (strFileName); i >= 0; --i)
                if (strFileName[i] == _T('\\') || strFileName[i] == _T('/'))
                {
                    wcsncpy (strDefDir, strFileName, i + 1);
                    break;
                }
                strDefDir[i + 1] = (TCHAR)0;
        }
        else	// Aborted, or file not found
            nReturn = 0;


        if (type != FILE_SAVE && type != FILE_SAVE_AUX)
        {
            // Make sure we've still got the focus
            SetForegroundWindow (Application.GetMainWnd ());
            Application.Message (WM_TAKE_FOCUS);
        }

        // Send a message to the view to create the caret
        Application.Message (WM_CREATE_CURSOR);

        // Show cursor
        os_cursor_on ();

        if (type != FILE_SAVE_AUX && type != FILE_SAVE)
        {
            // Go full screen
            DWORD tmp;
            HANDLE hThread = CreateThread (NULL, 0,
                (LPTHREAD_START_ROUTINE )FullScreen,
                (LPVOID)NULL, 0, &tmp);

            if (hThread == 0)
            {
                wchar_t wMsg[256];
                wsprintf (wMsg, L"Error #%d", GetLastError ());
                MessageBox (Application.GetMainWnd (), L"Could not start FullScreen thread", wMsg, MB_OK | MB_ICONEXCLAMATION);
            }
            else
                ResumeThread (hThread);
        }
        /*** DEBUG ***/
        else //if(!nReturn)
        {
            if(!nReturn) { // if not saved
                MessageBox (Application.GetMainWnd(),
                    L"Game not saved", 
                    APP_NAME,
                    MB_OK | MB_ICONEXCLAMATION);
                Sleep (250);
            }
            Application.GoFullScreen ();
        }
        /*************/

        return nReturn;
    }



    //****************************************************************************
    // os_read_key
    //	Get a keypress
    //****************************************************************************
    int os_read_key (int timeout)
    {
        return Application.GetKey (timeout);
    }



    //****************************************************************************
    // os_read_line
    //	Get a line from the keyboard
    //****************************************************************************
    int os_read_line (int max, char *buf, int timeout, int width, int continued)
    {
        int x;
        x =  Application.GetLine (buf, max, timeout);

        return x;
    }



}	// extern "C"

#pragma warning( default : 4018 )
