// S5api.cpp
#if !defined(__E32BASE_H__)
#include <e32base.h>
#endif
#include <eikdoc.h>
#include <eikon.rsg>
#include "frotz.h"
#include "frotzs5.h"
#include "s5api.h"
#include "s5inter.h"
//**********************************
//RMainServ
//**********************************
// The client class. An RSessionBase sends messages to the server with the function
// RSessionBase::SendReceive(); specifying an opcode (TMainServRqst) and and array of argument pointers.
// Functions in derived classes, such as RMainServ::Increase(), are wrappers for different calls to
// SendReceive().
// Most of the functions here return void because if they fail the server will panic the client.
// If they return it can be assumed that there is no error.
class MyDesC8 : TDesC8
  {
  public:
    MyDesC8(unsigned char *p, int len):TDesC8(p, len, len){}
  };


//**********************************
//RMainServ
//**********************************

RMainServ::RMainServ(TInt anumber)
{
	uniquethread = anumber;
}


const TUint kDefaultMessageSlots=4;

CFrotzAppUi *RMainServ::GetApp()
{
  TAny *p[KMaxMessageArguments];
  p[0] = (TAny*)NULL;
  TInt app = SendReceive(EMainServGetApp, &p[0]);
  return ((CFrotzAppUi *)app);
}
// Connect to the  server - default number of message slots = 4
TInt RMainServ::Connect(struct sg *g)
	{
	TTime home;
	TInt r;
	g->aFs = new RFs;
	((RFs *)g->aFs)->Connect();

	TBuf<64> tempsrv;
	//Connect to the Server previously created using the ThreadID
	tempsrv.Format(_L("FrotzS%d"),uniquethread);
	
    r=CreateSession(tempsrv,Version(),kDefaultMessageSlots);
	g->papp = GetApp();
    ((CFrotzAppUi *)(g->papp))->storyrunning = 1;
	home.HomeTime();
	g->seed = home.DateTime().MicroSecond();
	return(r);
	}

// Return the client side version number.
TVersion RMainServ::Version(void) const
	{
	return(TVersion(KMainServMajorVersionNumber,KMainServMinorVersionNumber,KMainServBuildVersionNumber));
	}

void RMainServ::Printf(struct sg *g, const char *msg)
  {
  TAny *p[KMaxMessageArguments];
  p[0] = (TAny*)msg;
  SendReceive(EMainServPrintf, &p[0]);
  }

unsigned short RMainServ::GetCh(struct sg *g)
  {
  return (unsigned short)SendReceive(EMainServGetCh, NULL);
  }

void RMainServ::KeyTimer(struct sg *g, int delay)
  {
  TAny *p[KMaxMessageArguments];
  p[0] = (TAny*)&delay;
  SendReceive(EMainServKeyTimer, &p[0]);
  }

void RMainServ::Exit(struct sg *g)
{
    SendReceive(EMainServTerminate, NULL);
	Close();
	((RThread *)(g->thisthread))->Terminate(0);
}

void RMainServ::EraseRect(struct sg *g, int top, int left, int bottom, int right, int rev)
{
  TRect r(left-1,top-1,right,bottom);
  TAny *p[KMaxMessageArguments];
  p[0] = (TAny*)&r;
  p[1] = (TAny*)&rev;
  SendReceive(EMainServEraseRect, &p[0]);
}

void RMainServ::Scroll(struct sg *g, int top, int left, int bottom, int right, int units, int rev)
{
  TRect r(left-1,top-1,right,bottom);
  TPoint pt(0, -units);
  TAny *p[KMaxMessageArguments];
  p[0] = (TAny*)&r;
  p[1] = (TAny*)&pt;
  SendReceive(EMainServScroll, &p[0]);
  EraseRect(g,(units > 0 ? bottom+1-units : top) , left, (units > 0 ?  bottom : top+1-units), right, rev);
}

void RMainServ::Cursor(struct sg *g, int cursor)
{
  TAny *p[KMaxMessageArguments];
  p[0] = (TAny*)&cursor;
  SendReceive(EMainServCursor, &p[0]);
}

void RMainServ::TextAttr(struct sg *g, int attr)
{
  TAny *p[KMaxMessageArguments];
  p[0] = (TAny*)&attr;
  SendReceive(EMainServTextAttr, &p[0]);
}

void RMainServ::PutChar(struct sg *g, int x, int y, unsigned char c)
{
int cx,cy;
unsigned char cc;
  cc = c; cx = x; cy = y;
  TAny *p[KMaxMessageArguments];
  p[0] = (TAny*)&cx;
  p[1] = (TAny*)&cy;
  p[2] = (TAny*)&cc;
  SendReceive(EMainServPutChar, &p[0]);
}

void RMainServ::PutString(struct sg *g, int x, int y, zchar *s)
{
  int cx = x, cy = y;
  TAny *p[KMaxMessageArguments];
  p[0] = (TAny*)&cx;
  p[1] = (TAny*)&cy;
  p[2] = (TAny*)s;
  SendReceive(EMainServPutString, &p[0]);
}

void RMainServ::SetCursor(struct sg *g, int x, int y)
{
  TPoint pt(x,y);
  TAny *p[KMaxMessageArguments];
  p[0] = (TAny*)&pt;
  SendReceive(EMainServSetCursor, &p[0]);
}

int  RMainServ::DlgOpen(struct sg *g, char *pathname, char *filename)
{
  TAny *p[KMaxMessageArguments];
  p[0] = (TAny*)pathname;
  p[1] = (TAny*)filename;
  return SendReceive(EMainServDlgOpen, &p[0]);
}

int  RMainServ::DlgSave(struct sg *g, char *pathname, char *filename)
{
  TAny *p[KMaxMessageArguments];
  p[0] = (TAny*)pathname;
  p[1] = (TAny*)filename;
  return SendReceive(EMainServDlgSave, &p[0]);
}

void  RMainServ::GetStoryName(char *sn)
{
  TAny *p[KMaxMessageArguments];
  p[0] = (TAny*)sn;
  SendReceive(EMainServGetStoryName, &p[0]);
}

void SrvConnect(struct sg *g, void *tr)
  {
	g->thisthread = tr;
	User::LeaveIfError(((RMainServ *)(g->ss))->Connect(g));
  }
void SrvDisconnect(struct sg *g)
  {
	((RFs *)g->aFs)->Close();
	delete ((RFs *)g->aFs);
	((RMainServ *)(g->ss))->Exit(g);
  }

void SrvPrintf(struct sg *g, const char *msg)
	{
    ((RMainServ *)(g->ss))->Printf(g,msg);
	}

unsigned short SrvGetTimedCh(struct sg *g, int delay)
{
	if(((CFrotzAppUi *)(g->papp))->keyready)
		return (((RMainServ *)(g->ss))->GetCh(g));
	if(delay == 0)
	{
		((CFrotzAppUi *)(g->papp))->waitingkey = 1;
		((CFrotzAppUi *)(g->papp))->SemaKey.Wait();
	} 
	else
	{
		((RMainServ *)(g->ss))->KeyTimer(g,delay*100000);
		((CFrotzAppUi *)(g->papp))->waitingkey = 1;
		((CFrotzAppUi *)(g->papp))->SemaKey.Wait();
    }
	return (((RMainServ *)(g->ss))->GetCh(g));
}

void SrvBeep(struct sg *g, int pitch)
{
	pitch = pitch;
}

FILE *SrvOpenRead(struct sg *g, const char *filename) 
// uses RFile, returns NULL if error
{
	RFile *rfile;
	rfile = new RFile;
	TInt res = rfile->Open(*((RFs *)g->aFs),_L(filename), 0);
	if(res == KErrNone)
		return (FILE *)rfile;
	return NULL;
}

FILE *SrvOpenWrite(struct sg *g, const char *filename) 
// returns NULL if error
{
	RFile *rfile;
	TInt res;
	rfile = new RFile;
    res = rfile->Open(*((RFs *)g->aFs),_L(filename), EFileWrite);
	if(res == KErrNotFound)
	  res = rfile->Create(*((RFs *)g->aFs),_L(filename), EFileWrite);
	else
	  rfile->SetSize(0);
	if(res == KErrNone)
		return (FILE *)rfile;
	return NULL;
}

FILE *SrvOpenRWText(struct sg *g, const char *filename) 
// Read/Write && text mode
{
    TInt res;
	RFile *rfile;
	rfile = new RFile;
    res = rfile->Open(*((RFs *)g->aFs),_L(filename), EFileWrite);
	if(res == KErrNotFound)
	  res = rfile->Create(*((RFs *)g->aFs),_L(filename), EFileWrite);
	else
	  rfile->SetSize(0);
	if(res == KErrNone)
		return (FILE *)rfile;
	return NULL;
}

FILE *SrvOpenWText(struct sg *g, const char *filename) 
// Write && text mode
{
    TInt res;
	RFile *rfile;
	rfile = new RFile;
    res = rfile->Open(*((RFs *)g->aFs),_L(filename), EFileWrite);
	if(res == KErrNotFound)
	  res = rfile->Create(*((RFs *)g->aFs),_L(filename), EFileWrite);
	else
	  rfile->SetSize(0);
	if(res == KErrNone)
		return (FILE *)rfile;
	return NULL;
}

FILE *SrvOpenRText(struct sg *g, const char *filename) 
// Read && text mode
{
	RFile *rfile;
	rfile = new RFile;
	TInt res = rfile->Open(*((RFs *)g->aFs),_L(filename), EFileStreamText);
	if(res == KErrNone)
		return (FILE *)rfile;
	return NULL;
}

void SrvClose(struct sg *g, FILE *file)
{
	RFile *rfile = (RFile *)file;
	rfile->Close();
	delete rfile;
}

#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif
void SrvSeek(struct sg *g, FILE *file, int offset, int origin)
{
	int pos = offset;
	RFile *rfile = (RFile *)file;
    if(origin == SEEK_SET)
	  rfile->Seek(ESeekStart,pos);
	else
    if(origin == SEEK_CUR)
	  rfile->Seek(ESeekCurrent,pos);
	else
	  rfile->Seek(ESeekEnd,pos);
}

int  SrvTell(struct sg *g, FILE *file)
{
	int pos = 0;
	RFile *rfile = (RFile *)file;
    rfile->Seek(ESeekCurrent,pos);
	return pos;
}

int  SrvRead (struct sg *g, void *buff, int width, int count, FILE *file)  
// returns <= 'count' !
{
    TPtr8 p((unsigned char *)buff, width*count);
	int res;
	RFile *rfile = (RFile *)file;
    res = rfile->Read(p, width*count);
	if(res != KErrNone)
      return 0;
	return p.Length();
}

int  SrvWrite(struct sg *g, void *buff, int width, int count, FILE *file) 
// returns <= 'count' !
{
	int res;
    TPtrC8 p((const unsigned char *)buff, width*count);
	RFile *rfile = (RFile *)file;
    res = rfile->Write(p, width*count);
    if(res != KErrNone)
	  return 0;
	return p.Length();
}

int  SrvPutc (struct sg *g, int c, FILE *file) 
// return the char written
{
	int res;
	unsigned char d = (unsigned char)c;
	res = SrvWrite(g,&d, 1, 1, file);
	if(res != 1)
      return 0;
	return c;
}

int  SrvGetc(struct sg *g, FILE *file) 
// EOF = returns 0
{
	int res;
	unsigned char c;
	res = SrvRead(g,&c, 1, 1, file);
	if(res != 1)
      return 0;
	return c;
}

int  SrvError(struct sg *g, FILE *file) 
// return always 0....
{
	file = file;
	return 0;
}

void SrvSetFileSize(struct sg *g, FILE *file, int adjust)
{
    TInt sz;
	RFile *rfile = (RFile *)file;
	rfile->Size(sz);
    rfile->SetSize(sz+adjust);  
}

char *Srvstrchr(const char *str, char c)
{
	char *ptr = (char *)str;
	while((*ptr != c) && (*ptr != '\0'))
		ptr++;
	if(c != '\0')
	  if(*ptr == '\0')
	    return NULL;
	return ptr;
}

int  Srvstrlen(char *str)
{
	char *ptr = str;
	int len = 0;
	while((*ptr++) != '\0')
		len++;
	return len;
}

void Srvmemcpy(void *dst, void *src, int count)
{
	unsigned char *pdst = (unsigned char *)dst;
	unsigned char *psrc = (unsigned char *)src;
	while(count > 0)
	{
		*pdst++ = *psrc++;
		--count;
	}
}

void Srvmemmove (void *dst, void *src, int count)
{
	unsigned char *pdst = (unsigned char *)dst;
	unsigned char *psrc = (unsigned char *)src;
	if(pdst < psrc)
		Srvmemcpy(dst,src,count);
	else
	{
		pdst += count;
		psrc += count;
		while(count > 0)
		{
			*--pdst = *--psrc;
			--count;
		}
	}
}

char *Srvstrcpy(char *dst, const char *src) 
// returns dst
{
	char *ptr = (char *)src;
	char *bdst = dst;

    while(*ptr != '\0')
		*dst++ = *ptr++;
	*dst = '\0';
	return bdst;
}

char *Srvstrcat(char *dst, const char *src) 
// returns dst
{
	char *ptr = Srvstrchr(dst, '\0');
	Srvstrcpy(ptr, src);
	return dst;
}


void *SrvMalloc(struct sg *g, int num, int size) 
// uses HBufC, alloc size+ptr (pointer to HBufC) TDes->Ptr()
{
    char *ptr;
    g->hbuff[num] = (void *)HBufC::NewL(size);
    ptr = (char *)((HBufC *)g->hbuff[num])->Ptr();
    return (void *)ptr;
}

void SrvFree(struct sg *g, int num, void *buff)  
// uses delete
{
    delete ((HBufC *)g->hbuff[num]);
}

void *SrvRealloc(struct sg *g, int num, void *buff, int size) 
// warning: ptr may change
{
    char *ptr;
    g->hbuff[num] = (void *)((HBufC *)g->hbuff[num])->ReAllocL(size);
    ptr = (char *)((HBufC *)g->hbuff[num])->Ptr();
	return (void *)buff;
}

void SrvExit(struct sg *g)
{
    ((RMainServ *)(g->ss))->Exit(g);
}

void SrvEraseRect(struct sg *g, int top, int left, int bottom, int right, int rev)
{
	((RMainServ *)(g->ss))->EraseRect(g,top, left, bottom, right, rev);
}

void SrvScroll(struct sg *g, int top, int left, int bottom, int right, int units, int rev)
{
	((RMainServ *)(g->ss))->Scroll(g,top, left, bottom, right, units, rev);
}

void SrvSwitchCursor(struct sg *g, int cursor)
{
	((RMainServ *)(g->ss))->Cursor(g,cursor);
}

void SrvTextAttr(struct sg *g, int attr)
{
    ((RMainServ *)(g->ss))->TextAttr(g,attr);
}

// Return an appropriate random seed value in the range from 0 to
// 32767, possibly by using the current system time.
int SrvRandom(struct sg *g)
{
	Math::Rand(g->seed);
    return (g->seed.Low() & 0x7FFF);
}

void SrvPutChar(struct sg *g, int x, int y, unsigned char c)
{
    ((RMainServ *)(g->ss))->PutChar(g,x,y,c);
}

void SrvPutString(struct sg *g, int x, int y, zchar *s)
{
	int i=0;
	//Truncate string to screen width
	while (((g->displstr[i++] = *s++) != 0) && (i+x) < g->h_screen_width);
	g->displstr[i++] = 0;

	// Don't let any printing go off the bottom of the screen.
	// Tends to happen when printing inverse blocks of text, e.g. Sherlock
	if (y > g->h_screen_height)
	{
	   g->cwp->y_cursor = g->h_screen_height - 1;
	   g->cwp->x_cursor = g->h_screen_width + 1;
	   return;
	}

	((RMainServ *)(g->ss))->PutString(g,x,y,g->displstr);
}

void SrvSetCursor(struct sg *g, int x, int y)
{
    ((RMainServ *)(g->ss))->SetCursor(g,x,y);
}

int SrvDlgOpen(struct sg *g, char *pathsrc, char *file)
{
    return ((RMainServ *)(g->ss))->DlgOpen(g,pathsrc, file);
}

int SrvDlgSave(struct sg *g, char *pathsrc, char *file)
{
    return ((RMainServ *)(g->ss))->DlgSave(g,pathsrc, file);
}

void SrvGetStoryName(struct sg *g, char **sn)
{
    ((RMainServ *)(g->ss))->GetStoryName(g->thestoryname);
	*sn = g->thestoryname;
}

void SrvScreenSize(struct sg *g, int *w, int *h)
{
  *w = ((CFrotzAppUi *)(g->papp))->cscreenwidth;
  *h = ((CFrotzAppUi *)(g->papp))->cscreenheight;
}

