#include "stdafx.h"
#include "FrotzCE.h"
#include "About.h"
#include "MainFrm.h"

extern "C"
{
#include "Frotz/Frotz.h"
}

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFrotzCEApp commands

BOOL CAboutDlg::OnInitDialog() 
{
CString strStoryInfo;

	CDialog::OnInitDialog();
	
	// Z Machine running?
	if (FROTZCEAPP->m_bZmachineRunning)
	{
	CString strRelease;

		// Get story name
		MAINFRAME->GetWindowText( strStoryInfo );
		// Unrecognised story?
		if (strStoryInfo == TEXT("FrotzCE"))
		{
			// Use file name
			strStoryInfo = TEXT( "Story: " );
			strStoryInfo += FROTZCEAPP->m_achStoryFile;

			for (int nPos = strStoryInfo.GetLength()-1; nPos >= 0; nPos--)
			{
				// Found beginning of file name?	
				if (strStoryInfo[nPos] == _T('\\') || strStoryInfo[nPos] == _T('/'))
				{
				int nDotPos;

					// Save file name
					strStoryInfo = strStoryInfo.Mid( nPos + 1 );
					// Remove extension
					if ((nDotPos = strStoryInfo.Find( _T('.') )) != -1)
						strStoryInfo = strStoryInfo.Left( nDotPos + 1 );

					break;
				}
			}
		}
		strStoryInfo = TEXT( "Story: " ) + strStoryInfo;

		// Add release no.
		strRelease.Format( TEXT("\nRelease: %d"), h_release );
		strStoryInfo += strRelease;
		// Add serial no. to string
		strStoryInfo += "  SerialNo: ";
		strStoryInfo += h_serial;

		// Display string
		SetDlgItemText( IDC_STORYINFO, strStoryInfo );
	}
	else 
	{
		strStoryInfo = TEXT( "Compiled: " );
		strStoryInfo += __DATE__;
		SetDlgItemText( IDC_STORYINFO, strStoryInfo );
	}

	CenterWindow();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
