/* Standard core_init() for pogo programs
 * -- Jonas Minnberg 2002
 */

#if 0

#include "device.h"
#include "font.h"

extern void deb_init(void); /* /dev/deb */
extern void screen_init(void); /* /dev/screen */
extern void vkey_init(void); /* /dev/vkey */
extern void key_init(void); /* /dev/key */
extern void console_init(void); /* /dev/con */
extern void filesys_init(void); /* /rom */
extern void sram_init(void); /* /sram */

void core_init(void)
{
	int fd;
	Font *font;

	/* Only init devices we need */
	deb_init();
	screen_init();
	vkey_init();
//	key_init();
	console_init();
	filesys_init();
	sram_init();

	/* Try to set keyboard image */
	fd = open("/rom/keyb.dat", 0);
	if(fd >= 0) {
		uint16 *ptr = (uint16*)lseek(fd, 0, SEEK_MEM);
		ioctl(0, KC_SETIMAGE, ptr);
		close(fd);
	}

	/* Set console fonts */
	font = font_load("/rom/fixed.font");
	ioctl(1, CC_SETFONT, font, 1);
	font = font_load("/rom/gfx5.font");
	ioctl(1, CC_SETFONT, font, 2);
	font = font_load("/rom/normal.font");
	ioctl(1, CC_SETFONT, font, 0);

	//smartkey_init();
}

#endif
