// ----------------------------------------------------------------------------
// DS Frotz
// 	
// description	:	DS version of GBA Frotz 
//					made with PAlib - www.palib.com -
//
// ----------------------------------------------------------------------------
// (c) 2006 papafuji - using PAlib
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// PAlib includes
// ----------------------------------------------------------------------------

#include <PA9.h>
#include <stdio.h> 
#include <ctype.h> 

// ----------------------------------------------------------------------------
// project includes
// ----------------------------------------------------------------------------

#include "main.h"
#include "draw.h"

// ----------------------------------------------------------------------------
//
// ----------------------------------------------------------------------------

char		SaveDesc[1024] 		 	= "";
char		IncompleteString[80] 	= "";
char*		CompletePos 		 	= NULL;

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

void TextCompletionInit( void )
{
	*SaveDesc			= 0;
	*IncompleteString	= 0;
	CompletePos 		= NULL;
}

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

int TextCompletion( char* _text, char* _data )
{
	char*	data;
	char*	dataStart;
	int		found = 0;
	//char*	spacePos;
	
	int		n = strlen( _text );				// remove ending spaces
	while( n-- ) 
		if ( _text[n] == ' ' ) _text[n] = '\0'; 
			else break;	

	if ( !*SaveDesc )
	{
		strcpy( SaveDesc, _data );
	}
	
	_data = SaveDesc;
	
	n = strlen( _data );
	
	while( n-- )								// remove ending spaces
		if ( _data[n] == ' ' )
			_data[n] = '\0'; 
		else break;	

	n = strlen( _data );						// toupper
	while(n--) 
	{
		if ( islower(_data[n] ) ) 
		{
			_data[n] = toupper(_data[n]);
		}
	}

	/*else if ( !*_data )
		strcpy( _data, SaveDesc );*/

	if ( strlen( _data ) < 2 ) 
		return strlen( _text );

	if ( !IncompleteString[0] )
	{
		int 	n 		= strlen( _text );
		
		CompletePos	= strrchr( _text, ' ' );
		CompletePos = ( CompletePos == NULL ) ? _text : (CompletePos+1);
		strcpy( IncompleteString, CompletePos );
		n = strlen(IncompleteString);
		while(n--) if ( islower(IncompleteString[n] ) ) IncompleteString[n] = toupper(IncompleteString[n]);
	}
	
	// no space, look for a verb...
/*
	if ( (spacePos = strchr( _text, ' ' )) == NULL )
	{
		int 	iii;
		bool	found 	= false;
		for( iii=lastVerbFound; iii<=GameHeader.NumWords; iii++ )
		{
			if ( Verbs[iii] && !strncmp(IncompleteString,Verbs[iii],strlen(IncompleteString)))
			{
				strcpy( _text, Verbs[iii] );
				strcat( _text, " " );
				found 	= true;
				lastVerbFound = iii+1;
				if ( lastVerbFound >= GameHeader.NumWords ) lastVerbFound = 0;
				break;
			}
		}
		if ( !found ) lastVerbFound = 0;
	}
	// else; search a word in the description data
	else
*/
	{
	
		dataStart 	= _data;
		data 		= dataStart + strlen(_data)-1;
	
		while( 1 )
		{
			while( 1 ) 
			{ 
				if ( data == dataStart ) break; 
				if ( *data == ' ' ) break; 
				data --; 
			}
			if ( !strncmp( IncompleteString, data+1, strlen(IncompleteString) ) )
			{
				char*	start = CompletePos;
				*start = '\0';
				strcpy( start, data+1 );
				while( *start ) if ( *start == ' ' ) *start = '\0'; else start ++;
				*data = '\0';
				data = dataStart;
				found = 1;
				break;
					// found
			}
			if ( data == dataStart ) break; 
			data --;
			if ( data == dataStart ) break; 
			data --;
		}
	
		if ( !found )
		{
			*dataStart = '\0';
			CompletePos[strlen(IncompleteString)] = '\0';
		}
	}

	return strlen( _text );
}

// ----------------------------------------------------------------------------
// (c) papafuji - 2006 - using PAlib
// ----------------------------------------------------------------------------
