// ----------------------------------------------------------------------------
// DS Frotz
// 	
// description	:	DS version of GBA Frotz 
//					made with PAlib - www.palib.com -
//
// ----------------------------------------------------------------------------
// (c) 2006 papafuji - using PAlib
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// PAlib includes
// ----------------------------------------------------------------------------

#include <PA9.h>
#include <stdio.h> 

// ----------------------------------------------------------------------------
// project includes
// ----------------------------------------------------------------------------

#include "font.h"

// ----------------------------------------------------------------------------
// ASCII CODES
// ----------------------------------------------------------------------------
/*
0 	 	NUL 	Null
1 	 	SOH 	Start of heading
2 	 	STX 	Start of text
3 	 	ETX 	End of text
4 	 	EOT 	End of transmit
5 	 	ENQ 	Enquiry
6 	 	ACK 	Acknowledge
7 	 	BEL 	Audible bell
8 	 	BS 		Backspace
9 	 	HT 		Horizontal tab
10 	 	LF 		Line feed
11 	 	VT 		Vertical tab
12 	 	FF 		Form feed
13 	 	CR 		Carriage return
14 	 	SO 		Shift out
15 	 	SI 		Shift in
16 	 	DLE 	Data link escape
*/

// ----------------------------------------------------------------------------
// EXTERNALS
// ----------------------------------------------------------------------------

extern int 			os_char_width (char z);

// ----------------------------------------------------------------------------
// CONSTANTS
// ----------------------------------------------------------------------------

int			fixedFont					= false;

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

bool GetFixedFont( void )
{
	return fixedFont;
}

int SetFixedFont( bool _val )
{
	int	oldfont = fixedFont;
	fixedFont = _val;
	return oldfont;
}

// ----------------------------------------------------------------------------
// MACROS
// ----------------------------------------------------------------------------

#define PLOT									PA_Put8bitPixel
#define PLOTNEXT								x ++; PA_Put8bitPixel

#define X(_d_)									x += _d_; PLOT(screen, x, y, color )
#define X2(_d_)									x += _d_; PLOT(screen, x, y, color ); PLOTNEXT(screen, x, y, color )
#define X3(_d_)									x += _d_; PLOT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color )
#define X4(_d_)									x += _d_; PLOT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color )
#define X5(_d_)									x += _d_; PLOT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color )
#define X6(_d_)									x += _d_; PLOT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color )
#define Y(_d_,_x_)								y += _d_; x = x0+_x_; PLOT(screen, x, y, color )
#define Y2(_d_,_x_)								y += _d_; x = x0+_x_; PLOT(screen, x, y, color ); PLOTNEXT(screen, x, y, color )
#define Y3(_d_,_x_)								y += _d_; x = x0+_x_; PLOT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color )
#define Y4(_d_,_x_)								y += _d_; x = x0+_x_; PLOT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color )
#define Y5(_d_,_x_)								y += _d_; x = x0+_x_; PLOT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color )
#define Y6(_d_,_x_)								y += _d_; x = x0+_x_; PLOT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color ); PLOTNEXT(screen, x, y, color )
#define C(_a_,_b_,_c_)							lettersColor = PA_RGB(_a_,_b_,_c_)
#define CBLACK									lettersColor = 5

// ----------------------------------------------------------------------------
// MACROS
// ----------------------------------------------------------------------------

#define DRAW_LETTER( _c_ , _col_, _x_, _y_ )		\
{													\
	s16	x0		= _x_;								\
	u8	color	= _col_;							\
	switch( _c_ )									\
	{												\
	case ' ' : break;								\
	case '>' : 			X(1); Y(1,2); Y(1,3); Y(1,4); Y(1,3); Y(1,2); Y(1,1);		\
		break;	\
	case '<' : 			X(4); Y(1,3); Y(1,2); Y(1,1); Y(1,2); Y(1,3); Y(1,4);		\
		break;	\
	case '!' : 			X(2); Y(1,2); Y(1,2); Y(1,2); Y(1,2); Y(2,2);				\
		break;	\
	case '?' : 			X3(1); Y(1,0);X(4); Y(1,4); Y(1,3); Y(1,2); Y(2,2);			\
		break;	\
	case ':' : 			Y(2,1); Y(1,2); Y(3,1); Y(1,2);								\
		break;	\
	case '=' : 			Y3(3,1); Y3(2,1); 											\
		break;	\
	case '%' : 			X2(1); Y2(1,1); Y5(2,0); Y2(2,2);  Y2(1,2); 				\
		break;	\
	case '/' : 			X(4);Y(1,3);Y(1,3);Y(1,2);Y(1,2);Y(1,1);					\
		break;	\
	case '\\' : 		X(1);Y(1,2);Y(1,2);Y(1,3);Y(1,3);Y(1,4);					\
		break;	\
	case '.' : 		if ( !fixedFont) { x0-=2;_x_-=2; } Y(6,3); /*X(1); Y(1,2);X(1);*/			\
		break;	\
	case ',' : 		if ( !fixedFont) { x0-=2;_x_-=2; } Y(5,3); Y(1,3); Y(1,2); 		\
		break;	\
	case ';' : 			Y(2,2); Y(2,2); Y(1,2); Y(1,2); Y(1,2);						\
		break;	\
	case '-' : 			Y4(3,1);													\
		break;	\
	case '+' : 			Y(1,2); Y(1,2); Y5(1,0); Y(1,2); Y(1,2);					\
		break;	\
	case '*' : 			Y(1,2); Y3(1,1); Y5(1,0); Y3(1,1); Y(1,2);					\
		break;	\
	case '$' :			X(2); Y3(1,1); Y(1,0); Y3(1,1); Y(1,4); Y4(1,0); Y(1,2); 						\
		break;	\
	case '&' :			X2(2); Y(1,1);X(3); Y(1,1); Y4(1,1); Y(1,0);X(3); Y(1,0);X(4); Y3(1,1); 						\
		break;	\
	case '#' : 			Y(1,1);X(2); Y5(1,0); Y(1,1);X(2); Y(1,1);X(2); Y5(1,0); Y(1,1);X(2);			\
		break;	\
	case '@' :			X3(1); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X2(3); Y(1,0);X2(3); Y(1,0); Y3(1,1); 		\
		break;	\
	case '(' : 		if ( !fixedFont) { x0--;_x_--; } 	X(2); Y(1,1); Y(1,1); Y(1,1); Y(1,1); Y(1,1); Y(1,1); Y(1,2);					\
		break;	\
	case ')' : 		if ( !fixedFont) { x0--;_x_--; } 	X(1); Y(1,2); Y(1,2); Y(1,2); Y(1,2); Y(1,2); Y(1,2); Y(1,1);					\
		break;	\
	case '[' : 		if ( !fixedFont) { x0--;_x_--; } 	X3(1); Y(1,1); Y(1,1); Y(1,1); Y(1,1); Y(1,1); Y(1,1); Y3(1,1);					\
		break;	\
	case ']' : 		if ( !fixedFont) { x0--;_x_--; } 	X3(1); Y(1,3); Y(1,3); Y(1,3); Y(1,3); Y(1,3); Y(1,3); Y3(1,1);					\
		break;	\
	case '|' :		if ( !fixedFont) { x0-=2;_x_-=2; } X(2); Y(1,2); Y(1,2); Y(1,2); Y(1,2); Y(1,2); Y(1,2); Y(1,2);					\
		break;	\
	case '_' :			Y(6,0);X(2);X(2);																		\
		break;	\
	case 'A' : 			X3(1); Y(1,0);X(4); Y(1,0);X(4); Y5(1,0); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); 		\
		break;	\
	case 'a' :			Y3(2,1); Y(1,4); Y4(1,1); Y(1,0);X(4); /*Y(1,0);X(4);*/ Y4(1,1);							\
		break;	\
	case 'B' :			X4(0); Y(1,0);X(4); Y(1,0);X(4); Y4(1,0); Y(1,0);X(4); Y(1,0);X(4); Y4(1,0);  			\
		break;	\
	case 'b' :			X(0); Y(1,0); Y(1,0); Y4(1,0); Y(1,0);X(4); Y(1,0);X(4); Y4(1,0); 						\
		break;	\
	case 'C' :			X3(1); Y(1,0);X(4); Y(1,0); Y(1,0); Y(1,0); Y(1,0);X(4); Y3(1,1);						\
		break;	\
	case 'c' :			Y3(2,1); Y(1,0); Y(1,0); Y(1,0); Y3(1,1);												\
		break;	\
	case 'D' : 			X4(0); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y4(1,0); 		\
		break;	\
	case 'd' :			X(4); Y(1,4); Y(1,4); Y4(1,1); Y(1,0);X(4); Y(1,0);X(4); Y4(1,1); 						\
		break;	\
	case 'E' : 			X4(0); Y(1,0); Y(1,0); Y3(1,0); Y(1,0); Y(1,0); Y4(1,0);								\
		break;	\
	case 'e' :			Y3(2,1); Y(1,0);X(4); Y5(1,0); Y(1,0); /*Y(1,0);*/ Y4(1,1);								\
		break;	\
	case 'F' :			X4(0); Y(1,0); Y3(1,0); Y(1,0); Y(1,0); Y(1,0); Y(1,0); 								\
		break;	\
	case 'f' :			X(2); Y(1,1); Y3(1,0); Y(1,1); Y(1,1); Y(1,1); Y(1,1);									\
		break;	\
	case 'G' : 			X3(1); Y(1,0);X(4); Y(1,0); Y(1,0);X(3);X(1); Y(1,0);X(4); Y(1,0);X(4); Y3(1,1); 		\
		break;	\
	case 'g' :			Y4(2,1); Y(1,0);X(4); Y(1,0);X(4); Y4(1,1); Y(1,4); Y3(1,1); 							\
		break;	\
	case 'H':			X(0);X(4); Y(1,0);X(4);  Y5(1,0); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4);	\
		break;	\
	case 'h' :			X(0); Y(1,0); Y(1,0); Y4(1,0); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4);					\
		break;	\
	case 'I' :		if ( !fixedFont) { x0--;_x_--; } X3(1); Y(1,2); Y(1,2); Y(1,2); Y(1,2); Y(1,2); Y3(1,1); 	\
		break;	\
	case 'i' :		if ( !fixedFont) { x0-=2;_x_-=2; } Y(1,2); Y(2,2); Y(1,2); Y(1,2); Y(1,2);					\
		break;	\
	case 'J' : 			X3(2); Y(1,3); Y(1,3); Y(1,3); Y(1,3); Y(1,3); Y(1,0);X(3); Y2(1,1);  					\
		break;	\
	case 'j' :		if ( !fixedFont) { x0--;_x_--; } Y(1,2); Y2(2,2); Y(1,2); Y(1,2); Y(1,1);					\
		break;	\
	case 'K' :			X(0);X(4); Y(1,0);X(3); Y(1,0);X(2); Y2(1,0); Y(1,0);X(2); Y(1,0);X(3); Y(1,0);X(4);	\
		break;	\
	case 'k' :			X(0); Y(1,0); Y(1,0); Y(1,0);X(2); Y2(1,0); Y(1,0);X(2); Y(1,0);X(3); 					\
		break;	\
	case 'L' :			X(0); Y(1,0); Y(1,0); Y(1,0); Y(1,0); Y(1,0); Y4(1,0);									\
		break;	\
	case 'l' :		if ( !fixedFont) { x0-=2;_x_-=2; } X(2); Y(1,2); Y(1,2); Y(1,2); Y(1,2); Y(1,2); Y(1,2);					\
		break;	\
	case 'M' :			X(0);X(4); Y(1,0);X(1);X(2);X(1); Y(1,0);X(2);X(2); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4);  \
		break;	\
	case 'm' : 			Y(2,1);X(2); Y(1,0);X(2);X(2); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); 					\
		break;	\
	case 'N' :			X(0);X(4); Y(1,0);X(1);X(3); Y(1,0);X(2);X(2); Y(1,0);X(3);X(1); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4);  \
		break;	\
	case 'n' : 			Y3(2,1); Y(1,1);X(3); Y(1,1);X(3); Y(1,1);X(3); Y(1,1);X(3);  							\
		break;	\
	case 'O' :			X3(1); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y3(1,1); 		\
		break;	\
	case 'o' : 			Y3(2,1); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y3(1,1);  								\
		break;	\
	case 'P' :			X4(0); Y(1,0);X(4); Y(1,0);X(4); Y4(1,0); Y(1,0); Y(1,0); Y(1,0); 						\
		break;	\
	case 'p' :			Y4(2,0); Y(1,0);X(4); Y(1,0);X(4); Y4(1,0); Y(1,0); Y(1,0); 							\
		break;	\
	case 'Q' :			X3(1); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X2(3); Y4(1,1);		\
		break;	\
	case 'q' :			Y4(2,1); Y(1,0);X(4); Y(1,0);X(4); Y4(1,1); Y(1,4); Y(1,4); 							\
		break;	\
	case 'R' :			X4(0); Y(1,0);X(4); Y(1,0);X(4); Y4(1,0); Y(1,0);X(2); Y(1,0);X(3); Y(1,0);X(4); 		\
		break;	\
	case 'r' : 			Y3(2,1); Y(1,1);X(3); Y(1,1); Y(1,1); Y(1,1);  											\
		break;	\
	case 'S' :			X3(1); Y(1,0);X(4); Y(1,0); Y3(1,1); Y(1,4); Y(1,0);X(4); Y3(1,1);						\
		break;	\
	case 's' :			Y3(2,1); Y(1,0); Y3(1,1); Y(1,4); /*Y(1,4);*/ Y3(1,1);										\
		break;	\
	case 'T' :			X5(0); Y(1,2); Y(1,2); Y(1,2); Y(1,2); Y(1,2); Y(1,2);									\
		break;	\
	case 't' :			X(1); Y3(1,0); Y(1,1); Y(1,1); Y(1,1); Y(1,1); Y(1,2);									\
		break;	\
	case 'U' :			X(0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y3(1,1); 	\
		break;	\
	case 'u' : 			Y(2,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y3(1,1);  							\
		break;	\
	case 'V' :			X(0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,1);X(2); Y(1,1);X(2); Y(1,2); 	\
		break;	\
	case 'v' : 			Y(2,0);X(4); Y(1,0);X(4); Y(1,1);X(2); Y(1,1);X(2); Y(1,2);  							\
		break;	\
	case 'W' :			X(0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(2);X(2); Y(1,0);X(1);X(2);X(1); Y(1,0);X(4); \
		break;	\
	case 'w' : 			Y(2,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(2);X(2); Y(1,1);X(2);  					\
		break;	\
	case 'X' :			X(0);X(4); Y(1,1);X(2); Y(1,1);X(2); Y(1,2); Y(1,1);X(2); Y(1,1);X(2); Y(1,0);X(4); 	\
		break;	\
	case 'x' : 			Y(2,0);X(4); Y(1,1);X(2); Y(1,2); Y(1,1);X(2); Y(1,0);X(4);  							\
		break;	\
	case 'Y' : 			X(0);X(4); Y(1,1);X(2); Y(1,2); Y(1,2); Y(1,2); Y(1,2); Y(1,2); 						\
		break;	\
	case 'y' : 			Y(2,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y4(1,1); Y(1,4); Y3(1,1); 								\
		break;	\
	case 'Z' : 			X5(0); Y(1,4); Y(1,4); Y(1,3); Y(1,2); Y(1,1); Y5(1,0); 								\
		break;	\
	case 'z' : 			Y5(2,0); Y(1,3); Y(1,2); Y(1,1); Y5(1,0); 												\
		break;	\
	case '0' : 			Y3(1,1); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y(1,0);X(4); Y3(1,1); 					\
		break;	\
	case '1' : 			X(2); Y2(1,1); Y(1,2); Y(1,2); Y(1,2); Y(1,2); Y3(1,1); 								\
		break;	\
	case '2' : 			X3(1); Y(1,0);X(4); Y(1,4); Y(1,3); Y(1,2); Y(1,1); Y5(1,0);							\
		break;	\
	case '3' : 			X3(1); Y(1,0);X(4); Y(1,4); Y2(1,2); Y(1,4); Y(1,0);X(4); Y3(1,1); 						\
		break;	\
	case '4' : 			X(3); Y2(1,2); Y(1,1);X(2);  Y5(1,0); Y(1,3); Y(1,3); Y(1,3); 							\
		break;	\
	case '5' : 			X5(0); Y(1,0); Y(1,0); Y4(1,0); Y(1,4); Y(1,4);	Y4(1,0); 								\
		break;	\
	case '6' : 			X3(1); Y(1,0); Y(1,0); Y4(1,0); Y(1,0);X(4); Y(1,0);X(4); Y3(1,1); 						\
		break;	\
	case '7' : 			X5(0); Y(1,4); Y(1,4); Y(1,3); Y(1,2); Y(1,1); Y(1,1); 									\
		break;	\
	case '8' : 			X3(1); Y(1,0);X(4); Y(1,0);X(4); Y3(1,1); Y(1,0);X(4); Y(1,0);X(4); Y3(1,1);			\
		break;	\
	case '9' : 			X3(1); Y(1,0);X(4); Y(1,0);X(4); Y4(1,1); Y(1,4); Y(1,4); Y3(1,1); 						\
		break;	\
	default :		if ( !fixedFont) { x0-=4;_x_-=4; } Y(0,4); Y(1,4); Y(1,4); 									\
	}			\
}

 
// ----------------------------------------------------------------------------
// PRINT CHAR
// ----------------------------------------------------------------------------

void PRINT_CHAR_EXT( int screen, char _char, int _x, int _y, int letterCol, int shadowsCol, int bgColor, bool drawBG )
{
	if ( _x >= 0 && _x <= (256-CHAR_WIDTH) && _y >= 0 && _y <= (192-CHAR_HEIGHT) )
	{
		s16		x 			= _x;
		s16		y 			= _y;
		
		if ( drawBG && (bgColor>-1) )	//&& (bgColor != DEFAULT_TEXT_BG_COLOR) )		// suppose screen has been cleaned before drawing letters
		{
			int	bgCol = bgColor + (bgColor<<8);
			int	base  = (x >> 1) + (y << 7);
			switch( CHAR_HEIGHT )
			{
			case 9 :
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				base += 125;
			case 8 :
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				base += 125;
			case 7 :
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				base += 125;
			case 6 :
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				base += 125;
			case 5 :
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				base += 125;
			case 4 :
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				base += 125;
			case 3 :
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				base += 125;
			case 2 :
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				base += 125;
			case 1 :
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
				PA_DrawBg[screen][base] = bgCol;base++;
			}
		}
		
		if ( CHAR_HEIGHT == 9 ) { _y = y = y + 1; }

		if ( shadowsCol > -1 )
		{
			x++;  y++;  DRAW_LETTER( _char , shadowsCol, x, y );
		}

		x=_x; y=_y;		DRAW_LETTER( _char , letterCol, x, y );
	}
}

// ----------------------------------------------------------------------------
// (c) papafuji - 2006 - using PAlib
// ----------------------------------------------------------------------------

