// ----------------------------------------------------------------------------
// DS Frotz
// 	
// description	:	DS version of GBA Frotz 
//					made with PAlib - www.palib.com -
//
// ----------------------------------------------------------------------------
// (c) 2006 papafuji - using PAlib
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// PAlib includes
// ----------------------------------------------------------------------------

#include <PA9.h>
#include <stdio.h> 

// ----------------------------------------------------------------------------
// project includes
// ----------------------------------------------------------------------------

#include "draw.h"
#include "frotz.h"

extern zword h_flags;

// ----------------------------------------------------------------------------
// ASCII CODES
// ----------------------------------------------------------------------------
/*
0 	 	NUL 	Null
1 	 	SOH 	Start of heading
2 	 	STX 	Start of text
3 	 	ETX 	End of text
4 	 	EOT 	End of transmit
5 	 	ENQ 	Enquiry
6 	 	ACK 	Acknowledge
7 	 	BEL 	Audible bell
8 	 	BS 		Backspace
9 	 	HT 		Horizontal tab
10 	 	LF 		Line feed
11 	 	VT 		Vertical tab
12 	 	FF 		Form feed
13 	 	CR 		Carriage return
14 	 	SO 		Shift out
15 	 	SI 		Shift in
16 	 	DLE 	Data link escape
*/

// ----------------------------------------------------------------------------
// local variables
// ----------------------------------------------------------------------------

int 			inverse 					= 0;
int 			bold 						= 0;
int				fixed						= 0;

int 			textColor					= DEFAULT_TEXT_COLOR;
int 			textShadowColor				= -1;
int 			textBGColor					= DEFAULT_TEXT_BG_COLOR;

int 			drawnTextColor				= DEFAULT_TEXT_COLOR;
int 			drawnTextShadowColor		= -1;
int 			drawnTextBGColor			= DEFAULT_TEXT_BG_COLOR;

int 			oldPromptX 					= -1;
int 			oldPromptY 					= -1;

// ----------------------------------------------------------------------------
// ...
// ----------------------------------------------------------------------------

int GetTextInverseFlag	( void )			{ return inverse;		}
int GetTextBoldFlag		( void )			{ return bold;			}

// ----------------------------------------------------------------------------
// ...
// ----------------------------------------------------------------------------

void updateStyleColor( void )
{
	if ( bold )
	{
		drawnTextColor			= BOLD_BLACK_COLORID;				//BOLD_WHITE_COLORID;
		drawnTextShadowColor	= -1;
		drawnTextBGColor		= textBGColor;						//textBGColor;
	}
	else if ( inverse )
	{
		drawnTextColor			= textBGColor;						//TEXT_MAGENTA_COLORID;		//textBGColor;
		drawnTextShadowColor	= -1;
		drawnTextBGColor		= textColor;						//textBGColor;	//TEXT_BLACK_COLORID;	//TEXT_CYAN_COLORID;		//textColor;
	}
	else
	{
		drawnTextColor			= textColor;
		drawnTextShadowColor	= -1;								//textShadowColor;
		drawnTextBGColor		= textBGColor;
	}
}

// ----------------------------------------------------------------------------
// ...
// ----------------------------------------------------------------------------

void SetTextStyle( int _inverse, int _bold, int _fixed )
{
	if ( _bold )
	{
		//WAIT_MSG( "SET STYLE BOLD " );
	}
	inverse 			= _inverse;	
	bold 				= _bold;	
	SetFixedFont( _fixed );
	updateStyleColor();
}

// ----------------------------------------------------------------------------
// ...
// ----------------------------------------------------------------------------

void SetTextBGColor		( int _clr 	)			
{ 
#if 0
	textBGColor 		= _clr; 
	//textBGColor 		= GRAY_COLORID(8);
	drawnTextBGColor	= textBGColor;
	//updateStyleColor(); 
#endif
}
// ----------------------------------------------------------------------------
// ...
// ----------------------------------------------------------------------------

void SetTextColor		( int _clr 	)			
{ 
#if 0
	if ( _clr == textBGColor ) 
		textColor 		= TEXT_WHITE_COLORID;	//NEW_TEXT_COLOR; 
	else
		textColor 		= _clr; 
	//textColor 			= TEXT_WHITE_COLORID; 
	drawnTextColor		= textColor;
	//updateStyleColor(); 
#endif
}
void SetTextShadowColor	( int _clr 	)			
{ 
	textShadowColor 	= -1; 
	//updateStyleColor(); 
}

// ----------------------------------------------------------------------------
// DRAW PROMPT
// ----------------------------------------------------------------------------


void DRAW_PROMPT( int _screen, int x0, int y0, int _w, int _on )
{
	if ( !_on )				// si on demande d'eteindre le prompt, on l'eteind  l'ancienne position
	{
		x0 = oldPromptX;
		y0 = oldPromptY;
		oldPromptX = -1;
		oldPromptY = -1;
	}
	else					// si on demande d'allumer le prompt, alors il faut d'abord l'teindre la ou il etait avant
	{
		DRAW_PROMPT( _screen, oldPromptX, oldPromptY, 6, 0 );
	}
	
	if ( x0 < 0 || x0 >= (256-_w) || y0 < 0 || y0 >= (192-CHAR_HEIGHT) )
		return;

	int	x, x1 = x0+6;
	int	y, y1 = y0+8;

	for( y=y0; y<y1; y ++ )
	{
		for( x=x0; x<x1; x ++ )
		{
			if ( (x+y)%2 )
			{
				if ( _on )
				{ 
					if ( PA_Get8bitPixel( _screen, x, y ) ==  drawnTextBGColor )
					{
						PA_Put8bitPixel( _screen, x, y, 31 );
					}
				}
				else
				{
					if ( PA_Get8bitPixel( _screen, x, y ) == 31 )
					{
						PA_Put8bitPixel( _screen, x, y, drawnTextBGColor );
					}
				}
			}
		}
	}

	oldPromptX = x0;
	oldPromptY = y0;
}

// ----------------------------------------------------------------------------
// CONSTANTS
// ----------------------------------------------------------------------------

extern void PRINT_CHAR_EXT( int screen, char _char, int _x, int _y, int letterCol, int shadowsCol, int bgColor, bool drawBG );

// ----------------------------------------------------------------------------
// PRINT CHAR
// ----------------------------------------------------------------------------

void PRINT_CHAR( int screen, char _char, int _x, int _y	)	//, int letterCol, int shadowsCol )
{
	//SetFixedFont( ( h_flags & FIXED_FONT_FLAG ) );
	PRINT_CHAR_EXT( screen, _char, _x, _y, drawnTextColor, drawnTextShadowColor, drawnTextBGColor, true );
}

// ----------------------------------------------------------------------------
// PRINT STRING
// ----------------------------------------------------------------------------

int gSkipLines = 0;

void SkipLines( int _lines )
{
	gSkipLines = _lines;
}

void PRINT_STRING( int screen, char* _text, int _x, int _y, int letterCol, int shadowsCol, int _widthmax )
{
	bool	endreached	= false;
	char*	t 			= _text;
	s16		x0 			= _x;
	s16		y 			= _y;
	u8		col 		= letterCol;
	
	int		oldFont		= SetFixedFont( true );
	
	if ( _widthmax < 0 ) 
	{
		_widthmax = 256 - _x + _widthmax;
	}
	else if ( _widthmax == 0 ) 
	{
		_widthmax = 256 - 2*_x;
	}

	int nbcarsmax = _widthmax / 6;

	while( !endreached )
	{
		int		cpt;
		char*	lastchar;
		char*	firstchar;
		bool	cutword;

		// first search end of line
treat_line:
		cpt 		= 0;
		lastchar	= 0;
		firstchar	= t;
		cutword		= false;
		
		while( true )
		{
			if ( *t == '[' ) 
			{
				t += 4;
			}
			else if ( *t == '\0' ) 
			{
				lastchar 	= t;
				endreached	= true;
				break;
			}
			else if ( *t == '\n' ) 
			{
				lastchar 	= t;
				break;
			}
			else if ( *t == ' ' ) 
			{
				lastchar 	= t;
				//words[cpt] = *t;
				t ++;
				cpt ++;
				//words[cpt] = '\0';
			}
			else
			{
				//words[cpt] = *t;
				t ++;
				cpt ++;
				//words[cpt] = '\0';
			}
			if ( cpt == nbcarsmax ) 
			{
				if ( lastchar == 0 ) { lastchar = t; cutword = true; }
				break;
			}
		}
		if ( (endreached == false) && (gSkipLines > 0 ) )
		{
			if ( cutword ) 	t = lastchar;
			else			t = lastchar+1;
			gSkipLines --;
			goto treat_line;
		}
		
		// then draw the characters of this line
		//t = words;
		t = firstchar;
		int	y0 = y;
		int xx = x0;
		while( t < lastchar )
		{
			//s16 x = xx;
			if ( *t == '[' ) 
			{
				int c;
				t++;
				sscanf( t, "%d", &c );
				if ( c <= 0 ) col = letterCol; else col = c;
				t += 3;
			}
			else
			{
				PRINT_CHAR_EXT( screen, *t, xx, y0, col, shadowsCol, -1, false );
				//y = y0+1; 	x=xx+1; 	DRAW_LETTER( *t , shadowsCol, x, y );
				//y = y0; 	x=xx; 		DRAW_LETTER( *t , col, x, y );
				//xx += 6;
				xx += 6;
				t ++;
			}
		}
		if ( cutword ) 	t = lastchar;
		else			t = lastchar+1;
		y = y0+8;
		if ( y > 184 ) 
		{
			if ( *t )
			{
				col = 32;
				s16 x = 237; y = 184; PRINT_CHAR_EXT( screen, '>', x, y, 33, 1, -1, false );	//DRAW_LETTER( '>' , 5, x, y );
					x = 243; y = 184; PRINT_CHAR_EXT( screen, '>', x, y, 33, 1, -1, false );	//DRAW_LETTER( '>' , 5, x, y );
					x = 249; y = 184; PRINT_CHAR_EXT( screen, '>', x, y, 33, 1, -1, false );	//DRAW_LETTER( '>' , 5, x, y );
			}
			endreached = true;		// end of the screen
		}
	}

	SetFixedFont( oldFont );
}

// ----------------------------------------------------------------------------
// (c) papafuji - 2006 - using PAlib
// ----------------------------------------------------------------------------

