/* object.c
 *
 *  foblub -- a Z-machine for TI calculators
 *  based on pinfocom by InfoTaskForce and Paul Smith
 *  Ported and extended by Nils Gesbert, 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to the
 *  Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Header: RCS/object.c,v 3.0 1992/10/21 16:56:19 pds Stab $
 */

#include "infocom.h"

#define attributes(_obj) (STANDARD ? std_attributes (_obj) : enh_attributes (_obj))
#define get_child(_obj) (STANDARD ? std_child (_obj) : enh_child (_obj))
#define get_sibling(_obj) (STANDARD ? std_sibling (_obj) : enh_sibling (_obj))
#define get_parent(_obj) (STANDARD ? std_parent (_obj) : enh_parent (_obj))
#define data(_obj) (STANDARD ? std_data (_obj) : enh_data (_obj))

__attribute__ ((pure)) byte *std_attributes (word obj) {
  return (byte*)(objd_obj_base + (obj * 9) + 0x35);
}
#define std_addr(obj) ((object_t*)std_attributes (obj))
#define std_child(obj) (std_addr (obj) -> child)
#define std_sibling(obj) (std_addr (obj) -> sibling)
#define std_parent(obj) (std_addr (obj) -> parent)
#define std_data(obj) (std_addr (obj) -> data)

__attribute__ ((pure)) byte *enh_attributes (word obj) {
  return (byte*)(objd_obj_base + (obj * 14) + 0x70);
}
#define enh_addr(obj) ((eobject_t*)enh_attributes (obj))
#define enh_child(obj) (enh_addr (obj) -> child)
#define enh_sibling(obj) (enh_addr (obj) -> sibling)
#define enh_parent(obj) (enh_addr (obj) -> parent)
#define enh_data(obj) (enh_addr (obj) -> data)

static void
cut_obj A1(word, obj)
{
    word a;
    word b;
    word c;

    if (STANDARD) {
      object_t *addr_obj = std_addr (obj);
      a = addr_obj -> parent;
      if (a == 0) return;

      c = addr_obj -> sibling;
      addr_obj -> parent = 0;
      addr_obj -> sibling = 0;

      addr_obj = std_addr (a);
      b = addr_obj -> child;
      
      if (b == obj)
	addr_obj -> child = c;
      else {
	addr_obj = std_addr (b);
	while ((a = addr_obj -> sibling) != obj)
	  addr_obj = std_addr (a);
	addr_obj -> sibling = c;
      }
    }
    else {
      eobject_t *addr_obj = enh_addr (obj);
      a = addr_obj -> parent;
      if (a == 0) return;

      c = addr_obj -> sibling;
      addr_obj -> parent = 0;
      addr_obj -> sibling = 0;

      addr_obj = enh_addr (a);
      b = addr_obj -> child;
      
      if (b == obj)
	addr_obj -> child = c;
      else {
	addr_obj = enh_addr (b);
	while ((a = addr_obj -> sibling) != obj)
	  addr_obj = enh_addr (a);
	addr_obj -> sibling = c;
      }
    }
}

inline void
transfer A2(word, o1, word, o2)
{
    cut_obj(o1);

    if (STANDARD) {
      object_t *addr_o1 = std_addr (o1);
      object_t *addr_o2 = std_addr (o2);

      addr_o1 -> sibling = addr_o2 -> child;
      addr_o1 -> parent = o2;
      addr_o2 -> child = o1;
    }
    else {
      eobject_t *addr_o1 = enh_addr (o1);
      eobject_t *addr_o2 = enh_addr (o2);

      addr_o1 -> sibling = addr_o2 -> child;
      addr_o1 -> parent = o2;
      addr_o2 -> child = o1;
    }
}

inline void
test_attr A2(word, obj, word, attr)
{
    byte* attributs = attributes(obj);
    int         b;
    int         i;

    b = 0x80;
    for (i = attr % 8; i > 0; --i)
        b >>= 1;

    ret_value((attributs[attr / 8] & b) != 0);
}

inline void
set_attr A2(word, obj, word, attr)
{
    byte* attributs = attributes(obj);
    int         b;
    int         i;

    b = 0x80;
    for (i = attr % 8; i > 0; --i)
        b >>= 1;
    attributs[attr / 8] |= b;
}

inline void
clr_attr A2(word, obj, word, attr)
{
    byte* attributs = attributes(obj);
    int         b;
    int         i;

    b = 0x80;
    for (i = attr % 8; i > 0; --i)
        b >>= 1;
    attributs[attr / 8] &= (~b);
}

inline void
get_loc A1(word, obj)
{
  store(get_parent (obj));
}

inline void
get_holds A1(word, obj)
{
    word child = get_child (obj);

    store (child);
    ret_value (child != 0);
}

inline void
get_link A1(word, obj)
{
    word sibling = get_sibling (obj);

    store(sibling);
    ret_value(sibling != 0);
}

inline void
check_loc A2(word, o1, word, o2)
{
  ret_value(get_parent (o1) == o2);
}
