/* file.c -- entirely rewritten for tigcc by Nils Gesbert, January 2003
 *
 *  foblub -- a Z-machine for TI calculators
 *  based on pinfocom by InfoTaskForce and Paul Smith
 *  Ported and extended by Nils Gesbert, 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to the
 *  Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "infocom.h"

#include <string.h>
#include <vat.h>
#include <alloc.h>
#include <args.h>
#include <statline.h>
#include "ttarchive.h"
#include "ttunpack.h"

#define REPERTOIRE_JEUX "zcode"
#define REP_SAUVEGARDES "zsvg"
#define MAX_CAR_NOM_FIC 19 /* \0 + 8 car. nom du rpertoire + \ + 8 car. nom fichier + \0 */

static struct {
  unsigned short nombre;
  HANDLE fichier[4];
} game_file;

static __attribute__ ((pure)) HANDLE ouvre_sauvegarde (const char *nom_fichier) {
  char nom_complet[MAX_CAR_NOM_FIC];
  int lg_nom_complet;
  SYM_ENTRY *se;

  nom_complet[0] = 0;
  lg_nom_complet = sprintf (nom_complet + 1,
			    (strchr (nom_fichier, '\\') ? "%.17s" : REP_SAUVEGARDES "\\%.8s"),
			    nom_fichier);
  se = SymFindPtr (nom_complet + lg_nom_complet + 1, 0);
  return (se ? se -> handle : H_NULL);
}

inline int open_file (const char* filename) {
  char nom_complet[MAX_CAR_NOM_FIC];
  char *basename;
  char *chiffre;
  Bool sauvegarde = FALSE;
  SYM_ENTRY *se;
  int i;  
  nom_complet[0] = 0;

  if (basename = strchr (filename, '\\')) {
    basename++;
    chiffre = nom_complet + sprintf (nom_complet + 1, "%.17s", filename);
    if (se = SymFindPtr (chiffre + 1, 0)) {
      byte *ptr = HeapDeref (se -> handle);
      if (!strcmp ("ZSVG", ptr + *(word*)ptr - 4)) {
	strncpy (nom_jeu, ptr + 10, 7);
	chiffre =
	  nom_complet + 1 + sprintf (nom_complet + 1, REPERTOIRE_JEUX "\\%.7s", ptr + 10);
	sauvegarde = TRUE;
      }
      else {
	*chiffre = 0;
	strncpy (nom_jeu, basename, 7);
      }
    }
    else goto argh;
  }
  else {
    chiffre =
      nom_complet + 1 + sprintf (nom_complet + 1, REPERTOIRE_JEUX "\\%.7s", filename);
    strncpy (nom_jeu, filename, 7);
  }
  
  chiffre[1] = 0;
  for (i = 0, *chiffre = '1'; i < 4; i++, (*chiffre)++) {
    if (se = SymFindPtr (chiffre + 1, 0))
      game_file.fichier[i] = se -> handle;
    else break;
    if (!ttarchive_valid (HeapDeref (game_file.fichier[i]) + 2)) {
      ST_helpMsg (FRENCH ? "fichier non valide" : "invalid gamefile");
      return 0;
    }
  }
  if (i == 0) {
argh :
    ST_helpMsg (FRENCH ? "jeu non trouv" : "game not found");
    return 0;
  }
  game_file.nombre = i;
  if (sauvegarde) return 2;
  return 1;
}


void
load_page A2(word, block, byte*, ptr)
{
  word numero_fichier = block / 16;
  word numero_bloc = block % 16;
  byte *archive;
#ifdef DEBUG2
  if (tracing) {
    char buf[50];
    sprintf (buf, "load_page : %hu", block);
    scr_putline (buf);
  }
#endif  

  if (numero_fichier >= game_file.nombre ||
      !(archive = HeapDeref (game_file.fichier[numero_fichier])) ||
      (archive += 2,
       ttarchive_entries (archive) <= numero_bloc) ||/* Qques vrifs pour pas tout planter */
      (archive = ttarchive_data(archive, numero_bloc),   /* si le fichier n'est pas bon... */
       ttunpack_size (archive) > BLOCK_SIZE) ||
      ttunpack_decompress (archive, ptr)) {
    
    if (!sauvegarde_ecran) {
      ST_helpMsg (FRENCH ? "erreur de chargement" : "error loading game");
      quit();
    }
    else error (FRENCH ? "impossible de dcompresser le bloc %hu" :
		"unable to uncompress bloc %hu", block);
  }
}


inline void
save()
{
  HANDLE hdl;
  HSym sym;
  byte *ptr;
  word i;
  byte j;
  byte b;
  int k;
  word l;
  byte orig[BLOCK_SIZE];
  word *wptr;
  int taille_pile = (stack_base - stack) * 2;
  char nom_complet[MAX_CAR_NOM_FIC];

  /* J'alloue la mmoire ncessaire pour la sauvegarde */
  /* Je ne sais pas combien il en faut mais je peux limiter a priori  la taille non compresse
     (en partant du principe que la compression rduit effectivement la taille,
     ce qui devrait TOUJOURS tre le cas dans la ralit...)
     S'il n'y en a pas autant de disponible j'alloue tout et j'espre que a va tenir. */
  long max = HeapMax() - 26;
  /* 26 = 5 mots (x 2) + 8 car. nom du jeu + 6 extension + 1 (ventuel) en fin de compression */
  long max2 = data_head.save_bytes + taille_pile;
  if (max < 0 ||
      (max = max > max2 ? max2 : max,
       !(hdl = HeapAlloc (max + 26)))) {
pasassezdememoire :
    scr_putline (FRENCH ? "[Dsol, pas assez de mmoire pour sauvegarder...]"
		 : "[Sorry, not enough memory to save...]");
annule :
    if (STANDARD) ret_value (0); else store (0);
    return;
  }
  
  /* Et maintenant je sauve... */
  wptr = (word*) HeapDeref (hdl);
  wptr[1] = pc_page;
  wptr[2] = pc_offset;
  wptr[3] = stack_base - stack_var_ptr;
  wptr[4] = taille_pile;
  
  ptr = (byte*) (wptr + 5);
  strncpy (ptr, nom_jeu, 8);
  ptr += 8;
  memcpy (ptr, stack, taille_pile);
  
  /* Alors on va utiliser la super techniqe de compression de la mort */
  for (i = 0, j = 0, k = BLOCK_SIZE, l = taille_pile;
       i < data_head.save_bytes; i++, k++) { /* k == i % BLOCK_SIZE */
    
    if (k == BLOCK_SIZE) {
      load_page (i / BLOCK_SIZE, orig);
      k = 0;
    }

    b = base_ptr[i] ^ orig[k];
    if (b) {
      if (j) { /* S'il y a eu une squence de zros j'cris sa longueur */
	ptr[l++] = j;
	j = 0;
      }
      ptr[l++] = b;
    }
    else if (!j++ || !j) ptr[l++] = 0; /* Si c'est le premier ou le 256e zro je l'cris */

    if (max < l) /* On est foutu... */ {
      HeapFree (hdl);
      goto pasassezdememoire;
    }
  }
  if (j) ptr[l++] = j; /* Pour complter */
  
  /* Et l faut mettre le type du fichier */
  ptr[l++] = 0;
  strcpy (ptr + l, "ZSVG");
  l += 5;
  ptr[l] = OTH_TAG;
  
  /* Voyons la place que a a pris finalement... */
  *wptr = (l += 17); /* Le mot o est stocke la taille ne compte pas dans celle-ci */
  /* 17 = 4 mots (x 2) + 8 car. nom du jeu + 1 OTH_TAG */
  HeapRealloc (hdl, l + 2); /* Mais je suppose qu'ici il compte ! */

  /* Je cre un  fichier  */
  nom_complet[0] = 0;
  do {
    char nom_fichier[18];
    int machin;
    SCR_STATE ss;
    machin = scr_getline (FRENCH ? "Entrez un nom de fichier (dfaut nom du jeu)  >"
			  : "Enter a filename (default: game name)>", 18, nom_fichier);
    if (machin == -1) { /* On a appuy sur Esc pour annuler */
      HeapFree (hdl);
      goto annule;
    }
    if (!machin || !strchr (nom_fichier, '\\'))
      machin =
	sprintf (nom_complet + 1, REP_SAUVEGARDES "\\%.8s", machin ? nom_fichier : nom_jeu);
    else strcpy (nom_complet + 1, nom_fichier);
    SaveScrState (&ss); /* Si une bote de dialogue apparat elle casse tout... */
    sym = SymAdd (nom_complet + machin + 1);
    RestoreScrState (&ss);
  } while (!sym.folder);
  /* Je l'associe  la mmoire alloue */
  DerefSym (sym) -> handle = hdl;
  /* Archivage */
#ifndef PAS_ARCHIVER_SVG
  if (!EM_moveSymToExtMem (NULL, sym))
    scr_putline (FRENCH ? "[Impossible d'archiver la sauvegarde]"
		 : "[Unable to archive the savegame]"); /* On n'insiste pas... */
#endif
  /* Fini ! */
  if (STANDARD) ret_value (1); else store (1);
}

void rextore (const char *nom_fic) {  
  HANDLE fichier;
  word dhsb = data_head.save_bytes;
  word *wptr;
  byte *ptr;
  int taille_pile;
  word i, j;
  byte b;
#define NOMBRE 23

debut :
  fichier = H_NULL;
  if (nom_fic) /* si un nom de fichier a t donn sur la ligne de commande, on l'essaye */
    fichier = ouvre_sauvegarde (nom_fic);
  while (!fichier) {
    char nom_fichier[18];
    int machin;
    machin = scr_getline (FRENCH ? "Entrez un nom de fichier (dfaut nom du jeu)  >"
			  : "Enter a filename (default: game name)>", 18, nom_fichier);
    if (machin == -1) { /* On a appuy sur Esc pour annuler */
annule :
      if (!prog_block_ptr) change_status(); /* Cas o le jeu n'a pas encore t dmarr */
      else {
	if (STANDARD) ret_value(0); else store(0);
      }
      return;
    }
    fichier = ouvre_sauvegarde (machin ? nom_fichier : nom_jeu);
  }
  wptr = (word*) HeapDeref (fichier);

  /* Bon en gros c'est la mme chose  l'envers... */

  ptr = (byte*) wptr;
  if (strcmp (ptr + *wptr - 4, "ZSVG")) {
    scr_putline (FRENCH ? "[Le fichier existe mais n'est pas une sauvegarde foblub valide.]"
		 : "[File exists but is not a valid foblub savegame.]");
    goto annule;
  }
  if (strcmp (ptr + 10, nom_jeu)) {
    scr_putline (FRENCH ? "[Attention, cette sauvegarde semble avoir t faite pour un autre"
		 " jeu. Appuyez sur Esc pour annuler ou sur une autre touche pour la charger"
		 " quand mme.]"
		 : "[Warning: this savegame appears to be from another game. Press Esc to cancel"
		 " or any other key to load it anyway.]");
    if (ngetchx() == KEY_ESC) goto annule;
  }
  pc_page = wptr[1];
  pc_offset = wptr[2];
  stack_var_ptr = stack_base - wptr[3];
  taille_pile = wptr[4];
  stack = stack_base - (taille_pile >> 1);
  ptr += 18;
  memcpy (stack, ptr, taille_pile);

  /* Je recharge la mm.dynamique SAUF si on m'a spcifi un nom de fichier
   (ce qui signifie qu'on vient de lancer le jeu) */
  if (!nom_fic)
    for (i = 0; i < dhsb / BLOCK_SIZE + 1; i++)
      load_page (i, base_ptr + i * BLOCK_SIZE);

  /* Et c'est parti ! */
  for (i = taille_pile, j = 0; i < *wptr - NOMBRE && j < dhsb; j++) {
    b = ptr[i++];
    if (b) base_ptr[j] ^= b;
    else j += (byte) (ptr[i++] - 1);
  }
  /* Logiquement les deux conditions de sortie devraient se raliser simultanment
     sinon y a un blme... */
  if (i != *wptr - NOMBRE || j != dhsb) {
    scr_putline (FRENCH ?
		 "[Il semble qu'il y ait un petit problme... appuyez sur ESC pour redmarrer le"
		 " jeu, sur entre pour charger une autre sauvegarde ou sur n'importe quelle "
		 "autre touche pour continuer comme si de rien n'tait.]"
		 :
		 "[It looks like there was some problem... press ESC to restart the game, enter "
		 "to load another savegame, or any other key to ignore this and proceed.]");
    switch (ngetchx()) {
    case KEY_ESC : data_head.save_bytes = dhsb; restart(); return;
      /* data_head.save_bytes a pu tre cras par la mauvaise sauvegarde
         -> on le remet  l'ancienne valeur sinon restart() ne fonctionnera pas correctement. */
    case KEY_ENTER : nom_fic = NULL; goto debut;
    }
  }

  /* Bon ben normalement c'est fini... */
  fix_pc();
  if (STANDARD) ret_value (1); else store(2);
}
#undef NOMBRE
inline void restore() {rextore (NULL);}
