
#ifndef z_ucs_h_INCLUDED
#define z_ucs_h_INCLUDED

#include <string.h>
#include <stdio.h>

#include "types.h"

#define UEOF ((z_ucs)-1)
#define UTF_8_MB_LEN 6
#define Z_UCS_NEWLINE ((z_ucs)'\n')
#define Z_UCS_SPACE ((z_ucs)' ')
#define Z_UCS_BACKSLASH ((z_ucs)'\\')

size_t z_ucs_len(/*@in@*/ /*@null@*/ z_ucs *string);
/*@dependent@*/ z_ucs *z_ucs_cpy(/*@out@*/ /*@dependent@*/ z_ucs *dst,
    /*@in@*/ /*@dependent@*/ z_ucs *src);
void z_ucs_ncpy(/*@out@*/ /*dependent@*/ z_ucs *dst,
    /*@in@*/ /*dependent@*/ z_ucs *src, size_t len);
void z_ucs_output_number(/*@out@*/ z_ucs *dst, long int number);
z_ucs parse_utf_8_char(FILE *fp);
z_ucs utf_8_to_z_ucs(char **src);
z_ucs latin1_to_z_ucs(char c);
/*@null@*/ /*@dependent@*/ char *latin1_string_to_z_ucs(
    /*@out@*/ /*@dependent@*/ z_ucs *dest,
    /*@in@*/ /*@dependent@*/ char *src, size_t max_dest_size);
/*@null@*/ /*@dependent@*/ char *utf_8_string_to_z_ucs(
    /*@out@*/ /*@dependent@*/ z_ucs *dest,
    /*@in@*/ char *src, int max_dest_size);
int z_ucs_to_utf_8(/*@out@*/ /*@null@*/ char *dst, z_ucs **src,
    size_t max_dst_size);
char z_ucs_to_latin1(z_ucs src);
int z_ucs_cmp(z_ucs *s1, z_ucs *s2);
int z_ucs_cmp_latin1(z_ucs *s1, char *s2);
/*@dependent@*/ /*@null@*/ z_ucs *z_ucs_chr(z_ucs *s1, z_ucs chr);
/*@dependent@*/ /*@null@*/ z_ucs *z_ucs_rchr(z_ucs *s1, z_ucs chr);

#endif // z_ucs_h_INCLUDED

