
#ifndef Interpreter_h_INCLUDED 
#define Interpreter_h_INCLUDED

#include "types.h"
#include "ScreenInterface.h"
#include "../fizmo/i18n_codes.h"


class Interpreter
{
  private:
    static struct z_screen_interface cpp_screen_interface;

  public:
    static ScreenInterface *active_cpp_screen_interface;

    static void register_screen_interface(ScreenInterface *screen_interface);
    static void start(char* z_story_filename, char *blorb_filename,
        char *restore_on_start_filename);
    static void new_screen_size(int width, int height);
    static zscii unicode_char_to_zscii_input_char(z_ucs unicode_char);
    static int streams_z_ucs_output(z_ucs *z_ucs_output);
    static int streams_latin1_output(char *latin1_output);
    static int i18n_translate(int string_code, ...);
    static int i18n_translate_and_exit(int string_code,
        int exit_code, ...);
};

#endif /* Interpreter_h_INCLUDED */

