
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "../fizmo/fizmo.h"
#include "../fizmo/types.h"
#include "../c/screen_interface.h"
#include "../fizmo/i18n.h"
#include "../fizmo/wordwrap.h"
#include "../fizmo/text.h"
#include "../fizmo/streams.h"
#include "../fizmo/locales.h"
#include "../fizmo/config.h"
#include "../fizmo/z_ucs.h"
#include "../fizmo/zpu.h"

#define MAX_INPUT_LENGTH 80
#define STORY_FILE "../minizork.z3"


static char* cgi_input = NULL;


char *cgi_get_interface_name()
{ return "simple-c"; }

bool cgi_return_false()
{ return false; }

bool cgi_return_true()
{ return true; }

uint8_t cgi_get_screen_height()
{ return 24; }

uint8_t cgi_get_screen_width()
{ return 80; }

uint8_t cgi_return_1()
{ return 1; }

z_colour cgi_get_default_foreground_colour()
{ return Z_COLOUR_BLACK; }

z_colour cgi_get_default_background_colour()
{ return Z_COLOUR_WHITE; }

uint8_t cgi_return_0()
{ return 0; }

int cgi_parse_config_parameter(char *key, char *value)
{ return 1; }

void cgi_link_interface_to_story(struct z_story *story)
{ }

void cgi_reset_interface()
{ }

int cgi_close_interface(z_ucs *error_message)
{ return 0; }

void cgi_set_buffer_mode(uint8_t new_buffer_mode)
{ }

void cgi_interface_output_z_ucs(z_ucs *z_ucs_output)
{
  while (*z_ucs_output != 0)
  {
    if ((*z_ucs_output & 0xffffff80) != 0)
      putchar('?');
    else
      putchar((char)*z_ucs_output);

    z_ucs_output++;
  }
}

int16_t cgi_interface_read_line(zscii *dest, uint16_t maximum_length,
    uint16_t tenth_seconds, uint32_t verification_routine,
    uint8_t preloaded_input, int *tenth_seconds_elapsed,
    bool disable_command_history, bool return_on_escape)
{
  int16_t input_size = 0;;
  char *input;
  int i = 0;

  if (cgi_input == NULL)
    return 0;

  input = cgi_input;

  while ( (*input != 0) && (i < maximum_length) )
  {
    if ( (*input == '\n') || (*input == '\r') )
      break;

    *(dest++) = tolower(*(input++));
    input_size++;
  }

  return input_size;
}

int cgi_interface_read_char(uint16_t tenth_seconds,
    uint32_t verification_routine, int *tenth_seconds_elapsed)
{
  if (cgi_input == NULL)
    return (uint8_t)' ';
  else
    return (uint8_t)tolower(*cgi_input);
}

void cgi_show_status(z_ucs *room_description, int status_line_mode,
    int16_t parameter1, int16_t parameter2)
{ }

void cgi_set_text_style(z_style text_style)
{ }

void cgi_set_colour(z_colour foreground, z_colour background,
    int16_t window)
{ }

void cgi_set_font(z_font font_type)
{ }

void cgi_split_window(int16_t nof_lines)
{ }

void cgi_set_window(int16_t window_number)
{ }

void cgi_erase_window(int16_t window_number)
{ }

void cgi_set_cursor(int16_t line, int16_t column, int16_t window)
{ }

uint16_t cgi_get_cursor_row()
{ return 0; }

uint16_t cgi_get_cursor_column()
{ return 0;}

void cgi_erase_line_value(uint16_t start_position)
{ }

void cgi_erase_line_pixels(uint16_t start_position)
{ }

void cgi_output_interface_info()
{ }

struct z_screen_interface cgi_interface =
{
  &cgi_get_interface_name,
  &cgi_return_false,
  &cgi_return_false,
  &cgi_return_false,
  &cgi_return_false,
  &cgi_return_false,
  &cgi_return_false,
  &cgi_return_false,
  &cgi_return_true,
  &cgi_return_false,
  &cgi_return_false,
  &cgi_return_false,
  &cgi_return_false,
  &cgi_get_screen_height,
  &cgi_get_screen_width,
  &cgi_get_screen_height,
  &cgi_get_screen_width,
  &cgi_return_1,
  &cgi_return_1,
  &cgi_get_default_foreground_colour,
  &cgi_get_default_background_colour,
  &cgi_return_0,
  &cgi_parse_config_parameter,
  &cgi_link_interface_to_story,
  &cgi_reset_interface,
  &cgi_close_interface,
  &cgi_set_buffer_mode,
  &cgi_interface_output_z_ucs,
  &cgi_interface_read_line,
  &cgi_interface_read_char,
  &cgi_show_status,
  &cgi_set_text_style,
  &cgi_set_colour,
  &cgi_set_font,
  &cgi_split_window,
  &cgi_set_window,
  &cgi_erase_window,
  &cgi_set_cursor,
  &cgi_get_cursor_row,
  &cgi_get_cursor_column,
  &cgi_erase_line_value,
  &cgi_erase_line_pixels,
  &cgi_output_interface_info,
  &cgi_return_false
};


char *parse_utf8_param(char *ptr)
{
  int code;
  char param_buffer[MAX_INPUT_LENGTH];
  char input_buffer[MAX_INPUT_LENGTH];
  int index, i;
  z_ucs c;

  index = 0;
  ptr++;
  while ( (*ptr != 0) && (index + 2 < MAX_INPUT_LENGTH) )
  {
    if (*ptr == '%')
    {
      code = 0;
      for (i=1; i>=0; i--)
      {
        ptr++;
        if ( (*ptr >= 'A') && (*ptr <= 'Z') )
        {
          code |= (((*ptr - 'A') + 10 ) << (i*4));
        }
        else if  ((*ptr >= '0') && (*ptr <= '9') )
        {
          code |= ((*ptr - '0') << (i*4));
        }
      }
      param_buffer[index] = (char)code;
    }
    else
    {
      param_buffer[index] = *ptr;
    }
    ptr++;
    index++;
  }
  param_buffer[index] = '\0';

  ptr = param_buffer;
  index = 0;
  while (*ptr != 0)
  {
    c = utf_8_to_z_ucs(&ptr);
    if (c < 0x80)
      input_buffer[index] = c;
    else
      input_buffer[index] = '?';
    index++;
  }
  input_buffer[index] = '\0';

  return strdup(input_buffer);
}


int main(int argc, char *argv[])
{
  char *params = getenv("QUERY_STRING");
  char *token;
  char *sep = "&";
  char *quetzalname = NULL;
  char *ptr;
  FILE *in;
  int c;

  printf("Content-type: text/plain\n\n");

  for (token=strtok(params, sep); token; token=strtok(NULL, sep))
  {
    if ((ptr = strchr(token, '=')))
    {
      *ptr = '\0';
      if (strcmp(token, "input") == 0)
      {
        cgi_input = parse_utf8_param(ptr);
      }
      else if (strcmp(token, "quetzalname") == 0)
      {
        if ((quetzalname = parse_utf8_param(ptr)) != NULL)
        {
          ptr = quetzalname;

          if (*ptr == '/')
            *ptr = '_';

          while (*ptr != 0)
          {
            if (*ptr == '.')
              *ptr = '_';
            ptr++;
          }
        }
      }
    }
  }

  if ( (cgi_input == NULL) || (quetzalname == NULL) )
    exit(-1);

  if ((in = fopen(quetzalname, "r")) == NULL)
    exit(-2);

  set_configuration_value("disable-external-streams", "true");
  set_configuration_value("disable-save", "true");
  set_configuration_value("disable-restore", "true");
  set_configuration_value("save-and-quit-file-before-read", quetzalname);
  set_configuration_value("restore-after-save-and-quit-file-before-read",
      "true");

  c = fgetc(in);
  fclose(in);

  if (c == EOF)
    quetzalname = NULL;

  fizmo_register_screen_interface(&cgi_interface);

  fizmo_start(STORY_FILE, NULL, quetzalname);

  if (terminate_interpreter != INTERPRETER_QUIT_SAVE_BEFORE_READ)
    remove(quetzalname);

  free(quetzalname);

  return 0;
}

