! ==============================================================================
! GRAMMAR for Triform 1.2a
!
! Nearly all of this file is copyrighted by Graham Nelson, 1993-2004, or David
! Griffith, 2012-2014, and licensed under the traditional Inform license:

! Copyright on Inform, the program and its source code, its example
! games and documentation (including this book) is retained by Graham
! Nelson, who asserts the moral right to be identified as the author
! under the Copyrights, Designs and Patents Act 1988.  Having said
! this, I am happy for it to be freely distributed to anybody who wants
! a copy, provided that: (a) distributed copies are not substantially
! different from those archived by the author, (b) this and other
! copyright messages are always retained in full, and (c) no profit is
! involved.  (Exceptions to these rules must be negotiated directly
! with the author.)  However, a story file produced with the Inform
! compiler (and libraries) then belongs to its author, and may be sold
! for profit if desired, provided that its game banner contains the
! information that it was compiled by Inform, and the Inform version
! number.

! All code contributed by myself and not appearing in any of the standard Inform
! libraries is public domain.
! ==============================================================================

System_file;

! ------------------------------------------------------------------------------
!  The "meta-verbs", commands to the game rather than in the game, come first:
! ------------------------------------------------------------------------------

Verb meta 'brief' 'verbose' 'long' 'superbrief' 'short' 'normal' 'standard'
    *                                           -> LookMode
    * 'mode'					-> LookMode;
#Ifndef NO_SCORE;
Verb meta 'notify'
    *                                           -> NotifyOn
    * 'on'                                      -> NotifyOn
    * 'off'                                     -> NotifyOff;
#Endif;
Verb meta 'pronouns' 'nouns'
    *                                           -> Pronouns;
Verb meta 'quit' 'q//' 'die'
    *                                           -> Quit;
Verb meta 'recording'
    *                                           -> CommandsOn
    * 'on'                                      -> CommandsOn
    * 'off'                                     -> CommandsOff;
Verb meta 'replay'
    *                                           -> CommandsRead;
Verb meta 'restart'
    *                                           -> Restart;
Verb meta 'restore'
    *                                           -> Restore;
Verb meta 'save'
    *                                           -> Save;
#Ifndef NO_SCORE;
Verb meta 'score'
    *                                           -> Score;
Verb meta 'fullscore' 'full'
    *                                           -> FullScore
    * 'score'                                   -> FullScore;
#Endif;
Verb meta 'script' 'transcript'
    *                                           -> ScriptOn
    * 'on'                                      -> ScriptOn
    * 'off'                                     -> ScriptOff;
Verb meta 'noscript' 'unscript'
    *                                           -> ScriptOff;
Verb meta 'verify'
    *                                           -> Verify;
Verb meta 'version'
    *                                           -> Version;

#Ifndef NO_PLACES;
Verb meta 'objects'
    *                                           -> Objects;
Verb meta 'places'
    *                                           -> Places;
#Endif; ! NO_PLACES

! ------------------------------------------------------------------------------
!  Debugging grammar
! ------------------------------------------------------------------------------

#Ifdef DEBUG;
Verb meta 'actions'
    *                                           -> ActionsOn
    * 'on'                                      -> ActionsOn
    * 'off'                                     -> ActionsOff;
Verb meta 'changes'
    *                                           -> ChangesOn
    * 'on'                                      -> ChangesOn
    * 'off'                                     -> ChangesOff;
Verb meta 'gonear'
    * anynumber                                 -> GoNear
    * noun                                      -> Gonear;
Verb meta 'goto'
    * anynumber                                 -> Goto;
Verb meta 'random'
    *                                           -> Predictable;
Verb meta 'routines' 'messages'
    *                                           -> RoutinesOn
    * 'on'                                      -> RoutinesOn
    * 'off'                                     -> RoutinesOff;
Verb meta 'scope'
    *                                           -> Scope
    * noun                                      -> Scope;
Verb meta 'showobj'
    *                                           -> Showobj
    * anynumber                                 -> Showobj
    * multi                                     -> Showobj;
Verb meta 'showverb'
    * special                                   -> Showverb;
Verb meta 'timers' 'daemons'
    *                                           -> TimersOn
    * 'on'                                      -> TimersOn
    * 'off'                                     -> TimersOff;
Verb meta 'trace'
    *                                           -> TraceOn
    * number                                    -> TraceLevel
    * 'on'                                      -> TraceOn
    * 'off'                                     -> TraceOff;
Verb meta 'abstract'
    * noun 'to' noun                            -> XAbstract;
Verb meta 'purloin'
    * multi                                     -> XPurloin;
Verb meta 'tree'
    *                                           -> XTree
    * noun                                      -> XTree;

#Ifdef TARGET_GLULX;
Verb meta 'glklist'
    *                                           -> Glklist;
#Endif; ! TARGET_

#Endif; ! DEBUG

! ------------------------------------------------------------------------------
!  A handful of very helpful parsing routines.
! ------------------------------------------------------------------------------

[ ADirection;
  if (noun in compass) rtrue;
	else if (verb_word == 'look' or 'l//')
	     { L__M(##Miscellany, 28); PrintCommand();
	       L__M(##Miscellany, 56); keep_silent = 2;
	     }
	else rfalse;
];

[ IsWearable;
  if (verb_word == 'remove' && noun notin actor) rfalse;
#IFDEF COMPLEXCLOTHING;
  if (noun ofclass Wearable) rtrue;
#IFNOT;
  if (noun has clothing) rtrue;
#ENDIF;
  rfalse;
];

[ Topics i;
  switch (scope_stage) {
	1: rfalse;
	2: objectloop (i has topic) ScopeWithin_O (i);
	   rtrue;
	3: "[A bug has occurred.]";
  }
];

[ Into wd o_wn i flag;
	o_wn = wn;
	if (reparsing == true) { num_words++;
		objectloop (i ofclass Container && Isvisible(i) && ValueorRun(i, inside_capacity)) {
			Descriptors();
			if (TryGivenObject(i, 8)) { wn = o_wn; num_words--; return GPR_PREPOSITION; }
			else wn = o_wn;
		}
		num_words--;
	}
	wn = o_wn;
	wd = NextWordStopped();
	if (wd == 'in') {
		flag++;
		if (NextWord() == 'to') ; else wn--;
	}
	if (wd == 'into' or 'within') {
		flag++;
	}
	if (wd == 'inside') {
		flag++;
		if (NextWord() == 'of') ; else wn--;
	}
	if (flag || (wd == -1 && verb_word ~= 'drop' or 'discard'))
		return GPR_PREPOSITION;
	return GPR_FAIL;
];

[ Onto wd o_wn flag;
	o_wn = wn;
	if (reparsing == true) {
		Descriptors();
		if (NounDomain(actor)) { wn = o_wn; return GPR_PREPOSITION; }
	}
	wn = o_wn;
	wd = NextWordStopped();
	if (wd == 'on') {
		flag++;
		if (NextWord() == 'top') {
			if (NextWord() == 'of') ;
			else wn--;
			}
		else wn--;
		if (NextWord() == 'to') {
			flag++;
			if (NextWord() == 'the') {
				if (NextWord() == 'top') {
					if (NextWord() == 'of') ; else wn--;
				}
				else wn--;
			}
			else wn--;
		}
		else wn--;
	}
	if (wd == 'onto') {
		flag++;
	}
	if (flag || (wd == -1 && verb_word ~= 'drop' or 'discard'))
		return GPR_PREPOSITION;
	return GPR_FAIL;
];

[ Behind wd flag;
	wd = NextWordStopped();
	if (wd == 'behind') flag++;
	if (wd == 'in') {
		if (NextWord() == 'back') {
			if (NextWord() == 'of') flag++;
		}
	}
	if (flag || (wd == -1 && verb_word ~= 'drop' or 'discard'))
		return GPR_PREPOSITION;
	return GPR_FAIL;
];

[ Under wd flag;
	wd = NextWordStopped();
	if (wd == 'down') wd = NextWord();
	if (wd == 'below' or 'beneath' or 'under' or 'underneath') flag++;
	if (flag || (wd == -1 && verb_word ~= 'drop' or 'discard'))
		return GPR_PREPOSITION;
	return GPR_FAIL;
];

! ------------------------------------------------------------------------------
!  Verbs for moving things.
! ------------------------------------------------------------------------------

Verb 'drop' 'discard'
    * multiheld                                 -> Drop
    * multiexcept Into noun			-> Insert
    * multiexcept Onto noun			-> PutOn
    * multiexcept Behind noun			-> PutBehind
    * multiexcept Under noun			-> PutUnder;

Verb 'throw' 'toss' 'lob' 'fling' 'heave'
    * multiheld Into noun			-> Insert
    * multiheld Onto noun			-> PutOn
    * multiheld Behind noun			-> PutBehind
    * multiheld Under noun			-> PutUnder
    * held 'at'/'against'/'on'/'onto' noun      -> ThrowAt;

Verb 'get'
    * 'out'/'off'/'down'			-> Exit
    * multi					-> Take
    * 'out' 'of' noun=IsWearable		-> Disrobe
    * 'out' 'of'/'from' noun			-> Exit
    * 'off' noun				-> Exit
    * 'off' 'of'/'from' noun			-> Exit
    * 'out' 'from' Under noun			-> Exit
    * 'out' 'from' 'in'/'inside'/'within' noun	-> Exit
    * 'out' 'from' Behind noun			-> Exit
    * 'down'/'up' 'from'/'off' noun		-> Exit
    * 'down'/'up' 'off' 'of'/'from' noun	-> Exit
    * 'a' 'drink'/'sip'/'swig' 'of'/'from' noun
						-> Drink
    * Under noun				-> GetBeneath
    * Into noun    				-> GetInside
    * Behind noun				-> GetBehind
    * Onto noun					-> GetOn;

Verb 'insert' 'jam' 'ram' 'shove' 'stick'
     'stuff' 'thrust' 'tuck'
    * multiexcept Into noun			-> Insert
    * multiexcept Under noun			-> PutUnder
    * multiexcept Behind noun			-> PutBehind;

Verb 'push' 'clear' 'move' 'press' 'shift'
    * 'ahead'/'on'/'forward'			-> VagueGo
    * noun=ADirection				-> Go
    * 'ahead'/'on'/'to' noun=ADirection		-> Go
    * noun                                      -> Push
    * 'over' noun				-> PushOver
    * noun 'over'				-> PushOver
    * noun noun=ADirection                      -> PushDir
    * multiexcept 'to' noun			-> Transfer
    * multiexcept Into noun			-> Insert
    * multiexcept Onto noun			-> PutOn
    * multiexcept Behind noun			-> PutBehind
    * multiexcept Under noun			-> PutUnder
    * multiexcept 'down'/'to' Onto noun
						-> PutOn
    * multiexcept 'down'/'to' Into noun
						-> Insert
    * multiexcept 'down'/'to' Behind noun
						-> PutBehind
    * multiexcept 'down'/'to' Under noun
						-> PutUnder;
Verb 'pick'
    * multi 'up'                                -> Take
    * 'up' multi				-> Take;

Verb 'put' 'place'
    * multiexcept Into noun			-> Insert
    * multiexcept Onto noun	              	-> PutOn
    * multiexcept Behind noun			-> PutBehind
    * multiexcept Under noun			-> PutUnder
    * multiheld 'down'                          -> Drop
    * multiexcept 'down' Onto noun		-> PutOn
    * multiexcept 'down' Into noun		-> Insert
    * multiexcept 'down' Behind noun		-> PutBehind
    * 'on' noun=IsWearable                      -> Wear
    * 'down' multiheld                          -> Drop;

Verb 'remove'
    * noun=IsWearable				-> Disrobe
    * multi					-> Take;

Verb 'take' 'acquire' 'carry' 'grab' 'hold' 'obtain' 'snatch' 'steal'
    * multi                               	-> Take;

Extend only 'take'
    * 'off' noun                          	-> Disrobe
    * noun 'off'				-> Disrobe
    * 'inventory'                         	-> Inv
    * 'a' 'drink'/'sip' 'of'/'from' noun	-> Drink;

Verb 'transfer'
    * 'to' noun					-> Enter
    * multiexcept 'to' noun                     -> Transfer
    * multiexcept Into noun			-> Insert
    * multiexcept Onto noun			-> PutOn
    * multiexcept Behind noun			-> PutBehind
    * multiexcept Under noun			-> PutUnder
    * multiexcept 'to' Into noun		-> Insert
    * multiexcept 'to' Onto noun		-> PutOn
    * multiexcept 'to' Behind noun		-> PutBehind
    * multiexcept 'to' Under noun		-> PutUnder;

! ------------------------------------------------------------------------------
!  Conversation verbs.
! ------------------------------------------------------------------------------

Verb 'answer' 'assert' 'say'
    * topic 'to' creature			-> Answer;
Verb 'ask'
    * 'about' scope=Topics			-> VagueAsk
    * 'about' topic				-> VagueAsk
    * creature 'about' scope=Topics		-> Ask
    * creature 'about' topic			-> Ask
    * creature 'for' multi			-> AskFor
    * creature 'to' topic			-> AskTo
    * 'that' creature topic			-> AskTo;
Verb 'consult'
    * noun 'about'/'on' topic                   -> Consult
    * 'about'/'on' topic			-> VagueConsult;
Verb 'order' 'command' 'instruct' 'request' 'persuade' 'convince'
    * creature 'to' topic			-> AskTo
    * 'that' creature topic			-> AskTo;
Verb 'scream' 'shout' 'yell'
    *						-> Scream
    * topic					-> Scream;
Verb 'show' 'display' 'present'
    * creature noun                             -> Show reverse
    * noun 'to' creature                        -> Show
    * 'inventory'/'possessions'			-> Inv
    * 'my' 'inventory'/'possessions'		-> Inv;
Verb 'speak' 'converse' 'talk'
    * 'with'/'to' creature			-> TalkTo
    * 'with'/'to' creature 'about' scope=Topics	-> TalkTo;
Extend only 'speak'
    * topic 'to' noun				-> Answer;
Verb 'tell' 'advise' 'inform'
    * creature 'about' scope=Topics		-> Tell
    * creature 'about'/'that' topic		-> Tell
    * creature 'to' topic                       -> AskTo;

! ------------------------------------------------------------------------------
!  All other verbs.
! ------------------------------------------------------------------------------

Verb 'adjust'
    * noun                                      -> Set
    * noun 'to' anynumber                       -> SetTo;
Verb 'attack' 'fight' 'hit' 'injure' 'slap' 'strike'
    * noun                                      -> Attack
    * noun 'with'/'using' held			-> Attack;
Verb 'bite'
    * noun					-> Bite;
Verb 'blow'
    * noun                                      -> Blow;
Verb meta 'bother' 'curses' 'dang' 'darn' 'drat' 'durnit' 'ugh'
    *                                           -> Mild
    * topic                                     -> Mild;
Verb 'break' 'crack' 'destroy' 'smash' 'wreck'
    * noun					-> Break
    * noun 'with'/'using' held			-> Break;
Verb 'burn' 'incinerate' 'light'
    * creature					-> Torture
    * creature 'with'/'using' held		-> Torture
    * noun                                      -> Burn
    * noun 'with'/'using' held                  -> Burn;
Verb 'buy' 'purchase'
    * noun                                      -> Buy;
Verb 'climb' 'scale'
    * noun                                      -> Climb
    * 'up'/'over' noun                          -> Climb
    * Into noun					-> GetInside
    * Onto noun					-> GetOn;
Verb 'close' 'cover' 'shut'
    * noun                                      -> Close
    * 'up' noun                                 -> Close
    * noun 'up'					-> Close;
Extend only 'shut' first
    * noun 'off'				-> Switchoff
    * 'off' noun                                -> SwitchOff;
Verb 'cut' 'chop' 'pierce' 'prune' 'slice' 'stab'
    * noun                                      -> Cut
    * noun 'with'/'using' held			-> Cut;
Verb 'dig'
    *						-> Dig
    * 'here'					-> Dig
    * noun                                      -> Dig
    * 'in'/'up' noun				-> Dig
    * noun 'with'/'using' held                  -> Dig
    * 'in'/'up' noun 'with'/'using' held	-> Dig;
Verb 'drink' 'sip' 'chug'
    * noun					-> Drink;
Verb 'eat' 'chew' 'swallow'
    * noun                                      -> Eat;
Verb 'empty' 'pour'
    * noun                                      -> Empty
    * 'out' noun                                -> Empty
    * noun 'out'                                -> Empty
    * noun 'to'/'on'/'onto'/'into' noun         -> EmptyT;
Verb 'enter'
    * noun                                      -> Enter;
Verb 'examine' 'x//' 'check' 'describe' 'inspect'
     'observe' 'see' 'study' 'view' 'watch'
    * noun                                      -> Examine;
Verb 'exit' 'out' 'outside'
    *                                           -> Exit
    * noun                                      -> Exit;
Verb 'face'
    * noun					-> Face;
Verb 'fill'
    * noun                                      -> Fill
    * noun 'with' noun				-> Fill;
Verb 'give' 'deliver' 'feed' 'hand' 'offer' 'pay'
    * noun 'to' creature                        -> Give
    * creature noun                             -> Give reverse
    * 'over' noun 'to' creature                 -> Give
    * noun 'over' 'to' creature			-> Give;
Verb 'go' 'amble' 'depart' 'head' 'proceed' 'run' 'saunter' 'stroll' 'travel' 'walk'
    *                                           -> VagueGo
    * noun=ADirection                           -> Go
    * 'to' noun=ADirection                      -> Go
    * 'to' noun                                 -> Enter
    * Behind noun				-> GetBehind
    * Under noun				-> GetBeneath
    * Into noun					-> GetInside
    * Onto noun					-> GetOn;
Verb 'hug' 'embrace'
    * noun					-> Hug;
Verb 'inventory' 'inv' 'i//'
    *                                           -> Inv
    * 'tall'                                    -> InvTall
    * 'wide'                                    -> InvWide;
Verb 'jump' 'hop' 'skip' 'leap'
    *                                           -> Jump
    * 'up'					-> Jump
    * 'over'/'past' noun                        -> JumpOver
    * 'up' 'over'/'past' noun                   -> JumpOver;
Verb 'kick'
    * noun					-> Kick
    * 'over' noun				-> PushOver
    * noun 'over'				-> PushOver;
Verb 'kill' 'murder' 'slay'
    * noun					-> Kill
    * noun 'with'/'using' noun			-> Kill;
Verb 'kiss'
    * noun					-> Kiss;
Verb 'knock' 'bang' 'pound'
    *						-> Knock
    * noun					-> Knock
    * 'on' noun					-> Knock
    * noun 'over'				-> PushOver
    * 'over' noun				-> PushOver;
Verb 'leave'
    *                                           -> VagueGo
    * noun=ADirection                           -> Go
    * 'to' noun=ADirection			-> Go
    * multiheld					-> Drop
    * multiheld Onto noun			-> PutOn
    * multiheld Into noun			-> PutOn
    * multiheld Behind noun			-> PutOn
    * multiheld 'below'/'beneath'/'under'/'underneath' noun
						-> PutUnder
    * noun                                      -> Exit
    * multiheld 'behind'/'here'			-> Drop
    * 'behind' multiheld			-> Drop;
Verb 'lie' 'recline'
    *						-> Lie
    * 'down'					-> Lie
    * Behind noun				-> GetBehind
    * Into noun					-> GetInside
    * Onto noun					-> GetOn
    * Under noun				-> GetBeneath
    * 'down' Into noun				-> GetInside
    * 'down' Onto noun				-> GetOn
    * 'down' Behind noun			-> GetBehind;
Verb 'listen' 'hear'
    *                                           -> Listen
    * noun                                      -> Listen
    * 'to' noun                                 -> Listen;
Verb 'lock'
    * noun					-> Lock
    * noun 'with'/'using' noun			-> Lock;
Verb 'look' 'l//'
    *                                           -> Look
    * noun					-> Examine
    * 'around'/'about'				-> Look
    * 'at' noun                                 -> Examine
    * Into noun					-> LookInside
    * Onto noun					-> LookOnTop
    * Behind noun				-> LookBehind
    * Under noun				-> LookUnder
    * 'up' topic 'in' noun                      -> Consult
    * topic 'up' 'in' noun			-> Consult
    * 'up' topic				-> VagueConsult
    * topic 'up'				-> VagueConsult
    * noun=ADirection                           -> Examine
    * 'to' noun=ADirection                      -> Examine;
Verb 'no'
    *                                           -> No;
Verb 'open' 'uncover' 'undo' 'unwrap'
    * noun                                      -> Open
    * noun 'with'/'using' held			-> Unlock;
Verb 'peel'
    * noun 'off'                                -> Disrobe
    * 'off' noun                                -> Disrobe;
Verb 'pray'
    *						-> Pray
    * topic                                     -> Pray;
Verb 'pry' 'prise' 'prize' 'lever' 'jemmy' 'jimmy' 'force'
    * noun 'with'/'using' held                  -> Unlock
    * 'apart'/'open' noun 'with' held           -> Unlock
    * noun 'apart'/'open' 'with' held           -> Unlock;
Verb 'pull' 'drag'
    * noun                                      -> Pull;
Verb 'punch'
    * noun					-> Punch
    * 'out' noun				-> Punch
    * noun 'out'				-> Punch;
Extend only 'shove' first
    * noun					-> Push
    * noun 'over'				-> PushOver
    * 'over' noun				-> PushOver;
Verb 'read'
    * noun                                      -> Read
    * 'about' topic 'in' noun                   -> Consult
    * topic 'in' noun                           -> Consult
    * 'in' noun 'about' topic			-> Consult
    * 'about' topic				-> VagueConsult;
Verb 'rip' 'tear'
    * noun					-> Rip;
Verb 'rub' 'clean' 'dust' 'polish' 'scrub'
     'shine' 'sweep' 'wipe'
    * noun                                      -> Rub
    * noun 'clean'				-> Rub
    * noun 'with'/'using' noun                  -> Rub
    * noun 'clean' 'with'/'using' noun		-> Rub;
Verb 'search'
    * noun                                      -> Search
    * Into noun					-> LookInside
    * Behind noun				-> LookBehind
    * Under noun				-> LookUnder
    * 'on' 'top' 'of' noun			-> LookOnTop
    * 'on' noun					-> LookOnTop;
Verb 'set'
    * noun                                      -> Set
    * noun 'to' anynumber                       -> SetTo
    * multiheld 'down'				-> Drop
    * 'down' multiheld				-> Drop
    * multiexcept Onto noun			-> PutOn
    * multiexcept Into noun			-> Insert
    * multiexcept Behind noun			-> PutBehind
    * multiexcept 'down' Onto noun		-> PutOn
    * multiexcept 'down' Into noun		-> Insert
    * multiexcept 'down' Behind noun		-> PutBehind
    * multiexcept Under noun			-> PutUnder
    * 'down' multiexcept Onto noun		-> PutOn
    * 'down' multiexcept Into noun		-> Insert
    * 'down' multiexcept Behind noun		-> PutBehind;
Verb 'shed' 'disrobe' 'doff'
    * noun                                      -> Disrobe;
Verb meta 'shit' 'balls' 'bollocks' 'bullshit' 'damn'
	    'fuck' 'horseshit' 'motherfucker' 'sod'
    *                                           -> Strong
    * topic                                     -> Strong;
Verb 'sing' 'hum' 'whistle'
    *                                           -> Sing
    * topic					-> Sing;
Verb 'sit'
    *						-> Sit
    * 'down'/'up'/'straight'			-> Sit
    * Behind noun				-> GetBehind
    * Under noun				-> GetBeneath
    * Into noun					-> GetInside
    * 'down'/'up' Into noun			-> GetInside
    * Onto noun					-> GetOn
    * 'down'/'up' Onto noun			-> GetOn;
Verb 'sleep' 'nap' 'slumber'
    *						-> Sleep;
Verb 'slide'
    * 'out' 'of' held				-> Disrobe
    * noun Into noun				-> Insert;
Verb 'slip'
    * 'out' 'of' held				-> Disrobe
    *'out'/'off' 'of'/'from' noun		-> Exit
    * held 'to' creature			-> Give
    * creature held				-> Give reverse
    * noun Into noun				-> Insert
    * noun Behind noun				-> PutBehind
    * noun Under noun				-> PutUnder
    * noun Onto noun				-> PutOn		
    * noun 'on'					-> Wear
    * 'on'/'into' held				-> Wear;
Verb 'smell' 'sniff'
    *                                           -> Smell
    * noun                                      -> Smell;
Verb 'sorry'
    *                                           -> Sorry;
Verb 'squeeze'
    * noun                                      -> Squeeze;
Verb 'stand'
    *                                           -> Stand
    * 'up'                                      -> Stand
    * Behind noun				-> GetBehind
    * Under noun				-> GetBeneath
    * Onto noun					-> GetOn
    * Into noun					-> GetInside;
Verb 'swim' 'dive'
    *                                           -> Swim;
Verb 'swing'
    * held					-> Swing
    * held 'at'/'onto' noun			-> Swing;
Verb 'switch'
    * noun                                      -> Switch
    * noun 'on'                                 -> Switchon
    * noun 'off'                                -> Switchoff
    * 'on' noun                                 -> Switchon
    * 'off' noun                                -> Switchoff;
Verb 'taste'
    * noun                                      -> Taste;
Verb 'think'
    *						-> Think
    * topic                                     -> Think;
Verb 'tie' 'attach' 'fasten' 'fix' 'connect' 'link'
    * noun                                      -> Tie
    * noun 'to'/'onto' noun			-> Tie;
Verb 'torture' 'rape'
    * noun					-> Torture
    * noun 'with'/'using' held
						-> Torture
    * noun 'by' topic				-> Torture;
Verb 'touch' 'feel' 'fondle' 'grope' 'stroke' 'caress'
    * noun                                      -> Touch;
Verb 'turn' 'rotate' 'screw' 'twist' 'unscrew'
    * noun                                      -> Turn
    * noun 'on'                                 -> Switchon
    * noun 'off'                                -> Switchoff
    * 'on' noun                                 -> Switchon
    * 'off' noun                                -> Switchoff;
Verb 'use' 'utilise' 'utilize'
    * noun					-> Use;
Verb 'wave'
    *                                           -> WaveHands
    * noun                                      -> Wave;
Verb 'wear' 'don'
    * noun                                      -> Wear;
Verb 'yes' 'y//'
    *                                           -> Yes;
Verb 'unlock'
    * noun					-> Unlock
    * noun 'with' held                          -> Unlock;
Verb 'untie' 'disconnect' 'detach'
    * noun					-> Untie
    * noun 'from' noun				-> Untie;
Verb 'wait' 'z//'
    *                                           -> Wait;
Verb 'wake' 'awake' 'awaken'
    *                                           -> Wake
    * 'up'                                      -> Wake
    * creature                                  -> WakeOther
    * creature 'up'                             -> WakeOther
    * 'up' creature                             -> WakeOther;

! ------------------------------------------------------------------------------
!  Final task: provide trivial routines if the user hasn't already:
! ------------------------------------------------------------------------------

#Stub AfterLife         0;
#Stub AfterPrompt       0;
#Stub Amusing           0;
#Stub BeforeParsing     0;
#Stub ChooseObjects     0;
#Stub DarkToDark        0;
#Stub DeathMessage      0;
#Stub Epilogue		0;
#Stub GamePostRoutine   0;
#Stub GamePreRoutine    0;
#Stub InDarkness	0;
#Stub InScope           1;
#Stub LookAttachedSub	0;
#Stub LookRoutine       0;
#Stub NewRoom           0;
#Stub ParseNumber       2;
#Stub ParserError       1;
#Stub PrintTaskName     1;
#Stub PrintVerb         1;
#Stub TimePasses        0;
#Stub UnknownVerb       1;

#Ifdef TARGET_GLULX;
#Stub HandleGlkEvent    2;
#Stub IdentifyGlkObject 4;
#Stub InitGlkWindow     1;
#Endif; ! TARGET_GLULX

#Ifndef PrintRank;
! Constant Make__PR;
! #Endif;
! #Ifdef Make__PR;
[ PrintRank; "."; ];
#Endif;

#Ifndef ParseNoun;
[ParseNoun; return -1; ];
#Endif;

#Default Story 0;
#Default Headline 0;

#Ifdef INFIX;
#Include "infix";
#Endif;

#Ifdef WITHOUT_DIRECTIONS;
Default d_obj NULL;
Default u_obj NULL;
Default e_obj NULL;
Default w_obj NULL;
Default n_obj NULL;
Default s_obj NULL;
Default sw_obj NULL;
Default se_obj NULL;
Default nw_obj NULL;
Default ne_obj NULL;
#Endif;

! ==============================================================================

Constant LIBRARY_GRAMMAR;       ! for dependency checking

! ==============================================================================