!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2003.07.19 ORBetterChoice
! Give the parser better decision making skills when considering objects.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! Give the parser better decision making skills when considering objects.
! For example, objects already carried are given less priority during a "Take" action
! and objects that are edible are given more priority for the "Eat command"
!--------------------------------------------------------------------------------------
! AutoDep:	
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#ifdef USE_ORBetterChoice; #include "ORBetterChoice"; #endif;
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORBetterChoice; 
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2003.01.02	Initial Creation
! 2003.01.25	Added code to prefer edible objects when eating.
! 2003.03.01	Made objects that are already being held even lower for "take" and 
!				"remove". Seems zero wasn't enough.
! 2003.07.19	Added code to prefer taking objects that actually have a place in the 
!				game world, rather than ones that are brought into scope by the presence
!				of another objects.
!--------------------------------------------------------------------------------------
#ifdef USE_ORBetterChoice;message "          Processing library extension ORBetterChoice...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 
	#ifndef USE_ORRoutinesList; Constant USE_ORRoutinesList; message "          ****Forcing inclusion of ORRoutinesList****"; #include "ORRoutinesList"; #endif; 
	#ifndef USE_OREntryPoints; Constant USE_OREntryPoints; message "          ****Forcing inclusion of OREntryPoints****"; #include "OREntryPoints"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORBetterChoice_DONEREPLACE; constant ORBetterChoice_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORBetterChoice_DONEMESSAGE; constant ORBetterChoice_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORBetterChoice requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORBetterChoice_DONECODE;constant ORBetterChoice_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	object with object_initialise[;ORChooseObjects.add_routine(__betterchoice);];
	[__betterchoice obj code;
		if(code<2) return 0; !--return default for "all" check
		!--parser is looking for a hint...
		switch(action_to_be){
			##take, ##remove:  if(obj in actor) return -1; !--if we are trying to take something, then lets not consider things that we already are holding
							if(ObjectScopedBySomething(obj)~=0) return -1; !--lets also try not to grab objects that are brought into scope by something else (add_to_scope). 
			##eat: if(object has edible) return 2; !--lets prefer edible things to non-edible things...
		}
		return 1;!--return default for "assistance" check
	];
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORBetterChoice_DONEGRAMMAR; constant ORBetterChoice_DONEGRAMMAR; #ifdef ORBetterChoice_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;