!----------------------------------------------------------------------------
! BetaHTML.h   Version 1.5                                  A Betatesting Aid
! Stas Starkov      stas_@mail.rb.ru                       	   08.10.2001
! based on betatest.h by Marnie Parker  aka Doe    doeadeer3@aol.com
!----------------------------------------------------------------------------
! This library can output HTML file of your playing game, so it can be handy
! in beta-testing. After beta comments in HTML file will be red line like this:
! "**************** Beta-test comment above! ***************"
! This means beta-testers don't need to go through the script file later to
! make comments. They can make comments as they play/beta-test. (They could
! anyway, but it is annoying when the game says, "I didn't understand that
! sentence.", or tries to do an inventory or something.) From the author's 
! side, it also make reading through the script file easier.
!
! Include this library between the inclusion of the "Parser" and "VerbLib"
! library files. Like this:  Include "betaHTML.h";
! Unfortunately you must place string 'Replace AfterGameOver;' before including
! "parser.h".
!
! You can add routines BetaAfterPrompt() and BetaAfterComment() to your game
! code to print out useful information, for example score, location, number of
! moves.
!
! Type 'beta' (and press ENTER) during the play session and you'll get a *.scr
! (or similar) file. If you want to add beta comment type '! ' and after that
! type comment. After quiting from the game rename output *.scr file to *.htm
! or *.html.
!
! To start a game with beta testing automatically on, just put
! <<BestTestOn>>; at the end of the Initialise routine.
!
! Note:  The library is not compatible with Glulx. If I'll get _any_ comments
! I'll think about that.
!----------------------------------------------------------------------------

Replace ScriptOnSub;
Replace ScriptOffSub;
Replace QuitSub;
Replace RestartSub;

Global betamode = false;
Global Beta_HTML = false;

[ ScriptOnSub;
    if (~~(betamode)) {
        print "This will also automatically turn beta testing mode on. Continue? (Y or N) >";
        if (YesOrNo()==0)
            "^Beta testing mode remains off.";
        betamode = true;
        print "Do you want to have HTML output to script file? (Y or N) >";
        if (YesOrNo()==0)
            print "^Output to script file remains plain text.^^";
        else
            Beta_HTML = true;
    }
    transcript_mode = ((0-->8) & 1);
    if (transcript_mode)
        return L__M(##ScriptOn,1);
    @output_stream 2;
    if (((0-->8) & 1) == 0)
        return L__M(##ScriptOn,3);
    @output_stream -1;
    print "<HTML><HEAD><TITLE>", (string) Story ,"</TITLE></HEAD>
        ^<BODY bgcolor=~white~ text=~blue~>";
    if ( Beta_HTML )
        print "<PRE>^";
    else
        print "<XMP>^";
    @output_stream 1;
    L__M(##ScriptOn,2);
    VersionSub();
    transcript_mode = true;
    "^Beta testing mode is now on. Comments may be entered by preceding
        the line with a !. They will not be parsed by the game.";
];
    
[ ScriptOffSub;
    if (betamode) {
        print "This will also automatically turn beta testing mode off. Continue? (Y or N) >";
        if (YesOrNo()==0)
            "^Beta testing mode remains on.";
        betamode = false;
    }
    transcript_mode = ((0-->8) & 1);
    if (transcript_mode == false)
        return L__M(##ScriptOff,1);
    L__M(##ScriptOff,2);
    @output_stream -1;
    if ( Beta_HTML )
        print "</PRE></BODY></HTML>^";
    else
        print "^</XMP></BODY></HTML>^";
    @output_stream 1;
    Beta_HTML = false;
    @output_stream -2;
    if ((0-->8) & 1)
        return L__M(##ScriptOff,3);
    transcript_mode = false;
    "^Beta testing mode is now off.";
];

[ AfterGameOver i;
    .RRQPL;
    L__M(##Miscellany,5);
    .RRQL;
    print "> ";
    #IFV3;
        read buffer parse;
    #ENDIF;
    temp_global=0;
    #IFV5;
        read buffer parse DrawStatusLine;
    #ENDIF;
    i=parse-->1;
    if (i==QUIT1__WD or QUIT2__WD)
        <<quit>>;
    if (i==RESTART__WD)
        <<restart>>;
    if (i==RESTORE__WD) {
        RestoreSub();
        jump RRQPL;
    }
    if (i==FULLSCORE1__WD or FULLSCORE2__WD && TASKS_PROVIDED==0) {
        new_line;
        FullScoreSub();
        jump RRQPL;
    }
    if (deadflag==2 && i==AMUSING__WD && AMUSING_PROVIDED==0) {
        new_line;
        Amusing();
        jump RRQPL;
    }
    #IFV5;
    if (i==UNDO1__WD or UNDO2__WD or UNDO3__WD) {
        if (undo_flag==0) {
            L__M(##Miscellany,6);
            jump RRQPL;
        }
        if (undo_flag==1)
            jump UndoFailed2;
        @restore_undo i;
        if (i==0) {
            .UndoFailed2;
            L__M(##Miscellany,7);
        }
        jump RRQPL;
    }
    #ENDIF;
    L__M(##Miscellany,8);
    jump RRQL;
];

[ QuitSub;
    L__M(##Quit,2);
    if (YesOrNo()~=0) {
        if (betamode) {
            betamode=false;
            <ScriptOff>;
        }
        quit;
    }
];

[ RestartSub;
    L__M(##Restart,1);
    if (YesOrNo()~=0) {
        if (betamode) {
            print "This will also automatically turn beta testing mode off. Continue? (Y or N) >";
            if (YesOrNo()==0)
                "^Beta testing mode remains on. No restarting also.";
            betamode = false;
            Beta_HTML = false;
            <ScriptOff>;
        }
        @restart;
        L__M(##Restart,2);
    }
];

[ BetaTestOnSub;
    if (betamode)
        "Beta testing mode is already on.";
    betamode = true;
    Beta_HTML = false;
    print "Turning scripting on...^";
    print "Do you want to have HTML output to script file? (Y or N) > ";
    if (YesOrNo()==0)
        print "^Output to script file remains plain text.^";
    else
        Beta_HTML = true;
    <<ScriptOn>>;
];

[ BetaTestOffSub;
    if (~~(betamode))
        "Beta testing mode is already off.";
    betamode = false;
    <<ScriptOff>>;
];

[ BetaCommentSub;
    if (betamode) {
        @output_stream -1;
        if ( Beta_HTML ) {
            print "<FONT color=~red~><STRONG>
                ^**************** Beta-test comment above! ***************^";
            #IFDEF BetaAfterComment;
                BetaAfterComment();
            #ENDIF;
            print "</STRONG></FONT>^";
        }
        else {
            print "**************** Beta-test comment above! ***************^";
            #IFDEF BetaAfterComment;
                BetaAfterComment();
            #ENDIF;
        }
        @output_stream 1;
        rtrue;
    }
    "Comments can only be used in beta testing mode.";
];

[ BeforeParsing;
    @output_stream -1;
    #IFDEF BetaAfterPrompt;
        BetaAfterPrompt();
    #ENDIF;
    if ( Beta_HTML )
        print "</STRONG></FONT>^";
    @output_stream 1;
    DrawStatusLine();
];

Object LibraryMessages
    with
    before [;
        Prompt: if ( Beta_HTML ) {
                    @output_stream -1;
                    print "<FONT color=~green~><STRONG>^";
                    @output_stream 1;
                }
                print "^>";
                rtrue;
        Miscellany:
            if ( Beta_HTML ) {
                if (lm_n==6 or 7 || (lm_n>9 && lm_n<17) ) {
                    @output_stream -1;
                    print "</STRONG></FONT>^";
                    @output_stream 1;
                }
            }
        Restore:                                    ! Ugly hack, sorry
            if (lm_n==2) {
                if ((0-->8) & 1) {
                    betamode = true;
                    Beta_HTML = false;
                    print "Do you want to have HTML output to script file? (Y or N) > ";
                    if (YesOrNo()==0)
                        print "^Output to script file remains plain text.^";
                    else
                        Beta_HTML = true;
                    @output_stream -1;
                    print "</XMP></BODY></HTML>^";
                    print "<HTML><HEAD><TITLE>", (string) Story ,"</TITLE></HEAD>
                        ^<BODY bgcolor=~white~ text=~blue~>";
                    if ( Beta_HTML )
                        print "<PRE>^";
                    else
                        print "<XMP>^";
                    @output_stream 1;
                    transcript_mode = true;
                }
                else {
                    if (betamode) {
                        betamode = false;
                        Beta_HTML = false;
                    }
                }
            "Ok.";
            }
    ];

Verb meta 'beta'
            *                                       ->BetaTestOn
            * 'test'                                ->BetaTestOn
            * 'test' 'off'                          ->BetaTestOff
            * 'off'                                 ->BetaTestOff
            * 'test' 'on'                           ->BetaTestOn
            * 'on'                                  ->BetaTestOn;

Verb meta '!'
            * topic                                 ->BetaComment;
