! Novel-mode -- Replace statements

Message "[Including Novel Mode components]";

Global pre_action;
Global upperprompt = 1;
Global lastref = 0;
Global pre_noun=0;
Global needapress = 0;
Global keypressed;
Global boldflag = -1;
Global scrx; 
Global scry;

Constant NO_PLACES;

Replace LanguageLM;
Replace BeforeParsing;

!-------replace action routines
Replace QuitSub; 
Replace SaveSub; 
Replace RestoreSub; 
Replace RestartSub;
Replace YesOrNo; 
Replace VersionSub;
Replace Banner;
Replace InvSub;
Replace LookSub;
Replace ScriptOnSub;
Replace LMode1Sub; 
Replace LMode2Sub; 
Replace LMode3Sub;

!------ parser routines to replace
Replace DrawStatusLine; 
Replace Keyboard;
Replace Parser__parse;
Replace NounDomain;
Replace AfterGameOver;
Replace PrintOrRun;
replace PronounsSub;

Array centre_text --> 64;

Property status; 	! -- for comments on the location name; eg "Forest -- running" or "Forest -- lying flat", the second
			! part is in the Forest.status routine

Global MainGameWin;

IFNDEF VERSION5;
ifdef SUMMARY_ON;
Constant SummaryWin  = ZWin4;
endif;
Constant InputWin    = ZWin2;
Constant NOZPIC; Constant NOZSND;
Include "V6Defs";

!---------------------------
! The v6 screen layout objects
!--------------------------

Object MyZWinStyle
 class ZWinStyle
 with	Init [k;
k = 0;

#ifdef SUMMARY_ON;
if (SUMMARY_ON > 0)
{SummaryWin.SetColours(C_BLUE, C_WHITE);
 SummaryWin.SetFont(FN_COURIER); 
 SummaryWin.SetFontStyle(ST_FIXED);
 SummaryWin.WinStyleSet();
 k = SUMMARY_ON * SummaryWin.GetCharHeight();
 SummaryWin.SetSize(k , scrx);
 SummaryWin.SetLoc(1,1);
}
#endif;

MainGameWin.SetColours(C_WHITE, C_BLUE); 
InputWin.SetColours(C_BLUE, C_WHITE);

InputWin.SetFont(FN_COURIER); 
InputWin.SetFontStyle(ST_FIXED);
InputWin.WinStyleSet();

MainGameWin.SetFont(FN_NORMAL); 

InputWin.SetSize(2 * InputWin.GetCharHeight(), scrx);
MainGameWin.SetSize(scry - (k + InputWin.GetYSize()) - 1, scrx);

InputWin.SetLoc(MainGameWin.GetYSize() + 1 + k, 1);
MainGameWin.SetLoc(k + 1, 1);
	];

Object PreZWinStyle
 class ZWinStyle
 with	Init [;
MainGameWin.SetColours(C_WHITE, C_BLUE); 
MainGameWin.SetFont(FN_NORMAL); 
MainGameWin.WinStyleSet(WS_WRAP | WS_SCROLL | WS_TRANSCRIPT | WS_BUFFER);
MainGameWin.SetSize(scry, scrx); MainGameWin.SetLoc(1,1);
	];


IFNOT;
Global ActiveZWindow;

!--------------------------
! The v5 screen layout objects
!--------------------------

 Object MyZWinStyle 
 with Activate [y;
 y = 2;
 #ifdef SUMMARY_ON; y = y + SUMMARY_ON; #endif;
 @split_window y;
	];

 Object PreZWinStyle
 with Activate [;
	@split_window 0;
		];

Class Window
with	GetCharWidth 1, GetCharHeight 1, 
	GetXCursor [arr;
@get_cursor arr;
return arr-->1;
	],
	SetFontStyle[style wn;
	    wn = ActiveZWindow;
!	    @set_window wn;
	    self.Activate();
	    @set_text_style style;
	    wn.Activate();
	],
	GetYCursor [arr;
@get_cursor arr;
return arr-->0;
	];

#ifdef SUMMARY_ON;
Window SummaryWin
with 	Activate [;
		@set_window 1;
	      ActiveZWindow = self;
		style reverse;
		@set_cursor 1 1;
	],
	SetCursor [y x;
if (x==0) x = self.GetXCursor();
if (y==0) y = self.GetYCursor();
@set_cursor y x;
	],
	Erase [i;
	  for (i = 1 : i <= SUMMARY_ON : i++)
	   { 	 @set_cursor i 1; spaces(0->33); 
	   }
	  @set_cursor 1 1;
	];
#endif;

Window InputWin
with 	Activate [u;
	    ActiveZWindow = self;
		style reverse;
		@set_window 1;
		u = 1;
		#ifdef SUMMARY_ON; u = u + SUMMARY_ON; #endif;
		@set_cursor u 1;
	],
	SetCursor [y x;
if (x==0) x = self.GetXCursor();
if (y==0) y = self.GetYCursor();
#ifdef SUMMARY_ON;
 y = y + SUMMARY_ON;
#endif;
@set_cursor y x;
	],
	Erase [;
		if (upperprompt == 0) style roman;
		StatFont(1); StatFont(2);
	];

Window MainWin
with Activate [;
		@set_window 0;
	      ActiveZWindow = self;
		

	],
	SetCursor [; rtrue; ],
	Erase [;
		@erase_window 0;
	];

Constant ST_ROMAN   0;
Constant ST_REVERSE 1;
Constant ST_BOLD    2;
Constant ST_ITALIC  4;
Constant ST_FIXED   8;

ENDIF;
