/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.iff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.zmpp.base.MemoryAccess;
import org.zmpp.base.MemorySection;
import org.zmpp.iff.Chunk;
import org.zmpp.iff.DefaultChunk;
import org.zmpp.iff.FormChunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFormChunk
extends DefaultChunk
implements FormChunk {
    private byte[] subId;
    private List<Chunk> subChunks;

    public DefaultFormChunk(MemoryAccess memoryAccess) throws IOException {
        super(memoryAccess, 0);
        this.initBaseInfo();
        this.readSubChunks();
    }

    private void initBaseInfo() throws IOException {
        if (!"FORM".equals(new String(this.getId()))) {
            throw new IOException("not a valid IFF format");
        }
        this.subId = new byte[4];
        for (int i = 0; i < 4; ++i) {
            this.subId[i] = this.memaccess.readByte(i + 8);
        }
    }

    private void readSubChunks() {
        this.subChunks = new ArrayList<Chunk>();
        int n = this.getSize();
        int n2 = 0;
        for (int i = 12; i < n; i += n2) {
            MemorySection memorySection = new MemorySection(this.memaccess, i, n - i);
            DefaultChunk defaultChunk = new DefaultChunk(memorySection, i);
            this.subChunks.add(defaultChunk);
            n2 = defaultChunk.getSize() + 8;
            n2 = n2 % 2 == 0 ? n2 : n2 + 1;
        }
    }

    @Override
    public boolean isValid() {
        return new String(this.getId()).equals("FORM");
    }

    @Override
    public byte[] getSubId() {
        return this.subId;
    }

    @Override
    public Iterator<Chunk> getSubChunks() {
        return this.subChunks.iterator();
    }

    @Override
    public Chunk getSubChunk(byte[] byArray) {
        for (Chunk chunk : this.subChunks) {
            if (!Arrays.equals(byArray, chunk.getId())) continue;
            return chunk;
        }
        return null;
    }

    @Override
    public Chunk getSubChunk(int n) {
        for (Chunk chunk : this.subChunks) {
            if (chunk.getAddress() != n) continue;
            return chunk;
        }
        return null;
    }
}

