! This include file holds custom verbs and their relevant routines.
! Note - subroutines first, list second!

! The relevant routines.

! DisabledSub
! Handles commands disabled.
[ DisabledSub;
 Quip (-1, 0, Forrester, "This command has been disabled for this game. I wouldn't want you to miss any of DETECTIVE now, would I? Ha Ha Ha Ha Ha [click] ha ha [click] ha ha [click] ha ha...!", 2);
];

! FoolSub
! Handles nonsense words (aka xyzzy and co).
[ FoolSub;
 L__M (##Fool, 1);
];

! ReadSub
! Handles reading things.
[ ReadSub;
 <<Examine noun>>;
];

! ShootAtSub
! Shoots something with something else.
[ ShootAtSub;
 if (runlife (noun, ##ShootAt)~=0) rfalse;
 L__M (##ShootAt, 1);
];

! The list of custom verbs.

! ShootAtRSub
! Wrapper for ShootAt.
[ ShootAtRSub;
 <<ShootAt second noun>>;	! Reverses noun and second for 'shoot x with y'.
];

! Genuine custom verbs.
Verb "shoot"	! As Inform doesn't have it.
 * noun "at" noun -> ShootAtR
 * noun "with" noun -> ShootAt
;

! Extensions and replacements to existing syntax.
Extend "read" first
 * Legible -> Read
;

! Meta verbs.
Extend "brief" replace
 * -> Disabled
;
Extend "normal" replace
 * -> Disabled
;
Extend "read" first
 * Legible -> Read
;
Extend "superbrief" replace
 * -> Disabled
;
Extend "verbose" replace
 * -> Disabled
;
Verb meta "xyzzy" "plugh" "plover" "samoht" "noside" "melenkurion" "zorton"
 * -> Fool
;