! Inform / INFSP 6


!!==============================================================================
!!
!!	ST_TEXTO
!!	Rutinas biplataforma para imprimir texto en diferentes formatos
!!
!!==============================================================================
!!
!!
!!	File:			st_texto.h
!!	Author(s):		J. Francisco Martn (jfm.lisaso@gmail.com)
!!	Language:		ES (Castellano)
!!	System:			Inform/INFSP 6
!!	Platform:		Mquina-Z / Glulx
!!	Version:		2.0
!!	Released:		2010/04/01
!!
!!
!!------------------------------------------------------------------------------
!!
!!
!!	Este programa es software libre: usted puede redistribuirlo y/o 
!!	modificarlo bajo los trminos de la Licencia Pblica General GNU 
!!	publicada por la Fundacin para el Software Libre, ya sea la versin 
!!	3 de la Licencia, o (a su eleccin) cualquier versin posterior.
!!
!!	Este programa se distribuye con la esperanza de que sea til, pero 
!!	SIN GARANTA ALGUNA; ni siquiera la garanta implcita MERCANTIL o 
!!	de APTITUD PARA UN PROPSITO DETERMINADO. Consulte los detalles de 
!!	la Licencia Pblica General GNU para ms informacin.
!!
!!	Debera haber recibido una copia de la Licencia Pblica General GNU 
!!	junto a este programa. En caso contrario, consulte
!!	<http://www.gnu.org/licenses/>.
!!
!!	Copyright (c) 2010, J. Francisco Martn
!!
!!
!!==============================================================================
System_file;


Constant _STR_	= 0;
Constant _STI_	= 1;
Constant _STB_	= 3;
Constant _STM_	= 2;

Default	STPARSER_STYLE _STR_;
Default	STPARSER_MSG1 "";
Default	STPARSER_MSG2 "";


!!==============================================================================
!!
!! SELECCIONAR FORMATO DE TEXTO
!!
!!==============================================================================


#Ifdef	TARGET_ZCODE;
[ st_normal;	font on; style roman; ];	!! Set style - normal
[ st_cursiva;	style underline; ];			!! Set style - cursiva
[ st_negrita;	style bold; ];				!! Set style - negrita
[ st_espaciada;	font off; ];				!! Set style - espaciada
#Ifnot;
[ st_normal;	glk($0086, 0); ];			!! Set style - normal
[ st_cursiva;	glk($0086, 1); ];			!! Set style - cursiva
[ st_negrita;	glk($0086, 3); ];			!! Set style - negrita
[ st_espaciada;	glk($0086, 2); ];			!! Set style - espaciada
#Endif;


[ st_parser;								!! Para mensajes del 'parser'
	switch ( STPARSER_STYLE ) {
		_STR_:	st_normal();
		_STI_:	st_cursiva();
		_STB_:	st_negrita();
		_STM_:	st_espaciada();
	}
];


!!==============================================================================
!!
!! IMPRIMIR TEXTO EN DIFERENTES FORMATOS
!!
!!==============================================================================


#Ifdef	TARGET_ZCODE;
[ stcursiva text;
    if (text==0) return false;
    style underline;
    print (string) text;
    style roman;
    return true;
];
[ stnegrita text;
    if (text==0) return false;
    style bold;
    print (string) text;
    style roman;
    return true;
];
[ stespaciada text;
    if (text==0) return false;
    font off;
    print (string) text;
    font on;
    return true;
];
[ stparser text;
	if (text==0) return false;
	st_parser();
	if (STPARSER_MSG1~=0) print (string) STPARSER_MSG1;
	print (string) text;
	if (STPARSER_MSG2~=0) print (string) STPARSER_MSG2;
	st_normal();
	return true;
];
#Ifnot;	!! TARGET_GLULX
[ stcursiva text;
    if (text==0) return false;
    glk($0086, 1);
    print (string) text;
    glk($0086, 0);
    return true;
];
[ stnegrita text;
    if (text==0) return false;
    glk($0086, 3);
    print (string) text;
    glk($0086, 0);
    return true;
];
[ stespaciada text;
    if (text==0) return false;
    glk($0086, 2);
    print (string) text;
    glk($0086, 0);
    return true;
];
[ stparser text;
	if (text==0) return false;
	st_parser();
	if (STPARSER_MSG1~=0) print (string) STPARSER_MSG1;
	print (string) text;
	if (STPARSER_MSG2~=0) print (string) STPARSER_MSG2;
	st_normal();
	return true;
];
#Endif;


