/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.blorb;

import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import org.zmpp.blorb.BlorbMediaCollection;
import org.zmpp.blorb.MemoryAccessInputStream;
import org.zmpp.iff.Chunk;
import org.zmpp.iff.FormChunk;
import org.zmpp.media.DefaultSoundEffect;
import org.zmpp.media.SoundEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlorbSounds
extends BlorbMediaCollection<SoundEffect> {
    private Map<Integer, SoundEffect> sounds;

    public BlorbSounds(FormChunk formChunk) {
        super(formChunk);
    }

    @Override
    public void clear() {
        super.clear();
        this.sounds.clear();
    }

    @Override
    protected void initDatabase() {
        this.sounds = new HashMap<Integer, SoundEffect>();
    }

    @Override
    protected boolean isHandledResource(byte[] byArray) {
        return byArray[0] == 83 && byArray[1] == 110 && byArray[2] == 100 && byArray[3] == 32;
    }

    @Override
    public SoundEffect getResource(int n) {
        return this.sounds.get(n);
    }

    @Override
    protected boolean putToDatabase(Chunk chunk, int n) {
        MemoryAccessInputStream memoryAccessInputStream = new MemoryAccessInputStream(chunk.getMemoryAccess(), 0, chunk.getSize() + 8);
        try {
            AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(memoryAccessInputStream);
            AudioInputStream audioInputStream = new AudioInputStream(memoryAccessInputStream, audioFileFormat.getFormat(), chunk.getSize());
            Clip clip = AudioSystem.getClip();
            clip.open(audioInputStream);
            this.sounds.put(n, new DefaultSoundEffect(clip));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }
}

