/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.instructions;

import org.zmpp.base.MemoryAccess;
import org.zmpp.instructions.AbstractInstruction;
import org.zmpp.instructions.InstructionStaticInfo;
import org.zmpp.instructions.LongStaticInfo;
import org.zmpp.vm.Machine;
import org.zmpp.vm.ObjectTree;
import org.zmpp.vm.ZObject;

public class LongInstruction
extends AbstractInstruction {
    private AbstractInstruction.OperandCount operandCount;

    public LongInstruction(Machine machine, int n) {
        super(machine, n);
        this.operandCount = AbstractInstruction.OperandCount.C2OP;
    }

    public LongInstruction(Machine machine, AbstractInstruction.OperandCount operandCount, int n) {
        super(machine, n);
        this.operandCount = operandCount;
    }

    public AbstractInstruction.InstructionResult doInstruction() {
        switch (this.getOpcode()) {
            case 1: {
                this.je();
                break;
            }
            case 2: {
                this.jl();
                break;
            }
            case 3: {
                this.jg();
                break;
            }
            case 6: {
                this.jin();
                break;
            }
            case 4: {
                this.dec_chk();
                break;
            }
            case 5: {
                this.inc_chk();
                break;
            }
            case 7: {
                this.test();
                break;
            }
            case 8: {
                this.or();
                break;
            }
            case 9: {
                this.and();
                break;
            }
            case 10: {
                this.test_attr();
                break;
            }
            case 11: {
                this.set_attr();
                break;
            }
            case 12: {
                this.clear_attr();
                break;
            }
            case 13: {
                this.store();
                break;
            }
            case 14: {
                this.insert_obj();
                break;
            }
            case 15: {
                this.loadw();
                break;
            }
            case 16: {
                this.loadb();
                break;
            }
            case 17: {
                this.get_prop();
                break;
            }
            case 18: {
                this.get_prop_addr();
                break;
            }
            case 19: {
                this.get_next_prop();
                break;
            }
            case 20: {
                this.add();
                break;
            }
            case 21: {
                this.sub();
                break;
            }
            case 22: {
                this.mul();
                break;
            }
            case 23: {
                this.div();
                break;
            }
            case 24: {
                this.mod();
                break;
            }
            case 25: {
                this.call(1);
                break;
            }
            case 26: {
                this.call(1);
                break;
            }
            case 27: {
                this.set_colour();
                break;
            }
            case 28: {
                this.z_throw();
                break;
            }
            default: {
                this.throwInvalidOpcode();
            }
        }
        return new AbstractInstruction.InstructionResult(1, false);
    }

    public AbstractInstruction.InstructionForm getInstructionForm() {
        return AbstractInstruction.InstructionForm.LONG;
    }

    public AbstractInstruction.OperandCount getOperandCount() {
        return this.operandCount;
    }

    protected InstructionStaticInfo getStaticInfo() {
        return LongStaticInfo.getInstance();
    }

    private void je() {
        boolean bl = false;
        short s = this.getValue(0);
        if (this.getNumOperands() <= 1) {
            this.getMachine().getCpu().halt("je expects at least two operands, only one provided");
        } else {
            for (int i = 1; i < this.getNumOperands(); ++i) {
                if (s != this.getValue(i)) continue;
                bl = true;
                break;
            }
            this.branchOnTest(bl);
        }
    }

    private void jl() {
        short s;
        short s2 = this.getValue(0);
        this.branchOnTest(s2 < (s = this.getValue(1)));
    }

    private void jg() {
        short s;
        short s2 = this.getValue(0);
        this.branchOnTest(s2 > (s = this.getValue(1)));
    }

    private void jin() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        int n3 = 0;
        if (n > 0) {
            n3 = this.getObjectTree().getObject(n).getParent();
        } else {
            this.getMachine().warn("@jin illegal access to object " + n);
        }
        this.branchOnTest(n3 == n2);
    }

    private void dec_chk() {
        int n = this.getUnsignedValue(0);
        short s = this.getValue(1);
        short s2 = (short)(this.getCpu().getVariable(n) - 1);
        this.getCpu().setVariable(n, s2);
        this.branchOnTest(s2 < s);
    }

    private void inc_chk() {
        int n = this.getUnsignedValue(0);
        short s = this.getValue(1);
        short s2 = (short)(this.getCpu().getVariable(n) + 1);
        this.getCpu().setVariable(n, s2);
        this.branchOnTest(s2 > s);
    }

    private void test() {
        int n;
        int n2 = this.getUnsignedValue(0);
        this.branchOnTest((n2 & (n = this.getUnsignedValue(1))) == n);
    }

    private void or() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        this.storeResult((short)((n | n2) & 0xFFFF));
        this.nextInstruction();
    }

    private void and() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        this.storeResult((short)(n & n2 & 0xFFFF));
        this.nextInstruction();
    }

    private void add() {
        short s = this.getValue(0);
        short s2 = this.getValue(1);
        this.storeResult((short)(s + s2));
        this.nextInstruction();
    }

    private void sub() {
        short s = this.getValue(0);
        short s2 = this.getValue(1);
        this.storeResult((short)(s - s2));
        this.nextInstruction();
    }

    private void mul() {
        short s = this.getValue(0);
        short s2 = this.getValue(1);
        this.storeResult((short)(s * s2));
        this.nextInstruction();
    }

    private void div() {
        short s = this.getValue(0);
        short s2 = this.getValue(1);
        if (s2 == 0) {
            this.getMachine().getCpu().halt("@div division by zero");
        } else {
            this.storeResult((short)(s / s2));
            this.nextInstruction();
        }
    }

    private void mod() {
        short s = this.getValue(0);
        short s2 = this.getValue(1);
        if (s2 == 0) {
            this.getMachine().getCpu().halt("@mod division by zero");
        } else {
            this.storeResult((short)(s % s2));
            this.nextInstruction();
        }
    }

    private void test_attr() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        if (n > 0 && this.isValidAttribute(n2)) {
            ZObject zObject = this.getObjectTree().getObject(n);
            this.branchOnTest(zObject.isAttributeSet(n2));
        } else {
            this.getMachine().warn("@test_attr illegal access to object " + n);
            this.branchOnTest(false);
        }
    }

    private void set_attr() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        if (n > 0 && this.isValidAttribute(n2)) {
            ZObject zObject = this.getObjectTree().getObject(n);
            zObject.setAttribute(n2);
        } else {
            this.getMachine().warn("@set_attr illegal access to object " + n + " attr: " + n2);
        }
        this.nextInstruction();
    }

    private void clear_attr() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        if (n > 0 && this.isValidAttribute(n2)) {
            ZObject zObject = this.getObjectTree().getObject(n);
            zObject.clearAttribute(n2);
        } else {
            this.getMachine().warn("@clear_attr illegal access to object " + n + " attr: " + n2);
        }
        this.nextInstruction();
    }

    private void store() {
        int n = this.getUnsignedValue(0);
        short s = this.getValue(1);
        if (n == 0) {
            this.getCpu().setStackTopElement(s);
        } else {
            this.getCpu().setVariable(n, s);
        }
        this.nextInstruction();
    }

    private void insert_obj() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        if (n > 0 && n2 > 0) {
            ObjectTree objectTree = this.getObjectTree();
            objectTree.insertObject(n2, n);
        } else {
            this.getMachine().warn("@insert_obj with object 0 called, obj: " + n + ", dest: " + n2);
        }
        this.nextInstruction();
    }

    private void loadw() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        MemoryAccess memoryAccess = this.getMachine().getGameData().getMemoryAccess();
        this.storeResult(memoryAccess.readShort(n + 2 * n2));
        this.nextInstruction();
    }

    private void loadb() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        MemoryAccess memoryAccess = this.getMachine().getGameData().getMemoryAccess();
        this.storeResult(memoryAccess.readUnsignedByte(n + n2));
        this.nextInstruction();
    }

    private void get_prop() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        if (n > 0) {
            short s;
            ZObject zObject = this.getObjectTree().getObject(n);
            int n3 = zObject.getPropertySize(n2);
            if (!zObject.isPropertyAvailable(n2)) {
                s = this.getObjectTree().getPropertyDefault(n2);
            } else if (n3 == 1) {
                s = zObject.getPropertyByte(n2, 0);
            } else {
                byte by = zObject.getPropertyByte(n2, 0);
                byte by2 = zObject.getPropertyByte(n2, 1);
                s = (short)(by << 8 | by2 & 0xFF);
            }
            this.storeResult(s);
        } else {
            this.getMachine().warn("@get_prop illegal access to object " + n);
        }
        this.nextInstruction();
    }

    private void get_prop_addr() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        if (n > 0) {
            short s = 0;
            ZObject zObject = this.getObjectTree().getObject(n);
            if (zObject.isPropertyAvailable(n2)) {
                s = (short)(zObject.getPropertyAddress(n2) & 0xFFFF);
            }
            this.storeResult(s);
        } else {
            this.getMachine().warn("@get_prop_addr illegal access to object " + n);
        }
        this.nextInstruction();
    }

    private void get_next_prop() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        short s = 0;
        if (n > 0) {
            ZObject zObject = this.getObjectTree().getObject(n);
            if (n2 == 0 || zObject.isPropertyAvailable(n2)) {
                s = (short)(zObject.getNextProperty(n2) & 0xFFFF);
                this.storeResult(s);
                this.nextInstruction();
            } else {
                this.getMachine().getCpu().halt("the property [" + n2 + "] of object [" + n + "] does not exist");
            }
        } else {
            this.getMachine().warn("@get_next_prop illegal access to object " + n);
            this.nextInstruction();
        }
    }

    private void set_colour() {
        int n = -3;
        if (this.getNumOperands() == 3) {
            n = this.getValue(2);
        }
        this.getMachine().getScreen().setForegroundColor(this.getValue(0), n);
        this.getMachine().getScreen().setBackgroundColor(this.getValue(1), n);
        this.nextInstruction();
    }

    private void z_throw() {
        short s = this.getValue(0);
        int n = this.getUnsignedValue(1);
        int n2 = this.getCpu().getRoutineContexts().size() - 1;
        if (n2 < n) {
            this.getMachine().getCpu().halt("@throw from an invalid stack frame state");
        } else {
            int n3 = n2 - n;
            for (int i = 0; i < n3; ++i) {
                this.getCpu().popRoutineContext((short)0);
            }
            this.returnFromRoutine(s);
        }
    }

    private boolean isValidAttribute(int n) {
        int n2 = this.getStoryFileVersion() <= 3 ? 32 : 48;
        return n >= 0 && n < n2;
    }
}

