south_station: room
	sdesc = "South Station"
	ldesc = "Bustling commuters run this way and that, trying to board trains
spanning a vast network of cities along the eastern seaboard. There
is a <b>locker</b> here.
 <P>
You can go <b>down</b> to the subway station here."
        buttons = locker_button
	down = red_line
;

locker: fixeditem, qcontainer, lockable
	location = south_station
	islocked = true
	isopen = nil
	noun = 'lock' 'locker'
	sdesc = "combonation lock"
	ldesc = {
	    if (sequence < 6)
		"This is one of those silly electronic keypad devices,
	designed to keep outside marauders at bay. You see before you
	a series of buttons. Presumably, the correct combination will
	open the door.
		 <p><hr>\n
		 <ul><ul>\n
		 <b>
		 ..1..  ..2..  ..3.. </p>\n
		 <p>
		 ..4..  ..5..  ..6.. </p>\n
		 <p>
		 ..7..  ..8..  ..9.. </p>\n
		 <p>
		 .....  ..10..  ..... </p>\n
		 </b>
		 </ul>\n
		 <p><hr>\n
		 <P>\n
		 </ul>\n";
	    else if (locker_stick.location = self)
	    {
		"Congratulations. You have opened the door - hopefully
	without too much cheating.\n
		  <p> Inside the locker ";

		if (itemcnt(self.contents) = 1)
		    " is one item ";
		else
		    " are <<itemcnt(self.contents)>> items,";
		if (paper.location = locker)
		    " one being a piece of bond <b>paper</b> covered with
	fancy writing, ";
		" and the other... WAIT, could this BE? But it
	IS! It's the long lost, ever searched for, blood-tears-sweat
	oh thank goodness, the <strong>STICK!</strong></a>
		 <p>\n
		 <b>GET THE STICK!</b>";
	    }
	    else
	    {
		if (itemcnt(self.contents) = 0)
		    "The locker is open and empty.
		     <p>\n
		     You check to make sure you still have the stick. It
		     is almost too good to be true. This time, it is yours
		     forever to keep. Success! This is wonderful. Master
		     will be so proud! 
		     <p>\n
		     You may, if you wish, stop
		     staring at the locker. ";
		else
		    inherited.ldesc;
		south_station.lookAround(true);
	    }
	}
	verDoUnlock(actor) =
	{
	    "Try pressing the keys on the keypad. ";
	}
	sequence = 1
	grid = [ [ 2 2 1 1 6 ] /* 1 */
		 [ 2 2 1 5 1 ] /* 2 */
		 [ 2 1 2 1 2 ] /* 3 */
		 [ 3 1 1 1 1 ] /* 4 */
		 [ 2 2 2 2 2 ] /* 5 */
		 [ 2 1 1 1 2 ] /* 6 */
		 [ 2 1 1 2 1 ] /* 7 */
		 [ 2 1 4 1 1 ] /* 8 */
		 [ 2 2 1 2 1 ] /* 9 */
		 [ 2 1 2 1 2 ] /* 10 */
		]
;

locker_stick: stick_class
    location = locker
    doTake(actor) =
    {
	inherited.doTakeBase(actor);

    }
;


	

class locker_button: fixeditem, numObj
    location = south_station
    noun = 'button' 'key'
    sdesc = "button <<value>>"
    ldesc = "It is a button on a combonation lock on the front of a
    locker in south station. The numeral <<value>> is printed in the
    center of the plastic square. "
    verDoPush(actor) = {}
    doPush(actor) =
    {
	"You push button <<value>> on the keypad.\n ";
	if (locker.grid[self.value][locker.sequence] = 1)
	    "The keypad resets itself.\n ";
	if (locker.grid[self.value][locker.sequence] > 2)
	    "There is a soft click that only a dog could hear.";
	locker.sequence := locker.grid[self.value][locker.sequence];
	if (locker.sequence = 6)
	{
	    "<b>Click!</b>\n ";
	    locker.islocked := nil;
	    locker.isopen := true;
	    locker.ldesc;
	}
	
    }
;



locker_button_1: locker_button
    noun = '1' 'one'
    adjective = 'first'
    value = 1
;

locker_button_2: locker_button
    noun = '2' 'two'
    adjective = 'second'
    value = 2
;

locker_button_3: locker_button
    value = 3
    noun = '3' 'three'
    adjective = 'third'
;

locker_button_4: locker_button
    value = 4
    noun = '4' 'four'
    adjective = 'fourth'
;

locker_button_5: locker_button
    value = 5
    noun = '5' 'five'
    adjective = 'fifth'
;

locker_button_6: locker_button
    value = 6
    noun = '6' 'six'
    adjective = 'sixth'
;

locker_button_7: locker_button
    value = 7
    noun = '7' 'seven'
    adjective = 'seventh'
;

locker_button_8: locker_button
    value = 8
    noun = '8' 'eight'
    adjective = 'eighth'
;

locker_button_9: locker_button
    value = 9
    noun = '9' 'nine'
    adjective = 'ninth'
;

locker_button_10: locker_button
    value = 10
    noun = '10' 'ten'
    adjective = 'tenth'
;

paper: item
    location = locker
    noun = 'paper'
    adjective = 'yellow' 'bond'
    sdesc = "paper"
    ldesc = "The scrap of paper (that looks like it will blow away in
	     any minute) uses a big flowery script explaining how and
	     why this stick ended up in a locker at the train
	     station. It probably says something very important,
	     perhaps crucial, but you are too impatient to read the 
	     long, fancy writing."
;
