quincy_market: room
	sdesc = "Quincy Market"
	ldesc = "<p>There are throngs of tourists being preyed upon by savvy marketeers. You also notice a <b>rock</b></p>
You can go <b>north</b> or back <b>down</b> into the subway</p>"
	north = fanual_hall
	down = green_line
;


rock: fixeditem
	location = quincy_market
	noun = 'rock'
	sdesc = "rock"
	ldesc = "It's just a rock lying on the ground. Utterly useless, worthless, and insignificant this small stone was one a part of a large boulder 
			crushed by glaciers during the last ice age. In another hundred million years, it will probably be reduced to sand."
;


rejoinVerb: deepverb
    verb = 'rejoin'
    sdesc ="rejoin"
    action(actor) =
    {
	juggling_act.doRejoin(actor);
    }
    doAction='Rejoin'
;

beVerb: deepverb
    verb = 'be'
    action (actor) = {"To be or not to be, that is the question\n";}
    doAction = 'Be'
;

ham: decoration
    location = juggler
    noun = 'ham' 'clown'
    sdesc = "ham"
    ldesc = "Do you mean yourself, the juggler or an actual juicy
	     ham?\n
	     Don't get too excited, there is no actual ham here.\n"
    verDoBe(actor) = {}
    doBe(actor) =
    {
	if(juggler.performance_sequence = 1)
	{
	    actor.location.ldesc;
	}
    }
;

juggling_act: decoration
    location = juggler
    sdesc = "A street performance"
    ldesc = "An amazing yet humorous act that combines
	     feats of unnatural skill with bad humor."
    verDoRejoin(actor) =
    {
	if (juggler.performance_sequence <> 1)
	    "This is not the time for that. ";
    }
    doRejoin(actor)=
    {
	actor.location.ldesc;
    }
;


get_choice: function(max, chosen)
{
    local choice;
    "<!-- choosing -->";
    choice := rand(max);
    if (chosen[choice])
	choice := get_choice(max,chosen);
    return choice;
}

performance_choices: function
{
    local i, choices, chosen;
    choices := ['<b>Do nothing</b>\n'
		'<b>Bark</b>'
		'<b>Roll over</b>'
		'<b>Howl</b>'
		'<b>Wag your tail</b>'
		'<b>Drool</b>'];
    chosen := [ nil nil nil nil nil nil ];
    "You may
     <UL>\n";
    for (i := 1; i <= length(choices); i++)
    {
	local choice;
	choice := get_choice(6,chosen);
	chosen[choice] := true;
	"\t<LI><<choices[choice]>></LI>\n";
    }
    "</UL>\n";      
}

fanual_hall: room
    sdesc = {"Fanual Hall"; donothing := nil;}
    repeat_q = nil
    ldesc =
    {
	donothing := nil;
	if (juggler.location = self)
	    switch (juggler.performance_sequence)
	    {
	      case 0:   "A <b>juggler</b> entertains the crowd<p>
		     You can go
		     <b>south</b>";
		     break;
	      case 1:
			if (!repeat_q)
			    "Why not go the whole way? You jump
			     through flaming hoops. You jump rope. Everything
			     seems to be going well, until 
			     the guy starts asking you questions.
			     Non - rhetorical questions.
			     This is not the type of thing people
			     usually do with dogs. What's going on here?";
		     "<P>\n
		     <I>What is on the top of a house?</I>
		     <P>\n";
	            performance_choices();
		    break;
	       case 2:  "<I>What is the opposite of smooth?</I>
		      <P>\n";
		    performance_choices();
		    break;
	       case 3:  "<I>Who was the greatest baseball player ever?</I>
		      <P>\n";
		    performance_choices();
		    break;
	       case 4: "The crowd, by this point has started to loudly
		    boo. I guess they liked DiMaggio better.
		    <P>\n
		    Well, this is the end of the show, so you grab the
		    hat in your mouth and walk it around. You end up
		    collecting quite a few dollars. However, one
		    person, a very old man looks at you
		    strangely. He bends down and stares into your eyes for a
		    moment. He seems to be concerned with your
		    neck. Quick as a mousetrap, he slaps a collar
		    around it. Attached to the collar is 
		    a once shiny but now very old medallion, covered
		    with Chinese lettering. The man turns and 
		    walks away, leaving
		    you to ponder for a moment your newfound gift.
		     <P>\n";
		    medallion.moveInto(Me);
		    incscore(100);
		    "Meanwhile, the crowd has broken up, and after the
		    man takes his hat back, you are left in a rather
		    boring section of Fanual Hall.
		     <P>\n
		    You can go
		    <b>south</b>";
		    unnotify(fanual_hall,&lose_patience);
		    unnotify(fanual_hall,&impatient);
		    setlevel(5);
		    break;
	    } /* end switch sequence */
	else
	    "Crowds of tourist flock about, buying things left
	     and right. You are surprised that there are no
	     street performers about.
	     <P>\n
	     You can go
	     <b>south</b>";
    }
    verDoBark(actor) =
    {
	if (juggler.performance_sequence <  1
	    and performance_sequence > 9)
	    barkVerb.action(actor);
    }
    doBark(actor) =
    {
	juggler.performance_sequence++;
	unnotify(fanual_hall,&lose_patience);
	unnotify(fanual_hall,&impatient);
	notify(fanual_hall,&lose_patience,1);
	if (juggler.performance_sequence < 4)
	    "The strange line of questions continued unabated.
	     <P>\n";
	self.ldesc;
    }
    exit_attempt = nil
    leave_fanual =
    {
	if (juggler.location = fanual_hall
	    and juggler.performance_sequence > 0)
	    if (!exit_attempt)
	    {
		"Fool, did you really believe that it was just that
		 easy? That you could walk away from things, no
		 questions asked, no hassle, a simple exit. You are here
		 for a reason, and you'll not blow it now by walking
		 away will you? A simple and very explicit word of
                 advice\: Don't do it.
	         <P>\n
	         You may
   	         <UL>\n
	         \t<LI> <b>Rejoin</b> the act\n
	         \t<LI> <b>Tempt fate</b> and walk out.\n
	         </UL>\n";
	         exit_attempt := true;
	         return nil;
	      }
	      else
	      {
		  fate.doTempt(Me);
	      }
	 else
	      return quincy_market;
    }
    lose_patience =
    {
       notify(fanual_hall,&impatient,0);
      repeat_q := true;
    }			      
    impatient=
    {
	if (!donothing)
	{
	       "People are losing their patience with you. Someone
	       shouts, <I>Hey Mutt, pay attention!</I> The performer
	       is getting both irritated and somewhat embarrassed.
	       He decides to try repeating the question.
			      <P>\n<<ldesc>>";
	 }
    }
    south = self.leave_fanual
    out = self.leave_fanual
;

juggler: Actor
    location = fanual_hall
    noun = 'juggler' 'man' 'performer' 'guy'
    sdesc = "juggler"
    ldesc = {
	"A young fellow is balancing on a five foot tall
    unicycle. There is a chair balanced on his nose, and he is
    juggling five flaming batons, while simultaneously telling jokes
    and asking for money. <P>\n
	     There is an open <b>hat</b>, and a also a <b>bag</b> of
    tricks. <P>\n
	     A couple of ideas strike your fancy
    <UL>\n
    \t <LI> <b>Knock</b> the guy off his unicycle\n
    \t <LI> <b>Growl</b> at all the tourists, maybe nip at a little
	     kid.\n
    \t <LI> <b>Check out</b> what's in the bag\n
    </UL>\n
	     <P> You can go <b>south</b>";
	jugglers_bag.moveInto(fanual_hall);
	jugglers_hat.moveInto(fanual_hall);
    }
    performance_sequence = 0
    verDoAttack(actor) = {}
    doAttack(actor) =
    {
	"With a running start, you launch yourself into the
    air. Unfortunately, this was probably not the best of moments to
    make an attack. The fellow had been juggling four running chain
    saws and a flaming baton.
	 <P>\n
	 You are singed, shaved, and then get motion sickness as the
    talented performer keeps tossing you in circles.
	  <P>\n
	 The audience is duly impressed.
	  <P>\n
	 You may
	 <UL>\n
	 \t<LI> <b>Be a ham</b> about it\n
	 \t<LI> Walk <b>out</b> in disgust.\n
	 </UL>\n";
	self.performance_sequence := 1;
	notify(fanual_hall,&lose_patience,2);
    }
    verDoKnock(actor) = {}
    doKnock(actor) = 
    {
    	self.doAttack(actor);
    }
 ;

unicycle: fixeditem
    location = juggler
    noun = 'unicycle' 'cycle'
    sdesc = 'unicycle'
    ldesc = "It has one wheel with peddles attached to the axle, and a narrow seat."
    verIoKnockOff(actor) = {}
    ioKnockOff(actor, dobj) = 
    {
      dobj.doAttack(actor);
    }

;

tourists: fixeditem
    location = fanual_hall
    noun = 'tourists'
    sdesc = "tourists"
    ldesc = "A circle of tourists gathers around the performer, watching his show. "
    verDoGrowl(actor) = {}
    doGrowl(actor) =
    {
	"You show a few teeth. Deep, menacing rumbles pour out of your
	 throat. And everybody starts laughing. The performer tossing out
	 jokes and witty remarks, making fun of you (of all the nerve!)
	 Worst of all everybody thinks that you are part of the act. ";
    }
;

jugglers_bag: fixeditem
    location = nil
    noun = 'bag'
    adjective = 'juggler\'s' 'man\'s' 'performer\'s'
    sdesc = "juggler's bag"
    ldesc = "There are a lot of things poking out of this bag. It
	     probably has the standard showbiz junk, namely a dew decks of
	     cards, dice, some ball or batons and the like. However,
	     something in there tickles you imagination - it is far to
	     bulky to be any of the items mentioned above. "
    verDoSearch(actor) = {}
    doSearch(actor) =
    {
       "Beneath the usual assortment of entertainment props lies a large, high caliber, military grade flame thrower. Cool. This fellow must have a heck of a grand finale. ";
   }
;

jugglers_hat: fixeditem
    location = nil
    noun = 'hat'
    adjective = 'juggler\'s' 'man\'s' 'performer\'s'
    sdesc = "juggler's hat"
    ldesc = "The hat has some change in it, along with a few one dollar bills. A five dollar bill is in there too, but you suspect that it may have been planted by the performer to entice people into being generous. "
;
