/*
 *   Copyright (c) 1999, 2002 by Michael J. Roberts.  Permission is
 *   granted to anyone to copy and use this file for any purpose.  
 *   
 *   This is a starter TADS source file.  This is a complete TADS game
 *   that you can compile and run.
 *   
 *   To compile this game in TADS Workbench, open the "Build" menu and
 *   select "Compile for Debugging."  To run the game, after compiling it,
 *   open the "Debug" menu and select "Go."
 *   
 *   This is the "advanced" starter game - it has only the minimum set of
 *   definitions needed for a working game.  If you would like some more
 *   examples, create a new game, and choose the "introductory" version
 *   when asked for the type of starter game to create.  
 */

/* use the HTML status line and prompts */
#define USE_HTML_STATUS
#define USE_HTML_PROMPT

/* include the standard TADS libraries */
#include <adv.t>
/*#include <gameinfo.t>*/
#include <std.t>

/* include game specific modules */

#include "math.t"
#include "verbs.t"
#include "south_river.t"
#include "north_river.t"

eatDaemon: function;
sleepDaemon: function;

/*
 *   This function is a daemon, set running by init(), which monitors how
 *   long it has been since the player has had anything to eat.  It will
 *   provide warnings for some time prior to the player's expiring from
 *   hunger, and will kill the player if he should go too long without
 *   heeding these warnings.
 */
replace eatDaemon: function( parm )
{
}

replace sleepDaemon: function( parm )
{
}

/* at game startup, turn on HTML mode */
replace commonInit: function
{
    /* display the special code sequence to turn on HTML recognition */
    "\H+";
    global.realtime := true;
    global.teleport := nil;
    global.game_level := 1;
    global.linear := true;
    global.maxscore := 1041;
    notify (Me, &flea_infest, 0);
    setGender();
    setBreed();
    disclaim();
    if (global.linear)
	setlevel(0);
    else
	nonlinearVerb.action(Me);
}

setGender: function
{
	local sex;
	sex := inputdialog(INDLG_ICON_QUESTION, 'Pick one:', ['&male' '&female' '&neuter'],1,3);
	switch (sex)
	{
		case 1: Me.isHim := true;
			    Me.isHer := nil;
			    break;	
		case 2: Me.isHim := nil;
			    Me.isHer := true;
			    break;	
		case 3: Me.isHim := nil;
			    Me.isHer := nil;
			    break;	
	}
}

setBreed: function
{
	local breed_choice;
	"<h1>Welcome to Drool</h1>
	<HR>\n <P>\n
	 <IMG ALIGN=top SRC='dragon.png'><P>";
	breed_choice := numbered_menu('Enter your breed:\n',
				      ['Mutt'
				       'Great Dane'
				       'Black Labrador'
				       'German Shepherd'
				       'Dumb yapping poodle'
				       'Weiner Dog'
				       'Snoopy'],
				      1);

	switch (breed_choice)
	{
		case 1: Me.breed := 'mutt'; 
				addword(Me,&noun,'mutt');
				break;
		case 2: Me.breed := 'great dane';
				addword(Me,&adjective,'Great');
				addword(Me,&noun,'Dane');
				 break;
		case 3: Me.breed := 'black labrador';
				addword(Me,&adjective,'black');
				addword(Me,&noun,'labrador');
				 break;
		case 4: Me.breed := 'german shephard';
				addword(Me,&adjective,'german');
				addword(Me,&noun,'shephard');
				 break;
		case 5: Me.breed := 'dumb yapping poodle';
				addword(Me,&adjective,'dumb');
				addword(Me,&adjective,'yapping');
				addword(Me,&noun,'poodle');
				 break;
		case 6: Me.breed := 'weiner dog';
				addword(Me,&adjective,'weiner');
				 break;
		case 7: Me.breed := 'super-intelegent beagle';
				addword(Me,&adjective,'snoopy');
				addword(Me,&noun,'snoopy');
				 break;
		default:	Me.breed := breed_choice;
				break;
	}
}


modify Me
    noun = 'me' 'myself' 'dog'
    verDoWag(actor) = 
	{ 
	"You try, but your body is too heavy for your tail to wag. 
	You have no idea what that movie will be about when it comes
	out in three years";
	incscore(1);
	}
    verDoSinkIn(actor, io)= {}
    doSinkIn(actor, io) = {}
    fleas = []
    flea_count = 0
    flea_gestation = 20
    flea_cycle = 0
    flea_infest = 
   {
	   flea_cycle ++;
	  if ((self.flea_count+2)*rand(100)  > 290)
	       "\n You feel a flea bite you on the back.<br>\n";
	  if (flea_cycle > flea_gestation)
	  {
		  local f;
		  f := new flea;
	   	  fleas += flea;
	   	  flea_count ++;
		 flea_cycle := 0;
	           "\n You think that you have more fleas.<br>\n";
	}
    }
    sdesc = "<<self.breed>>"
    ldesc = {" %You% %are% a <<self.breed>>.<br>\n";
			if ( length(self.fleas) > 12) 
                     {
			 "With ";
			 say(cvtstr(length(self.fleas)/12));
			 " dozen fleas. <br>\n";
                      }
    }
    hasStick = nil
    fetch_attempt = 0
;

genetals: fixeditem
	noun = 'genitals' 'genitalia' 'butt'
	adjective = 'my'
	location = Me
	sdesc = "genetalia"
	ldesc = {
	    if (self.location.isHim)
		"The two familiar bumps assure you that %you% are a boy dog.";
	    else if (self.location.isHer)
		"The familiar holes assure you that %you% are a girl dog.";
	    else
		"The two, er.. one familiar bump assures %you% that
		 %you% are.. wait, isn't something missing?
		 It must have been that trip to the vet last year!\n";
	}
	doSmell(actor) =
	{
	    if (actor.isHim)
		"%You% smell like a boy <<actor.breed>>.";
	    else if (actor.isHer)
		"%You% smell like a girl <<actor.breed>>.";
	    else
		"%You% smell like a boy <<actor.breed>>... sort of.";
	}
;

    
disclaim: function
{
"
<h2>Disclaimer</h2>

<p>
I release Drool into the public domain as of Feb 29, 2004. The game is
freely distributable, you can modify it, create derived works, and use
them under any means or terms as you see fit. All characters,
locations, and events transpiring in this game are completely
fictional. This game is distributed in the hope that it will be fun,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. It is possible
that there are a few images snarfed from the circa-1994 world wide web
incorporated in Drool, for example a map of the Boston subway system,
which may or may not fall under the <i>illegitimis non carborundum</i>
clause in copyright law.

<P> Drool is a short game, usually taking a couple of hours to solve.
The name \"Drool\" was selected 5/31/94 from the copious list of
suggestions sent in by players. Drool garnered an occaisional good <b>review</b> and also some passionate player
feedback.  For example, I've been informed that sticks can injure a
dog's mouth and throat. Let me encourage you to use something less
dangerous for your own pooch; tennis balls are fun. Drool was written
in the spring of 1994, and got quite a lot of attention during those
early days of the World Wide Web. Drool is no longer actively
maintained by the author, and it is quite possible that things no
longer work. Drool was mostly created using a big nest of
unix-symbolic links, and there was also an program to switch files
around, for example turning a traffic light from red to green or
switching a scene from day to night. For those frustrated by the game
and looking for a shortcut, or just interested in taking a closer look
at how things work, the administrative interface allows one to <b>cheat</b> with impunity.

<p>\n
Jeff Breidenbach <br>\n
jeff@ alum.mit.edu <br>\n
</p>\n
<p>TADS version by:<br>\n
 John huebner\n
 john@ john.huebner.name\n
</p>
";
}


class flea: item
	noun = 'flea' 'fleas'
	location = Me
	sdesc = "flea"
	ldesc = "Irritating, itchy flea."
	pluraldesc = "fleas"
	isListed = true
	isEquivalent = true
	verDoAttack (actor) = {}
	doAttack (actor) = 
	{
		if (actor.flea_count > 0)
		{
		switch (rand(6))
		{
		case 1: "You try to bite your fleas, but they scurry deeper into your fur, and you only bite yourself.";
			break;
		case 2:
		case 3:	"You sink your teeth into that annoying insect and spit it out onto the ground.";
			self.location.flea_count --;
			delete self;
			break;
		case 4:	"You try to scratch your fleas, but they scurry deeper into your fur, and you only scratch yourself.";
			break;
		case 5:
		case 6:	"You sink your claw into that annoying insect and grind it into the ground with your paw";
			self.location.flea_count --;
			delete self;
			break;
		}
		}
		else
		{
			"You scratch your ever-present fl... WAIT! You have no fleas!";
		}
	}
;


/* 
 *   Retrieve the card-catalog information for the game.  This information
 *   is written to a file called GameInfo.txt during preinit, and can then
 *   be stored in the compiled .gam file for retrieval by automated tools.
 *   This information is useful for archive maintainers and other
 *   searching and browsing tools.  
 *
getGameInfo: function
{
    /* build and return the game information list 
    return ['Name', 'Drool',
            'Byline', 'original by Jeff Breidenbach, ported to TADS by John Huebner',
            'Desc', 'a silly IF game involving a dog wandering
around Boston. It was originally written in early 1994.',
            'Version', '1.0',
            'ReleaseDate', getGameInfoToday(),
            'Language', 'en-US',
            'PresentationProfile', 'Multimedia'];
}
*/
/* starting location */

disclaimer: readable
	noun = 'disclaimer' 'document' 'form' 'introduction'
	adjective = 'legal'
	sdesc = "disclaimer"
	ldesc = "It is an official looking document, perhaps you should read it."
	readdesc = {disclaim();}
	location = Me
;

startroom: room
    start = 'A big grassy park and a sunny day. There are lots of
	     little kids playing here.
	     One <b>tyke</b> seems particularly evil.<p>'
    end = 'You may go <b>east</b> or <b>west</b>'

    sdesc = "Boston Commons, 1994"
/*
 * The following five strings are used for changing the description.
 */

    intro_desc = "<TITLE>Drool</TITLE>
    <i><hr>  These are the halcyon days of puppyhood. The sun is
shining in Boston for a change, and everyone seems happy. It is the
kind of day when some just toss a frisbee around, others laugh and
talk about nothing in particular, and even hyperactive canines get smiled
at rather than kicked.</i>


<hr><p>

Oh BOY oh BOY oh BOY! There is GRASS. And there are SMELLS. But
nothing is better than being at master's side. WAIT! What does he
have? This is stupendous, oh WOW! Master has a stick! YES! YES!
Master has a stick! STICK! What's he going to do?!<p>

Look he threw it! <strong> YES! YES! </strong><p>
"

    thrown_desc = "A big grassy park and a sunny day. There are lots
		   of little <b>kids</b> playing here.<p>
		   Oh boy, here is the <strong>stick!</strong><p>
		   <b>GET THE STICK</b>"

    kite_desc = "<<start>>
		 <hr><p>
		 The following narrative is almost too gruesome to relate.<p>
		 In the course of two minutes, a small
		 <b>child</b>
		 of about age eight, picked up
the <strong> STICK </strong>. Tragically, the branch was placed in a complex 
kitish structure, and lofted into the air.<p>

As you came bounding along the boy, startled, released the string he was
holding. The resulting untethered kite was caught in the strong northbound
wind and quickly lost to sight.<p>

		 <p>
		 <hr>
		 <<end>>"
    plain_desc = "<<start>> <<end>>"
    story_told = nil
    ldesc =
    {
	local player;
	player:=parserGetMe();
	switch (player.fetch_attempt)
	{
	  case 0: intro_desc;
		  break;
	  case 1: thrown_desc;
		  break;
	  case 2:
		  if (self.story_told)
		      plain_desc;
		  else
		  {
		      kite_desc;
		      self.story_told := true;
		  }
		  break;
	  default:
		 plain_desc;
		 break;
	}
    }

  west =  {
	    local stick;
	    stick:=getStick(parserGetMe());
	    if (stick = nil)
	    {
		"The master is here, and he looks disappointed. You have
		 let down the Master. Oh <strong> BAD BAD
		 DOG</strong>! This is TERRIBLE! Oh, the shame of
		 failure stings deeply. WHERE IS THE 
		 STICK? The humiliation. The ignomy. The sheer
		 incompetence. Honor demands a fetch, and you have not
		 fetched. <STRONG>Bad dog!</STRONG> 

		 The master asks:
		 <i> Where is the stick? Come on, go get it.</i><p>
		 
		 You can
		 <b>leave</b> in disgrace.";
	    }
	    else if(stick.real)
	    {
		"Ahh, that's a good dog. And the master scratches your ears.
		 What more 
		 <b>reward</b> could anyone ask for?
		 <P>
		 <H1>The End</H1>\n";
		incscore(100);
		reward.moveInto(master_room);
	    }
	    else if (!stick.real)
	    {
		"The master looks at you expectantly. He has, after
		 all, been waiting for quite a while. When you come
		 bounding up with the prize, his smile turns to a
		 frown.
		 <P><I>Wait a sec, that's not the same stick I threw
		 you. C'mon doggy, fetch the right stick</I>
		 <P> Oh no, he is right! The stick, while seemingly
		 identical to even your trained eye, is from the same
		 branch of the same tree - but it's not the same
		 stick. You have mistakenly fetched an almost exact
		 copy, and that's not good enough.
		 <P>
		 You have no choice but to <b>slink away</b> in
		 shame\n";
		stick.moveInto(nil);
		setlevel(8);
		incscore(100);
	    }
	    return master_room;
	}
  east = esplenade
  north = observitory
   
; /* End of startroom */



class stick_class: item
    sdesc = "stick"
    ldesc = {
	if (!global.linear or self.real)
	    "This is the ALMIGHTY STICK! It's mere presence uplifts the
	     spirit, restores all gumption and beckons you forward. 
	     You feel dizzy and unsteady from joy.
	     The stick radiates happiness and peace and hope. It is
	     graced by the Master himself. Only destiny could have
	     brought you this close. The song of angels can be heard
	     over the city noise, and you detect an aura of magnificence
	     surrounding this bough like a halo of life itself.  
	     You revel in the realization of the sole purpose of your
	     existence, your one and only goal, the very object of this game:
	     to return this stick back to master.";
	else
	    "This is the ALMIGHTY STICK! You revel in the realization
	     of the sole purpose of your
	     existence, your one and only goal, the very object of this game:
	     to return this stick back to master.";
    }
    noun = 'stick' 'branch' 
    adjective = 'almighty'
    real = nil
    
    doTakeBase(actor) =
    {
	if (self=locker_stick or self=fenway_stick)
	{
	    "You actually fetch the stick!\n";
	    inherited.doTake(actor);
	}
	else
	    "You try to fetch the stick!\n";
	if (actor.fetch_attempt > 0)
	    incscore(100);
	actor.fetch_attempt  := actor.fetch_attempt + 1;
	if (actor.location = startroom)
	    startroom.ldesc;
	else
	    setlevel(global.game_level+1);
	if (self=locker_stick)
	{
	    locker.ldesc;
	}
	
	
}
; 

start_stick: stick_class
    location = startroom
    doTake(actor) =
    {
	inherited.doTakeBase(actor);
	if (actor.fetch_attempt = 2)
	{
	    self.moveInto(nil);
	    rubbish_stick.moveInto(rubbish);
	}
    }
;


review: item
    noun = 'review' 'reviews'
    adjective = 'two' 'three' 
    location = Me
    sdesc = "two reviews"
    ldesc = "<h1>Two Reviews of Drool. </h1>\n 
	  These are my favorite two reviews. Well, maybe they're my
	  favorite one review - note the suspicious similarity. From
 http://techweb.cmp.com/ng/arcade/f-arcade.htm\n and
 http://felix.unife.it/Root/d-Internet/h-Bigsurf/12-Alternative_Sites,\n
 respectively.
 <p>\n
<STRONG><b>Drool</b></STRONG><BR>\n
<I>(Last Reviewed in June 1995)</I><BR>\n
Fetch the stick. Sounds easy enough, but whether you're a mutt or a
    \"dumb, yapping poodle,\" Drool makes a dog's life
    difficult.<p>\nEvil tykes, funny-looking fellows and airport
    terrorists impede your quest to return a stick to your master in
    this text-based, choose-your-own-adventure game. Frustrated by
    your every attempt to be a good dog, you set off through Boston
    looking for your grail--your master's stick. You'll ride the
    subway, wander through Harvard Square, hike MIT's Infinite
    Corridor, wait in line 
    at the Hard Rock Cafe and nose  around in Dumpsters. Fail in your
    search and face that awful evil, your master's
    disapproval. Succeed and you'll bask in his affection. Either way,
    you'll get to explore a virtual Boston and play in one of the most
    imaginative and innovative games we've seen in a long time. This
    dog's life ain't so bad. <STRONG>http://www.mit.edu:8001/afs/athena.mit.edu/user/j/b/jbreiden/game/entry.html</STRONG>
   <p>\n<BR>\n
   <BR>\n<BR>\n<BR>\n
   <p>\n
   <CENTER><B>Drool</B></CENTER><BR>\n
   <CENTER><b>http://www.mit.edu:8001/afs/athena.mit.edu/user/j/b/jbreiden/game/entry.html</b></CENTER>
   <p>\n
    You'll be well rewarded for all your efforts (if you manually type
    in the URL listed above) after you get to this fantastic
    page. It's part game and part virtual tour of Boston,
    Mass. (US). The premise is easy enough. You are to chase and then
    fetch a stick (you play the role of the dog) and then it's off to
    the chase! This is no easy task as you have to manuever through
    evil kids, weird folks, airport terrorists and other unsavory
    characters in your quest for that dog-gone stick you have to
    fetch. You'll ride the subway and then have to navigate through
    Harvard Square and then you may have to wait in line at the Hard
    Rock Cafe or try and get through MIT's Infinite Corridor
    passage. All this and more awaits you - but if you succeed in
    bringing back the stick to your master then all will be praise and
    affection - but if you fail - your master will eagerly show his
    nasty disapproval. This has to be one of the most unique,
    inventive and highly imaginative web pages and/or web games out
    there. It just doesn't get any better than this folks. You
    absolutely MUST surf over to this site.
    <p>\n<BR>\n<BR>\n
    <i>Ok, I know I only promised to include two reviews, but I can't
    help including this letter from Mr. Takashi Ito</i> <p>\n<BR>\n
    Dear Mr. Jeff Breidenbach:<p>\n
    \"dogmark\"seleced your wonderful site (Drool)
    for \"Cool DOG Site of the Day\" on April 15,1996
    Thank you very much for your cool site information.
    Please visit my \"Cool DOG Site of the Day\"
    URL is http://www.st.rim.or.jp/~ito/d/dogmark.html
    please visit \"dogmark selected
    site\"=http://www.st.rim.or.jp/~ito/d/dogmarkselected.html This is
    the direct access site which cannot jump from \"Cool DOG Site of
    the Day\" and only for the selected WWW. Please make a link to my
    site if possible. \"dogmark\" also selecet monthly BEST DOG Site and
    the site is introduced in the No.1 selling Dog Magazine in Japan
    called \"WAN\". 
    Your Site is surely the nominee for monthly BEST DOG Site.
    Many thanks again for your Cool DOG Sute.
    I really enjoyed your DOG Site.
    <p>\n
    Takashi Ito<BR>\n
    \"dogmark's Cool DOG Site of the Day\"<BR>\n
    <BR>\n<BR>\n<BR>\n"

;
		       

day: function 
{
	if(global.realtime)
	{
	  local timelist;
	  timelist :=gettime();
	  return timelist[3];
	}
	else
	{
  	  return global.turnsofar / 96;
	}
}

hour: function 
{
	if(global.realtime)
	{
	  local timelist;
	  timelist :=gettime();
	  return timelist[6];
	}
	else
	{
	  local turns_today;
  	  turns_today := remainder(global.turnsofar+48,96);
	  return turns_today / 4;
	}
}

minute: function
{
	if(global.realtime)
	{
	  local timelist;
	  timelist :=gettime();
	  return timelist[7];
	}
	else
	{
	  local quarter;
  	  quarter := remainder(global.turnsofar,4);
	  return quarter*15;
	}
}

time_frequent: function (infuture)
{
    /* Every 1 minutes we switch
    * Sorry Jeff but I got impatient waiting 2 minutes*/
    return (remainder((minute()+infuture),2) < 1); 
}


time_group1: function
{
    /* Every 4 hours we switch */
    return (remainder(hour(),8) < 4); 
}

time_rare: function
{
    if (day() = 13)
       return (hour() = 4);
}

time_night: function
{
    return ( hour() > 21 or hour() < 6);
}
show_time: function
{
	local h := hour();
	if (h < 6 or h > 21)
		"It is dark outside, though the city streetlamps and the moon provide some illumination.";
	else if (h > 5 and h < 10)
		"The sun is low in the eastern horizon, peeking over buildings and trees.";	
	else if (h > 18)
		"The sun is low in the west, dipping behind buildings and trees.";
	else 
		"The sun is shining brightly, high in the sky.";
}

sun: decoration
	noun = 'sun' 'shadows'
	sdesc = "sun"
	ldesc = { show_time();}
	location = Me
;

numbered_menu: function (prompt, list, def)
{
	local index, option, ret;
	say ('<p>' +prompt + '</p>\n<ol>');
	for (index :=1; index <= length(list); index ++)
	{
	    /* Bizzare hack, HTML is supported in text mode,
	       but <ol> is not, so check for text mode by
	       asking about jpeg support */
	    if (systemInfo(__SYSINFO_JPEG))
		say ('<li>' + list[index] + '</li>\n');
	    else
	        "<b><<cvtstr(index)>></b> <<list[index]>>\n ";
	}
	"</ol>\n";
	ret :=  input();
	if ( reSearch('[0-9]+',ret))
		return cvtnum(ret);
	else
		return def;
}

bulleted_menu: function (prompt, list)
{
	local index, option, ret_str, ret;
	say ('<p>' +prompt + '</p>\n<ul>');
	for (index :=1; index <= length(list); index ++)
	{
	    /* Bizzare hack, HTML is supported in text mode,
	       but <ul> is not, so check for text mode by
	       asking about jpeg support */
	    if (systemInfo(__SYSINFO_JPEG))
		say ('<li>' + list[index] + '</li>\n');
	    else
	        "<b><<cvtstr(index)>></b> <<list[index]>>\n ";
	}
	"</ul>\n";
	return input();
}

