label day_four:
window hide
with Pause(1)
show text "Day Four" zorder 5 with dissolve
with Pause(2)
hide text with dissolve
window show
show inn zorder 3 with dissolve

$TakeOver = "Empty"
if game.town_stability >=7:
    """

    A man stops you on your way to work.  He does it in one of the most direct ways possible.  He grabs your ankle, almost making you trip.

    You had not seen him waiting.  His legs and chest are covered in snow and his arms and face are so caked with dirt that there is little about him other than his shape which indicates what he is and even then he is too thin to be easily recognised.

    His grip is weak.  Once he is sure he's stopped you, he simply lets go.

    His voice comes out as a mucus-edged whine.  Too tired to cough.
    """

    "Man"  """

    My name was Tihmor.  Remember that I lived.

    My name was Tihmor.
    """

    """

    You knew Tihmor growing up.  You played in the snow with him.

    He is no longer moving.

    There is no-one about to help you move the body, so you leave it.  Something will find it in time.

    The inn is warm and safe.

    Henryk waits behind the bar, a grim expression on his face.
    """
    show henrykimg zorder 4 with dissolve:
        xalign 0.05 yalign 0.25
    if game.ToldHenryk != "Nothing":
        henryk  """

        I'm sorry [game.player_name], I know I said I would be with you today, but there's been an incident.

        There's a group of people outside the town hall.  They want the Senator to take charge.  It's not good [game.player_name].  There'll be blood, I can tell you that.  But people might listen to me, so I need to be there.  And it would be strange if I wasn't.

        I will be back as soon as I can be.  You'll be alright, won't you?
        """

        """

        You are sure he does not intend it, but his eyes leave you no choice but to nod.
        """
else:
    """
    A woman stops you on your way to work.  Her eyes fill with relief when she sees you and she lets out a sigh.
    """

    "Woman"  "You work at the inn, right?  Oh, you have to help me, my friend has fallen and can't get up.  I think he's starving, help me get him to the inn, won't you?"

    """

    You peer into the snow where the woman is looking.  A man you remember playing with as a child lies in a drift, his chest's slow rise and fall his only movement.

    It takes less effort than you had thought to move him.  He is dead weight, but he is thin and the walk isn't long.

    The inn is warm and safe and the moment you have pushed open the doors many people come forward to take the man, Tihmor, off your hands, making sure he is fed and warm.

    Henryk waits behind the bar, a smile on his face.
    """
    show henrykimg zorder 4 with dissolve:
        xalign 0.05 yalign 0.25
    if game.ToldHenryk != "Yes":
        if game.ToldHenryk == "Sick":
            henryk """

            It's good to see you.  You look better.  Are you?
            """

            "You nod and Henryk's smile grows."

            henryk """

            I'm glad to hear it.
            """
        else:
            henryk "Good morning [game.player_name]."
        henryk """
        I'm afraid I'll have to head out again today.  I hate to leave you alone here again, but I'm afraid there is no helping it.  Someone found something out in the forest.  Something that … no, I'm sorry, the Alderman didn't want me talking about it, not till we know it's significant.

        But I think it is a good thing.

        Either way, the Alderman wants me to go look at it.  I just hope I can get there ...

        You will be okay, won't you?
        """
        """

        You are sure he does not intend it, but his eyes, those of an excited child, leave you no choice but to nod.
        """
    else:
        

        henryk """

        It's good to see you [game.player_name].  After last night … I don't know.  I worry too much.

        I'm glad you're here.

        I have good news and a little bit of bad.

        The bad is that I'll have to leave you here alone again today.  But it's because of the good.

        Elisabetta came in last night, after you left.  I got talking to her and she mentioned that she's been collecting books about strange phenomena.

        Well, she more than mentioned.  She gave me what I hope was a complete catalogue.

        Either way, she said I could have a look through them.  I thought it would be odd to ask on your behalf.  I don't want to arouse suspicion.

        So can you manage the Wolf and Wheel today?  And hopefully by tonight, I'll have found something that can help you.

        Just one more day.  Can you manage it?
        """

        """

        You can tell by his tone that the question is genuine, but his eyes betray him and you know that you can do nothing but nod."""
"""
Henryk nods back and then with a few parting words of encouragement, leaves you alone behind the bar again.
"""
hide henrykimg with dissolve
"""
You get through the breakfast rush without losing yourself.  Maybe that made you cocky.  Maybe it was just the surprise of seeing a large group of people come in, eagerly hanging on every word the Alderman's chosen citizen says.

You wonder for a moment, possibly despite yourself, if this will be a story of power.  A chance at control.  But even as you feel yourself falling into the tale, you know that it won't be.

There is suffering and pain here, and if even the Alderman's chosen could not conquer it, what chance do you have?
"""

hide inn with dissolve
call herbalist_5 from _call_herbalist_5
show inn zorder 3 with dissolve

"""

More blood.  Did you have any other choice?  You don't know.  Certainly nothing has changed here.  People begin to move away from the cluster, which means they start to move towards you.  Back to work, but your mind is still flying from thought to thought.  The death, the creatures of the darkness, your gift.  

Something has to be done.  And soon.  

Because you can't control this.  You can't stop yourself from sinking into yet another story.  

A voice you don't recognise.  You don't even look over.  

It just happens.
"""

hide inn with dissolve
call the_boatman from _call_the_boatman
show inn zorder 3 with dissolve


"""

You thought after yesterday, that maybe you'd find a way to control it.  Maybe you'd find a way out.  But each time it is easier.  Like another layer of polish is added and the floor becomes even more slippery.

You are not aware of opening your eyes.  You are not aware of hearing a voice.

You leave the riverside and enter the forest.
"""

hide inn with dissolve
call birthing_tree from _call_birthing_tree
show inn zorder 3 with dissolve
show henrykimg zorder 4 with dissolve:
    xalign 0.05 yalign 0.25
henryk  "[game.player_name]!  [game.player_name]!  Oh I should never have left you alone, Alexis forgive me, [game.player_name] can you hear me?"

"""

Your head hurts, your vision takes many seconds to sharpen.  Your left side is soaked in alcohol from a fallen bottle of moonshine.  Henryk awkwardly bends over you.

It is the same.  Worse.  For minutes you barely remember who you are.  Your life is the blood and bark, flowers and rot, fear and stew.  You have been in four different skins and for a long while it does not seem to matter which one came first.

At some point Henryk got you to your feet and moved you to the cramped kitchen.  You have no idea who is looking after the bar.
"""

if game.ToldHenryk != "Yes":
    henryk """
    There's clearly something very wrong.  I think you need to see Fyodora, but before you go, please, talk to me.

    I care about you.  I want to help you.  And I can see that you know more than you're telling me.

    Please let me help you.

    [game.player_name], please.

    Talk to me.
    """
else:
    henryk """
    I'm so sorry [game.player_name].

    It was stupid, so so stupid to leave you alone here today.  I should just have found someone else to do it, let you wait at home.  I don't know why I didn't.  I was excited, only thinking about my part in this.

    I'm sorry.  I took your tragedy and could only think of myself and how I could help.

    I hope you can forgive me, in time.

    But, and I know this does not forgive it, I did find something.  Elisabetta did have a book about an old sage who could control stories.  It was a fable, but there were things that might be worth trying.  Potions and special ways of thinking.

    I can talk to Joan, if you trust me to.  She can make something for you and you can take a few days off to learn the techniques.

    What do you think?  Do you want to try it?
    """
$textualinsert = "doe"
$textualinsert2 = "doe's already dirty coat"
if game.status_stag == "Alive":
    $textualinsert = "stag"
    $textualinsert2 = "stag's pure coat"

"""
You open your mouth to speak.  Maybe you are sure about what you are going to say, or maybe not.  But you stop.  Your eye catches sight of something out of the small kitchen window.  

It's the [textualinsert], staring right into your eyes.  On its back sits a woman, dirty river water running down her legs and staining the [textualinsert2]

Somewhere close, a wolf howls.

They are right.  It is time.  

Or: there is no more time.

You do it now.
"""
hide henrykimg with dissolve
menu:
    "Henryk, I want to tell you how it all started.  I'd just finished serving breakfast and I saw a Nightwatcher sitting at the end of the bar.":
        $c=3

    "This is odd Henryk, but could you tell me about the conversations you had with the Alderman, just after the sun disappeared?  About how this town should be run." if TakeOver != "Failed":
        $c=7

    "Thank you Henryk.  I'll take the book." if game.ToldHenryk == "Yes":
        $c=2

    "I think I just need to go for a walk in the woods.  Goodbye, Henryk." if game.ForestRunaway == "True":
        $c=1


label cee3:
if c==3:

    """

    The first wave of the morning rush is over and Henryk is circulating around the busy tables while you are left with the usually empty bar.  Except today it isn't empty.  One of the nightwatchers is still here, her scabbed hands encircling a glass of moonshine, her coat, still clogged with white snow, lying on a stool beside her.

    You remember being here.

    You remember her.  You remember being her.  

    You remember {i}why{/i} you are here.

    You hesitate.  Did you talk first last time?  Should you again this time?

    She breaks the stalemate.  She looks directly into your eyes and begins talking.
    """
    "Nightwatcher"  "I saw something strange today.  I was on perimeter watch.  I'm not really supposed to go into the forest, but I've done some hunting and … and I thought I saw something."
    window hide
    with Pause(1)
    show text "The Stag" with dissolve
    with Pause(2)
    hide text with dissolve
    window show

    """
    There is something strange about the cold tonight.  It feels piercing, like a draft through a tear in fabric, but covering your whole body, so that it does not matter how you adjust your furs, the feeling on your skin is constant.

    But you are warm.  Of course you are warm.  You are standing in the inn.  At the bar?  In the kitchen?  Does it matter?

    The second is the glow.

    At first you think it's the moon.  But it's too white, it seems hazy despite the lack of fog tonight, so you look up to the sky and see that the moon is riding high, not sitting low and casting long, swaying shadows.

    Your shadow flickers, lit by fire-light bounced across walls.

    You take a few tentative steps towards it and feel that warmth in you growing.

    Which warmth?
    """
    menu:
        "The warmth of the fire.":
            $c=6

        "The warmth of the stag.":
            $c=4

if c==4:
    """

    A wolf howls.
    """
    show henrykimg zorder 4 with dissolve:
        xalign 0.05 yalign 0.25
    """

    Henryk's eyes meet you.  You can feel his words still filling the room.  You know that they are unchanged.

    A decision has not been made.  Did you even try?  Or is it all simply pointless?  Do you have any power at all?

    Henryk raises an eyebrow.
    """

    henryk "Are you alright [game.player_name]?  Do you need to sit down?  Did you hear me?"

    """

    You can still hear the wolf's howl.  The moment to choose has passed and now it is here again.
    """
    hide henrykimg with dissolve
    menu:
        "Henryk, did you know my parents?  Do you remember how they met?":
            $c=5

        "This is odd Henryk, but could you tell me about the conversations you had with the Alderman, just after the sun disappeared?  About how this town should be run." if TakeOver != "Failed":
            $c=7

        "Thank you Henryk.  I'll take the book." if game.ToldHenryk == "Yes":
            $c=2

        "I think I just need to go for a walk in the woods.  Goodbye, Henryk." if game.ForestRunaway == "True":
            $c=1



if c==6:
    show henrykimg zorder 4 with dissolve:
        xalign 0.05 yalign 0.25
    henryk """

    I just worry for you.  It seemed like you just couldn't hear me.

    Please, tell me what's wrong.  You have seemed distant these last days, even before this.

    Has anything similar happened to you before?  Do you think you should speak to Fyodora?
    """

    """
    You are standing in the kitchen, Henryk looking up at you.

    Somewhere close to the window, a wolf howls.

    Some things have changed.  You know that much.

    But not enough.

    The moment to choose has passed and now it is here again.

    Henryk looks at you expectantly.

    Something more has to be done.
    """
    hide henrykimg with dissolve
    menu:
        "Henryk, did you know my parents?  Do you remember how they met?":
            $c=5

        "This is odd Henryk, but could you tell me about the conversations you had with the Alderman, just after the sun disappeared?  About how this town should be run." if TakeOver != "Failed":
            $c=7

        "Thank you Henryk.  I'll take the book." if game.ToldHenryk == "Yes":
            $c=2

        "I think I just need to go for a walk in the woods.  Goodbye, Henryk." if game.ForestRunaway == "True":
            $c=1
label cee1:
if c==1:

    """

    Henryk gives you a confused look, but he lets you go.  Maybe, if he'd known what you were going to do, he would have stopped you.  But maybe he saw it in your eyes and let you go anyway.

    You will never know.
    """
    hide inn with dissolve
    show bedroom zorder 1 with dissolve
    """

    You return home and pack a small bag of things.  You don't know if you will need any of them.
    """
    hide bedroom with dissolve
    show woods zorder 4 with dissolve
    """

    The forest is a place of darkness in a dark world.  You cannot help but shiver as you pass the treeline."""
    if game.occult_connection >= 14 and game.status_stag == "Alive":
        """
        But you are not cold for long.  A light guides you forward and you feel your body grow warm.  Something soft touches your dangling finger tips.  You do not have to look down to know that the wolf has joined you.

        He guides you forward and then, quite suddenly, you are there.  The structure is small, barely tall enough for you to stand up in or wide enough for you to lie down in, but for all its jaunty angles, you feel warm and safe the moment you step inside.
        """

        "Wolf"  """

        I'll do a better job when the moon shines full again and I can use slaughterer's hands.  But I hope you will be comfortable until then.

        Welcome home, creature of the night.
        """

        """

        The End

        (Ending 1/11)
        """
    else:
        """
        You do not know how long you spend stumbling through the darkness.  You start to lose yourself in a much more physical way than you did back in the warmth of the Wolf and Wheel.  Your fingers disappear to you, then your toes.  Your vision starts to curdle.

        From time to time you hear a howl and each time you do, you stop, turn, and continue towards it.  With your senses swirling around your mind, you are unsure each time whether you are actually getting closer, until suddenly you are there.  The wolf, the [textualinsert]] and the woman stand in a clearing, along with a now scaled, now furry, now bald thing.  The wolf bows slightly to you.
        """
        "Wolf"  """

        We have meat, we have warmth and we have a roof of leaves.

        Welcome home, creature of the night.
        """

        """

        The End

        (Ending 2/11)
        """

label cee2:
if c==2:

    """

    Henryk shows you the relevant chapter, but in the end you read the whole book.  You don't know if it helped.  You don't know if the meditation - a way of thinking from far off Il Fersaai - helped.  You don't know if the potions helped.  You don't know if the hours of storytelling from Henryk, inconsequential tales meant to be a safe training ground for you not to engage with, helped.

    But {i}something{/i} helped.  Because here you are now, just a week later, your mind tinted clear from the potions, your breathing deep, and your mental reflexes sharpened.  

    A hunter at the next table over starts talking about a metal monstrosity she found in the woods.  For a moment you can smell the coal fire and hear the whirr of gears.  But you find the heat of the fire and rough grain of your wooden seat and you are back and what she says are just words.
    """

    if game.town_stability < 7:
        """
        But what good is it?  A week is a long time in the darkness and the world you knew has already gone.
        
        The inn is crowded and ripe with the smells of biology.  Those who stand push up against you in an attempt to keep away from the fire, either out of respect or fear.  Fyodora's clinic is full and the inn has taken in overflow.  A few of the less urgent cases lie on floor mats by the fire, but at least one is only here because the move across the square to the clinic proper would be too much.

        Something in him has gone bad.  You can all smell it.

        Another corner is taken up by a wake.  The body is already gone, lost somewhere in the woods, but the mourners raise toast after toast to the young woman's memory.

        No fights have broken out today.  Perhaps desire has gone, perhaps you are simply in an ebb.  You are told that two people died yesterday.  You can believe it.  You heard it from your house.
        """

        if game.occult_connection < 12: 
            "Somewhere in the distance a wolf howls."

        """
        You live free, free in a doomed world.

        The End

        (Ending 3/11)
        """
    else:
        """
        A week is a long time in the darkness, but the inn is exactly how you left it.  It is comforting, for all its banality.

        Two people argue in a corner and when their friend comes over to settle the debate the loser shrugs and offers to fetch them all a round.

        The front door opens and Fyodora walks in, helping to support one of her patients.  A few people jump up from their seats to help her to deliver a man to a table, where she leaves him, promising that she'll be back to pick him up in an hour and a half.

        Mik walks in with a wheelbarrow filled with viscera and spends some time loudly giving them to Henryk for free.

        A corner of the inn is taken up by Joan and her tea group, Mila sitting comfortably silent, Noah looking out of place but deep in a debate about social restructuring.
        """

        if game.occult_connection < 12:
            """
            Somewhere in the distance, a wolf howls.


            You are free.  Free to live in a world that is dark, dark and, for now, full of hope.
            """
        else:
            "You are free.  Free to live in a world that is dark, dark and full of hope."

        """
        The End

        (Ending 4/11)]
        """

if c==5:

    """

    There are a few moments after the words have left your mouth before Henryk opens his.  It will happen.  You have no choice.  You will be there.  You will pluck at what was.  Even if you try not to, you will.

    But you were not there, the first time.  You do not know how it was supposed to go.

    Will you come back different?  Different thoughts, different hair, different eyes?  

    Or will you simply not come back at all?

    With a single question, an involuntary power, have you ripped your page of history from the world and consigned it to the flames?

    Henryk's lips begin to move and you are somewhere else, something else.

    For the last time feeling the warmth of the sun.

    The End

    (Ending 5/11)
    """


if c==7:
    show henrykimg zorder 4 with dissolve:
        xalign 0.05 yalign 0.25
    "Henryk raises an eyebrow, but you know him well enough to know that he will not deny you."

    henryk "Well it was in the Alderman's meeting room.  I don't know if you've ever been in there, but he has a long wooden table and …"
    hide henrykimg with dissolve
    window hide
    with Pause(1)
    show text "The Meeting" with dissolve
    with Pause(2)
    hide text with dissolve
    window show

    """

    You are tired and sore from the effort of helping the others get you up the stairs.  They never look too stable to you and you are sure that one day the makeshift ramps and multiple people pushing you will cause something in their structure to break.

    But you're letting your mind wander.  You rub your legs - the echo of the pain that never leaves them particularly bad today - and you look at the faces around you.  The Alderman to your left, Fyodora opposite you, Joan to your right.  A bartender, a doctor, a herbalist and the Alderman, the only one not out of place.

    You make an odd council.

    The Alderman's head is hanging down as if his strings have been cut.
    """
    show joanimg zorder 4 with dissolve:
        xalign 0.05 yalign 0.25
        
    joan  "It's not your policies Alexi.  They're not bad policies.  At least, that is what I believe."

    "The others nod."
    show fyodoraimg zorder 4 with dissolve:
        xalign 0.5 yalign 0.25
    fyodora  """

    They're not bad at all.  I … I don't understand.  Why?  Why would they do this?  How could they leave?  You're doing the best you can with our resources, we're not close yet to running out of anything and I didn't think it would be possible but you've actually got people out there getting more.

    But how much did they take?  I've seen your plans, Alderman, they're good.  Fair and practical.  And we are bringing in far more than I thought possible, but we need stores.  We need backups.  Did they take everything?
    """

    "The Alderman shakes his head."
    show aldermanimg zorder 4 with dissolve:
        xalign 0.95 yalign 0.25

    alderman  "I have the accounts here.  In summary, less than they could have taken.  I'm not sure why that is."

    fyodora  "Human decency?  Practicality?  They couldn't carry that much?"

    alderman  "No, I don't believe so.  Let me check our supply of wagons and transportation equipment …"

    joan  """

    If I can just say, and I'm sorry to interrupt, but I'm not sure it matters why they took what they took.  They're gone and we won't solve anything by talking about {i}how{/i} they left.  It's painful, I know that, but I think we should talk about {i}why{/i} they left.

    I don't think anything you could have done would have made them stay Alexi.  They wanted something you couldn't have given them, something you shouldn't have given them.  

    It's very sad, very very sad, that they are gone and that our friends and neighbours left with them.  But they wanted something that Lotosk should never be.

    You showed goodness and compassion Alexi.  They did not like that, but it is something you should always be proud of.

    But there is something else.  They left because they did not feel heard.  I do not believe that it was a lack of food, or warmth, or shelter.  It was emotional.  

    Do not blame yourself Alexi.  In their case, what they were asking for, it wasn't something we could give.  But things will be harder now.  And there will be others.  It's natural that people will feel alone.  Especially now.

    You've done a wonderful job of keeping everything going Alexi.  But we need more.  The people need to feel that they matter, that they're heard.  Do you understand?
    """

    "Alexi slowly brings his eyes around to meet Joan's.  They look wet and sunken.  The eyes of a man too tired to step off the path that he has chosen, the eyes of a man too trapped to ask for help."

    fyodora  """

    They need a guide too.  People don't know how they should be.  And with good reason.  They're scared, they don't know whether they should panic or work or drink or try to grasp every pleasure that they can before it's too late.

    They need someone who can inspire them.  No, maybe that's the wrong word.  Guide is wrong too.  Just, someone who can be an example.  Like an anchor, someone solid whom folks can look at and think 'they're not lost, they know what to do, why don't I do what they do too?'
    """

    "The Alderman speaks quietly."

    alderman  "I can't do that."

    "There is a moment of silence.  Fyodora sits unnaturally still, but Joan nods."

    joan  "You're a good man Alexi.  And a fine leader.  But no, you can't do that.  It's not who you are.  It's not who I am.  And Henryk, Fyodora, you can't do it either.  What you do is too specialised.  People can't do what you do, so they won't try."

    fyodora  "So who?"

    "There is a moment of silence in which you remember who you are.  You know how this story is supposed to end, you know what name they are supposed to say.  But no-one has said it yet.  In a moment they might, but not yet."
    menu:
        "*Stay silent*":
            $c=8

        "I think [game.player_name] would be an excellent choice.":
            $c=13

        "Why don't we wait to make this decision?  The world is changing, things are coming out of the woods.  Shouldn't we try to make contact with them before we set anything in stone?":
            $c=9

if c==8:

    """

    Just a moment more passes before Fyodora suggests the person you know was suggested.  Joan agrees instantly and the Alderman concurs.  

    It is too late already.  They are already making plans.  Someone has already sent for the person whom you already know as the Alderman's helper.

    Which is, of course, also the end of the story.
    """
    hide aldermanimg with dissolve
    hide fyodoraimg with dissolve
    hide joanimg with dissolve
    show henrykimg zorder 4 with dissolve:
        xalign 0.05 yalign 0.25
    """

    Henryk smiles and then looks at you thoughtfully.
    """

    henryk "[game.player_name], why exactly did you want to hear that?"

    """

    You shrug.  You don't know.  If it was to take your chance, then you failed.  So why did you listen?

    A wolf howls, more urgent, more desperate than before.  You feel yourself as it for a moment, the cold air sharp but reassuring as you suck it into your throat, snow stuck between the pads of your feet.

    You do not pull yourself back.  The story was just a single note.  A word.  But it was enough.

    Whatever you do, you must do it now.
    """
    $TakeOver = "Failed"
    menu:
        "Henryk, I want to tell you how it all started.  I'd just finished serving breakfast and I saw a Nightwatcher sitting at the end of the bar.":
            $c=3
            jump cee3
        "Thank you Henryk.  I'll take the book." if game.ToldHenryk == "Yes":
            $c=2
            jump cee2
        "I think I just need to go for a walk in the woods.  Goodbye, Henryk." if game.ForestRunaway == "True":
            $c=1
            jump cee1

if c==9:

    "The Alderman looks up, clearly surprised."

    alderman  "Things from the woods?  I have heard reports of monsters, but you believe we should talk to these things?  And are you suggesting that we make them part of our political discourse?"

    "Fyodora is failing to keep disgust from her face, but Joan leans in to defend you."

    joan  "Do you remember the old faith, Alexi?  The faith of spirits?  I know you do not believe, I know you are loyal to the pantheon, but Henryk may be right.  There may be things out there that could help us."

    "The Alderman turns to you."
    menu:
        "Joan is right.  I've spoken to people who have said that they have met kindly, intelligent beings in the woods since the sun disappeared.":
            $c=11

        "You should be cautious Joan.  Not all the things in the forest are kind.":
            $c=10

if c==10:

    "The Alderman shakes his head, clearly confused."

    fyodora  "I find it odd to be saying this, but I highly advise against introducing monsters into our society.  Our priority should be {i}people{/i}.  I treated a man who claimed to have been attacked by a creature made of shadows.  I have never seen wounds like his.  He says his pain was indescribable and after examining him I believe that he was telling the truth."

    "Joan looks pained and says nothing.  The Alderman turns back to you and shakes his head."

    alderman  "I'm glad that you have these ideas Henryk, but I'm afraid that this time I just don't see the sense in it."

    """

    You open your mouth to reply, but before you can Fyodora has moved the conversation on.

    Yes, yes you heard correctly.  She just said the name.  Joan agrees instantly and the Alderman concurs.  

    It is too late already.  They are already making plans.  Someone has already sent for the person whom you already know as the Alderman's helper.

    Which is, of course, also the end of the story.
    """
    hide aldermanimg with dissolve
    hide fyodoraimg with dissolve
    hide joanimg with dissolve
    show henrykimg zorder 4 with dissolve:
        xalign 0.05 yalign 0.25
    """
    Henryk smiles and then looks at you thoughtfully.
    """

    henryk "[game.player_name], why exactly did you want to hear that?"

    """

    You failed.  There is little else you can do but shrug.

    A wolf howls, more urgent, more desperate than before.  You feel yourself as it for a moment, the cold air sharp but reassuring as you suck it into your throat, snow stuck between the pads of your feet.

    You do not pull yourself back.  The story was just a single note.  A word.  But it was enough.

    Whatever you do, you must do it now.
    """
    $TakeOver = "Failed"
    menu:
        "Henryk, I want to tell you how it all started.  I'd just finished serving breakfast and I saw a Nightwatcher sitting at the end of the bar.":
            $c=3
            jump cee3
        "Thank you Henryk.  I'll take the book." if game.ToldHenryk == "Yes":
            $c=2
            jump cee2
        "I think I just need to go for a walk in the woods.  Goodbye, Henryk." if game.ForestRunaway == "True":
            $c=1
            jump cee1

if c==11:

    "The Alderman nods his head slowly."

    fyodora  "I find it odd to be saying this, but I highly advise against introducing monsters into our society.  Our priority should be {i}people{/i}.  I treated a man who claimed to have been attacked by a creature made of shadows.  I have never seen wounds like his.  He says his pain was indescribable and after examining him I believe that he was telling the truth."

    "Joan looks pained and says nothing.  A desperate argument starts to rise up your throat, but the Alderman cuts you off."

    alderman  """

    That is truly horrific Fyodora.  You must take me to the man, I should speak to him.  But if there are beasts of that ferocity in the woods, and I have no reason to doubt you or one of our citizens, then surely our situation is even more dire than we had realised.

    Oh Casimir, are you looking down on us now?

    But since I have no reason to doubt any of our citizens, I also trust Henryk.  I wish to speak to you more on this Henryk.  But for now you have given me something to think about.

    I fear that this darkness is driving me mad.

    We shall see.  May I ask that you all return tomorrow?  I had not expected the conversation to take this turn.  I must think.

    Oh Casimir, give me the strength you had.
    """

    $c=12


label cee12:
if c==12:
    if game.occult_connection >= 12:
        hide aldermanimg with dissolve
        hide fyodoraimg with dissolve
        hide joanimg with dissolve
        """
        The story fades quickly, the sounds around you shifting, cold biting through your clothes.

        One of your hands is wet.  The other is warm.  You look to your left and see Henryk, smiling as he gazes into the centre of the circle.  You look to your right and see the woman with pondweed hair.  She smiles too, although her face is crooked and her eyes are locked with yours.

        She and you are the only two who are not chanting.

        In the centre of the clearing is what might be a woman or might be a tree.  The darkness is thick, and even if it weren't, you can only catch glimpses as the next circle ahead of you flies past: shapes, mostly human, dancing wildly across rough forest floor.

        The beat comes from all around, above and below you.  You look up and see only darkness.  You look down and see movement.  Something pushing in and out.

        You stoop and pick up the heart.  It's green and warm and smooth.  Too many veins and arteries run from it and disappear into the earth.
        """
        show henrykimg zorder 4 with dissolve:
            xalign 0.05 yalign 0.25

        henryk "You hungry?"

        "You must look confused, because Henryk laughs and leans down to scoop up another heart that lies by his feet.  With a swift motion of his head he slices his teeth through one of the vessels and drinks deep of a liquid too viscous to be normal blood.  It runs down his chin and stains his already muddy clothes."

        henryk "To your health [game.player_name].  May it last for all time!"

        """

        The End

        (Ending 6/11)
        """
    else:
        $reanimated = ""
        if game.status_stag == "Dead":
            $reanimated = ", reanimated"

        """
        The story fades quickly, sounds around you shifting.  You feel cold, but not bitingly so.  There is wood under your hands, wood you know very well.

        The bar of the Wolf and Wheel.

        You open your eyes and they take a moment to adjust to the gloom.  The fire is not lit and from the damp in the wood under your fingers you would guess that it has not been lit for some time.

        The room is busy, if not crowded.  Figures slither across the floor, perch on tables and roost in the rafters.  Bodies of so many sizes, shapes and textures that you could not begin to describe any.

        Three stand out, standing in the centre.  The wolf, the woman with pondweed hair, and the stag[reanimated].

        Of other people, humans, there is not a sign.

        The wolf awkwardly pulls its lips back.  It takes a moment for you to understand that it is attempting to smile.

        It appears calculated.  Vicious.

        The woman with pondweed hair looks down at the wolf and then back at you.  She laughs.

        The stag hangs its head and looks away.  You notice that it no longer glows.

        The wolf nods towards you.
        """

        "Wolf"  """

        You are back?  Welcome to the new world.

        We owe it to you.

        We are here now.  Your kind.

        Welcome to your new old world, fellow creature of the night.

        The End

        (Ending 7/11)
        """


if c==13:

    alderman  "[game.player_name]?  The one who helps you run the inn?  Why?"
    menu:
        "[game.player_name] is hard working, no-one will be a better example.":
            $game.town_stability +=2
            $c=17

        "[game.player_name] is kind, no-one will do better at making everyone and everything feel safe.":
            $game.town_stability +=1
            $game.occult_connection +=1
            $c=17

        "I've talked to [game.player_name] about the dark and no-one understands it better.  [game.player_name] will do everything possible to purge the woods of monsters.":
            $c=16

        "I've talked to [game.player_name] about the dark and no-one understands it better.  [game.player_name] will make contact with the creatures of the forest and help make a truly unified society.":
            $c=15

        "[game.player_name] is ruthless, no-one will be able to help you control the town better.":
            $c=14



if c==14:

    alderman  "No, no I'm sorry Henryk but I don't think that would be appropriate.  That's not the sort of person I think I'm looking for at all.  This is a time for social unity and I think that calls for kindness, not ruthlessness."

    """

    Just a moment more passes before Fyodora suggests the person whom you know was suggested.  Joan agrees instantly and the Alderman concurs.  

    It is too late already.  They are already making plans.  Someone has already sent for the person whom you already know as the Alderman's helper.

    Which is, of course, also the end of the story.

    """
    hide aldermanimg with dissolve
    hide fyodoraimg with dissolve
    hide joanimg with dissolve
    show henrykimg zorder 4 with dissolve:
        xalign 0.05 yalign 0.25
    """

    Henryk smiles and then looks at you thoughtfully.
    """

    henryk "[game.player_name], why exactly did you want to hear that?"

    """

    You shrug.  You don't know.  If it was to take your chance, then you failed.  So why did you listen?

    A wolf howls, more urgent, more desperate than before.  You feel yourself as it for a moment, the cold air sharp but reassuring as you suck it into your throat, the snow stuck between the pads of your feet.

    You do not pull yourself back.  The story was just a single note.  A word.  But it was enough.

    Whatever you do, you must do it now.
    """
    $TakeOver = "Failed"
    menu:
        "Henryk, I want to tell you how it all started.  I'd just finished serving breakfast and I saw a Nightwatcher sitting at the end of the bar.":
            $c=3
            jump cee3
        "Thank you Henryk.  I'll take the book." if game.ToldHenryk == "Yes":
            $c=2
            jump cee2
        "I think I just need to go for a walk in the woods.  Goodbye, Henryk." if game.ForestRunaway == "True":
            $c=1
            jump cee1


if c==15:

    "The Alderman nods his head slowly."

    fyodora  "I find it odd to be saying this, but I highly advise against introducing monsters into our society.  Our priority should be {i}people{/i}.  I treated a man who claimed to have been attacked by a creature made of shadows.  I have never seen wounds like his.  He says his pain was indescribable and after examining him I believe that he was telling the truth."

    "Joan looks pained and says nothing.  A desperate argument starts to rise up your throat, but the Alderman cuts you off."

    alderman  """

    That is truly horrific Fyodora.  You must take me to the man, I should speak to him.  But if there are beasts of that ferocity in the woods, and I have no reason to doubt you or one of our citizens, then surely our situation is even more dire than we had realised.

    Oh Casimir, are you looking down on us now?

    But since I have no reason to doubt any of our citizens, I also trust Henryk.  I wish to speak to you and [game.player_name] about this this more Henryk.  I can't see any harm in at least talking.

    Can you bring [game.player_name] here Henryk?  We might as well do this now.
    """

    #note: screen fade to black.
    hide aldermanimg with dissolve
    hide fyodoraimg with dissolve
    hide joanimg with dissolve
    show henrykimg zorder 4 with dissolve:
        xalign 0.05 yalign 0.25
    henryk "And that's it [game.player_name], at least, you know all the rest."
    
    $c=12
    jump cee12


if c==16:

    "The Alderman nods slowly, but it is Fyodora who shows true enthusiasm."


    fyodora  """

    I realise that they may not be your first concern Alderman, but I think Henryk is right.  I don't know about [game.player_name]'s credentials, but these monsters are a real threat to our people.  

    Just yesterday I treated a man who claimed to have been attacked by a creature made of shadows.  I have never seen wounds like his.  He says his pain was indescribable and after examining him I believe that he was telling the truth.
    """

    "Joan takes in a breath and then lets it out as a sad sigh, but she does nothing more than shake her head."

    alderman  """

    It is not what I had thought.  But perhaps you are right and I am overly concerned with more … mundane issues.

    I wish to speak to you and [game.player_name] about this this more Henryk.  I can't see any harm in at least talking.

    Can you bring [game.player_name] here Henryk?  We might as well do this now.
    """
    hide aldermanimg with dissolve
    hide fyodoraimg with dissolve
    hide joanimg with dissolve
    #note: screen fade to black.
    show henrykimg zorder 4 with dissolve:
        xalign 0.05 yalign 0.25
    henryk "And that's it [game.player_name], or at least you know all the rest."

    """

    The story fades quickly, the sounds around you shifting, the warmth around you changing.

    There is something soft under your hands.  You flex your fingers and feel that the pelt is wet.

    Your clothes are wet.  You open your eyes and see blood.  Under your fingers is a body, bullet and bayonet wounds still slowly leaking blood.  

    Even though it has been butchered, you recognise the wolf.
    """
    if game.town_stability >=10:

        """
        You look up and as you do the people begin to cheer.

        You stand behind the bar, but that is the only part of the scene before you that is familiar.  Each table is covered not with food and drink, but with bodies.  Bodies of so many sizes, shapes and textures, each so mangled and butchered, that you could not begin to describe any.

        The people, young and strong, look to you.  Their clothes are ripped and torn, soiled with mud and blood and other viscera you cannot place.  Most stand by tables, displaying their trophies.
        """

        "Man"  "The wolf is dead, long live Lotosk!"

        "Woman"  "Humanity stands victorious!"

        "The crowd cheers again and it has barely finished when the young man you know as the fisher who found the statues climbs atop a table and starts a new chant."

        "Fisher"  """

        We couldn't have done it without you!

        For [game.player_name]!  For [game.player_name]!
        """

        """

        The room takes up the chant.

        You do not know what war you find yourself the hero of.  But it is clear that you were the victor.

        What happens next, it would appear, is completely up to you.

        The End

        (Ending 8/11)
        """
    else:
        """
        You look up and as you do the people meet your eyes.

        You recognise them all, the elderly of Lotosk, children sitting confused beside them.  Many are missing.  There are some other faces, the faces of workers or hunters, but there are few.

        You stand behind the bar of the Wolf and Wheel, but the room feels different, cold and damp and dark.  Can it only be that the fire is not lit?  By the feeling of the wood of the bar upon which the wolf rests, it has not been lit for some time.

        The people all seem to be waiting for you to speak, but when you don't Joan stands up and all eyes turn slowly to her.

        """
        show joanimg zorder 4 with dissolve:
            xalign 0.05 yalign 0.25
        joan  """

        I think it is time for us to move on.  We have killed the wolf and, if [game.player_name] is right, that should mean we are safe from the monsters of the woods.

        So we must turn our attention to other things.  If our Alderman were still with us, he would be telling us to focus on food and fuel for fires.  We have defeated one enemy, but it is time we turned all our attention to the others.  Cold and starvation.

        That is how we can honour those whom we have lost in the battles against the night beasts.  They would not want us to die now, after all they have sacrificed.

        So I implore you, all the people of Lotosk, we must not lose hope.  We may be all that is left, but we can survive.

        We must.
        """
        hide joanimg with dissolve
        """

        One or two people clap, but most just sit silently in the dark.

        No-one seems to know what will happen next.

        And neither do you.

        The End

        (Ending 9/11)
        """
if c==17:

    "The Alderman nods slowly."

    alderman  "That is certainly a good recommendation.  Does anyone else know [game.player_name]?  Any objections?"

    "Fyodora and Joan shake their heads."

    alderman  "Can you bring [game.player_name] here Henryk?  We might as well talk it out now."

    #note: screen fade to black.
    hide aldermanimg with dissolve
    hide fyodoraimg with dissolve
    hide joanimg with dissolve
    show henrykimg zorder 4 with dissolve:
        xalign 0.05 yalign 0.25
    henryk "And that's it [game.player_name], at least, you know all the rest."
    if game.occult_connection >=12:
        $c=12
        jump cee12
    else:
        """
        The story fades quickly, the sounds around you shifting, the warmth around you changing.
        """
        if game.town_stability < 7:
            """
            The inn is crowded and ripe with the smells of biology.  Those who stand push up against you in an attempt to keep away from the fire, either out of respect or fear.  Fyodora's clinic is full and the inn has taken in overflow.  A few of the less urgent cases lie on floor mats by the fire, but at least one is only here because the move across the square to the clinic proper would be too much.

            Something in him has gone bad.  You can all smell it.

            Another corner is taken up by a wake.  The body is already gone, lost somewhere in the woods, but the mourners raise toast after toast to the young woman's memory.

            Someone begins to tell a story of a fight that broke out yesterday and claimed the life of two people.  Your stomach sinks, but you stay where you are, lost enjoying the sound of words simply rolling over you.

            Until you hear the last ones: \"And it's all [game.player_name]'s fault.\"

            It is only now you realise that everyone is looking at you.  Not directly, but none let you leave the corner of their eye.  Everyone is ready.  It is not difficult to tell which ones wish to attack and which ones would stand to defend you.  There are many more of the former than the latter.

            But no-one moves.  At least not now.

            This is your town, you realise.  At least for today.

            It will not last long.

            The End

            (Ending 10/11)
            """
        else:
            """
            The inn looks the same.  Two people argue in a corner and when their friend comes over to settle the debate the loser shrugs and offers to fetch them all a round.

            The front door opens and Fyodora walks in, helping to support one of her patients.  A few people jump up from their seats to help her to deliver a man to a table, where she leaves him, promising that she'll be back to pick him up in an hour and a half.

            Mik walks in with a wheelbarrow filled with viscera and spends some time loudly giving them to Henryk for free.

            A corner of the inn is taken up by Joan and her tea group, Mila sitting comfortably silent, Noah looking out of place but deep in a debate about social restructuring.

            And through all of it, you do nothing but listen.  Words roll over you and you see everything that your eyes can see and nothing more.

            More than one person sees you and raises a glass in your direction.  You overhear a conversation between a group of workers praising your innovative new ideas.
            """
            if game.occult_connection < 12:
                """
                Somewhere in the distance, a wolf howls.


                This is your town, you realise.  A town that is dark, dark and, for now, full of hope.
                """
            else:
                "This is your town, you realise.  A town that is dark, dark and full of hope."

            """
            The End

            (Ending 11/11)
            """
return