/*
 *
 * The Xylophonad
 *
 * Persons
 *
 * code and data dealing with people
 *
 */

var Person = new Object;
NUM_CHRS = 0;
function ch(name,fullname,ishere,pname,male,female,firstplace,description,talks,subjects,reactions,presents,mannerisms,sights,special,
            daemonBefore,daemonAfter)
{
	Person[++NUM_CHRS] = new Object;
	Person[NUM_CHRS].id = NUM_CHRS;
	Person[NUM_CHRS].name = name; // variable name and recognised word
	Person[NUM_CHRS].fullname = fullname; // name displayed in output
	Person[NUM_CHRS].ishere = ishere; // special string for "Aunt Cedilla is here."
	Person[NUM_CHRS].pname = pname; // true for proper names
	Person[NUM_CHRS].male = male;
	Person[NUM_CHRS].female = female;
	Person[NUM_CHRS].impersonal = (!male && !female);
	Person[NUM_CHRS].firstplace = firstplace; // starting place
	Person[NUM_CHRS].description = description;
	Person[NUM_CHRS].talks = talks; // default talks
	Person[NUM_CHRS].subjects = subjects; // talks about specific tokens
	Person[NUM_CHRS].reactions = reactions; // reactions to 'foo cedilla'
	Person[NUM_CHRS].presents = presents; // reactions to certain Things
	Person[NUM_CHRS].mannerisms = mannerisms; // mannerisms
	Person[NUM_CHRS].sights = sights;
	Person[NUM_CHRS].special = special;
	Person[NUM_CHRS].daemonBefore = daemonBefore; // daemons (run every turn, whether or not hero is here!)
	Person[NUM_CHRS].daemonAfter = daemonAfter;
	eval(name + ' = Person[' + NUM_CHRS + '];');
	eval('words(\'' + name.toLowerCase() + '\')');

	Person[NUM_CHRS].is_carrying = {};
	Person[NUM_CHRS].tryToTake = {};
	
}

function default_react(action,person)
{
	var str = '';
	if(action=='fight')
		str = 'You take a swing, but ' + the_person(person) + ' ducks it.'
	else if(action=='kiss')
		str = 'I don\'t think you and ' + the_person(person) +
		  ' are close enough for that.'
	else if(action=='wake' && asleep(person))
		str = capitalise(the_person(person)) + ' won\'t wake up.'
	else if(action=='wake')
		str = capitalise(the_person(person)) + ' isn\'t asleep!';

	if(str=='')
		return(false);

	say(str);
	return(true);
}

/*
 *  Diogenes the philosopher
 */

ch('diogenes',
'Diogenes',
'Diogenes, a bedraggled-looking philosopher, sits in a barrel shouting insults at passersby.',
true,
true,
false,
plaza,
"Diogenes is a scruffy-looking fellow with a dark beard, wearing a grubby toga. He is standing \
in an old wine barrel, from which he leers and shouts insults at anyone who'll listen, and many who won't. \
He's a philosopher. It's his thing.",
[
	"=Scram!",
	"=Hey lady! I have serious disagreements with your interpretation of the nature of existence!",
	"=You! Yeah, you! Your mom exists as the only spark of consciousness she can be sure of in an unknowable universe!"
],
{
	barrel: "=It's a philosopher thing. People should be less obsessed with material wealth and status. \
	         Besides, have you <i>seen</i> the house prices in this city?",
	
	daedalus: '=Yeah, I know Daedalus," says Diogenes gruffly. "Lives on an island somewhere. \
	           Stupid opinions. Thinks scientific knowledge should be used to <i>do</i> things.',
	bicyclops: 'Diogenes spits. "Two-eyed hairy bastard."',
	troy: "=It's an imperialist outrage, that war. All about lamp-oil and money.",
	helen: "=She's one fine lady, all right. I hope they bring her back safe.",
	soldiers: "=It's an imperialist outrage, that war. All about lamp-oil and money.",
	trojan: "=It's an imperialist outrage, that war. All about lamp-oil and money.",
	hades: "Diogenes tells you to go to hell in a handcart.",
	god: "=Gods? Pah! Swan about like they own the place.",
	eurystheus: '"Sure, he\'s a bit of a sod, but what you gonna do? People ain\'t gonna oppress themselves."',
	theatre: '"That Thespis is in everything these days. I\'m getting sick of his stupid cheekbony face."',
	thespis: '"That Thespis is in everything these days. I\'m getting sick of his stupid cheekbony face."',
	medusa: '"She\'s a woman terribly wronged. I bet if anyone cared, they could find a way to lift her curse."',
	
},
{
	fight: "You take a swing, but Diogenes ducks into his barrel.",
},
{
},
[	"Diogenes belches loudly.",
	"Diogenes shouts \"Scram!\"",
	"Diogenes blows a raspberry.",
],
{	barrel: "An old oak wine barrel, darkened by age and mildew. \
	         You're not sure why anyone would want to live there, but it seems \
	         to meet Diogenes' needs."
},
{},
function() {
	if(heroloc()==personloc(diogenes)) {
		for(var i=1; i<=MAX_TOKENS; ++i) {
			if(Token[i]=='philosopher') {
				Token[i]='diogenes';
			}
		}
	}
},
null);
diogenes.synonyms = ['oscar', 'philosopher', 'man', 'grouch']

/*
 *   Daedalus
 */
ch('daedalus',
'Daedalus',
'Daedalus, the inventor, stands here' +
 '[[ gs(BUILT_BICYCLE) && personloc(daedalus)==outside_daedalus_hut ? ", holding out the bicicicle eagerly" : "" ]].',
true, true, false,
nowhere,
"A middle-aged man with a bristly beard and a toga, constantly scratching his head and muttering little \
calculations to himself.",
[
	"[[ talk_daedalus() ]]",
],
{
	bicyclops: '"Oh, he\'s simply beastly. If you help me with my invention, we\'ll be able to get rid of him. Clean up the neighbourhood once and for all."',
	coldbox: '"That\'s another invention of mine. It\'s a box for keeping food cold. I named it after the kingdom of Phrygia ' +
	          'in Anatolia. Behold, the Anatoliarator!"',
	troy: '"It\'s an awful war. All the great thinkers were against it."',
	soldiers: '"It\'s an awful war. All the great thinkers were against it."',
	diogenes: '"He just sits in a barrel and shouts. Never makes anything practical. Philosophy should be <i>applied."</i>',
	sappho: '"She\'s a pleasant lady to have for a neighbour. Artsy. And her cat is lovely."',
	hades: '"The story goes that there\'s a path to Hades from this island. I haven\'t found it myself, though."',
	helen: '"Oh, have you met Helen of Troy? She\'s lovely. I do hope she\'s safe, wherever she is."',
},
{},
{
	kithara: "[[ give_daedalus(kithara) ]]",
	cartwheels: "[[ give_daedalus(cartwheels) ]]",
	saddle: "[[ give_daedalus(saddle) ]]",
	
},
[],
{},
{},
function() {
	if(personloc(daedalus)==heroloc()) {
		for(var i=1; i<=MAX_TOKENS; ++i) {
			if(Token[i]=='philosopher') {
				Token[i]='daedalus';
			}
		}
	}
},
function() {
	if(!gs(MET_DAEDALUS_IN_WORKSHOP) && heroloc()==daedalus_workshop && personloc(daedalus)==daedalus_workshop) {
		say('\n\n"Welcome," says Daedalus with a smile. "Excuse the labyrinth. Experiment of mine. Now, I\'ve been ' +
		 "thinking about how to beat this dreadful Bicyclops " +
		 "that lives on my island. Thing's a nuisance, always eating sailors, terrible for trade. My thinking is we could " +
		 "charge it with an appropriate vehicle. I've got plans for such a vehicle, in my head anyway. I'll need a suitable frame, " +
		 "and some wheels of course.\"");
		sgs(MET_DAEDALUS_IN_WORKSHOP, 1);
	}
	
	if(gs(BUILT_BICYCLE) && heroloc()==outside_daedalus_hut && personloc(daedalus)==outside_daedalus_hut) {
		say('\nDaedalus holds out the bicicicle eagerly. "Come on, get on the bike! That\'s a short name for it I just invented."');
	}
	
	if(thingloc(saddle)==daedalus_workshop && !gs(GAVE_DAEDALUS_SADDLE)) {
		say('\n');
		give_daedalus(saddle);
	}
	if(thingloc(kithara)==daedalus_workshop && !gs(GAVE_DAEDALUS_FRAME)) {
		say('\n');
		give_daedalus(kithara);
	}
	if(thingloc(cartwheels)==daedalus_workshop && !gs(GAVE_DAEDALUS_WHEELS)) {
		say('\n');
		give_daedalus(cartwheels);
	}
}
);
function talk_daedalus() {
	if(gs(FINISHED_BICYCLOPS)) {
		say('"Hallo! How\'s the adventuressing coming on?"');
	} else if(gs(BUILT_BICYCLE)) {
		say('"Go on, get on the bike!"');
	} else if(!(gs(GAVE_DAEDALUS_FRAME) && gs(GAVE_DAEDALUS_WHEELS))) {
		say('"I\'ll need a frame and some wheels."');
	} else {
		say('"I\'ll need a saddle of some sort."');
	}
}
function give_daedalus(th) { // only called for things daedalus actually wants!
	if(th==kithara) {
		say('"Aha!" says Daedalus, taking the kithara. "This looks like a decent frame.' +
		     '[[ gs(GAVE_DAEDALUS_WHEELS) ? \'\' : \' It still needs wheels, of course.\' ]]"');
		get_point_for(GAVE_DAEDALUS_FRAME);
		take_away(kithara);
		set_thingloc(kithara, daedalus_workshop);
	} else if(th==cartwheels) {
		say('"Wheels! Excellent!" says Daedalus, taking the cartwheels.' +
		    '[[ gs(GAVE_DAEDALUS_FRAME) ? \'\' : \'"Of course, I\\\'ll need a frame to attach them to."\' ]]');
		get_point_for(GAVE_DAEDALUS_WHEELS);
		take_away(cartwheels);
		set_thingloc(cartwheels, daedalus_workshop);
	} else if(th==saddle) {
		if(gs(GAVE_DAEDALUS_FRAME) && gs(GAVE_DAEDALUS_WHEELS)) {
			say('"A saddle! Excellent!" says Daedalus, taking it from you."');
		} else {
			say('"A saddle?" says Daedalus, taking it from you. "I suppose it might come in handy."');
		}
		take_away(saddle);
		set_thingloc(saddle, daedalus_workshop);
		get_point_for(GAVE_DAEDALUS_SADDLE);
	}
	
	if(gs(GAVE_DAEDALUS_FRAME) && gs(GAVE_DAEDALUS_WHEELS) && !gs(GAVE_DAEDALUS_SADDLE)) {
		say('\n"Now," says Daedalus, "I just need to attach the two wheels to the frame and &ndash; ah. I suppose the pilot will ' +
		    'need somewhere to sit..."');
	}
	
	if(gs(GAVE_DAEDALUS_FRAME) && gs(GAVE_DAEDALUS_WHEELS) && gs(GAVE_DAEDALUS_SADDLE)) {
		// finished the bicycle!
		say('\n\n"That\'s everything!" says Daedalus, taking a claw-shaped tool from a shelf and tinkering with the various components. ' +
		     '"A couple of wheels to make the thing go, a frame to hold it together, and a saddle for the rider to sit on... there!"\n' +
		     'He assembles the bits and bobs into a strange, thin contraption with two wheels, one in front of the other. "I shall name my invention," says ' +
		     'Daedalus proudly, "after a particularly tremendous icicle that I once saw on the River Bic in winter. Behold, ' +
		     'the Bicicicle!\n' +
		     '"Now, if you would do the honour of giving it a test-ride? Come on..." He wheels the contraption out of the hut.');
		sgs(BUILT_BICYCLE, 1);
		set_thingloc(kithara, nowhere);
		set_thingloc(cartwheels, nowhere);
		set_thingloc(saddle, nowhere);
		set_personloc(daedalus, outside_daedalus_hut);
	}
	
	
}



/*
 * King Eurystheus
 * The king of Anachronopolis, who gives you the three labours at the beginning
 */
//ch(name,fullname,ishere,pname,male,female,firstplace,description,talks,subjects,reactions,presents,mannerisms,sights,special,daemon)
ch('eurystheus',
'King Eurystheus',
'King Eurystheus [[personloc(eurystheus)==courtroom ? "sits on the throne" : "stands here"]].',
true, true, false,
courtroom,
"King Eurystheus is a copper-skinned, muscular man, wearing a golden headband and a silk toga with ornate blue trimming.[[ \
personloc(eurystheus)==courtroom ? ' He sits on the throne with an amused smile, holding a copper goblet.' : '' ]]",
["[[ talk_eurystheus() ]]"],
{
	troy: '"You\'d better pray you\'ll figure out a way to get there."',
	soldiers: '"Well, what would you have done about the Trojans? Just let them carry on being Trojan?"',
	trojan: '"Well, what would you have done about the Trojans? Just let them carry on being Trojan?"',
	helen: '"She\'s a national treasure, that girl. If anything happens to her, I\'m holding you accountable."',
	hades: '"I believe it\'s in roughly that direction," says the king, pointing a hand downwards.',
	bicyclops: '"As if Cyclopses weren\'t freakish enough, one with <i>two</i> eyes? Euch! I want it dead."',
	goblet: 'The king takes a long draught. "No, you can\'t have any."',
	wine: 'The king takes a long draught. "No, you can\'t have any."',
	diogenes: 'The king looks sour. "That philosopher\'s set up home on my doorstep, and now my advisers tell me I can\'t burn down his barrel while he sleeps in it."',
	daedalus: '"He\'s a crackpot. I hope the Bicyclops gets him."',
	medusa: '"There\'s an idea. Why not go and take a long, hard look at her?"',
},
{
	kiss: "The king reaches out a hand for you to kiss, then subtly flips you the &nu;'s as as he withdraws it.",
	fight: fight_king
},
{
},
["King Eurystheus takes a swig of wine.",
 "King Eurystheus glares at you.",
 'King Eurystheus slouches languidly in his throne.'],
{
	goblet: "A copper goblet smelling of the king's favourite expensive wine.",
	wine: "A copper goblet smelling of the king's favourite expensive wine."
},
{
	'throw.pitchfork' : fight_king,
	usurp: fight_king,
	regicide: fight_king,
	'commit.regicide': fight_king
},
null, function() {
	if(heroloc()==courtroom && !gs(CONFRONTED_KING) && gs(FINISHED_TROY) && gs(FINISHED_BICYCLOPS) && gs(FINISHED_HADES)) {
		say('\n\nThe king looks up. "Xylophone," he says coldly. "My spies inform me you\'ve finished those little errands ' +
		 'I sent you on. I must confess I was rather hoping you\'d die in the effort, but credit where it\'s due. Your debt to ' +
		 'society is paid. Now get lost." He gives you his trademark smirk, and his eyes go back to his wine goblet.');
		if(in_inv(pitchfork)) {
			say('\nSuddenly, the pitchfork you are carrying starts to feel heavy.');
		}
		sgs(CONFRONTED_KING, 1);
	}
});
function talk_eurystheus() {
	var finished_labours = gs(FINISHED_TROY) && gs(FINISHED_BICYCLOPS) && gs(FINISHED_HADES);
	if(!finished_labours) {
		say('The king sneers. "Didn\'t I give you some labours to do? They don\'t appear to be all finished."');
	} else {
		say('The king sneers. "Didn\'t I ask you to leave?"');
	}
}
function fight_king() {
	if(Token[1]=='throw' && !in_inv(pitchfork)) {
		say("You're not carrying that.");
		return true;
	}
	
	if((in_inv(pitchfork) || thingloc(pitchfork)==courtroom) && gs(FINISHED_TROY) && gs(FINISHED_BICYCLOPS) && gs(FINISHED_HADES)) {
		winner = true;
		sgs('sc', MAX_SCORE);
		die("You're angry, and it's a spur-of-the-moment thing. You [[ in_inv(pitchfork) ? 'whip out your' : 'pick up the' ]] pitchfork and hurl it into the king's chest. " +
		    "He gasps, clings the shaft, and slumps in his seat, the wine goblet clattering to the floor.\n" +
		    "A couple of guards appear from the wings and step towards you, but see your expression and think better of it.\n" +
		    'Then the guards kneel.\n\n' +
		    "And why not? You've been adventuressing for as long as you can remember, and a spot of Queening might give you a bit of me time. " +
		    " Sure, there's a cell waiting for you in Hades, but you've got years to get out of that one. You push the late " +
		    "Eurystheus out of your throne, and sit down.", "Ending 2 of 2");
	}
	
	else {
		die("You wait until the king looks like he's off guard, then make a lunge for him.\n" +
		"Unfortunately, his guards aren't off guard. They appear from the wings and take you down in seconds.");
	}
	
	return true;
}

/*
 * Thespis, the actor
 */
ch('thespis',
'Thespis',
'Thespis, the actor, is in here rehearsing a scene with himself.',
true, true, false,
props_cupboard,
"Thespis is a small man with curtains of brown hair and high cheekbones, \
wearing a black tunic with a high, round collar. He stands with his chest \
puffed out and his feet apart, reciting lines to himself.",
['""'],
{},
{},
{},
[],
{},
{},
null,
function() {
	if(heroloc()==props_cupboard && personloc(thespis)==props_cupboard) {
		
		if(!gs(USED_TEMPLE_POSEIDON)) {
			say('\nThespis stops himself mid-line and looks at you with irritation.\n\
			     "Fool!" he says. "I was practising my lines. I\'ll have to start all over again now." \
			     He pushes you out the door.\n\
			     \n');
			set_heroloc(theatre);
			look();
		} else {
			say('\nThespis stops himself mid-line and looks at you with irritation.\n' +
			     '<i>"Honestly!"</i> he booms. "How am I supposed to learn my lines with you barbarians ' +
			     'materialising all over the place? I can\'t work in these conditions! <i>Go to hell in a handcart!"</i> ' +
			     'He storms out and slams the door.');
			set_personloc(thespis, nowhere);
		}
	};
}
);




// ch(name,fullname,ishere,pname,male,female,firstplace,description,talks,subjects,reactions,presents,mannerisms,sights,special,
//    daemonBefore,daemonAfter)
ch('medusa',
'Medusa',
"[[ medusa_ishere() ]]",
true, false, true,
medusas_cave,
"[[ describe_medusa() ]]",
[], // talks set by daemon
{
	themself: "=[[ smoky() ? \"Haven\'t you figured it out? I'm Medusa. Get out before you see me!\" : \
	           \"I was cursed by a jealous goddess. Everyone who saw me would die. So I\'ve been camping \
	            out here. You and that barber are the first people I\'ve seen in years.\"]]",
	perseus: '"He came by five summers ago. I tried to warn him off but he was intent on trying to cut my \
	          head off. I never wanted to hurt him."',
	statue: "=Everyone I [[ gs(MEDUSA_CURED) ? 'saw turned' : 'see turns' ]] into a statue. \
	         [[ gs(MEDUSA_CURED) ? \"It was\" : \"It's\" ]] horrible.",
	palladium: "[[ capitalise(medusas_name) ]] thinks for a moment. \"Yeah, that's one of mine,\" she says.",
	hair: '"A goddess did it."[[ smoky() ? "": " Medusa looks bitter." ]]',
	ointment: '"Strawberry juice and myrrh. It\'s the only thing that stops my skin cracking. \
	           Try some, if you like."',
	barber: '"[[ gs(MEDUSA_CURED) ? "I\'m so grateful to him!" : "It\'s no use. Any barber who saw me would die." ]]"',
	haircut: '"[[ gs(MEDUSA_CURED) ? "I\'m so grateful to him!" : "It\'s no use. Any barber who saw me would die." ]]"',
	
},
{
	fight: fight_medusa
},
{},
[], // mannerisms set by daemon
{},
{},
function() {
	
	if(heroloc()==personloc(medusa) && smoky()) {
		medusa.fullname = "woman";
		medusa.pname = false;
	} else {
		medusa.fullname = "Medusa";
		medusa.pname = true;
	}
	
	medusa.talks = !gs(SEEN_MEDUSA) ? medusa_talks_precured : medusa_talks_cured;
	medusa.mannerisms = !gs(SEEN_MEDUSA) ? medusa_mannerisms_precured : medusa_mannerisms_cured;
	
	// in the smoky cave, understand "woman" to mean Medusa.
	if(heroloc()==personloc(medusa)) {
		for(var i=1; i<=MAX_TOKENS; ++i) {
			if(Token[i]=='woman') {
				Token[i] = 'medusa';
				her = medusa;
			}
		}
		Token_str = Token_str.replace('woman', 'medusa');
	}
},
function() {
	if(!gs(SEEN_MEDUSA) && heroloc()==personloc(medusa) && !gs(OBJECT_ON_HOLE)) {
		if(!gs(MEDUSA_CURED)) {
			die('\n"I\'m so sorry," says Medusa, her voice horrified and pleading for forgiveness. \
			     "It\'s not me, it\'s <i>them</i> &ndash;"\n\
			      One of her snakes catches your eye. You turn to stone.', "You are a statue");
		} else {
			say('\n<i>"No!"</i> Medusa cries, ducking her head and reaching her hands up to cover her \
			     hair... but it\'s not there. She slowly looks at you.\n\
			     "You haven\'t turned to stone," she says. "The snakes are gone. I\'m cured. \
			     I\'m cured!"');
		}
		sgs(SEEN_MEDUSA, 1);
	}
});
function medusa_ishere() {
	if(gs(OBJECT_ON_HOLE)) {
		say("There is a woman in the room with you, but you can't make out any details.");
	} else {
		say("Medusa, a pale woman with a [[ gs(MEDUSA_CURED) ? 'bald head' : 'mass of snakes for hair' ]], \
		     stands here.");
	}
}
function describe_medusa() {
	if(smoky()) {
		say("All you can tell is that she's a woman, and she's in the cave with you. It's too smoky \
		    to see her at all clearly. She's shambling around, like she's possibly trying to avoid you.");
	} else {
		say("Medusa is a tall woman with pale skin, wide red eyes, and [[ !gs(MEDUSA_CURED) ? \
		     'a mass of living snakes for hair' : 'a bald head. Her face is beautiful, and has the numb, \
		     bewildered expression of someone whose world has just changed' ]].");
	}
}
function fight_medusa() {
	if(!smoky()) {
		say("Medusa dodges your swing. \"What are you doing?\" she cries. \"I'm not a threat to you.\"");
		return;
	}
	
	if(!in_inv(sword)) {
		say("You punch the woman. She reels, and carries on stumbling around the room.");
	} else {
		
		say('You turn to, by your best guess, the woman\'s direction, swing your sword at about neck \
		     height, and get lucky. The woman stumbles forward. As she gets close to you, you get a glimpse \
		     of a terrified female face[[ gs(MEDUSA_CURED) ? ". Medusa\'s body dissolves in a cloud of yellow smoke." : ", its hair a mass of dying snakes. You feel your body tense up, \
		     but Medusa has dissolved in a cloud of yellow smoke before any damage is done to you." ]]');
		
		set_personloc(medusa, nowhere);
		if(!gs(MEDUSA_CURED)) {
			inc_score(); // get_point_for(medusa_dead)
		}
	}
}
function smoky() {
	return !!gs(OBJECT_ON_HOLE);
}
function medusas_name() {
	return gs(OBJECT_ON_HOLE) ? "the woman" : "Medusa"
}
medusa_talks_precured = ['"Get away from me!" cries the woman in a panicked voice.'];
medusa_talks_cured = [
	'"I got the snakes from a jealous goddess. Everyone who looked at me would die, so I\'ve been \
	 hiding out here." Medusa fingers her bald head. "I\'m not sure what I\'ll do now."',
	'Medusa smiles nervously. "Sorry," she says, "I\'m not used to company."'
];
medusa_mannerisms_precured = [
	'[[ capitalise(medusas_name()) ]] backs away from you.',
	'[[ capitalise(medusas_name()) ]] lifts her arms, trying to cover her head.'
];
medusa_mannerisms_cured = [
	"Medusa fingers her bald scalp.",
	"Medusa paces around the chamber.",
	"Medusa sits on a crate and puts her head in her hands."
]


ch('barber',
'barber',
"An old barber, with a rag tied round his eyes, stands here.",
false,true,false,
barbershop,
"The barber is an old man with well-clipped grey hair. He has a rag tied over his eyes, and carries a stick &ndash; \
he's blind. He faces your general direction with a friendly smile.",
[ "=I been barbering sixty years. Some god blinded me, but I ain't lettin' that stop me.",
  "=What'll it be, short back and sides?",
  "=Go anywhere nice on your 'olidays?"
],
{
	themself: '"I once gave a haircut to this chap who turned out to be a god. He said he didn\'t want \
	           anyone else to have as good a haircut as him, so he blinded me afterwards. When he came \
	           back to get it redone after a month, he was pissed right off."',
	eyes: "[[ barber.subjects.themself ]]",
	blindfold: "[[ barber.subjects.themself ]]",
	hair: '"Haircut, one obol."',
	haircut: '"Haircut, one obol."',
	medusa: '"If she\'s got hair, I can cut it."',
},
{
	pay: pay_barber,
	fight: '"Attack a poor defenceless blind man, would you?" says the barber, and whacks you in the head with his stick.',
},
{
	money: pay_barber
},
[ "The barber adjusts his blindfold.",
  "The barber feels out the area in front of him with his stick.",
  "The barber hums a low tune to himself."
],
{
	blindfold: "A clean rag tied around the barber's eyes signifies that he's blind.",
},
{
	'take.haircut': "[[ pay_barber() ]]",
	'take.blindfold': "You may be an amoral mercenary, but stealing from a blind man's actual face is a bit much even for you.",
},
function() {
},
function() {
	if(gs(BARBER_FOLLOWING)) {
		var n = gsn(BARBER_FOLLOWING);
		
		var followed = false;
		if(personloc(barber)!=heroloc()) {
			followed = true;
			say("\nThe barber follows you. ");
			set_personloc(barber, heroloc());
			sgs(BARBER_FOLLOWING, 1 + n);
		}
		
		for(var i=1; i<NUM_CHRS; ++i) {
			if(Person[i] != barber && personloc(Person[i])==heroloc() && !asleep(Person[i])) {
				say('"Aha, here\'s the patient," says the barber, feeling his way towards '
				    + the_person(Person[i]) + ' and grabbing ' + their(Person[i]) + ' head. ' +
				    capitalise(the_person(Person[i])) + ' is too startled to respond as the barber \
				    takes out a pair of shears and gives ' + them(Person[i]) + ' a quick ' +
				    ( Person[i]==medusa ? 'polish' : 'trim' ) + '.\n\
				    "Thanks for your custom!" says the barber, and walks off.');
				set_personloc(barber, barbershop);
				sgs(PAID_BARBER, 0);
				sgs(BARBER_FOLLOWING, 0);
				return;
			}
		}
		
		if(heroloc() == cave_mouth && !gs(MEDUSA_CURED) && personloc(medusa)==medusas_cave) {
			say('"Aha, I hear the patient," says the barber. "You wait here if you like."\n\
			     He feels his way southeast. For a few moments, you hear the clipping of shears and \
			     some distressed hisses, then the barber returns. "Whew," he says. "A real rats\' \
			     nest, that one. Look at these locks." He holds up a clump of small, dead snakes.\n\
			     "Thanks for your custom," he adds, and leaves the cave.');

			set_personloc(barber, barbershop);
			get_point_for(MEDUSA_CURED);
			sgs(PAID_BARBER, 0);
			sgs(BARBER_FOLLOWING, 0);
			return;
		}
		
		if(n>=20) {
			sgs(PAID_BARBER, 0);
			say('\n"We\'ve been walking for ages. You\'re wasting my time," says the barber');
			if(heroloc()==barbershop) {
				say(", and stops following you.");
			} else {
				say(", and walks brusquely [[ heroloc()==outside_barbershop ? 'back into his shop' : 'off' ]].");
				set_personloc(barber, barbershop);
			}
			sgs(BARBER_FOLLOWING, 0);
		} else if(n % 5 == 0) {
			say(' "Are we there yet?" ' + (followed ? 'he says' : 'says the barber') + (n>=15 ? ' impatiently' : '') + '.');
		}
		
	}
});
function pay_barber() {
	if(spend(1)) {
		if(gs(PAID_BARBER)) {
			say('"Ooh, thanks for the tip," says the barber, taking an obol.');
			sgs(BARBER_FOLLOWING, 1);
		} else {
			sgs(PAID_BARBER, 1);
			get_point_for(EVER_PAID_BARBER);
			say('You hand the barber an obol. "Great," he says. "If it\'s for you, sit down. \
			    If it\'s a home visit, lead the way!"');
		}
	}
}

ch('achilles',
'Achilles',
'Achilles [[ gs(ACHILLES_CRYING) ? "sits here, wailing over the remains of the horse" : "stands here" ]].',
true, true, false,
nowhere,
"Achilles is a powerful-looking man, and commander of the Greek military presence in Troy. \
He's dressed in shining gold armour[[ gs(ACHILLES_BAREFOOT) ? ' and' : ',' ]] a helmet with a big red \
plume[[ gs(ACHILLES_BAREFOOT) ? '' : ', and heavy shin-high boots' ]].\
[[ gs(ACHILLES_CRYING) ? \" He's on his knees, wailing over the wreck of the wooden horse.\" : \"\" ]]",
["[[ achilles_talks() ]]"],
{
	horse: "=It was supposed to be a surprise attack! Let the Trojans mistake it for a gift from the gods, \
	        wheel it in, then we switch it on and flatten the city with our giant wooden mecha-horse. \
	        You've ruined it!",
	troy: "=Those Trojan bastards will pay for... er... whatever it was they did in the first place.",
	heel: '[[ gs(ACHILLES_BAREFOOT) ? \'"I\\\'ll need a new pair of boots now."\' : \'Achilles raps a knuckle against his boots. "Reinforced leather," he says. "I mean, what kind \
	       of numpty would have one vulnerable spot on his heel that everyone knows about, and then \
	       walk around barefoot?"\' ]]',
	boot: "[[ achilles.subjects.heel ]]",
	hector: "[[ tell_achilles_patroclus('hector'); ]]",
	patroclus: "[[ tell_achilles_patroclus('patroclus'); ]]",
	eurystheus: "Achilles shrugs. \"He's all right, as kings go.\"",
	medusa: '"Lives in a cave down the beach, according to the locals. I wouldn\'t go near her, though, they say the sight of her is petrifying."',
	snakes: '"No mundane snakes in these parts that I know about. The hissing noise\'ll be Medusa, probably."',
	hades: '"They say the road to Hades is paved with good intentions."',
	bicyclops: '"I\'ll get round to slaying it at some point."',
	minotaur: '"I\'ll get round to slaying it at some point."',
	perseus: '"Perseus is a mate of mine." Achilles frowns. "Haven\'t seen him in a while, though. Went off to kill Medusa, or something."',
},
{
	fight: fight_achilles,
},
{},
["[[ achilles_mannerisms() ]]"],
{
	heel: "Achilles' heel is, according to rumour, his one weak spot. That's presumably why he wears \
	       massive boots.",
	boot: "Achilles wears thick, shin-high, heavy-looking boots.",
	armour: "Achilles wears splendid gold plate armour. Mostly for show, if the story about him being \
	         invulnerable except for his heel is to be believed."
},
{
	'fight.heel': hit_achilles_heel,
	'fight.achilles.in.heel': hit_achilles_heel,
	'fight.achilles.heel': hit_achilles_heel,
	'cut.heel': hit_achilles_heel,
	'cut.achilles.heel': hit_achilles_heel,
	'cut.achilles.heel': hit_achilles_heel,
	'cut.achilles.in.heel': hit_achilles_heel,
	'cut.in.heel': hit_achilles_heel,
	'fight.in.heel': hit_achilles_heel
},
null,
function() {
	if(gs(ACHILLES_FOLLOWING) && personloc(achilles) != heroloc()) {
		set_personloc(achilles, heroloc());
		say('\nAchilles follows you.');
		if(heroloc()==personloc(medusa) && !gs(MEDUSA_CURED) && !gs(OBJECT_ON_HOLE) && !gs(MEDUSAS_FIRE_OUT)) {
			say('\nAchilles looks at Medusa, and turns to stone.');
			sgs(ACHILLES_FOLLOWING, 0);
			set_personloc(achilles, nowhere);
			sgs(GREECE_WON_WAR, 0);
			get_point_for(ACHILLES_DEAD);
			end_war();
		}
	}
	if(!gs(ACHILLES_BAREFOOT) && personloc(achilles)==heroloc() && heroloc()==south_of_troy) {
		say(" He steps onto the swampy grass and, with a SCHLOOP, his boots are sucked off his feet into the mud." +
		    '"Aw, I paid a fortune for those," he says.');
		get_point_for(ACHILLES_BAREFOOT);
	}
}
);
function fight_achilles() {
	
	for(var i=3; i<=MAX_TOKENS; ++i) {
		if(Token[i]=='heel') {
			hit_achilles_heel();
			return true;
		}
	}
	
	say("You take a swing at achilles. Your attack clangs off his body.\n" +
	    "\"I'm invulnerable, you know,\" he says. \"Well, except for &ndash; er, never mind.\"");
	return true;
}
function achilles_talks() {
	
	if(gs(MET_PATROCLUS) && personloc(achilles)!=fort && !gs(WAR_OVER)) {
		tell_achilles_patroclus('patroclus');
		return;
	}
	
	if(gs(ACHILLES_CRYING)) {
	return pickOne(["=My lovely horse!",
		 "Achilles just sobs.",
		 "=It was so pretty! I carved its fetlocks myself!"]);
	} else if(gs(ACHILLES_FOLLOWING)) {
		return pickOne(["I'll save Patroclus! Lead the way!", "Where's Patroclus? Show me!"]);
	} else if(personloc(hector)==heroloc()) {
		return pickOne(['"Not now, I\'m fighting."',
		  '"I think there might be some enchantment going on," says Achilles between swings. "If you want to help, ' +
		  'find some local legend that might make Troy vulnerable."']);
	} else if(gs(WAR_OVER) && personloc(achilles)==sandy_beach) {
		return '"The ship won\'t launch. I don\'t understand, it\'s been fine the last 999 times."';
	} else {
		return '"I\'m the fastest man in the world, you know."';
	};
}
function achilles_mannerisms() {
	return pickOne(gs(ACHILLES_CRYING) ?
	 ["Achilles lets out a mighty sob.",
	  "Achilles cries 'Nooooooooooo!'",
	  "Achilles sniffs." ] :
	 gs(WAR_OVER) ?
	 ["Achilles looks at the ship in puzzlement."] :
	 ["Achilles [[ gs(ACHILLES_BAREFOOT) ? 'glances at his feet' : 'adjusts his boots carefully' ]].",
	  "Achilles adjusts his helmet." ]
    );
}
function hit_achilles_heel() {
	// todo: there'll be a way to get him to take his boots off.
	// Then you can kill him and win the war for Troy.
	
	if(gs(ACHILLES_BAREFOOT)) {
		
		if(!in_inv(sword)) {
			
			say("You wait for Achilles to turn his back, then punch him in the heel.\n" +
			    'He spins round. "Careful!"');
			
			return true;
		}
		
		
		say("You wait for Achilles to turn his back, then slash him across the &ndash; well, the tendon above the heel. "+
		    "Does that have a name?\n" +
		    "Achilles goes down like a sack of onions and looks at you in terror. Blood pours from his ankle, "+
		    "and his body twitches and... sort of dissipates in a golden light. Oh, that's right, he's a demigod.");
		get_point_for(ACHILLES_DEAD);
		sgs(ACHILLES_FOLLOWING, 0);
		set_personloc(achilles, nowhere);
		sgs(GREECE_WON_WAR, 0);
		end_war();
		
	} else {
		say("Your attack clangs off Achilles' reinforced boots. Achilles just smirks for a moment[[ \
		    gs(ACHILLES_CRYING) ? ', then carries on sobbing' : '' ]].");
	}
	    
	return true;
		
}
function tell_achilles_patroclus(PorH) { // either 'patroclus' or 'hector'
	if(!gs(MET_PATROCLUS)) {
		say(PorH == 'patroclus' ? 'Achilles briefly smiles. "He\'s in there giving some Trojans what for, no doubt."' :
		    'Achilles frowns. "He\'s the leader of the Trojans. Can\'t say I\'m a fan."');
	} else if(!gs(WAR_OVER) && heroloc()!=fort) {
		say('You tell Achilles about Hector and Patroclus.\n' +
		    '"Patroclus is in trouble?" Achilles pulls himself together and looks serious. "Lead the way!"');
		get_point_for(TOLD_ACHILLES);
		sgs(ACHILLES_CRYING, 0);
		sgs(ACHILLES_FOLLOWING, 1);
	} else {
		say("[[ achilles_talks() ]]");	
	}
}


function achilles_fights_hector() {
	// Achilles is invulnerable unless hit boots are off.
	// Hector is invulnerable unless the Palladium has been de-statue-fied.
	
	achilles.vulnerable = !!gs(ACHILLES_BAREFOOT);
	hector.vulnerable = !!gs(PALLADIUM_CURED);
	
	var victim = pick(2) ? hector : achilles;
	var attacker = (victim == hector) ? achilles : hector;
	
	say('\n' + capitalise(the_person(attacker)) + ' ' + pickOne(['swings', 'thrusts', 'stabs']) + ' his sword at ' + the_person(victim));
	
	if(pick(2)) {
		say(pickOne([', but misses.', '. ' + the_person(victim) + ' jumps out of the way.']));
	} else {
		say(pickOne([', and hits.', ', and connects.', ', and draws blood.']));
		
		if(victim.vulnerable) {
			say('\n' + capitalise(the_person(victim)) + ' gasps, hangs on the blade for a moment, then falls.');
			if(victim==achilles) {
				say(' His body twitches and dissipates in a golden light.');
				
				if(gs(PATROCLUS_UNTIED)) {
					say('\nPatroclus wails and scarpers down the ladder. Hector grins evilly.');
				} else {
					say('\nHector grins evilly and slits Patroclus\' throat in celebration. A Trojan lackey arrives and carries off the body.');
					sgs(PATROCLUS_DEAD, 1);
				}
				set_personloc(patroclus, nowhere);
				// war ends with Troy winning
				
				sgs(GREECE_WON_WAR, 0);
				get_point_for(ACHILLES_DEAD);
				end_war();
				
			} else { // victim==hector
				say(' A Trojan soldier climbs into the room, sheds a tear, and carries the body down the ladder over his shoulder.');
				
				say('\nAchilles runs up to Patroclus[[ gs(PATROCLUS_UNTIED) ? "" : ", unties his bonds," ]] and takes his hands.\n' +
				    '"I told you I\'d always be there for you," says Achilles. "Let\'s get back to the ship." Smiling, the two of them descend the ladder.');
				
				// war ends with Greece winning
				set_personloc(hector, nowhere);
				get_point_for(HECTOR_DEAD);
				sgs(GREECE_WON_WAR, 1);
				end_war();
				
			}
			
		} else {
			say(pickOne([
				' ' + the_person(victim) + ' barely seems to notice.',
				' ' + the_person(victim) + ' laughs it off.',
				' ' + the_person(victim) + ' doesn\'t look hurt.',
				' ' + the_person(victim) + ' doesn\'t flinch.',
				' ' + the_person(victim) + ' seems unhurt.',
				' ' + the_person(victim) + ' doesn\'t seem bothered.',
			]));
		}
		
	}
	
}


function end_war() {
	
	var loc = heroloc();

	var victor = gs(GREECE_WON_WAR) ? "Greece" : "Troy";
	var loser = (victor=="Greece") ? "Troy" : "Greece";
	var victor_demonym = (victor=="Greece") ? "Greek" : "Trojan";
	var loser_demonym = (victor=="Greece") ? "Trojan" : "Greek";
	
	if(loc==fort) {
		var patroclusHere = false;
		
		if(!gs(GREECE_WON_WAR)) {
			if(personloc(patroclus)==fort) {
				patroclusHere = true;
				say("\nPatroclus screams.");
			}
			if(personloc(hector)==fort) {
				say("\nHector cheers" +
				    "[[ personloc(patroclus) == fort ? \", and slits Patroclus' throat in celebration. A Trojan lackey arrives and carries the body away. Hector\" : \". He\" ]]" +
				    " gives you a grateful wink and smiles leerily through his beard.");
				set_personloc(patroclus, nowhere);
				sgs(PATROCLUS_DEAD, 1);
			}
		} else {

			// Greece won: Achilles and Patroclus already handled
			set_personloc(hector, nowhere);
			
		}
	}
	
	say("\n\nA [[ gs(GREECE_WON_WAR) ? 'triumphant' : 'melancholy' ]] horn blows in the distance.");

	
	if(loc.isTroy && loc.isOutdoors && gs(FIGHTING_HAPPENING)) {
		say(" Suddenly, it's on everybody's lips: " + victor + " has won the war!\n");
	}
	if(personloc(barber)==heroloc()) {
		say('\n"Ooh, I just heard," says the barber. "' + victor + ' won the war. What about that, eh?"\n');
	}
	
	say(' You hear a cryer yelling: "The war is over! ' + victor + ' has won! Rejoice, unless you\'re a ' + loser_demonym + '!"');
	
	if(loc.isOutdoors) {
		if(gs(FIGHTING_HAPPENING) && loc.isTroy) {
			if(victor=="Troy") {
				say("\nThe fighting stops abruptly, and a few scores of dejected-looking Greek soldiers file away past you. " +
				    "The Trojan soldiers jeer after them for a minute, then go home.");
			} else {
				say("\nThe fighting stops abruptly, and a few scores of triumphant-looking Greek soldiers march away past you. " +
				    "The Trojan soldiers grumble for a minute, then go home.");
			}
		} else if((gs(FIGHTING_HAPPENING) && loc == west_of_troy) || loc == siege_camp) {
			say(" A few scores of " + (victor=="Greece" ? "triumphant" : "dejected") + "-looking Greek soldiers " +
			    (victor=="Greece" ? "march" : "trudge") + " past you towards the west.");
		} if(loc == sandy_beach) {
			say(" The ship pulls in a bit closer to the shore. A few scores of " + (victor=="Greece" ? "triumphant" : "dejected") +
			     "-looking Greek soldiers file in from the east and paddle aboard.");
		} else if(loc == pebbly_beach) {
			say(" To the north, you see the ship pull in closer to the short. Some Greek soldiers march in from the east and " +
			     "paddle aboard.");
		}
		
		if(loc==sandy_beach || loc==pebbly_beach || loc==siege_camp) {
			say(" Something is wrong, though: the ship jerks, but it won't start moving.");
		}
		
		if(loc==outside_citadel) {
			say("\nWith a metallic clinking, the great gates of the Citadel open.");
		}
	}
	
	sgs(FIGHTING_HAPPENING, 0);
	
	get_point_for(WAR_OVER);
	sgs(SHIP_STATUS, SHIP_BOARDING);
	
	set_personloc(patroclus, nowhere);
	
	if(!gs(ACHILLES_DEAD)) {
		set_personloc(achilles, sandy_beach);
	} else {
		set_personloc(achilles, nowhere);
		set_personloc(eudoros, sandy_beach);
	}

}

/*
 * Eudoros, Achilles' second-in-command
 * Only appears if Achilles is dead
 */

ch('eudoros',
'Eudoros',
"Eudoros, second-in-command of the Greek army, stands miserably by the gangplank.",
true, true, false,
nowhere,
"Eudoros is a Greek officer with an unshaven face and battered armour. " +
 "He looks rather tired and miserable.",
['"It\'s bad enough that we lost the war, but now something\'s wrong with the boat. It won\'t launch."'],
{
	helen: '"Yeah, I guess the king would be pleased if we could bring her back with us."',
	achilles: 'Eudoros looks at the ground for a moment.',
	ship: 'Eudoros blows air out through inflated cheeks. "Maybe if we had some way of pushing it..."',
},
{
	fight: 'Eudoros dodges you. "Please, I\'ve taken enough of a beating for one day."',
},
{},
[	'Eudoros looks at the boat in puzzlement. "Why won\'t she launch?" he wonders aloud.',
],
{},
{},
null, null);



/*
 * The guard on duty at Troy's back gate
 * a mini-(almost non-)puzzle: kill him, bribe him, or seduce him
 */
//ch(name,fullname,ishere,pname,male,female,firstplace,description,talks,subjects,reactions,presents,
// mannerisms,sights,special,daemonBefore,daemonAfter)
ch('guard',
'guard',
"A guardsman [[ asleep(guard) ? 'is sprawled unconscious' : 'slouches' ]] by the gate[[ gs(GOT_CHICKEN) ? '' : ', chewing on a chicken leg' ]].",
false, true, false,
east_of_troy,
"A generic-looking Trojan guardsman, wearing tarnished chain mail and holding a rusty pike. \
He [[ asleep(guard) ? 'is sprawled on the floor with a bump on his head and a smile on his face' : \
'leans against the wall beside the back gate, eyeing you with suspicion.' ]][[ gs(GOT_CHICKEN) && !asleep(guard) ? '' : ' He is gnawing on a chicken leg.' ]]",
[
	"=Troy cannot fall while the Palladium stands!",
	"=Who goes there?",
	"=Your name's not down, you're not comin' in.",
],
{},
{
	fight: fight_guard,
	kiss: kiss_guard,
	pay: bribe_guard
},
{
	money: bribe_guard
},
[
	"The guard half-heartedly rattles his pike.",
	"The guard picks his nose, then tries to look like he didn't notice you noticing."
],
{},
{},
null, null);
function fight_guard() {
	if(asleep(guard)) {
		say("You give him an extra smack. He should be out cold for several more hours.");
	} else if(!in_inv(sword)) { // very unlikely the player will drop it, but let's give the guard a fighting chance
		die("You smack the guard in the face. He looks irritated, like he'd been expecting a \
		     quiet shift, and runs you through with his spear.");
	} else {
		say("All right, action time! The guard drops his chicken leg as you charge him with your sword outstretched. He parries it with \
		     his pike, then thrusts. You jump the pike and...\n\
		     ...look, let's cut to the result. Two minutes later you're alive, and he's been chopped into \
		     tiny bits. Well done.");
		
		set_personloc(guard, nowhere);
		set_thingloc(chicken, east_of_troy);
		get_point_for(GOT_CHICKEN);
	}
	return true;
}
function bribe_guard() {
	if(asleep(guard)) {
		return false;
	} else if(spend(5)) {
		say("Trojan guards' wages aren't high. You toss him five obols.\n\
		    \"I suppose I am due a break,\" he says, and slinks off into the city, dropping his chicken leg.");
		set_personloc(guard, nowhere);
	set_thingloc(chicken, east_of_troy);
		get_point_for(GOT_CHICKEN);
	}
	return true;
}
function kiss_guard() {
	say("Guarding Troy is a lonely job. You draw him into an embrace, enjoy a meaningless and chicken-flavoured makeout session \
	     for a minute or two, then instinctively clonk him on the back of the head. He falls unconscious, the chicken leg dropping \
	     out of his hand.");
	sleep(guard);
	set_thingloc(chicken, east_of_troy);
	get_point_for(GOT_CHICKEN);
	return true;
}

// patroclus goes here
// function ch(name,fullname,ishere,pname,male,female,firstplace,description,talks,subjects,reactions,presents,mannerisms,sights,special,
 //           daemonBefore,daemonAfter)

ch('patroclus',
'Patroclus',
"Patroclus is here[[ !gs(PATROCLUS_UNTIED) ? ', his wrists and ankles bound with rope' : '' ]].[[ get_point_for(MET_PATROCLUS); ]]",
true, true, false,
fort,
'Patroclus is tall and buff, with short fair hair and a slight beard covering his large jaw.[[ !gs(PATROCLUS_UNTIED) ? " His wrists and ankles are bound with rope." : "" ]]',
[ "[[ patroclus_talks() ]]" ],
{},
{ untie: "[[ untie_patroclus() ]]" },
{},
[ "[[ patroclus_mannerisms() ]]" ],
{},
{
	'cut.rope' : "[[ untie_patroclus() ]]",
	'cut.patroclus.rope' : "[[ untie_patroclus() ]]",
},
null,
function() {
	if(heroloc()==personloc(patroclus)) {
		if(personloc(achilles)!=heroloc()) {
			say('\nPatroclus ' + pickOne(['cries', 'yells', 'wails']) + ', "' +
			     pickOne(['Get', 'Go and get', 'Fetch']) + ' Achilles' + pickOne(['', ', now', ', quick', '! Hurry']) + '!"');
		} else if(pick(2)) {
			say('\nPatroclus ' + pickOne(['cries', 'yells', 'shouts']) + ', "' +
				 pickOne(['Go on', 'Come on', 'Sock him', 'Get him', 'Give him what for']) + ', Achilles!"');
		}
	}
}
);
function untie_patroclus() {
	if(gs(PATROCLUS_UNTIED)) {
		say("Patroclus isn't tied up.");
	} else if(personloc(hector)==fort && personloc(achilles)!=fort) {
		say("You reach out to untie Patroclus' bonds, but Hector growls and slaps your hand away.");
	} else {
		say("You untie Patroclus' bonds. He gives you a hasty smile and carries on watching the fight.");
		sgs(PATROCLUS_UNTIED, 1); // not worth a point
	}
}
function patroclus_talks() {
	if(gs(HECTOR_HAS_PATROCLUS)) {
		if(personloc(achilles)==heroloc()) {
			say('Patroclus ignores you. "Get him, Achilles!" he yells.');
		} else {
			say(pickOne([
				"=Get Achilles!",
				"=Go and tell Achilles I need him, now!",
				"=Where's Achilles?"
			]));
		}
	} else {
		say("=Help!");
	}
}
function patroclus_mannerisms() {
	
	if(gs(HECTOR_HAS_PATROCLUS)) {
		say(pickOne(['Patroclus [[personloc(achilles)==fort ? "cheers on" : "calls for"]] Achilles.', 'Patroclus wails.']));
	} else {
		say(pickOne(['Patroclus [[ gs(PATROCLUS_UNTIED) ? "waves his fists nervously" : "tries to gnaw the rope from his wrists" ]].', 'Patroclus winces.']));
	}
}

ch('hector',
'Hector',
"The Trojan leader, Hector, stands here[[ (personloc(patroclus)==fort && !personloc(achilles)==fort) ? \"with a knife to Patroclus' throat\" : \"\" ]].",
true, true, false,
fort,
"Hector is a bearded, burly Trojan clad in black leather and dark mail.",
["[[ talk_hector() ]]"],
{},
{},
{},
["Hector strokes his beard.", "Hector [[ gs(WAR_OVER) && gs(GREECE_WON_WAR) ? 'humphs' : 'laughs' ]]."],
{},
{},
function() {
	if(heroloc()==personloc(hector)) {
		for(var i=1; i<=MAX_TOKENS; ++i) {
			if(Token[i]=='trojan') { Token[i] = 'hector' }
		}
	}
},
null);
function talk_hector() {
	if(personloc(achilles)==fort) {
		say('"Don\'t bother me just now. I\'m fighting."');
	} else if(gs(WAR_OVER)) {
		say('"Get out of here[[ gs(GREECE_WON_WAR) ? ", I\'m not in the mood" : ", before you go the same way as Achilles and his loverboy" ]]."');
	} else {
		say('"Why don\'t you go and tell Achilles I\'ve got his loverboy, eh?"');
	}
}

ch('helen',
"Helen of Troy",
"Helen of Troy [[ heroloc()==helens_chamber ? 'herself sits on the bed, looking wistfully at the painting' : thingloc(chicken)==heroloc() ? 'sits here' : 'runs around at your feet' ]].",
true, false, true,
helens_chamber,
"Helen of Troy is a short-haired, strong-looking, small pug dog. She has a peculiarly flat face, as though it's " +
 "been repeatedly bashed against a heavy object.[[ in_inv(chicken) ? ' She is jumping up at you, as though you\\\'re carrying " +
 "something she wants' : personloc(helen)==helens_chamber ? ' She is staring wistfully at the painting on the wall' : '' ]].",
['"Woof!"', '"Yap!"', '"Grrr!"', '"Arf!"', '"Yip!"'],
{
},
{
	fight: "Helen of Troy bites you really hard on the ankle. Adorable!",
	kiss: "She's, um, enthusastic.",
	take: "Helen of Troy squirms out of your grasp.",
	stroke: "Helen of Troy rolls on her back and lets you tickle her tummy.",
},
{
	chicken: "[[ take_away(chicken); set_thingloc(chicken, heroloc()); ]]Helen of Troy bats the chicken to the floor and starts worrying it happily.",
},
[ "[[ helen_mannerisms() ]]" ],
{},
{},
function() {
	// change "dog" to "helen" in helen's presence
	if(personloc(helen)==heroloc()) {
		for(var i=1; i<=MAX_TOKENS; ++i) {
			if(Token[i]=='dog') {
				Token[i]='helen';
			}
		}
	}
	
	// change "helen (of) troy" to "helen"
	for(var i=2; i<=MAX_TOKENS; ++i) {
		if(Token[i]=='troy' && Token[i-1]=='helen') {
			for(var j=i; j<MAX_TOKENS; ++j) {
				Token[j] = Token[j + 1];
			}
			Token[MAX_TOKENS] = '';
		}
	}
}, function() {
	if(!gs(HELEN_FOLLOWING) && in_inv(chicken) && personloc(helen)==heroloc()) {
		say('\nHelen sniffs at your chicken leg and starts drooling maniacally. Her eyes widen.');
		sgs(HELEN_FOLLOWING, 1);
		get_point_for(MET_HELEN);
	}
	
	else if(gs(JUST_MOVED) && gs(HELEN_FOLLOWING) && personloc(helen)!=nowhere && in_inv(chicken)) {
		say("\nHelen of Troy follows you excitedly.");
		set_personloc(helen, heroloc());
	}
	
	if(heroloc()==sandy_beach && personloc(helen)==sandy_beach) {
		say("\nHelen of Troy sees the ship and gives a yip of joy. She runs towards it, leaps, and bashes her " +
		     "face into the stern at high-speed. That's enough impetus to get it going. Helen clambers " +
		     "aboard, and [[ gs(ACHILLES_DEAD) ? 'Eudoros' : 'Achilles' ]] manages to hop aboard too. " +
		     "The ship gathers speed and heads over the horizon " +
		     "[[ gs(GREECE_WON_WAR) ? 'with its flags raised in victory' : 'with its sail between its legs' ]].");
		sgs(HELEN_FOLLOWING, 0);
		set_personloc(helen, nowhere);
		set_personloc(achilles, nowhere);
		set_personloc(eudoros, nowhere);
		inc_score(); // get_point_for(LAUNCHED_SHIP);
		sgs(SHIP_STATUS, SHIP_GONE);
		
		sgs(FINISHED_TROY, 1);
	}
}
);
function helen_mannerisms() {
	
	if(thingloc(chicken)==personloc(helen)) {
		say(pickOne(["Helen of Troy gives the chicken leg a mighty chomp.",
		    "Helen of Troy gnaws on the chicken leg.",
		    "Helen of Troy holds the chicken leg between her front paws and nibbles at it."]));
		return;
	}
	
	if(heroloc()=='helens_chamber') {
		say("Helen of Troy looks wistfully at the painting, and whines.");
		return;
	}
	
	say(pickOne([
		'Helen of Troy jumps up and licks your face.',
		'Helen of Troy runs around in a circle.',
		'Helen of Troy barks.',
		'Helen of Troy whines.',
		'Helen of Troy drools.'	
	]));
}

// ch(name,fullname,ishere,pname,male,female,firstplace,description,talks,subjects,reactions,presents,
//    mannerisms,sights,special,daemonBefore,daemonAfter)
ch('minotaur',
'Minotaur',
"The Minotaur looms over you.",
false, false, false, nowhere,
"An enormous, shambling creature, human from the neck down but with the head of a bull. Steam billows from its beringed nostrils, " +
 "and it emits a low grunting noise. It looks very strong.",
['"Moo!"', '"Moooooo!"', '"Moooo!"', '"MoooOOOooOOOO!"'],
{},
{
	fight: fight_minotaur
},
{},
["The Minotaur moos angrily.", "The Minotaur puts out a foot and drags it backwards along the ground.", "The Minotaur lowers its horns."],
{},
{},
null, null);

function fight_minotaur() {
	if(in_inv(sword)) {
		say("You swing your sword at the Minotaur")
		if(!pick(2)) {
			say(", but miss.");
			if(!pick(4)) {
				say(" Oh dear, now it's really angry!");
				die("\nThe Minotaur lowers its horns and charges...");
			}
		} else {
			say(", and hit! The creature bellows and runs off into the maze.");
			// This gives the Minotaur thing a bit of puzzliness after all: you have to run rather than fight.
			sgs(MINOTAUR_CHASING, 0);
			set_personloc(minotaur, nowhere);
		}
	} else {
		say("You punch the Minotaur in the chest.");
		var n = pick(3)
		if(n==2) {
			say(" It barely seems to notice.");
		} else if (n==1) {
			say(" It grunts and runs off into the maze.");
			sgs(MINOTAUR_CHASING, 0);
			set_personloc(minotaur, nowhere);
		} else {
			say(" Oh dear, now it's really angry!");
			die("\nThe Minotaur lowers its horns and charges...");
		}
	}
}


/*
 *  The Bicyclops
 */
ch('bicyclops',
'Bicyclops',
"The Bicyclops, a hideous giant humanoid, stands over you.",
false, false, false,
bicyclops_lair,
"The Bicyclops stands twenty feet tall, with a hairy humanoid body, its modesty protected by a loincloth made of a ship's " +
 "sail. As if ordinary Cyclopses weren\'t ugly enough, this one has <i>two</i> eyes &ndash; one above the other.",
["The Bicyclops roars.", "The Bicyclops grunts.", "The Bicyclops bellows.", "The Bicyclops growls."],
{},
{ fight: fight_bicyclops,
},
{},
[
	"The Bicyclops picks up a bone and shakes it.",
	"The Bicyclops stamps its foot, causing a minor earthquake.",
	"The Bicyclops faces you and roars.",
],
{},
{},
null, null);
function fight_bicyclops() {
	die("You take a swing at the Bicyclops, which has been fairly content to ignore you until now. It turns, fixes its " +
	 "horrible eyes on you, bares its teeth and lunges.\n" +
	 "You really ought to learn to know when you're outmatched.");
	return true;
}

/*
 * Sappho the bard
 */
ch('sappho',
'Sappho',
"Sappho, the bard, sits here.",
true, false, true,
sapphos_house,
"Sappho is a reclusive bard, well known for her love poetry. She is red-haired, slim and dressed in drapy, hippyish garments.",
["Sappho smiles and continues to compose a verse in her head."],
{
	daedalus: '"He\'s not a bad neighbour, but I don\'t have much use for him."',
	trail: '"Odd, isn\'t it? It seems to be a natural feature of this island."',
	symbol: '"I never worked that out."',
	bicyclops: '"Oh, I don\'t mind him. He doesn\'t come round this side of the island much."',
	troy: '"I went on the anti-war protests with everyone else, but kings do what they like. Men make horrible rulers."',
	soldiers: '"I went on the anti-war protests with everyone else, but kings do what they like. Men make horrible rulers."',
	helen: '"Oh, she\'s amazing. I don\'t think she\'d get on with Hecate though."',
	eurystheus: '"If it were up to me, we\'d have queens instead. Have you ever thought of going into royalty?"',
	cat: 'Sappho smiles[[ personloc(cat)==sapphos_house ? " at the cat" : "" ]]. "I\'m never lonely with Hecate around," she says.',
	hades: '"They say the primrose path of dalliance leads there."',
},
{
	kiss: 'What, just because it\'s Sappho? Come off it, you barely know her.',
},
{
},
["Sappho hums a modal tune.",
 "Sappho smiles at you.",
 "Sappho takes out a quill and papyrus and jots down a few lines.",
 "Sappho [[ personloc(cat)==sapphos_house ? 'gives the cat a stroke behind the ears' : 'sings to herself' ]].",
 "Sappho [[ personloc(cat)==sapphos_house ? 'strokes the cat' : 'hums to herself' ]]." ],
{},
{},
null, null);

/*
 * ...and her cat, Hecate
 */
ch('cat',
"cat",
"A cat sits on the floor, curled up in a circle.",
false, false, false,
sapphos_house,
"A small ginger cat with dabs of white on its nose and paws. It lies in a circle shape [[ personloc(cat)==sapphos_house ? 'in the middle " +
 "of the floor, somehow managing to take up most of the room' : 'by the side of the path' ]].",
['"Meow!"'],
{
	fish: '"MEEEEEEOOOOOWWWW!!!!"',
},
{ fight: "The cat squeals and swipes you right across the face with a clawed paw.[[ personloc(sappho)==heroloc() ? '\\n\"Serves you right,\" says Sappho.' : '' ]].",
  stroke: "The cat rolls over on its back adorably, then claws your arm. Ouch!",
  take: "The cat hisses and bristles its fur. You think better of trying to pick it up.",
},
{ fish: "[[ give_cat_fish() ]]",
  chicken: "The cat turns its nose up at the chicken.",
  cheese: "The cat turns its nose up at the cheese.",
},
["The cat meows.", "The cat purrs.", "The cat twitches its tail.", "The cat stretches.", "The cat yowls.", "The cat chirrups.", "The cat pounces on an imaginary mouse."],
{},
{},
null, null);
function give_cat_fish() {
	say("The cat opens an eye, sees the fish, grabs it from you, purrs, and enthusiastically carries the fish out of the door to " +
	     "devour it in a safe place.");
	get_point_for(GAVE_CAT_FISH);
	take_away(fish);
	set_personloc(cat, outside_sapphos_hut);
}

/*
 * Tantalus
 */
ch('tantalus',
"Tantalus",
"Tantalus stands in the pool, neck-deep in the wine.",
true, true, false,
tantalus_cell,
"Tantalus is a red-nosed, aristocratic-looking fellow with a droopy black moustache. He stands neck-deep in the wine, " +
 "occasionally attempting to take a sip in the hope that this time it won't be too fast for him.",
['"If only I had some sort of straw..."',
 '"Look at this! They\'ve immersed me in wine but made it impossible to drink. It\'s like they didn\'t think!"',
 '"It\'s always <i>just</i> too far from my face. If I could just reach a little further..."'],
{
	aulos: '"That might make a good straw!"',
},
{
	fight: "It's kind of pointless attacking someone who's already in hell.",
},
{	aulos: "[[ give_tantalus_aulos() ]]" },
[],
{},
{},
null, null);
function give_tantalus_aulos() {
	say('Tantalus grabs the aulos. "Perfect!"\n' +
	 'He puts his fingers over the soundholes, sticks one end into the pool, and starts sucking the wine through. ' +
	 'Within a minute, the wine is all gone.\n' +
	 '"Thanks," he says. "They said when I finished drinking, I\'d be free to go!" He hoists himself out of the pool, ' +
	 'and runs happily out the door. The pool fills up again, but Tantalus is long gone.');
	set_personloc(tantalus, nowhere);
	take_away(aulos);
	get_point_for(RESCUED_TANTALUS);
	if(gs(RESCUED_SISYPHUS)) {
		sgs(FINISHED_HADES, 1);
	}
}

/*
 * Sisyphus
 */
// ch(name,fullname,ishere,pname,male,female,firstplace,description,talks,subjects,reactions,presents,
//    mannerisms,sights,special,daemonBefore,daemonAfter)
ch('sisyphus',
"Sisyphus",
"Sisyphus is here, trying to push the boulder to the top of the slope.",
true, true, false,
sisyphus_cell,
"Sisyphus is bronzed and sweaty and muscly from hundreds of years' pointless exercise. He continues his efforts to push " +
 "the boulder up the slope with a look of grim determination. It's not like there's much else for him to do.",
['"Maybe if I had something to wedge it with..."', '"Don\'t disturb me! You\'ll make me drop it again."'],
{ boulder: '"Maybe if I had something to wedge it with..."', },
{
	fight: "It's kind of pointless attacking someone who's already in hell.",
},
{ cheese: "[[ wedge_boulder(), '']]" },
[],
{},
{},
null,
function() {
	if(!gs(RESCUED_SISYPHUS) && heroloc()==sisyphus_cell) {
		
		if(!gs(SISYPHUS_PHASE)) {
			say("\nWith great effort, Sisyphus pushes the boulder up to the middle of the slope.");
			sgs(SISYPHUS_PHASE, 1);
		} else if(gs(SISYPHUS_PHASE)==1) {
			say("\nSisyphus has almost got the boulder to the top of the slope.");
			sgs(SISYPHUS_PHASE, 2);
		} else if(gs(SISYPHUS_PHASE)==2) {
			say("\nWith a grunt, Sisyphus pushes the boulder to the top of the slope. " +
			     "But at the last moment he loses his grip, and it tumbles back to the bottom.\n" +
			     '"' + pickOne(["Whoops", "Oops", "Tsk"]) + ', ' +
			           pickOne(["butterfingers", "clumsy me", "there it goes again"]) + '," he mutters.');
			sgs(SISYPHUS_PHASE, 0);
		}
	}
}
);


// Perseus - you never actually interact with him except as a statue, but this makes the name get parsed properly
ch('perseus', 'Perseus', '', true, true, false, nowhere, '', [], {}, {}, {}, [], {}, {}, null, null);



