/*------------------------------------------------------------*/
/* Adventure Parser

   Need to include the adv-world definition file before including this one.
   This is because the vocabulary definitions depend on the adventure-world
   objects.
*/


/*-------------------BEGIN Added by Dennis Lo 88/10/30 for portable version */
char *strchr (str, ch)
  char *str;
  char ch;
{
  int l = strlen (str);

  while (l-- >= 0)
  {
    if (*str == ch)
      return (str);
    str++;
  } 
  return ( (char *) 0);
}

char *strlwr (str)
  char *str;
{
  char *orig = str;

  for ( ; *str; str++)
    if (*str >= 'A'  &&  *str <= 'Z')
      *str = tolower (*str);
  return (orig);
}
/*----------------------- END of additions for portable version. */




#define v_sig 4               /* 1st 4 letters of vocab words significant */

#define max_cmd_size 64                /* at most 63 chars per command */
#define max_cmd_len max_cmd_size-1

#define max_word_size 16               /* at most 15 chars per word in input */
#define max_word_len max_word_size-1

typedef char v_cmd [max_cmd_size ];
typedef char v_word [max_word_size ];  /* a vocabulary (normal) word */

typedef struct        /* a command */
{
  v_cmd
    cm;               /* command entered */

  v_word
    verb,             /* verb part */
    noun,             /* noun part */
    sh_verb,          /* short form of verb and noun for comparison */
    sh_noun;

  int
    vn,               /* verb # in vocab */
    nn;               /* noun # in vocab */
}
CmdRec;

CmdRec cmd;           /* global command structure */

/*----------------------------*/
/* Get the verb and the noun from a command of the form "verb noun".
   If noun is omitted, a null string returned.

   Will handle leading blanks, and too long strings.
*/
ParseCommand( cm, verb, noun )
  char *cm;
  char *verb;
  char *noun;
{
  char *p,*q;

  *verb='\0'; *noun='\0';
  while (*cm && *cm==' ') cm++;   /* skip leading blanks in command */

  p = strchr( cm, ' ' );          /* find space delimiting verb */
  q = strchr( cm, '\0');          /* get last char */

  if (!p)   p = q;                /* if 1 word, set ptr */
  strncat( verb, cm, min(p-cm, max_word_len) );

  if (*p)                         /* if >1 word */
  {
    while (*p && *p==' ') p++;    /* skip lead blanks */
    strncat( noun, p, min(q-p, max_word_len) );
  }
}

/*----------------------------*/
/* Make a string exactly v_sig characters long (plus null), truncating or
   blank-padding if necessary
*/
resize_word( s )
  char *s;
{
  int i;

  for ( i=strlen(s); i<v_sig; i++ )
    *(s+i) = ' ';
  *(s+v_sig)='\0';
}

/*----------------------------*/
/* Return a word's vocabulary #, given the vocab array and it's size
*/
int GetWordNum( w, voc )
  char *w;
  vocab_type *voc;
{
  int wn,i;
  v_word sh_word;

  strcpy( sh_word, w );
  resize_word( sh_word );
  for ( wn=0;  *voc->name;  voc++ )
  {
    if (!strcmp( sh_word, voc->name ))
    {
      wn = voc->num;
      break;
    }
  }
  return( wn );
}

/*----------------------------*/
/*
*/
int GetVerbNum( verb )
  char *verb;
{
  return( GetWordNum( verb, v_verb ));
}

int GetNounNum( noun )
  char *noun;
{
  return( GetWordNum( noun, v_noun ));
}

/*----------------------------*/
/* enter aux. object (e.g. Give XXX to AUX)
*/
int InputNoun( prompt, noun )
  char *prompt;
  char *noun;
{
  int nn;

  cprintf( prompt );
  gets( noun );
  nn = GetNounNum( noun );
  resize_word( noun );
  return( nn );
}

/*----------------------------*/
/* Parse the command into the verb and noun, then find out the verb & noun #'s
*/
AnalyseCommand( cmd )
  CmdRec *cmd;
{
  ParseCommand( cmd->cm,   cmd->verb, cmd->noun );
  strlwr( cmd->verb );
  strlwr( cmd->noun );
  cmd->vn = GetVerbNum( cmd->verb );
  cmd->nn = GetNounNum( cmd->noun );

  strcpy( cmd->sh_verb, cmd->verb );
  resize_word( cmd->sh_verb );
  strcpy( cmd->sh_noun, cmd->noun );
  resize_word( cmd->sh_noun );
}


