/*
 * Polyadventure
 *
 * A remake of the various versions of the classic Adventure game by Don
 * Woods and Willie Crowther, based on their sources.  Currently, the 350,
 * 550, and 551-point versions are implemented.  See the file "ccr-help.t"
 * for more information.
 *
 * Please document all changes in the history so we know who did what.
 *
 * This source code is copylefted under the terms of the GNU Public
 * License.  Essentially, this means that you are free to do whatever
 * you wish with this source code, provided you do not charge any
 * money for it or for any derivative works.
 *
 *
 * Contributors (see history.t for current e-mail addresses)
 *
 *      bjs     In real life:   Bennett J. Standeven
 *
 *      djp     In real life:   David J. Picton
 *
 * Modification History
 *
 *
 * 24-Aug-99    bjs     Initial pre-release version 0.00
 *              bjs     Added 550-point characters, generalized Wumpus code,
 *                      split NPC file into three parts-one for each version.
 *
 * 3-Mar-00     djp     Initial beta release - Version 1.00
 *              djp     * Cleaned up a few bugs in the methods for attacking
 *                        and throwing objects at NPC's.  Also:
 *                      * Reworked attacking code to use the new
 *                        weapon class where appropriate.
 *                      * Reworked the code for 'throw x to enemy'.  When
 *                        weapons get trapped if they land close to the
 *                        enemy (e.g. the Bear), 'throw weapon TO enemy'
 *                        is the same as 'throw weapon AT enemy' but 'throw
 *                        other at enemy' resolves to 'give other to enemy'.
 *                        In other cases the latter choice is made for all
 *                        items. (exception: the Djinn)
 *                      * Removed redundant location code from
 *                        floatingdecoration objects.
 *                      * Implemented a heredesc for Slime and Basilisk.
 *                      * Ensured that 'giving' methods are inherited from
 *                        'feedable' rather than 'Actor' by adjusting the
 *                        order of classes (feedable comes before Actor etc)
 *                      * Added code to lock the grate when the blob
 *                        is summoned.
 *                      * Tidied up NPC interaction code to follow the
 *                        order:
 *                        Attacking
 *                        Kicking
 *                        Throwing
 *                        Giving
 *                        Feeding
 *                        Other
 *
 * 4-Apr-00     djp     Version 1.01: bugfix release
 *                      Changes in this version:
 *                      * Fixed faulty verification methods for attacking
 *                        the goblins.
 *                      * Fixed a bug preventing weapons being thrown at
 *                        the basilisk.
 *                      * Changed slime responses (objects given to or thrown
 *                        at the slime are absorbed, but reappear after the
 *                        vial has been used.  There is no longer any talk
 *                        of the slime being 'uninterested' - it's hard to
 *                        see how the player could deduce its state of mind!)
 *                      * Removed erroneous reference to the mybooth property
 *                        from Blob.dobjCheck.
 *
 * 18-Sep-00    djp     Version 2.00: New version with 701-point game
 *                      Changes in this version:
 *                      * Changes to support attacking with the gleaming
 *                        sword.
 *                      * SlimeRoom description changed to cater for looking
 *                        in using the crystal ball.
 *              
 * 25-Sep-00    djp     Version 2.01: bugfix release
 *
 * 20-Dec-00    djp     Version 2.02: bugfix release
 *                      Changes in this version:
 *                      * Added verification methods for rubbing NPCs. (N.B.
 *                        chasers already have a default)
 *
 * 8-Jun-01     djp     Version 2.05: bugfix release
 *                      Changes in this version:
 *                      * Added code for giving liquids to NPCs.
 *                      * Corrected bugs affecting contliquid items thrown
 *                        at certain NPCs (blob, slime) - the container
 *                        should be thrown, not the actual liquid.
 *                      * Corrected the description of the petrified
 *                        basilisk.
 *
 * 17-Aug-01    djp     Version 2.06: bugfix release with e-mail address update
 *                      Changes in this version
 *                      * Acknowledge honeycomb when trying to feed the ogre.
 *
 * 13-Jan-03    djp     Version 2.09 rev C: bugfixes and code tidy-up
 * 24-Jun-02    djp     Version 2.09: bugfixes and code tidy-up
 *                      Changes in this version
 *                      * Changed ActorAction to actorAction in Goblins
 *
 * 12-Aug-03    bjs     Version 2.11: added 580-point mode.
 *                      * Blob now calls cave-closing/security alert function 
 *                        to seal exits.
 *
 * 23-Jul-04    djp     Version 3.00.  Addition of a new game mode (701+).
 *
 * 12-Apr-05    djp     Version 3.10: Bugfixes and enhancements
 *                      * Corrected the location of the sword shards after
 *                        throwing the gleaming sword at the giant.
 *
 */

/*
 * This file handles non-player character movement and characteristics.
 *
 * Be sure to update exitlist and/or npclist if you add any new travel
 * verbs to CCR_Room.
 */

// NPCs for the 550-point version.

Goblins: feedable, Chaser

    isThem = true
    sdesc = "gooseberry goblins"
    ldesc = "Each goblin stands eight inches high on a pair of spindly
        black legs, has a globular, spine-covered body resembling a
        giant gooseberry, a wide mouth filled with sharp teeth, and a
        pair of glittering little green eyes!"

    moveinc = 1
    stayinc = 0

    noun = 'goblin' 'goblins' 'horde'
    adjective = 'gooseberry' 'silent' 'giggling' 'little'
                'slavering' 'vicious' 'goblins'

    // ATTACKING
    verDoAttack(actor) = {}
    doAttack(actor) = { "You attack the goblins and manage to squash
        a few, but the others overwhelm you, forcing you to the ground
        and ripping out your throat."; die();
    }
    verDoAttackWith(actor,io) = {}
    doAttackWith(actor, io) = {
        if (isclass(io,weapon)) {
            "You kill several of
            the gooseberry goblins with <<io.thedesc>>,
            but the others swarm at you, force you to the ground, and rip
            out your throat."; die();
        }
            else if (io = Hands) self.doAttack(actor);
            else "You'd be better off using your bare hands
            than that thing!";

    }
    // KICKING
    verDoKick(actor) = {}
    doKick(actor) = { return self.doAttack(actor);}

    // THROWING
    ioThrowAt(actor, dobj) = {
        if (isclass(dobj,weapon)) return self.doAttack(actor);
        else if (dobj = glass_vial) dobj.doThrowAt(actor, self);
        else if (dobj = DragonTeeth) { P(); "As each of the dragon's teeth
                            strikes the ground, a fully-armed human
                            skeleton springs up from where it struck
                            and leaps to your defense!  The skeletal
                            warriors attack the vicious gooseberry
                            goblins and drive them away in screaming
                            panic;  they then salute you with their
                            ancient and rusty swords, and fade silently
                            into nothingness."; P();
                        self.banish;  DragonTeeth.moveInto(nil);
        }
        else {
                "You miss. ";
                global.dropsilent := true;
                dobj.doDrop(actor);
                global.dropsilent := nil;
        }
    }
    verIoThrowTo(actor) = { self.verIoGiveTo(actor); }
    ioThrowTo(actor, dobj) = { self.ioGiveTo(actor,dobj); }

    // GIVING
    ioGiveTo(actor,dobj) = {
        if(isclass(dobj,contliquid) and ((dobj.myflag = &haswater) or
        (dobj.myflag = &haswine))){
            self.doFeedWith(actor,dobj);
        }
        else if(isclass(dobj,fooditem))self.doFeedWith(actor,dobj);
        else "The goblins show no interest in <<dobj.thedesc>>";
    }

    // FEEDING
    doFeed(actor) = {
        "Goblins live exclusively on human flesh, and you
        can't spare any of your own to placate them.  On the other
        hand, I suspect that they're going to eat you pretty soon
        whether you like it or not - you'd better find some way
        of killing or driving them away!";
    }
    doFeedWith(actor, io) = {
        if(isclass(io,contliquid) and ((io.myflag = &haswater) or
        (io.myflag = &haswine))){
            pass doFeedWith;
        }
        self.doFeed(actor);
    }

    // OTHER (mainly Chaser code)

    // Called once each turn that they chase the player.
    ChaseMsg() = {
        if(self.locstay = 0) "You are being pursued by a vicious
                               horde of little gooseberry goblins!\n";
        switch(chase) {
            case 1: "\nYou are surrounded by a horde of silent
                     little gooseberry goblins!";
                     break;
            case 2: P(); "One of the gooseberry goblins begins
                     to giggle in a high-pitched voice.  Another
                     takes up the giggling, then another...  soon
                     all of them are giggling insanely and
                     jumping up and down with glee!";
                    break;
            case 3: "\nYou are surrounded by a giggling horde of
                     little gooseberry goblins!";
                    break;
            case 4: P(); "The goblins are jumping up and down
                     frantically, and are working themselves
                     into a real slavering frenzy!!";
                    break;
            case 5: "\nYou are surrounded by a slavering horde
                     of gooseberry goblins!";
                    break;
            case 6: P(); "With a shrill cry, the gooseberry
                     goblins hurl themselves upon you, tickling
                     you mercilessly.  You crush and hurl away
                     several of them, but are soon borne down
                     to the ground by the endless attack.  The
                     goblins then gleefully rip out your throat,
                     and you sink into unconciousness.";
                    P(); break;
            default: break; // Their first message is given
        }                       // when they appear.
        if(self.chase > 5) die();
        if(Basilisk.isIn(self.location) and self.chase > 1)
             "\nFortunately, the sound is not loud enough to wake
             the basilisk.\n";     // BJS: added.
    }
    MagicMsg = {
        "Congratulations!  The goblins are unable to follow you.";
        self.banish; // Although I don't think the player will
                     // actually be able to escape this way.
                     // DJP - although the code allows the player more turns
                     // before the goblins kill him, there's no possibility of
                     // getting to Fake_Y2 soon enough.
    }
    SlippMsg = {return self.MagicMsg;}

    summon(...) = {
        P(); I();
        "Suddenly and without warning, there appears from
        within the very cave walls around you a horde of vicious
        little goblins!  Each one stands about eight inches high
        on a pair of spindly black legs, has a globular, spine-covered
        body resembling a giant gooseberry, a wide mouth filled with
        sharp teeth, and a pair of glittering little green eyes!"; P();
        self.ischasing := true;
        if(argcount > 0)
            self.moveInto(getarg(1));
        else
            self.moveInto(toplocation(parserGetMe()));
        self.prevloc := nil;  // needed to avoid false BackTrack calls
        notify(self, &move, 0);
    }
    backtrackAct() = {
        "\nYou leap over the goblins.\n";
    }
    verDoTake(actor) = { "Probably not a wise idea.";}
    actorAction(v, d, p, i) = {
        "The gooseberry goblins don't
        pay any attention.";
        exit;  // Don't obey the order.
    }   // Not "The gooseberry goblins doesn't seem interested."!

    verDoEat(actor) = { "Yeetttch!  I think I just lost my appetite.";}

    doCount(actor) = {
        "You haven't got time to hang around counting the goblins - there
        are far to many.";
    }
;

Blob: feedable, Chaser

    sdesc = "large white blob"
    ldesc = { P(); "It is six feet across and resembles a blob of
        translucent white jelly.  Although it looks massive, it is
        bouncing lightly up and down as though it were as light as
        a feather.  It is emitting a constant throbbing sound.";
    }

    moveinc = 1
    stayinc = 0

    noun = 'rover' 'blob'
    adjective = 'white' 'large' 'translucent' 'bouncing'
                'throbbing' 'roaring' 'immense' 'unfriendly'
                'looking' 'unfriendly-looking'

    // ATTACKING
    verDoAttack(actor) = {}
    doAttack(actor) = { "You attack the strange blob, but bounce
        harmlessly off of its strong but very rubbery skin.";
    }

    verDoAttackWith (actor, io) = {}
    doAttackWith(actor, iobj) = { if (isclass(iobj,weapon)) {
                                        "The "; iobj.sdesc; " cuts through
                                        the blob's body (?) without harming
                                        it. ";
                        }
                        else if (iobj = Hands) self.doAttack(actor);
                        else "You'd be better off using your bare hands
                                than that thing!";
    }
    // KICKING
    verDoKick(actor) = {}
    doKick(actor) = { return self.doAttack(actor); }

    // THROWING
    ioThrowAt(actor, dobj) = {
        local o := dobj;
        if (isclass(o,contliquid)) o := dobj.mycont;
        if (isclass(o,weapon)) {
            self.doAttackWith(actor,o);
            o.moveInto(droploc(actor));
        }
        else if (o = glass_vial) o.doThrowAt(actor, self);
        else {
            caps(); o.thedesc; 
            if(o.isThem) " bounce "; else " bounces ";
            "harmlessly off the blob's body.  You catch <<o.itobjdesc>> on the 
            rebound. ";
        }
    }
    verIoThrowTo(actor) = { self.verIoGiveTo(actor); }
    ioThrowTo(actor, dobj) = { self.ioGiveTo(actor,dobj); }

    // GIVING -- uses class feedable defaults

    // FEEDING -- uses class feedable defaults

    // OTHER - chaser code etc.

    // Called once each turn that it chases the player.
    ChaseMsg() = {
    if(self.stayloc = 0 and self.chase > 11)
        "The blob bounces after you.\n";
        switch(chase) {
            case 1: P(); "The bubbling sound grows louder.";
                     break;
            case 2: P(); "The bubbling sound ends with a loud
                     >splash<.";
                    break;
            case 3: P(); "A hollow, echoing >ROAR< sounds in the
                     distance.";
                    break;
            case 5: P(); "A strange throbbing sound can be
                     heard in the distance.";
                    break;
            case 7: P(); "The throbbing sound is growing louder.";
                    break;
            case 9: P(); "The source of the throbbing sound is
                      approaching quickly.  Another hollow
                      >ROAR< echoes through the cave.";
                    break;
            case 11: P(); "There is a loud >ROAR< only a short
                     distance away!!";
                    break;
            case 13: P(); I();
                    "Into view there bounces a horrible
                     creature!!  Six feet across, it resembles
                     a large blob of translucent white jelly;
                     Although it looks massive, it is bouncing
                     lightly up and down as though it were as
                     light as a feather.  It is emitting a
                     constant throbbing sound, and it >ROAR<s
                     loudly as it sees you."; P();
                    break;
            case 14: P(); "There is an immense and unfriendly-looking
                      blob in the room with you!"; break;
            case 15: P(); I();
                    "The blob >ROAR<s triumphantly
                     and bounces straight at you with
                     amazing speed, crushing you to the
                     ground and cutting off your air
                     supply with its body.  You quickly
                     suffocate."; break;
            default: break; // The first message is given
        }                   // when it appears.
        if(Basilisk.isIn(self.location))
            "\nFortunately, the sound is not loud enough to wake
            the basilisk.\n";     // BJS: added.
        if(self.chase > 14) die();
    }
    MagicMsg = "Oops! Magic words aren't supposed to work when the blob
        is chasing you!"
    SlippMsg = "Oops! The slippers and the blob cannot exist together!"

    summon(...) = {
        P(); I(); "From somewhere in the distance comes an ominous
        bubbling sound. ";
        start_closing(nil); // Security alert.
        pass summon;
    }
    backtrackAct() = { // Do nothing.
    }

    listendesc = {
        switch(chase) {
            case -1:
            case 0:
            case 1:
                "You hear a bubbling sound in the distance. ";
                break;
            case 2:
            case 3:
            case 4:
                "You hear nothing unexpected. ";
                break;
            case 5:
            case 6:
            case 7:
            case 8:
                "A strange throbbing sound can be heard in the distance. ";
                break;
            case 9:
            case 10:
            case 11:
            case 12:
                "A strange throbbing sound can be heard, approaching
                quickly. ";
                break;
            case 13:
            case 14:
            case 15:
                caps(); self.thedesc; " is making a strange throbbing
                sound. It >ROAR<s as you look at it. ";
            break;
        }
    }
    dobjCheck(a, v, i, p) = {
        if(self.chase >= 13 or v = summonVerb or v = banishVerb or
        v = gonearVerb or v = listenVerb)
            return;
        if(v = inspectVerb) {
            "It hasn't yet come into view. ";
            exit;
        }
        else {
            "It's too far away. ";
            exit;
        }
        exit;
    }
    iobjCheck(a, v, d, p) = {
        if (v = askVerb or v = tellVerb) return;
        self.dobjCheck(a, v, d, p);
    }

    verDoEat(actor) = { "Yeetttch!  I think I just lost my appetite.";
    }
    doSummon(actor) = {
        local waschasing := self.ischasing;
            if (not waschasing) self.move; // initialize variables
            inherited.doSummon(actor);
            if (not waschasing) self.chase := 12; // make blob appear
    }
;

Turtle: feedable, Actor // can attempt to feed, but default responses given
        sdesc = "Darwin the Tortoise"
        thedesc = {self.sdesc;}
        adesc = {self.sdesc;}
        ldesc = "On the tortoise's back is inscribed, \"I'm
                 Darwin - ride me!\"."
        actorDesc = "Darwin the tortoise is swimming in the
                        reservoir nearby."
        location = nil
        noun = 'tortoise' 'turtle' 'Darwin'
        adjective = 'large' 'Darwin'

        //ATTACKING,KICKING,THROWING not implemented
        //GIVING, FEEDING uses class feedable defaults

        doBoard(actor) = { Reservoir.doCross(actor); }
        verDoBoard(actor) = {}
        doRide(actor) = { Reservoir.doCross(actor); }
        verDoRide(actor) = {}
        doEnter(actor) = { Reservoir.doCross(actor); }
        verDoEnter(actor) = {}
;

// DJP - Basilisk and Basilisk_Statue changed to floatingdecoration
Basilisk: floatingdecoration
    game550 = true
    alive = true
    sdesc = "basilisk"
    ldesc = {
        local actor := getActor(&currentActor);
        "I wouldn't wake it up if I were you.  ";
        if(actor.isIn(North_Basilisk))
            "It is asleep, but is twitching
            and grumbling as if restless.";
    }
    noun = 'basilisk' 'monster' 'beast' 'lizard'
    adjective = 'sleeping' 'twitching' 'grumbling'

    locationOK = true   // OK for location to be method.
    loclist = [North_Basilisk South_Basilisk]

    heredesc = {
        P(); I();
        if (self.isIn(South_Basilisk))
            "There is a basilisk lying
            in the corridor to the north, snoring quietly.";
        else
            "There is a basilisk
            in the corridor to the south.  It is
            asleep, but twitching and grumbling
            as if restless.";
    }

    // ATTACKING
    verDoAttack(actor) = {}
    doAttack(actor) = {
        "You attack the basilisk mightly.  It instantly
        awakens and looks you dead in the eye, and
        your body turns into solid rock.";
        die();
    }
    verDoAttackWith(actor, io) = {}
    doAttackWith(actor, io) = {
        if (isclass(io,weapon)) {
            caps; "<<io.thedesc>> rebounds harmlessly from the
            basilisk's tough scales.  The basilisk awakens,
            grunting in shock, and glares at you.  You are
            instantly turned into a solid rock statue (and
            not a particularly impressive one, at that).";
            die();
        }
        else if (io = Hands) {
            self.doAttack(actor);
        }
        else {
            "You'd probably be better off using your
            bare hands than that thing!";
        }
    }

    // KICKING
    verDoKick(actor) = {}
    doKick(actor) = {
        self.doAttack(actor);
    }

    // THROWING
    verIoThrowAt(actor) = {}
    ioThrowAt(actor, dobj) = {
        if (isclass(dobj,weapon))
            self.doAttackWith(actor, dobj);
        else if (dobj = glass_vial) dobj.doThrowAt(actor, self);
        else
            self.ioGiveTo(actor, dobj);
    }
    verIoThrowTo(actor) = { self.verIoGiveTo(actor); }
    ioThrowTo(actor, dobj) = { self.ioGiveTo(actor,dobj); }

    // GIVING
    verIoGiveTo(actor) = {"You couldn't do that without waking
        the basilisk, which would be a very bad idea. ";}
    ioGiveTo(actor,dobj) = {self.verIoGiveTo(actor);}

    // FEEDING - not implemented

    // OTHER
    // DJP - added methods for waking

    verDoWake(actor) = {}
    doWake(actor) = {
            if (metal_plate.isIn(actor)) Basilisk.petrified;
            else Basilisk.petrifier;
    }

    petrified = {
        "The basilisk stirs grumpily and awakens, peering sleepily
        about.  It sees its reflection in the metal plate that
        you are carrying, shudders, and turns into solid granite.";
        P();
        self.alive := nil;
        BasiliskStatue.moveLoclist(self.loclist);
        self.moveLoclist([]);
    }
    petrifier = {
        "The basilisk stirs grumpily and awakens, peering sleepily
        about.  It spies you, growls, and stares you straight in the
        eye.  Your body is instantly petrified.";

        die();
    }
    verDoRub(actor) = {"Don't be ridiculous!";}
;
BasiliskStatue: floatingdecoration
    game550 = true
    sdesc = "petrified basilisk"
    ldesc = {
        "It looks just the same as it did before it was petrified.";
    }
    heredesc = {
        P(); I();
            "There is a petrified basilisk
            in the corridor to the ";
        if (self.isIn(South_Basilisk))
            "north. ";
        else
            "south. ";
    }

    locationOK = true   // OK for location to be method.
    loclist = []
    noun = 'basilisk' 'statue'
    adjective = 'petrified' 'basilisk' 'statue' 'dead'

    // ATTACKING
    verDoAttack(actor) = { self.verDoKick(actor); }
    verDoAttackWith(actor, io) = { self.verDoKick(actor); }
    // KICKING
    verDoKick(actor) = { "You've already done enough damage!"; }
;

Djinn: Actor
    sdesc = "twelve-foot tall djinn"
    ldesc = "The djinn seems impatient for you to open the pentagram."
    actorDesc = "There is a twelve-foot djinn standing in the center
            of the pentagram, glowering at you."
    // I don't think that it actually gets printed, though.
    location = nil
    noun = 'djinn' 'genie'
    adjective = 'tall' 'twelve' 'foot' 'twelve-foot'
    phugggtell = { if(phugggVerb.isused) return;
        P();
        "A large phosphorescent cloud of smoke drifts into
         view, and a large mouth and two dark eyes take shape
         on the side.  One of the eyes winks at you, and the
         djinn's deep voice says \"GREETINGS AGAIN, MORTAL.  I
         HAVE REMEMBERED A PIECE OF ANCIENT LORE THAT I LEARNED
         FROM MY AUNT, AN AFREET OF GREAT KNOWLEDGE.  THERE
         IS ANOTHER MAGIC WORD THAT YOU MIGHT FIND OF USE IF
         YOU SHOULD EVER FIND YOURSELF BEING ATTACKED BY THOSE
         PESTIFEROUS DWARVES.  YOU SHOULD USE IT ONLY AS A LAST
         RESORT, THOUGH, SINCE IT IS A MOST POTENT WORD AND IS
         PRONE TO BACKFIRE FOR NO OBVIOUS REASON;  ALSO, IT
         SHOULD NEVER BE USED NEAR WATER OR NEAR ANY SHARP
         WEAPON OR THE RESULTS MAY BE MOST UNFORTUNATE.  THE
         WORD IS 'phuggg'\", whispers the djinn, \"AND IT MUST
         BE PRONOUNCED CAREFULLY IF IT IS TO HAVE THE PROPER
         EFFECT.  FAREWELL AGAIN, AND GOOD LUCK!\" With that,
         the djinn-cloud drifts away out of sight.";
        P();
    }
    phugggtime = 5

    // ATTACKING
    verDoAttack(actor) = {}
    doAttack(actor) = {
        "That's not a wise thing to try - djinni are
        essentially immortal and thus pretty hard
        to hurt. Besides, this one seems rather
        friendly - why don't you just try releasing
        him?";
    }
    verDoAttackWith (actor, io) = {}
    doAttackWith(actor, io) = { self.doAttack(actor); }

    // KICKING
    verDoKick(actor) = {}
    doKick(actor) = { self.doAttack(actor); }

    // THROWING
    verIoThrowAt(actor) = {}
    verIoThrowTo(actor) = {}
    ioThrowAt(actor, dobj) = { Floor_Pentagram.ioThrowAt(actor, dobj); }
    ioThrowTo(actor, dobj) = { Floor_Pentagram.ioThrowAt(actor, dobj); }

    // OTHER
    verDoDrop(actor) = {} // Since "free" is a synonym for "drop", but
    doDrop(actor) = { Floor_Pentagram.doOpen(actor); } // we're not really
                                                       // carrying the djinn.
    verDoRub(actor) = {"Don't be ridiculous!";}
;

Ogre:   feedable, Actor
    game550 = true
    exists = true
    sdesc = "nasty ogre"
    ldesc = "The ogre looks exceptionally large and nasty."

    actorDesc = {
        "There is a large, nasty-looking ogre blocking your
        path!";
    }

    noun = 'ogre'
    adjective = 'nasty' 'large' 'nasty-looking'

    location = Glassy_Room

    // ATTACKING
    verDoAttack(actor) = {}
    doAttack(actor) = {
        self.rhetoricalturn := global.turnsofar;
        "What, with your bare hands? ";
    }
    nicetry() = {
        if (rand(2)-1)
            "You attack the ogre, but he fends off
            your attack easily and comes very close
            to crushing your skull with *his* bare
            (but extremely strong) hands.  You are
            forced to retreat in disgrace.";
        else {
            "You attack the ogre - a brave but foolish action.
            He quickly grabs you and with a heave of his
            mighty arms rips your body limb from limb.";
            die();
        }
    }
    verDoAttackWith(actor, io) = {}
    doAttackWith(actor, io) = {
        //
        // Can't kill the ogre except by throwing something at him.
        //
        if (isclass(io,weapon)) {
            "The ogre contemptuously catches "; io.thedesc;
            " in mid-swing, rips it out of your hands, and
            uses it to chop off your head.";
            die();
        }
        else if (io = Hands) { self.nicetry; }
        else "You'd be better off using your bare hands than
              that thing!";
    }

    // KICKING
    verDoKick(actor) = {}
    doKick(actor) = {
        if (rand(2)-1)
            "You attack the ogre, but he fends off
            your attack easily and comes very close
            to crushing your skull with his bare hands.
            You are forced to retreat in disgrace.";
        else {
            "You attack the ogre - a brave but foolish action.
            He quickly grabs you and with a heave of his
            mighty arms rips your body limb from limb.";
            die();
        }
    }

    // THROWING
    verIoThrowAt(actor) = {}
    ioThrowAt(actor, dobj) = {
        if (isclass(dobj,weapon) and not (dobj = singing_sword)) {
            "The ogre casually catches <<dobj.thedesc>> in mid-air, ";
            if(dobj = sword) "and cries \" Hah! I've nothing to fear
            from a rusty old sword like that!\"  Before you have time
            to ponder his words (you can't see any rust on
            the sword) he ";
            "braces his feet, winds up and throws it
            straight back at you with incredible force.
            You are unable to dodge it and it chops you
            in half";
            if (dobj = sword) {
                swordshards.moveInto(self.location);
                dobj.moveInto(nil);
                ", then shatters to pieces as it hits the wall of the room. ";
            }           
            else ". ";
            die();
        }
        else if( dobj = singing_sword ) {
            "The sword halts in mid-air, twirls like a
             dervish, and chants several bars of \"Dies
             Ire\" in a rough tenor voice.  It then begins
             to spin like a rip-saw blade and flies
             directly at the ogre, who attempts to catch
             it without success;  it strikes him full
             on the chest.  There is a brilliant flash
             of light, a deafening roar and a cloud of
             oily grey smoke;  when the smoke clears
             (and your eyes begin working properly again)
             you see that the ogre has vanished.  The sword
             is lying on the ground, sparking and flaming.
             Before your eyes it softens and melts, writhes
             as if in pain, and shrinks rapidly until all
             that is left is a small silvery ring which
             cools rapidly.";
            singing_sword.moveInto(nil);
            Ogre.moveInto(nil);
            Ogre.exists := nil;
            mithril_ring.moveInto(Glassy_Room);
        }
        else pass ioThrowAt;
    }
    verIoThrowTo(actor) = {}
    ioThrowTo(actor,dobj) = {self.ioGiveTo(actor,dobj);}

    // GIVING uses defaults for class feedable

    // FEEDING
    doFeedWith(actor,io) = {
        if(isclass(io,contliquid) and ((io.myflag = &haswater) or
        (io.myflag = &haswine))){
            pass doFeedWith;
        }
        else if (isclass (io,fooditem))
            "The ogre doesn't seem interested in <<io.thedesc>> - maybe
            he isn't hungry. ";
        else
            "The ogre doesn't seem interested in <<io.thedesc>>. ";
    }

    doFeed(actor) = {
        if (tasty_food.isIn(actor) or honeycomb.isIn(actor)) {
            "The ogre doesn't seem interested in the food - maybe
            he isn't hungry. ";
        }
        else {
            "You have nothing the ogre wants to eat.";
        }
    }
    // OTHER
    disavow = "The ogre doesn't appear to be very interested in answering
        questions. "
    verDoTellAbout(actor,io) = {"The ogre doesn't seem to be very
        interested in making conversation. ";}
    verDoRub(actor) = {"Don't be ridiculous!";}
;

Slime: fixeditem, feedable
    game550 = true
        exists = true
        sdesc = "slime"
        ldesc = "A sheet of evil-looking green slime swathes the floor to
         the south.  It is twitching and flowing as though aware of
         your presence."
    heredesc = {P(); I(); "The passage to the south is swathed
           with sheets of evil-looking green slime, which
           twitch and flow as if aware of your presence.";}
    location = Crack_2
    noun = 'slime' 'sheet'
    adjective = 'green' 'evil' 'evil-looking' 'sheet' 'slime'
        'slimy' 'acidic'

    // ATTACKING
    verDoAttack(actor) = {}
    // DJP - attacking without a weapon now prompts the player; saying
    // 'yes' to bare hands results in death.
    doAttack(actor) = {
        "With what?  %Your% bare hands?";
        self.rhetoricalturn := global.turnsofar;
    }
    verDoAttackWith(actor, io) = {}
    // attacking with objects has no effect, but bare hands are fatal.
    doAttackWith(actor, io) = {
        if (io = Hands) self.doTouch(actor);
        else "The slime is unaffected by your attack. ";
    }

    // KICKING
    verDoKick(actor) = {}
    doKick(actor) = {self.doTouch(actor);}

    // THROWING
    verIoThrowAt(actor) = { self.verIoGiveTo(actor); }

    // DJP: Objects which are thrown get trapped in the slime.  This isn't
    // true to the original game, but probably more logical!
    ioThrowAt(actor, dobj) = {
        local o := dobj;
        if(isclass(dobj,contliquid)) o := dobj.mycont;
        if (o = glass_vial) o.doThrowAt(actor, self);
        else {
            caps(); o.thedesc;
            " <<o.isdesc>> caught up in
            the slime, which flows down and
            hides <<o.itobjdesc>> from view. ";
            o.moveInto(SlimeRoom);
        }
    }
    verIoThrowTo(actor) = { self.verIoGiveTo(actor); }
    ioThrowTo(actor, dobj) = {self.ioGiveTo(actor,dobj);}

    // GIVING
    verIoGiveTo(actor) = {}
    ioGiveTo(actor,dobj) = {
        self.ioThrowAt(actor,dobj);
    }

    // FEEDING
    doFeed(actor) = {
        "There's nothing here it wants to eat (except
        perhaps you).";
    }

    /* DJP - 'feed slime with me' now does just that. */
    doFeedWith(actor, io) = {
        if (io = Me) {
            "Self-sacrifice is \(not\) the object of this game!
            However, if you really want to become food to
            repulsive slime ... "; P();
            self.doTouch(actor);
        }
        else if (testtake(actor,io)) self.ioGiveTo(actor,io);
    }

    // OTHER

    verIoPutIn(actor) = {}
    ioPutIn(actor,dobj) = {self.ioThrowAt(actor,dobj);}

    verDoRub(actor) = {}
    doRub(actor) = {self.doTouch(actor);}
    verDoTouch(actor) = {}
    doTouch(actor) = { "As you touch the slime, it flows up your body
        and rapidly digests away all of your flesh.";
        die();
    }
    verDoCross(actor) = {}
    doCross(actor) = {
        "As you enter the passage, you are forced to
        brush up against some of the green slime.  Instantly
        it flows down and covers your body, and rapidly
        digests away all of your flesh.";
        die();
    }
    verifyRemove(actor) = { "Surely you're joking."; }
;

SlimeRoom: NoNPC // DJP - repository for objects thrown at slime
                 // Description changed for 701-point game - we can see in
                 // using the crystal ball if the sapphire and a light source
                 // are both present.
sdesc = "In Slime"
ldesc = {I();
        "You are trapped in an opaque mass of green slime. ";
    }
;

