/*
 * The Legend Lives!
 *
 * Executable and source code are
 *
 *                 Copyright (C) 1995 by David M. Baggett
 *
 * All rights reserved, except as follows:
 * 
 *    Electronic redistribution is permitted, but only if not for profit.
 *    Specifically, you may provide copies in electronic form ONLY if you
 *    do not charge anything beyond the distribution media cost AND if you
 *    do not alter the source code in any way.
 *
 * Note that the author reserves all rights to derivative works and
 * products.  This includes ports and enhanced versions.  The author will
 * typically grant permission for these when asked, but this will be
 * dealt with on a case by case basis only.
 *
 */

/*
 * The Orf System
 *
 * This system contains Flora, homeworld of the Barfee Outlet.
 *
 * Includes:
 *
 * Colorspace Orchid
 */

barfee: Outside
	sdesc = "Barfee Outlet -- Seed Central"
	ldesc = {
		I(); "You are standing in the center of the Barfee
		Outlet, right next to the main matter mover.  Creatures
		of all races bustle around madly, looking for great
		deals on seeds.  A huge neon sign right beyond your nose
		screams, \"Welcome to planet Flora, home of Barfee:
		your one-stop source for vegetation.\""; P();
		
		I(); "Here in the middle of Seed Central there's really
		nothing but people, and lots of them.  Or make that
		\"creatures.\"  In any case, from here Barfee looks like a
		giant open market, with little stands here and there, and
		patrons and salescreatures arguing loudly over prices."; P();
		
		I(); "The northern area of this arena seems to be 
		devoted to vegetable seeds, while the southern area
		caters to fruit buyers.  To the east is a large warehouse
		in which they sell various varieties of flowers but the 
		crowd gets really thick in that direction.  Westward
		you see all kinds of growing supplies.";
	}

	north = vegetables
	south = fruits
	east = {
		"You fight your way through the thick throng and, gasping
		for breath, arrive at the..."; P();
		return flowers;
	}
	west = supplies

	in = { BARFEEmover.doEnter(Me); return nil; }
;

class BARFEEdecoration: Decoration location = barfee;

BARFEEstands: Distant, BARFEEdecoration
	sdesc = "stands"
	ldesc = "The stands are all different shapes and sizes."
	noun = 'stands' 'carts' 'stand' 'cart' 'market'
	adjective = 'open' 'little'
;
BARFEEsign: Readable, BARFEEdecoration
	sdesc = "Barfee sign"
	readdesc = { self.ldesc; }
	ldesc = "The sign is grotesquely loud and is written in
		many different languages."
		
	verDoTake(actor) = {
		"It's about ten times larger than you are.  Just
		reading the whole thing gives you a kink in your neck.";
	}
;

BARFEEfolks: floatingdecoration
	sdesc = "Barfee customers"
	adesc = { self.sdesc; }
	ldesc = "They're all scurrying about in a frenzy, looking for 
		great prices on foodstuffs."
	noun = 'customers' 'creatures' 'people' 'buyers' 'folks' 'patrons'
			'throng' 'crowd' 'mass'
	adjective = 'barfee'
	loclist = [barfee vegetables fruits flowers supplies]
;

BARFEEmover: BARFEEdecoration, mattermover
	autoreset = true	// resets to (0, 0, 0) after move

	address = {
		"The machine's address is written in flowery green script:
		\n\t\"Barfee: (8549, 4392, 8392) -- Orchid\"";
	}
	
	ar = 8549
	ag = 4392
	ab = 8392

	r = BARFEEred
	g = BARFEEgreen
	b = BARFEEblue

	colorspace = 'Orchid'
	system = 'Orf'
	planet = 'Flora'
;

BARFEEred: BARFEEdecoration, reddial		setting = 0 ;
BARFEEgreen: BARFEEdecoration, greendial	setting = 0 ;
BARFEEblue: BARFEEdecoration, bluedial		setting = 0 ;

vegetables: Outside
	sdesc = "Barfee Vegetable MegaStore"
	ldesc = {
		I(); "You are in the Barfee Vegetable MegaStore, standing
		in front of a large bin filled with seed packets.  There
		are so many shoppers here that this is really the only
		place you can get to the goods -- it's that crowded.
		Seed Central is to the south.";
	}
	south = barfee
	
	enter(actor) = {
		notify(VEGseller, &talk, 0);
		inherited.enter(actor); 
	}
	leave(actor) = {
		unnotify(VEGseller, &talk);
		inherited.leave(actor);
	}
;

VEGbin: Decoration, Qcontainer
	sdesc = "Barfee vegetable seed bin"
	location = vegetables
	maxbulk = 100
	noun = 'bin' 'container' 'barrel' 'box'
	adjective = 'vegetable' 'barfee' 'seed'

	//
	// Can't put anything in the bin.
	//
	passcantakeout(actor, obj, loctype) = {
		"If you put something in the bin, you'll likely
		have to pay to get it back.";

		return nil;
	}
;

VEGseller: Female, Actor
	paid = nil

	sdesc = "matronly old salescreature"
	ldesc = {
		I(); "From her green skin and red and silver hair it's 
		obvious she is a native of Foon, a farming planet
		in your home system of Val "; note(self); ". She's
		quite wide around the beam, but in a pleasant way that
		makes her seem to be perpetually chuckling.  At the moment
		you are her only customer; her stand is an island of
		bare space in the midst of a thick throng of creatures
		bearing in on all sides.";
	}
	noun = 'creature' 'salescreature' 'woman' 'lady' 'salesman'
		'salesperson' 'storekeeper' 'shopkeeper' 'keeper'
		'farmer' 'mother' 'mom' 'person' 'foonian'
		'hick' 'hillbilly' 'saleswoman'
	adjective = 'matronly' 'sales' 'shop' 'old' 'big' 'large' 'foreign'
		'foon' 'cassandra\'s' 'kessawndre\'s' 'backwoods'
		'backwater' 'seed' 'barfee'
	location = vegetables

	footnote = {
		"Foon has a reputation for being a bit -- how to put
		this? -- backwater.  Neither the advent of miraculous new
		technology nor the formation of the Republic has changed
		the Foonians' simple way of life one bit.  They provide
		much of the food for Tode, Tel, Hop, and Kuwl, however,
		and as such are appreciated in the Val system even though
		they're considered frighteningly rural by today's
		standards.";
	}

	actordesc = { 
		"A matronly Foonian salescreature watches you
		expectantly from behind the bin.  She seems eager
		to engage you in conversation."; 
	}

	listendesc = { "She keeps going on about her daughter."; }

	pay = {
		"The old woman takes your card and disappears into the
		throng.  Moments later she returns.  \"It suz your
		card haws been terminotud.  Yee butter call your bank,
		Senny, boofore semone errusts yee!  Probeblu jest eh
		kempyeeter glitch, Au knai, bet Au jest cawn't toke
		your card with thawt flawg roused,\" she says
		regretfully.";
	}


	verDoPay(actor) = {}
	doPay(actor) = {
		if (galacticard.isin(Me))
			self.pay;
		else
			"You'll have to be a bit more specific --
			you don't have your Galacticard with you.";
	}

	verIoGiveto(actor) =  {}
	ioGiveto(actor, dobj) = {
		I();

		if (dobj = galacticard) {
			self.pay;
		}
		else if (dobj = akmid) {
			"The woman smiles understandingly.  \"Thawt's
			not qwaut uneff fair eh pawckut ev soods thooz
			doze, Au'm efrode,\" she laments.";
		}
		else if (dobj = creditslip) {
			"\"Ahh,\" the old woman exclaims, \"stare crudit.
			Thawt'll dee jest faun; toke eh sood pawckut frem
			theh bin, Senny.\"";
			
			self.paid := true;
			creditslip.movein(nil);
		}
		else if (dobj.isseeds) {
			if (dobj.isfruit) {
				"\"Yee'll hawve tee toke thayze tee theh
				freet urueh ayver thore,\" she explains,
				pointing southward.  \"Au cawn't give yee
				cruhdit fair thayze hoor.\"";
			}
			else if (dobj.isveg) {
				"\"Yee'ld lauk tee uxchonge thayse?  All
				raught, hoor's stare crudit for thum,\"
				the woman says, handing you a store
				credit recipt.";
				
				creditslip.movein(Me);
				dobj.movein(VEGbin);
			}
			else {
				"\"Yee'll nood tee toke thayse ulsewore,
				Au'm efrode,\" the woman says, shaking
				her head.";
			}
		}
 		else {
			"\"Aum sarru sir, bet Au cawn't Auccupt thawt
			instud ev kerruncy,\" she explains carefully,
			nodding her head left and right.";
		}
	}

	verDoAskfor(actor, io) = {}
	doAskfor(actor, io) = {
		if (io = VEGdaughter)
			self.doAskabout(actor, io);
		else
                        "\"Au cawn't give yee thawt,\" she says.";
	}
	verDoAskabout(actor, io) = {}
	doAskabout(actor, io) = {
		I();

		if (io = VEGdaughter) {
			if (farmpaper.location = nil) {
				"She hands you a scrap of paper.  \"If yee
				wawnt tee knai ebait her, whau not pou her
				eh visit?  Jest yeese this nember awnd yee'll
				bu raught noor theh farm.  Au'll lut her
				knai you're kemming!,\" the old woman says
				gleefully.";
			
				farmpaper.movein(Me);
				ELmover.accepting := true;

				incscore(2);
			}
			else {
				"The woman smiles reassuringly.  \"Bau all
				moons yee should pou her eh visit.  Her
				Pa awnd Au wain't maund awt all, Senny,\"
				she cuckles.";
			}
		}
		else if (io = eggseeds) {
			// actually we just use this to match "eggplant".

			"\"This big araind!\" she exclaims. \"What un
			euggplawnt thawt wez.\"";
		}
		else if (io = farmpaper) {
			"\"Thawt's theh nember, mau bayu,\" she tells you.";
		}
		else if (io.isseeds) {
			"\"Thawt's a good stroun.  A good bau, Au tull yee,\"
			she proclaims enthusiastically.";
		}
		else if (io = creditslip) {
			"\"Stare crudit, Senny,\" the Foonian says.";
		}
		else
			"\"Au cawn't tull yee mech ebait thawt,\" she says.";
	}

	verDoTellabout(actor, io) = {}
	doTellabout(actor, io) = {
		"The woman seems more interested in her merchandise
		than your story.";
	}

	verIoShowto(actor) = {}
	ioShowto(actor, dobj) = { self.doAskabout(actor, dobj); }

	verDoSprayWith(actor, io) = { "Don't be a jerk."; }

	Message = [
		'The Foonian gives you a wink and says, "Hawve Au taled yee
		ebait mau daghter yut, Senny? Shu\'s working an theh farm
		bawk an Feen, yee knai, graying uggplawnts.  Shu\'s eh 
		faun wen, mau Kessawndreh."  She gives you a little nudge
		with her elbow.'

		'"Cawn Au intrust yee in sem soods teedowu, mau bayu?" the
		saleswoman asks eagerly, motioning broadly at the packages
		in the bin.'

		'"Mau Kessawndreh wen eh contust jest thu ethur dowu,"
		the hefty Foonian proclaims loudly, "fare graying theh
		larjust uggplawnt in all ev Feen.  Theh uggs ware this
		big araind awnd made en ahfeel towstu omlutte!"  She
		makes a gesture with her hands that suggests something
		about 8 inches across.'

		'"Yare buing ahfeel quayut, Senny," the saleswoman
		says, "Dee yee nood sem hulp with theh goods?"'

		'The salesperson says, "Cawn Au intrust yee in sem
		faun vujtebble soods teedowu?  Awz yee cawn su wu
		hawve en uxsellunt seluction!"'

		'The matronly saleswoman looks up from her seeds and
		eagerly implores, "Yee mest visit mau daghter, Senny,
		shu\'s quaute eh girl thawt wen.  If yee want her nember,
		jest awsk; yee look lauk eh faun ooneff bayu -- hawndsem awnd 
		vury learnud Au\'ll but."'

		'"Bawk an Feen wu\'ve got theh bust graying sail in theh
		gawluxy," the woman brags, "which is whau uveruwen kems
		tee es fair thore freets awnd vujtebbles.  Wu\'ve nay 
		nood fair fawncy tuchnaleju yee knai."'

		'"So, bayu," the saleswoman mentions, "if yee dayn\'t maund
		mu awsking, are yee frem Tade?  Au that Au keed tull
		frem yair mawnnerisms, thawt\'s al.  Yee maught oovun
		so yee look lauk wen ev theh Vawllu Kings -- fawnsu 
		thet!  Dayn\'t seppase yair rulotud?"'

		'"Hawve Au taled yee ebait mau daghter Kessawndre\'s
		uggplawnt shu wen theh graying contust with?  Thue
		uggs were jest dropping aff thawt thing -- wu hawd
		ooneff uggs tee lawst eh menth!," the woman laughs.'
	]

	talk = {
		P(); I(); say(self.Message[rnd(9)]);
	}

	doSmell(actor) = {
		"Don't be gross.";
	}
	verDoRub(actor) = {
		"I don't think the matronly saleswoman would
		be interested in your amorous advances.";
	}	
	verDoAttackwith(actor, io)  = {}
	doAttackwith(actor, io) = { "Now, now... be nice."; }
;
farmpaper: Item, Readable
	sdesc = "crumpled scrap of paper"
	ldesc = "Written in barely-legible script is
		\"Cassandra: Elwood Farm (3921, 5840, 9278)
		(Just up road from mover.)\""
	readdesc = { self.ldesc; }
	location = nil
	
	noun = 'paper' 'scrap' 'number' 'address'
	adjective = 'illegible' 'small' 'woman\'s' 'cassandra\'s' 'matter'
			'mover' 'mattermover' 'elwood' 'farm' 'farm\'s'
			'crumpled'
;
creditslip: Item, Readable
	sdesc = "store credit receipt"
	ldesc = "It's a Barfee store credit receipt.  It says, \"Good for
		one Barfee seed packet.\""
	location = nil
	
	noun = 'receipt' 'reciept' 'paper' 'slip'
	adjective = 'store' 'credit' 'money' 'return' 'seed' 'barfee' 'packet'
;

fruits: Outside
	sdesc = "Barfee Fruit MegaStore"

	ldesc = {
		I(); "The Barfee Fruit MegaStore is not quite as crowded
		as the rest of the outlet, but than again that's not
		saying much.  Fortunately walking around is easy here,
		and you can actually breathe, which is a definite plus."; P();

		I();
		if (not self.isseen) {
			"You find a friendly-looking salesperson standing
			in front of a large bin and approach him.  From
			the looks of it, he's a Hoppian.  (The big 
			floppy ears give it away.)";
		}
		else {
			"You are standing in front of the friendly Hoppian's
			bin.";
		}
		
		" The bin is filled with fruit seed packets.  Seed Central
		is north of here.";
	}

	north = barfee
	
	enter(actor) = {
		notify(FRUITseller, &talk, 0);
		inherited.enter(actor);
	}
	leave(actor) = {
		unnotify(FRUITseller, &talk);
		inherited.leave(actor);
	}
;
FRUITbin: Decoration, Qcontainer
	sdesc = "Barfee fruit seed bin"
	location = fruits
	maxbulk = 100
	noun = 'bin' 'container' 'barrel' 'box'
	adjective = 'fruit' 'barfee' 'seed'

	//
	// Can't put anything in the bin.
	//
	passcantakeout(actor, obj, loctype) = {
		"If you put something in the bin, you'll likely
		have to pay to get it back.";

		return nil;
	}
;
FRUITseller: Male, Actor
	paid = nil

	sdesc = "Hoppian salesman"
	ldesc = {
		I(); "It's hard to say what makes it more obvious that
		the salesman standing in front of you is a Hoppian --
		the fact that he looks like a giant rabbit, or the
		fact that he's exceedingly well-dressed.  The tuxedo
		looks quite smart on the 10-foot tall Barfee representative,
		whose light gray fur and two oversized shiny white teeth
		perfectly complement his picture-perfect formalwear.  His
		large, floppy ears might be best tucked into a spiffy
		top hat, you think, but then again they do add a
		bit of levity to an otherwise stuffy appearance.";
	}
	noun = 'creature' 'salescreature' 'salesman'
		'salesperson' 'storekeeper' 'shopkeeper' 'keeper'
		'person' 'rabbit' 'bunny' 'seller' 'man'
		'tuxedo' 'fur' 'ears' 'teeth' 'formalwear' 'hoppian'
	adjective = 'sales' 'shop' 'old' 'big' 'large' 'foreign'
		'hop' 'seed' 'barfee'
		'light' 'gray' 'grey' 'floppy' 'two' 'oversize'
		'shiny' 'white'
	location = fruits

	islistable(actor) = {
		if (fruits.isseen)
			return true;
		else
			return nil;
	}
	actordesc = { 
		if (fruits.isseen) {
		       "The tall and dapper Hoppian salesman tends to
			the bin in front of you. He nods politely as you
			look at him.";
		}
	}

	pay = {
		"The Hoppian smiles broadly as he takes the
		Galacticard.  \"Credit;\" he chimes, \"very well,
		Sir,\" and disappears into the throng for a moment.
		He returns with an expression that seems to indicate
		that he's just gotten a whiff of something very
		unpleasant, and informs you that your card has been
		declined.  Gosh, I wonder what's happened to your
		credit rating?";
	}


	verDoPay(actor) = {}
	doPay(actor) = {
		if (galacticard.isin(Me))
			self.pay;
		else
			"You'll have to be a bit more specific --
			you don't have your Galacticard with you.";
	}

	verIoGiveto(actor) =  {}
	ioGiveto(actor, dobj) = {
		I();

		if (dobj = galacticard) {
			self.pay;
		}
		else if (dobj = akmid) {
			"The Hoppian pauses for a second, chuckles nervously,
			and then, in a patient tone, informs you that, \"Just
			one akmid won't quite do, unfortunately.\"";
		}
		else if (dobj = creditslip) {
			"\"Store credit, Sir?  Well done.  Please take
			a seed packet from the bin,\" the Hoppian
			urges you.";
			
			self.paid := true;
			creditslip.movein(nil);
		}
		else if (dobj.isseeds) {
			if (dobj.isveg) {
				"The Hoppian takes a good look at ";
				dobj.thedesc; ". \"Unfortunately, Sir,\"
				he apologizes, \"only the vegetable
				vedors to the north can give you
				store credit for those.  I'm sure you
				understand this little bureaucratic
				difficulty,\" he laughs nervously.";
			}
			else if (dobj.isfruit) {
				"\"I'd be happy to give you store credit
				for those, my friend,\" the Hoppian
				tells you as he hands you a credit slip.";
 
				creditslip.movein(Me);
				dobj.movein(FRUITbin);
			}
			else {
				"The Hoppian scrutinizes "; dobj.thedesc;
				". \"Well I'm very sorry,\" he says, \"
				but I can't exchange that here.  You'll
				need to find someone else to help you
				with it.\""; 
			}
		}
 		else {
			"The Hoppian salesman seems quite puzzled.
			\"Well I'm sorry,\" he says, \"but you'll
			have to find someone else to handle that.\"";
		}
	}

	verDoAskabout(actor, io) = {}
	doAskabout(actor, io) = {
		I();
		
#ifdef	DEMO
		if (nil) {
		}
#else
		if (io = seeds) {
			if (seeds.isin(FRUITbin))
				"\"You'll see that we have the
				finest breed right here in the
				bin,\" the Hoppian informs you.";
			else
				"\"I'm afraid we're all out
				of prune seeds, friend,\" the
				Hoppian apologizes.";
		}
#endif
		else if (io.isseeds) {
			"The Hoppian tells you more than you could
			ever possibly want to know about 
			<<io.objthedesc(actor)>>; at the end of it all
			you're sorry you asked.";
		}
		else if (io = creditslip) {
			"\"Store credit, my friend,\" the Hoppian
			explains patiently, \"You buy seeds with
			it.\"";
		}
		else {
			"\"I'm afraid I don't know terribly much
			about that, friend,\" the Hoppian salesman
			says apologetically.";
		}
	}

	verIoShowto(actor) = {}
	ioShowto(actor, dobj) = {
#ifndef	DEMO
		if (dobj = seeds)
			"The Hoppian tells you more than you could
			ever possibly want to know about 
			<<dobj.objthedesc(actor)>>; at the end of it all
			you're sorry you asked.";
		else
#endif
			self.doAskabout(actor, dobj);
	}

	verDoTellabout(actor, io) = {}
	doTellabout(actor, io) = {
		"The Hoppian listens for a moment, then interrupts
		you:  \"Yes, well, that being the case, perhaps
		you'd be interested in purchasing some seeds today?\"";
	}

	verDoSprayWith(actor, io) = { "Don't be a jerk."; }

	Message = [
		'"You\'ll notice, Sir, that we have quite a wide selection,"
		the Hoppian says, gracefully running a paw over the
		rim of the bin.'
		
		'The Hoppian informs you that the Grandpa Jones apples
		are a new strain, genetically engineered by Barfee
		scientists only this year.'
		
		'Sunlight dances off the Hoppian\'s whiskers as he wiggles
		his nose.'
		
		'"Is there something I might be able to help you with
		today?" the Hoppian inquires, chuckling quietly but in an
		officious way that makes you feel kind of like you\'re in a
		classy jewelery store with nothing but 50% off coupons.'

		'The salesman confides in you that, "it\'s quite an
		excellent year for the particular strain of elderberries
		we sell here at Barfee."  His pronunciation of the outlet\'s
		name as "barfay" makes you wince under your breath.'
 
		'Sensing your apparent awkwardness, the Hoppian behind the
		bin asks if you\'re a newcomer to the seed industry.  You
		reply that your girlfriend sent you to pick something up
		for her.  He gives you a look that seems to say,
		"Ah yes, of course.  That explains it.  Poor sap."'

		'The Hoppian salesman waits until he thinks you\'re not
		looking, then straightens his bowtie and pulls back his
		ears, which, to his consternation, plop right back down
		into their usual cockeyed configuration.'

		'The Hoppian sighs gently, looks in a random direction,
		and then down at a wristwatch strapped to his left paw.'
	]

	talk = {
		P(); I(); say(self.Message[rnd(8)]);
	}

	doSmell(actor) = {
		"He smells like rabbit food.";
	}
	verDoRub(actor) = {
		"I don't think the 10-foot tall Barfee representative would
		be interested in your amorous advances, you sleaze.";
	}	
	verDoAttackwith(actor, io)  = {}
	doAttackwith(actor, io) = {
		"You poor, twisted individual.  They're gonna lock you
		up, pal.";
	}
;

wristwatch: Decoration
	sdesc = "Hoppian's wristwatch"
	adesc = { self.thedesc; }
	ldesc = {
		"It's looks like an expensive one.  That's all you can tell.";
	}
	
	location = FRUITseller
	
	noun = 'watch' 'wristwatch' 
	adjective = 'wrist' 'hoppian' 'hoppian\'s' 'salesman\'s'
	
	verDoTake(actor) = {
		"I don't think the Hoppian wants to give it up.";
	}
;

flowers: Outside
	firsttime = true

	sdesc = "Barfee Flower Warehouse"
	ldesc = {
		I(); "You are standing at the entrance to the Barfee flower
		warehouse.  You see Barfee employees giving away plastic
		daisies inside the warehouse -- perhaps that's why it's
		so crowded here.  The fact is that you couldn't
		fall down here if you tried -- you're crammed in like an
		olive in a bottle with all the rest of the would-be plastic
		daisy owners. Actually getting inside the warehouse looks
		absolutely impossible.  Not only that, but you suspect
		that you'd be crushed to death even if you made it in."; P();

		FLOWERSwarehouse.ldesc; P();
		
		I(); "The only obvious way to travel is back to the west.";
	}
	
	west = barfee
	east = {
		"No chance.  You can't even see into the warehouse, much
		less move into it.";

		return nil;
	}

 	footnote = {
		"Barfee's main distribution center is located on the
		opposite side of planet Flora.  The outlet you're
		currently in is mainly for noncommercial buyers.";
	}

	enter(actor) = {
		if (self.firsttime) {
			notify(BARFship, &flyby, 0);
			self.firsttime := nil;
		}

		inherited.enter(actor); 
	}
	leave(actor) = {
		/*
		 * We let the Barfee ship run for the rest of the game
		 * (or until the player solves the puzzle).
		 */
		// unnotify(BARFship, &flyby);

		inherited.leave(actor);
	}
;

BARFshipnoise: Listablesound, Decoration
	sound = nil
	islistablesound(actor) = { return self.sound; }

	isdetermined = true
	sdesc = "distant craft"
	ldesc = "You can't examine the noise from the craft, but you might be
		able to listen to it."
	noun = 'noise' 'sound' 'hissing'
	adjective = 'barf' 'ship' 'craft' 'mechanical' 'rushing'
	location = flowers

	listlistendesc = {
		"is making a mechanical hissing sound.";
	}
	listendesc = {
		"It's a mechanical hissing sound.";
	}
;
BARFship: Distant
	state = 1
	landing = nil	// not landing right now
	distant = true

	sdesc = "Barfee Advanced Research Foundation intraplanetary ship"
	ldesc = {
		if (self.distant) {
			"It's too small for you to make out any features.";
		}
		else {
			"It's a fairly small craft -- the sort you'd expect
			would be used for short distance transport missions.
			It's completely black except for the bright green
			letters on the side that read \"Barfee Advanced\
			Research Foundation.\"";
		}
	}

	location = nil

	isknownto(actor) = { return true; }

	noun = 'ship' 'craft' 'vehicle' 'spec' 'dot'
	adjective = 'barfee' 'advanced' 'research' 'foundation'
		'intraplanetary' 'interplanetary' 'inter' 'planetary'
		'space' 'star' 'air' 'small' 'dot' 'sized' 'dot-sized'
		'distant' 'jet' 'black'

	allowedverbs = [inspectVerb waveVerb]

	flyby = {
		/*
		 * NOTE: Do not change state numbers without updating
		 * the code in transition below!
		 */
		self.state := self.state + 1;
		if (self.state > 30)
			self.state := 1;

		if (not Me.isin(flowers))
			return;		// no message when player's not here

		if (self.state >= 1 and self.state <= 5) {
			// Ship in transit
		}
		else if (self.state = 6) {
			P(); I(); "You hear a faint mechanical 
			hissing sound in the distance.";
			
			BARFshipnoise.sound := true;
		}
		else if (self.state = 7) {
			P(); I(); "You hear a mechanical hissing 
			sound coming from somewhere above you.";
		}
		else if (self.state = 8) {
			P(); I(); "You hear a steadily loudening 
			hissing sound. It seems to be coming from a 
			dot-sized craft on the horizon.";
			
			self.movein(flowers);
		}
		else if (self.state = 9) {
			P(); I(); "A distant intraplanetary craft of 
			some kind hurtles towards you, accompanied by 
			a rushing sound reminiscent of the sea.";

			BARFship.distant := nil;
		}
		else if (self.state = 10) {
			P(); I(); "A small intraplanetary vehicle 
			decelerates noticeably as it approaches the 
			Barfee flower warehouse.  The violent sound 
			dissipates as the craft slows.";

			BARFshipnoise.sound := nil;
		}
		else if (self.state >= 11 and self.state <= 13) {
			P(); I(); "A small intraplanetary vehicle 
			hovers overhead as it attempts to negotiate a 
			landing on top of the warehouse. The jet 
			black craft prominently features the words 
			\"Barfee Advanced Research Foundation\" in 
			large green letters on its side."; P();

			I(); "Looking more closely, you notice that 
			two individuals roughly your size are guiding 
			the ship in to a touchdown on the rooftop a 
			hundred feet above.  They look like the 
			second stringers, hardly confident of their 
			guidance, and surely afraid of being crushed. 
			 The fact that their vests are emblazoned 
			with the word \"Trainee\" doesn't exactly 
			fill you with confidence."; P();

			I(); "The two initiates are waving their arms 
			around frantically; this is made all the more 
			obvious by the intergalactic orange sticks 
			they're holding in their hands.  The pilot of 
			the ship periodically pokes his head out the 
			window and looks to the ground, perhaps 
			hoping against hope that some more competent 
			help will show up.";
			
			self.landing := true;
			if (self.state = 11) {
				pilot.movein(flowers);
				pilot.makeknownto(Me);
				trainees.movein(flowers);
				trainees.makeknownto(Me);
			}
		}
		else if (self.state = 14) {
			P(); I(); "A Barfee Advanced Research 
			Foundation ship just completed a hair-raising 
			landing on the roof of the building.  The 
			pilot seems to be threatening the ground crew 
			with bodily harm.";
			
			self.landing := nil;
			pilot.threatening := true;
		}
		else if (self.state = 15) {
			P(); I(); "Several Barfee employees in white 
			labcoats emerge from a Barfee Advanced 
			Research Foundation intraplanetary craft that 
			just touched down on top of the flower 
			warehouse.  They look very shaken.";

			trainees.movein(nil);
			employees.movein(flowers);
			pilot.threatening := nil;
			pilot.movein(nil);
		}
		else if (self.state >= 16 and self.state <= 19) {
			P(); I(); "You notice a Barfee intraplanetary 
			vehicle left unattended on top of the 
			building.";

			employees.movein(nil);
		}
		else if (self.state = 20) {
			P(); I(); "You spot the pilot of a Barfee 
			Advanced Research Foundation ship getting 
			into his craft.";
		}
		else if (self.state = 21) {
			P(); I(); "A Barfee Advanced Research 
			Foundation ship begins to hover a few feet 
			above the roof of the flower warehouse.";
		}
		else if (self.state = 22) {
			P(); I(); "A Barfee Advanced Research 
			Foundation ship zips away from the flower 
			warehouse in a flash.";
		}
		else if (self.state = 23) {
			P(); I(); "Looking up, you notice a ship 
			flying away in the distance.";
		}
		else if (self.state = 24) {
			P(); I(); "You spot a tiny spec far in the 
			distance, which you make out to be a flying 
			craft of some kind.";

			BARFship.distant := true;
		}
		else if (self.state = 25) {
			self.movein(nil);
		}
		else if (self.state >= 26 and self.state <= 30) {
			// ship in transit
		}
	}
;
pilot: Distant
	threatening = nil
	sdesc = "Barfee Advanced Research Foundation ship pilot"
	ldesc = {
		if (self.threatening)
			"The pilot looks extremely annoyed 
			at the trainees' incompetence.";
		else
			"The pilot looks worried.";
	}
	noun = 'pilot'
	adjective = 'ship' 'barf' 'barfee' 'ship\'s'
	location = nil

	allowedverbs = [inspectVerb waveVerb]
;
trainees: Distant
	sdesc = "Barfee trainees"
	ldesc = {
		"The trainees look very worried.";
	}
	noun = 'crew' 'trainees' 'vests' 'vest' 'stringers' 
	adjective = 'second'
	location = nil
;
traineessticks: Part
	partof = trainees
	sdesc = "international orange sticks"
	ldesc = {
		"They just look like bright orange cylinders.
		Intergalactic orange is the standard color for
		such guidance aids.";
	}
	noun = 'sticks' 'batons' 'stick' 'baton'
	adjective = 'orange'
;
employees: Distant
	sdesc = "Barfee employees"
	ldesc = {
		"The Barfee employees are wearing labcoats.  You
		infer that they must be researchers -- you've
		heard that Barfee employees many of the best
		chemists in the galaxy "; note(self); ".";
	}
	noun = 'employees' 'researchers'
	adjective = 'barfee'
	
	footnote = {
		"The bad chemists generally work for Akmi in
		the \"Phood for Egghedz\" program.";
	}
;
FLOWERSwarehouse: Distant
	sdesc = "Barfee flower warehouse"
	ldesc = {
		I(); "The warehouse itself is nondescript; it's just a
		big, long, gray building, about 100 feet tall.  Come to
		think of it, it looks a lot like a hangar; perhaps in 
		days past it housed starships or intraplanetary craft ";
		note(self); ".  You can't help wondering how flowers
		could possibly take up so much space.";
	}

	noun = 'warehouse' 'building' 'hangar' 'house' 'roof' 'rooftop'
	adjective = 'ware' 'barfee' 'roof'
 
 	footnote = {
		"Barfee's main distribution center is located on the
		opposite side of planet Flora.  The outlet you're
		currently in is mainly for noncommercial buyers.";
	}
	
	location = flowers
;
plasticdaisies: Distant
	sdesc = "plastic daisies"
	isplural = true
	ldesc = {
		"They look like cheap plastic flowers.";
	}
	location = flowers
	noun = 'flowers' 'daisies' 'daisy'
	adjective = 'plastic' 'barfee'
;
supplies: Room
	sdesc = "Barfee Garden Supply Depot"
	ldesc = {
		I(); "You are standing inside the supply depot, a small
		white building with buyers swarming all around inside
		it.  Though there's a lot of activity here, it's surely
		the least crowded section of the Barfee outlet.  Oddly
		enough, there don't seem to be many salescreatures
		around -- you can't get anyone's attention.  Fortunately
		there's a vending machine of some kind right in front
		of you. ";

		SUPPLIESmachine.shortdesc;
	}

	east = barfee
;
SUPPLIESwarehouse: Decoration
	sdesc = "supplies depot"
	ldesc = "You're in it."
	noun = 'building' 'depot' 
	adjective = 'small' 'white'
	location = supplies
;
SUPPLIESbuyers: Decoration
	sdesc = "buyers"
	ldesc = "It's quite a diverse crowd."
	adesc = { self.sdesc; }
	thedesc = { self.sdesc; }
	
	noun = 'buyers' 'crowd'
	adjective = 'barfee'

	location = supplies
;

SUPPLIESmachine: Qcontainer
	upright = true
	state = 0
	turns = 0

	sdesc = "Barfee vending machine"
	shortdesc = {
		if (self.upright) {
			"The vending machine is about twice your height,
			emerald green, and cylindrical.  A giant red Barfee
			logo climbs up the machine in a wide spiral.  There is
			a slot for Galacticards in the side and a keypad next
			to the slot.";
		}
		else {
			"It's lying on its side pitifully.  One of the
			compartments is smashed open.  A giant red Barfee
			logo slides across the machine in a wide spiral.";
		}
	}
	ldesc = {
		I(); self.shortdesc; P();
		I(); "The ";
		if (not self.upright)
			"toppled ";
		"vending unit is filled with all sorts of
		gardening products. ";

		self.doLookin(Me);

		P();
		
		if (self.upright) {
			if (self.state = 0) {
				I(); "The machine looks a bit 
				unstable.  I wouldn't get too close 
				if I were you.";
			}
			else if (self.state = 1) {
				I(); "The machine is teetering 
				noticeably. If you're not careful 
				you'll likely get crushed.";
			}
			else if (self.state = 2) {
				I(); "The machine is rotating about 
				on its base like a dropped coin.  
				Better get out of the way while you 
				still can!";
			}
			else if (self.state = 3) {
				I(); "The machine is rotating about 
				on its base like a dropped coin.  
				Better get out of the way while you 
				still can!";
			}
		}
		else {
			I();
			if (akmigrow.isin(SUPPLIESmachine)) {
				"The glass guarding the compartment 
				containing ";
				akmigrow.thedesc;
				" has shattered.";
			}
			else {
				"The glass where ";
				akmigrow.thedesc; 
				" once was is shattered.";
			}
		}
	}

	location = supplies
	noun = 'machine' 'cylinder' 'partition' 'compartment' 'glass' 'vending'
	adjective = 'vending' 'barfee' 'supplies' 'supply' 'tall'
		'cylindrical' 'emerald' 'green' 'coin' 'glass'

	steady = {
		self.turns := self.turns + 1;
		if (self.turns >= 7) {
			self.turns := 0;
			self.state := self.state - 1;
		}
		if (self.state = 0) {
			unnotify(self, &steady);
			P(); I(); "The machine looks a bit steadier now.";
		}
	}

	verDoBreak(actor) = {}
	doBreak(actor) = {
		"Your frenetic attempts to break into the vending 
		machine, while incredibly obvious to the horrified 
		customers around you, somehow fail to either attract 
		the attention of the local authorities or improve 
		your access to the goods inside.";
	}
	verDoHitwith(actor, io) = {}
	doHitwith(actor, io) = { self.doBreak(actor); }

	verDoAttackwith(actor, io) = {}
	doAttackwith(actor, io) = { self.doBreak(actor); }

	verDoWave(actor) = {}
	doWave(actor) = {
		"You try to grab the machine and shake it, but it's
		just too heavy for your efforts to have much effect.";
	}

	verDoHit(actor) = {}
	doHit(actor) = {
		"You ram your fist into the machine with all your 
		might. This action is accompanied by a loud cracking 
		sound and, soon after, great pain.  You decide 
		against a follow-up blow.";
	}

	verDoKick(actor) = {}
	doKick(actor) = {
		if (self.state = 0)
			notify(self, &steady, 0);
		
		if (self.upright) {
			self.state := self.state + 1;
			if (self.state = 1) {
				"You boot the machine roundly, much to
				the astonishment of several onlookers.
				The vending tower beings to wobble a bit.";
			}
			else if (self.state = 2) {
				"Undeterred, you give the machine one
				more swift kick in the coin slot.  It's
				really rocking back and forth now.  Nearby
				customers are starting to flee in terror.";
			}
			else if (self.state = 3) {
				"In a dramatic display of poise, agility,
				and apparent insanity, you execute a flying
				sidekick into the Barfee vending machine,
				sending it and you hurtling to the ground
				with a tremendous crash.  The Barfee
				patron you nearly crushed to death looks
				a bit peeved, but other than that your
				spectacular theatrics seem to have gone
				largely unnoticed.";

				SUPPLIESpatron.movein(self.location);

				self.upright := nil;
				unnotify(self, &steady);
				
				incscore(3);
			}
		}
		else {
			"You've already toppled it, you maniac!";
		}	
	}

	//
	// Don't let anything out of the machine except for the can
	// of Akmi Soopur Wundur Gro, and that only when the machine's
	// been toppled.
	//
	passgen(actor, obj, loctype, passmethod) = {
		// If not "in" containment or nil, call our parent's method.
		if (loctype <> nil and loctype <> 'in')
			return inherited.(passmethod)(actor, obj, loctype);

		if (obj = nil)
			return true;
			
		if (self.upright or obj <> akmigrow) {
			"\^<<obj.subjthedesc>> is sealed in the 
			machine behind thick glass.";

			return nil;
		}
		else
			return true;
	}
	passcantouchin(actor, obj, loctype) = { 
		return self.passgen(actor, obj, loctype, &passcantouch);
	}
	passcantakein(actor, obj, loctype) = {
		return self.passgen(actor, obj, loctype, &passcantake);
	}
	passcansmellin(actor, obj, loctype) = {
		return self.passgen(actor, obj, loctype, &passcansmell);
	}
	passcanhearin(actor, obj, loctype) = {
		return self.passgen(actor, obj, loctype, &passcanhear);
	}

	verIoPutin(actor) = {
		if (self.upright) {
			"The compartments of the Barfee vending machine are
			sealed behind thick glass.  You can't put anything
			inside.";
		}
	}
	
	// Can't give the following error in verIoPutin because we
	// need the do
	ioPutin(actor, dobj) = {
		"You can't be sure that you'll be able to squeeze 
		<<dobj.thedesc>> into the compartment without cutting 
		your hands on the glass. Best leave well enough 
		alone.";
	}
;
vendingmachinelogo: Part, Readable
	partof = SUPPLIESmachine
	sdesc = "red Barfee logo"
	ldesc = "It's just the word \"Barfee\" in very stylized letters."
	readdesc = "It says, \"Barfee\"."
	noun = 'logo'
	adjective = 'red' 'barfee' 'vending' 'machine'
;
vendingmachinechardslot: Part, Container
	partof = SUPPLIESmachine
	sdesc = "vending machine Galacticard slot"
	
	noun = 'slot'
	adjective = 'card' 'galacticard' 'vending' 'machine' 'barfee'

	ioPutin(actor, dobj) = {
		if (dobj <> galacticard)
			"The slot only accommodates a galacticard.";
		else {
			"You stick the card in the slot.  Seconds
			later the machine makes a loud buzzing sound
			and ejects your card.  You retrieve it from
			the ground.";
		}
	}
;
vendingmachinekeypad: Part
	partof = SUPPLIESmachine

	sdesc = "vending machine keypad"
	ldesc = {
		"The keypad has black keys numbered 0 to 9.";
	}
	noun = 'keypad' 'keys' 'pad' 'key'
	adjective = 'black' 'vending' 'machine' 'barfee'
	
	verIoTypeon(actor) = { }
	ioTypeon(actor, dobj) = {
		if (dobj <> numObj) {
			"You can only type numbers on the keypad.
			(Don't put numbers in quotes.)";
		}
		else {
			"A pleasant voice emanating from deep
			within the vending machine says, \"Please
			insert your Galacticard to make a purchase.\"";
		}
	}
;

/*
 * Stuff in the Barfee vending machine
 */
akmigrow: Readable, pourable
	taken = nil		// not snagged yet
	
	liquiddesc = "Akmi Soopur Wundur Gro"
	sdesc = {
		"can of Akmi Soopur Wundur Gro";
		if (self.isin(SUPPLIESmachine)) {
			" "; note(self);
		}
	}
	ldesc = {
		"The "; self.sdesc; " is bright orange, with mauve
		lettering.  Considering it's an Akmi product, the
		mauve if pretty subdued -- you can barely read it. ";

		self.readdesc;
	}
	readdesc = {
		"The label says, \"Akmi Soopur Wundur Gro: Por on a
		dahb and watch yur plantz gro layk nevur befor! 
		Garanteed sayf by Akmi Resurch Labz.  Werks grate on
		petz to!\"";
	}

	footnote = {
		"Barfee does make their own plant growth enhancers,
		and Akmi's products are known to be quite inferior
		to Barfee's.  Perhaps this got into the vending machine
		by mistake.
		On the other hand, it might the result of some
		unspoken agreement between Akmi and Barfee higher-ups.
		It's hard to say no to Akmi since they control half
		the galaxy's assets.";
	}

	noun = 'can' 'gro' 'grow'
	adjective = 'akmi' 'super' 'wonder' 'sooper' 'wundur' 'wunder'
			'soopur' 'miracle' 'orange' 'mauve' 'gro' 'grow'

	location = SUPPLIESmachine
	
	doTake(actor) = {
		if (not self.taken) {
			"You carefully reach into the now-open compartment
			and snatch <<self.objthedesc(nil)>>. ";

			self.taken := true;
		}

		//
		// Do usually take stuff, but suppress "Taken" message.
		//
		Outhide(true);
		inherited.doTake(actor);
		Outhide(nil);
	}

	verDoWave(actor) = {
		if (not self.isin(BARFship.location))
			self.wavemessage;
	}
	doWave(actor) = {
		if (BARFship.landing) {
			/*
			 * The player guides the BARF ship in to
			 * a safe landing on the ground.
			 */
			flowerstransition.transition;
		}
		else
			self.wavemessage;
	}
	doWaveat(actor, io) = {
		if (io = pilot or io = BARFship)
			self.doWave(actor);
		else
			"I fail to see what you're trying to accomplish.";
	}
	wavemessage = {
		"What are you trying to do, signal low-flying spacecraft?";
	}

	poureffect(actor, o) = {
		if (o = seedlump) {
			"You douse the seeds with "; self.liquiddesc; ".";
			" Soon after, you realize it probably wasn't
			such a good idea -- the lump of soil begins
			to foam, and then quickly vaporizes, taking
			the seeds with it.";

			o.movein(nil);
		}
		else if (o = zdybel) {
			if (zdybel.scrambled) {
				"You splash the poor, harmless Bedzyl with ";
				self.liquiddesc; " and it is instantly
				vaporized by the toxic liquid. Good job,
				you maniac.";
				
				o.movein(nil);
			}
			else {
				"If you think you can safely get close
				enough to the Zdybel to pour ";
				self.liquiddesc; " on it, you've got
				another thing coming.";
			}
		}
		else if (o.isseeds) {
			"Call me a rebel, but you might want to plant the
			seeds first.";
		}
		else {
			"Pouring "; self.liquiddesc; " on "; o.thedesc;
			" doesn't seem very productive.";
		}
	}
;
SUPPLIESfertan: Item, Readable
	sdesc = "Barfee fertilyzer (tm)"
	ldesc = {
		"It's a palm-sized yellow gadget with a VU meter and
		a metal prong sticking out of it. "; self.readdesc;
	}
	readdesc = {
		"The label on the machine reads: \"";

		"This handy probe will tell you in only seconds whether
		or not to fertilize your soil.  Just stick the pointy
		end in the dirt and watch the needle.  Remember: an
		over-fertilized soil is an unhappy soil!  Barfee -- 
		keeping your leafy friends cheery.";
		
		"\"";
	}
	noun = 'fertilyzer' 'analyzer' 'meter' 'gadget' 'prong' 'label'
	adjective = 'barfee' 'fertilizer' 'yellow' 'pronged' 'VU' 'metal'
			'palm-sized'
	
	location = SUPPLIESmachine
;
SUPPLIESphcomputer: Item
	sdesc = "Barfee Pocket pH Pal (tm)"
	ldesc = "It's a palm-sized plastic pH computer.  The instructions
		on the case are not visible, but you can assume that
		you stick this thing in some dirt and it tells you how
		acidic it is."
	noun = 'pal' 'computer' 'case' 'meter' 'gadget'
	adjective = 'barfee' 'pH' 'pocket'
	
	location = SUPPLIESmachine
;
SUPPLIESthermometer: Item
	sdesc = "pair of Barfee infrared goggles"
	ldesc = "What we have here is an oversized pair of black
		goggles.  The idea seems to be that if you wear
		them you can tell the exact temperature of all
		you survey."
	noun = 'goggles'
	adjective = 'pair' 'infra' 'red' 'infrared' 'temperature'
	
	location = SUPPLIESmachine
;
SUPPLIESheater: Item, Readable
	sdesc = "Barfee soil heater"
	ldesc = "You evidently put these cables in the ground and
		they warm up the soil.  Wording on the side of the
		package claims that they're waterproof and totally
		safe, and that they speed up plant growth by sometimes
		miraculous amounts."
	readedesc = { self.ldesc; }
	
	noun = 'heater' 'cable' 'package'
	adjective = 'barfee' 'soil' 'waterproof' 'water-proof' 'safe'
	
	location = SUPPLIESmachine
;
SUPPLIESguide: Item, Readable
	sdesc = "Barfee germination and culture guide"
	ldesc = "It's evidently a short book with detailed information
		on germination times and sowing cultures for
		many different kinds of flora."
	readdesc = {
		"Since it's sealed up in the vending machine, you
		can't really leaf through it.";
	}	
	
	noun = 'guide' 'book' 'booklet' 'leaflet' 'pamphlet'
	adjective = 'barfee' 'germination' 'culture' 'flora' 'flower'
			'plant' 'tree' 'shrub' 'shrubbery' 'vegetation'

	location = SUPPLIESmachine
;
SUPPLIESsower: Item
	sdesc = "Barfee SeedSticker Sower (tm)"
	ldesc = "The SeedSticker (tm) looks like an orange plastic
		trowel, except that it has a little white
		wheel and a \"gate\" across the pointy end.  Turning
		the ratchet makes the seeds come out in measured
		amounts."
		
	noun = 'trowel' 'spade' 'seedsticker' 'sower' 'sticker'
	adjective = 'seed' 'orange' 'plastic' 'white'
	
	location = SUPPLIESmachine
;
SUPPLIESsowergate: Part
	partof = SUPPLIESsower
	sdesc = { SUPPLIESsower.sdesc; " gate"; }
	ldesc = "It's just a little white piece of plastic."
	
	noun = 'gate'
	adjective = 'trowel' 'spade' 'seedsticker' 'sower' 'sticker' 'white'
			'plastic'
;
SUPPLIESsowerwheel: Part
	partof = SUPPLIESsower
	sdesc = { SUPPLIESsower.sdesc; " ratchet"; }
	ldesc = "It's just a little white wheel."
	
	noun = 'wheel' 'ratchet'
	adjective = 'trowel' 'spade' 'seedsticker' 'sower' 'sticker' 'white'
			'plastic'
;
SUPPLIESsquirtbulb: Item
	sdesc = "Barfee SquirtBulb (tm)"
	ldesc = "This little green bulb-shaped item squirts water when
		you squeeze it (assuming that you've filled it with
		water ahead of time, that is)."
	
	noun = 'squirtbulb' 'bulb'
	adjective = 'barfee' 'squirt' 'water' 'green' 'little'
	

	location = SUPPLIESmachine
;
SUPPLIESstarterkit: Item
	sdesc = "Barfee seed starter kit"
	ldesc = "It's just a box with different kinds of Barfee seeds
		in it.  There's nothing particularly special about it."
	noun = 'kit' 'box' 'tray'
	adjective = 'barfee' 'starter' 'seed'
;
SUPPLIESpatron: Decoration
	location = nil
	sdesc = "Barfee patron you almost crushed to death"
	ldesc = "The peaceful and well-groomed Hoppian you nearly
		squished looks no worse for wear, though a bit
		leary of you."
	noun = 'patron' 'buyer' 'customer'
	adjective = 'barfee' 'hoppian' 'well-groomed' 'peaceful'
;


#ifndef	DEMO

hakkar: Distant, Male
	isdetermined = true
	sdesc = "\"Hakkar the Horrible\""
	
	allowedverbs = [listentoVerb]
	listendesc = "Hakkar is currently shouting obscenities at
		     the top of his lungs."
	noun = 'hakkar' 'horrible' 'boss'
	adjective = 'horrible'
	location = researchhall
;


researchhall: Room
	hakkaranger = 0

	noun = 'hall'	
	adjective = 'research'
	
	sdesc = "Barfee Research Area Entrance"
	ldesc = {
		I(); "You're standing in an empty hall with metal walls,
		ceiling, and floor.  Behind you, to the south, is
		the vault door that leads to the outside; it does
		not appear to open from the inside.  Right in front of
		you, farther down the hall, is a smaller but equally
		durable-looking door with a sign on it that reads
		\"Barfee Research Central.\"  There is another room
		to the west, and to the east is what you assume to be
		the check-in area; you suspect that's where the boss is;
		this suspicion is partly affirmed by the growling and
		cursing emanating from within.  \"Hakkar the Horrible\" is
		in full form.";
	}

	in = {
		"There are several directions that could be taken
		as \"in\" here.  Please be a bit more specific.";

		return nil;
	}
	north = RESEARCHdoor1
	south = {
		"There's no inside  keypad for the large door in
		the southern wall of the warehouse.  You see no way at all
		to get the door open from in here.";
		return nil;
	}	
	west = researchmoverroom
	east = {
		self.hakkaranger := self.hakkaranger + 1;
		if (self.hakkaranger = 1) {
			"You carefully peer into the office to
			your right; you think it's probably a good
			idea to check things out instead of just blindly
			traipsing in.  Good thing, too, because your
			caution affords you the opportunity to snap your
			head back before Hakkar sees you; he's quite
			preoccupied with thoroughly chastising an employee,
			and from the tone of his voice he definitely
			seems like someone to avoid.  You have, after
			all, been absent from work for over a month.";
		}
		else if (self.hakkaranger = 2) {
			I(); "Screwing your courage to the sticking place,
			you bravely bound into Hakkar's office.  Noticing
			you, he drops the employee he had previously
			been holding up by the lapels and glares at
			his next victim: you."; P();
			
			I(); "\"Hornweiler, do you think you can just
			come crawling back here begging for mercy after
			ditching us for a month?  You must be out of
			your mind!  I oughta tear you limb from limb
			just for showing your ugly face in here again,
			and...  Say, did you get a nose job, Hornweiler?
			You look a lot better; now GET TO WORK
			BEFORE I PUT IT BACK THE WAY IT WAS, YOU WEASEL!\"
			Hakkar bellows at peak volume, his fist raised
			and primed for substantial violence."; P();

			I(); "\"Never, never, talk back to a *roll.\"  Your
			mother told you that when you were young, and you
			decide to take the advice to heart.  Now that
			you get right down to it, though, you can't
			imagine why anyone would argue with an incredibly
			tall, green, and hairy monstrosity with paws as
			big as your head, more teeth than an Akmi Cheez
			Comb, poor hygiene habits, and an unpronounceable
			initial consonant "; note(self); ".  You turn tail
			and exit without even exhaling, feeling quite
			lucky to be alive (and dizzy from lack of
			oxygen).";
		}
		else if (self.hakkaranger = 3) {
			I(); "In a sudden fit of complete insanity, you
			once again call yourself to Hakkar's attention.
			Needless to say, he is neither amused nor
			lenient.  During his long and somewhat 
			physical correctional lecture he happens to
			notice that you don't have the scar on your
			neck that Hornweiler got from last year's
			begonia incident (the victim of the prank
			found it less funny than Hornweiler, you
			gather).  *rolls aren't known for their
			intelligence, but they're not known for their
			stupidity either, and Hakkar immediately
			reports you to the local authorities."; P();
			
			I(); "After a long and tedious interrogation
			at the hands of the regional constabulary,
			several agents from Akmi Secret Service
			arrive, solemnly pronounce you a traitor
			to the Republic, and order you transmogrified
			into syntheplast.  Several Akmi employees
			cheerfully comply.";

			notify(deathobject, &death, 0);
		}

		return nil;
	}
	
 	footnote = {
		"Until Tode made contact with the *rolls several 
		hundred years ago, Todian linguists thought they'd 
		classified all the phonetic sounds the galaxy's 
		species' vocal apparatuses were capable of producing. 
		Until they encountered it in common use in *rollian 
		speech, they'd never thought of spitting as 
		linguistically meaningful. The choice of * as an 
		orthographic representation for the sound of spitting 
		was primarily motivated by its similarity to what 
		appears on the printed page soon after its 
		production.";
	}
;

class researchdoorway: Door
	isopen = nil
	islocked = true
	openedonce = nil	// ever opened? (for scoring)

	sdesc = "research lab door"
	ldesc = {
		"The door is solid metal and quite indestructible. ";
		if (self.isopen) {
			"Fortunately, it's open.";
		}
		else {
			"The only way to get it open seems to be to punch
			in the correct passcode on the keypad to the right.";
		}
	}
	noun = 'door'
	adjective = 'research' 'lab' 'solid' 'metal' 'indestructible'

	verDoOpen(actor) = { "You need to use the keypad to open the door."; }
	verDoClose(actor) = { self.verDoOpen(actor); }
	verDoUnlock(actor) = { self.verDoOpen(actor); }
	verDoLock(actor) = { self.verDoLock(actor); }
	verDoLockwith(actor) = { self.verDoLock(actor); }	
	verDoUnlockwith(actor) = { self.verDoUnlock(actor); }
	
	open = {
		if (not researchdoorway.openedonce)
			incscore(4);
		self.isopen := true;
		self.islocked := nil;
		researchdoorway.openedonce := true;
		if (self.otherside) {
			self.otherside.isopen := true;
			self.otherside.islocked := nil;
			self.otherside.openedonce := true;
		}
	}
	close = {
		self.isopen := nil;
		self.islocked := true;
		if (self.otherside) {
			self.otherside.isopen := nil;
			self.otherside.islocked := true;
		}
	}
;
class keypad: Decoration
	reset = nil

	sdesc = "door keypad"
	ldesc = {
		"The keypad has white keys numbered 0 to 9, and a
		larger key labeled \"RESET.\"";
	}
	noun = 'keypad' 'keys' 'reset' 'pad' 'key'
	adjective = 'research' 'lab' 'white' 'reset' 'door'
	
	verDoPush(actor) = {}
	doPush(actor) = {
		if (self.mydoor.isopen) {
			/*
			 * If the door is already open any keypress will
			 * cause it to shut.
			 */
			"The door silently seals shut.";
			self.mydoor.close;
			self.reset := nil;
		}
		else {
			"You press the reset button and then type in the four
			numbers you remember seeing Buddy type:
			23, 46, 69, 812.
			Now if you could only remember the last number...
			Hmmm.  Your instincts tell you there's a
			pattern "; note(self); ".";
		
			self.reset := true;
		}
	}

	footnote = {
		"When you know the number, type it on the keypad;
		e.g. \"type 1776 on door keypad\".";
	}

	verDoReset(actor) = {}
	doReset(actor) = { self.doPush(actor); }
	
	verIoTypeon(actor) = { }
	ioTypeon(actor, dobj) = {
		if (dobj <> numObj) {
			"You can only type numbers on the keypad.
			(Don't put numbers in quotes.)";
		}
		else if (self.mydoor.isopen) {
			/*
			 * If the door is already open, any keypress
			 * will close it.
			 */
			"The door silently seals shut.";
			self.reset := nil;
			self.mydoor.close;
		}
		else if (not self.reset) {
			self.fail;
			// keypad stays in non-reset state
		}
		else {
			if (numObj.value = 1015) {
				"The door silently slides open.";
				self.mydoor.open;		
			}
			else {
				self.fail;
			}
			self.reset := nil;
		}
	}
	
	fail = {
		"Nothing obvious happens.  Perhaps you should
		reset the keypad and try again.";
	}
;

RESEARCHdoor1: researchdoorway
	doordest = barfeelab
	otherside = RESEARCHdoor2
	location = researchhall
	mykey = keypad1	// just a cute way of saying "no key"
;
keypad1: keypad
	mydoor = RESEARCHdoor1
	location = researchhall
;
RESEARCHdoor2: researchdoorway
	doordest = researchhall
	otherside = RESEARCHdoor1
	location = barfeelab
	mykey = keypad2	// just a cute way of saying "no key"
;
keypad2: keypad
	mydoor = RESEARCHdoor2
	location = barfeelab
;
researchmoverroom: Room
	sdesc = "Featureless Cubicle"
	ldesc = {
		I(); "It's clear from the size and lack of decor that
		this room was built specifically to house the
		matter mover that fills it.  The hallway is
		to the east."; P();

		I(); "The matter mover here is a bit unusual -- it
		has a button on it, next to a light.";
	}

	in = { researchmover.doEnter(Me); return nil; }
	out = { return self.east; }
	east = researchhall
;
researchlight: Part
	partof = researchmover
	sdesc = "matter mover light"
	ldesc = {
		"The light is currently ";
		if (researchmover.accepting)
			"green";
		else
			"red";
		".";
	}
	noun = 'light'
	adjective = 'red' 'green' 'matter' 'mover'
;
researchbutton: Button, Part
	partof = researchmover
	enabled = nil
	noun = 'button'
	doPush(actor) = {
		"Click.  The light changes color.";

		if (self.enabled)
			self.enabled := nil;
		else
			self.enabled := true;
	}
;
researchmover: mattermover
	autoreset = true
	accepting = { return researchbutton.enabled; }
	location = researchmoverroom

	ldesc = {
		"This matter mover is a bit different from others
		you've seen -- it has a button and a light on it. ";
		researchlight.ldesc; P();

		self.address; P();
	
		"Current dial settings: (";
		self.r.printsetting; ", ";
		self.g.printsetting; ", ";
		self.b.printsetting; ")";

	}
	address = {
		"The address plate on the machine reads:\b
		\t8549, 4392, 8393 -- colorspace Orchid\n
		\t*** Leave in accepting mode only for open house day ***\n";
	}

	/*
	 * This mover's coordinates
	 */
	ar = 8549
	ag = 4392
	ab = 8393
	
	/*
	 * This mover's dials
 	 */
	r = researchred
	g = researchgreen
	b = researchblue

	colorspace = 'Orchid'
	system = 'Val'
	planet = 'Orf'
;

researchgreen:	greendial 	setting = 0 location = researchmoverroom;
researchblue:	bluedial	setting = 0 location = researchmoverroom;
researchred:	reddial 	setting = 0 location = researchmoverroom;

barfeelab: Room
	sdesc = "Barfee Research Lab"
	ldesc = {
		I(); "You are in a huge, well-stocked laboratory.
		Dozens of researchers scurry about, argue with each
		other, and frequently set things ablaze.  Aside from
		the usual lab equipment, there is a strange-looking
		machine on an especially large marble lab table that
		stands in the center of the lab."; P();

		I(); "The only way out of this arena is south, the
		way you came in.";
	}

	south = RESEARCHdoor2
	out = { return self.south; }
;
barfeelabresearchers: Decoration
	sdesc = "Barfee researchers"
	ldesc = "The researchers are all hard at work."
	noun = 'researchers'
	adjective = 'barfee' 'lab'
	location = barfeelab

	lose = {
		"The researchers are so absorbed in their
		work that you can't get anyone's attention.";
	}

	verIoGiveto(actor) =  {}
	ioGiveto(actor, dobj) = { self.lose; }
	verDoAskabout(actor, io) = {}
	doAskabout(actor, io) = { self.lose; }
	
	ioShowto(actor, dobj) = { self.doAskabout(actor, dobj); }

	doSmell(actor) = { "The researchers smell like chemicals."; }
	verDoRub(actor) = {
		"We really must do something about your sociopathy.";
	}
	verDoAttackwith(actor, io)  = {}
	doAttackwith(actor, io) = {
		"For the last time: this is *not* a murder-oriented
		game! Now cut it out!";
	}

	verDoSpraywith(actor, io) = {}
	doSpraywith(actor, io) = {
		"You spray a random researcher with <<io.objthedesc(nil)>>,
		but he doesn't even notice.  They must be used to having
		foul chemicals sprayed on them.";
	}
;
labtable: Table
	sdesc = "large marble lab table"
	ldesc = {
		"It's just an ordinary lab table, albeit a 
		rather huge one. <<self.contdesc(Me)>>";
	}
	noun = 'table'
	adjective = 'lab' 'marble' 'large' 'huge' 'big'
	location = barfeelab
;
transmogrifier: Container
	sdesc = "Akmi Transmogrifyer"
	adesc = "an <<self.sdesc>>"
	ldesc = {
		"It's just a big plaid box made of some synthetic cheese
		product that you can put things in.  It has four oversized
		dials and a large red button on the front. ";

		self.readdesc;

		" There is a sign on the machine that says,
		\"Out of order\".";
	}
	readdesc = {
		"Large letters on the machine read \"Transmogrifyer\".";
	}
	noun = 'transmogrifyer' 'machine' 'box'
	adjective = 'akmi' 'synthetic' 'cheese' 'cheez' 'product'
	location = labtable
	locationtype = 'on'
;
class transmogdial: Part, Dial
	partof = transmogrifier
	setting = 0
	minsetting = 0
	maxsetting = 19
	noun = 'dial'
	plural = 'dials'
;
magentadial: transmogdial
	sdesc = "magenta dial"
	adjective = 'magenta' 'akmi' 'transmogrifyer' 'oversized'
;
salmondial: transmogdial
	sdesc = "salmon dial"
	adjective = 'salmon' 'akmi' 'transmogrifyer' 'oversized'
;
mauvedial: transmogdial
	sdesc = "mauve dial"
	adjective = 'mauve' 'akmi' 'transmogrifyer' 'oversized'
;
orangedial: transmogdial
	sdesc = "orange dial"
	adjective = 'orange' 'akmi' 'transmogrifyer' 'oversized'
;
transmogbutton: Part, Button
	partof = transmogrifier
	sdesc = "transmogrifier button"
	ldesc = {
		"It's just a big red button.";
	}
	noun = 'button'
	adjective = 'akmi' 'transmogrifyer' 'big' 'red'

	doPush(actor) = {
		local val := 0;
		
		if (transmogrifier.contents = []) {
			"Click.";
			return;
		}

		//
		// Since the machine is broken, it only uses the
		// the first digit of the salmon dial and the
		// second digit of the orange dial.
		//
		if (salmondial.setting > 9)
			val += 10;
		val += orangedial.setting;
		if (orangedial.setting > 9)
			val -= 10;
		
		//
		// TADS arrays start at 1.
		//
		val++;

		//	
		// Can't create the same object twice without
		// destroying it first.
		//
		if (self.products[val].location <> nil) {
			"Click.";
			return;
		}

		//
		// No we look up the object to create from
		// our list and replace the objects in the
		// transmogrifier with the new object.
		//
		while (transmogrifier.contents <> [])
			transmogrifier.contents[1].movein(nil);

		self.products[val].movein(transmogrifier);
		
		"The machine makes a loud grinding noise. ";
		transmogrifier.doLookin(Me);
	}
	
	products = [	repellant seeds paperclip oillamp coal
			playingcard toothpick actionfigure aknex
			deadrat bomb flint liquidnitrogen marbles
			glue valmid wugrumphat clay idtag wax
	]
;
transmogsign: Part, Readable
	partof = transmogrifier
	sdesc = "sign"
	ldesc = { self.readdesc; }
	readdesc = {
		"The sign says, \"Out of order\".";
	}
	noun = 'sign'
	adjective = 'akmi' 'transmogrifyer'
;
// include the definitions for all the objects the transmogrifier produces
#include "products.t"

barfeegrowthformula: pourable, Readable
	isseen = nil
	scored = nil

	liquiddesc = "Barfee advanced growth formula QX-32-Beta"
	sdesc = {
		"thermos of "; self.liquiddesc;
	}
	ldesc = {
		"It's a nondescript themos with potent-smelling
		liquid in it."; 

		" "; self.readdesc;
	}
	readdesc = {
		"A label on the can says, \"Barfee advanced growth
		formula QX-32-Beta.\"";
	}
	
	noun = 'thermos' 'formula' 'QX-32-Beta' 'liquid'
	adjective = 'barfee' 'advanced' 'growth' 'formula'

	weight = 3
	bulk = 3
	
	location = labtable
	locationtype = 'on'

	verDoSmell(actor) = {}
	doSmell(actor) = { "I told you, it smells very potent."; }
	verDoDrink(actor) = {}
	doDrink(actor) = { "You are completely insane."; }
	verDoEat(actor) = {}
	doEat(actor) = { "What is WRONG with you people?!?"; }

	poureffect(actor, o) = {
		if (o = seedlump) {
			if (seedlump.grown) {
				"You pour "; self.liquiddesc; " on the
				seeds, but nothing happens.  Maybe you
				just got lucky last time.";
			}
			else {
				"You douse the seeds with "; self.liquiddesc;
				". Almost immediately thereafter the ground
				begins to shake violently, and you see ";
				seedlump.myplant.adesc;
				" lying right on top of the soil.  So it
				*was* potent stuff after all!";

				if (seedlump.myplant = egg and not self.scored) {
					self.scored := true;
					incscore(4);
				}

				seedlump.myplant.movein(Me.location);
				seedlump.myplant.makeknownto(Me);
				seedlump.grown := true;
			}
		}
		else if (o = zdybel) {
			if (zdybel.scrambled) {
				"You splash the Bedzyl with ";
				self.liquiddesc; ".  Nothing obvious
				happens.";
			}
			else {
				"If you think you can safely get close
				enough to the Zdybel to pour ";
				self.liquiddesc; " on it, you've got
				another thing coming.";
			}
		}
		else if (o.isseeds) {
			"Call me a rebel, but you might want to plant the
			seeds first.";
		}
		else {
			"Pouring "; self.liquiddesc; " on "; o.thedesc;
			" doesn't seem very productive.";
		}
	}
;
#endif	/* DEMO */
